/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.smartx.support.SmartManager;
import com.ibm.db2.tools.common.support.WrappingComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;

public class MultiLineLabel
extends DiagnosisRenderer
implements Accessible,
ChangeListener,
Serializable,
WrappingComponent {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String NEWLINE = "\n";
    public static final String TAB = "\t";
    public static final int NO_SIZING = 0;
    public static final int SIZING_FIXED_WIDTH = 1;
    public static final int SIZING_CONTAINER_WIDTH = 2;
    public static final int SIZING_VIEWPORT_WIDTH = 3;
    protected int sizingMode = 2;
    protected int defaultWidth;
    protected int minimumScrollingWidth;
    protected int forcedWidth;
    protected Container myContainer;
    protected String description;
    protected Vector terms;
    protected Vector defs;
    protected String htmlText;
    protected boolean wrap;
    protected boolean scrolled;
    protected int mnemonic = 0;
    protected Component labelFor = null;
    protected static final String LABEL_FOR_PROPERTY = "labelFor";
    protected Dimension minimumSize;
    protected Dimension preferredSize;
    protected Dimension unwrappedSize;
    protected int prevWidth;
    protected static final String LABELED_BY_PROPERTY = "labeledBy";
    protected static final String DISPLAYED_MNEMONIC_PROPERTY = "displayedMnemonic";
    protected Redoable redoable;
    static /* synthetic */ Class class$javax$swing$JViewport;
    static /* synthetic */ Class class$javax$swing$JScrollPane;

    public MultiLineLabel() {
        this.hyperLinkPolicy = true;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setVisible(true);
        this.backColor = UIManager.getColor("Label.background");
        this.scrolled = false;
        this.wrap = true;
        this.minimumScrollingWidth = 100;
        this.forcedWidth = 200;
        this.maxWidth = this.defaultWidth = 400;
        this.paragraphSpacing = 1.5f;
    }

    public MultiLineLabel(String string) {
        this();
        this.setText(string);
    }

    public MultiLineLabel(boolean bl) {
        this();
        this.wrap = bl;
    }

    public MultiLineLabel(String string, boolean bl) {
        this();
        this.wrap = bl;
        this.setText(string);
    }

    public MultiLineLabel(String string, int n2) {
        this(string);
        if (n2 >= 0) {
            this.setForcedWidth(this.maxWidth);
        }
    }

    public MultiLineLabel(String string, Container container) {
        this(string, true);
        this.sizingMode = 2;
        this.myContainer = container;
    }

    public MultiLineLabel(String string, Locale locale) {
        this(string);
    }

    public void setText(String string) {
        this.setHtmlText(string);
    }

    public String getText() {
        return this.taggedString();
    }

    public void setHtmlText(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = string.trim();
        if (this.htmlText == null || !this.htmlText.equals(string2)) {
            this.focusAnchor = 0;
            this.htmlText = string2;
            this.prevWidth = 0;
            this.getPreferredSize();
            this.revalidate();
            this.repaint();
        }
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public void setSizingMode(int n2) {
        this.sizingMode = n2;
    }

    public void setDefaultWidth(int n2) {
        this.defaultWidth = n2;
    }

    public void setMinimumScrollingWidth(int n2) {
        this.minimumScrollingWidth = n2;
    }

    public void setForcedWidth(int n2) {
        this.sizingMode = 1;
        this.wrap = true;
        this.forcedWidth = n2;
        if (this.getText() != null && n2 > 0) {
            this.configure(null, null);
            this.multiLineMsg = this.getText();
            this.wrap(n2);
            this.revalidate();
            this.repaint();
        }
    }

    public void setContainer(Container container) {
        this.sizingMode = 2;
        this.myContainer = container;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
        super.setPreferredSize(dimension);
    }

    protected Insets getOffsets() {
        Insets insets = this.getInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        LayoutManager layoutManager = this.getParent().getLayout();
        if (layoutManager instanceof GridBagLayout) {
            GridBagConstraints gridBagConstraints = ((GridBagLayout)layoutManager).getConstraints(this);
            insets.left += gridBagConstraints.insets.left;
            insets.right += gridBagConstraints.insets.right;
        } else if (layoutManager instanceof BorderLayout) {
            insets.left += ((BorderLayout)layoutManager).getHgap();
            insets.right += ((BorderLayout)layoutManager).getHgap();
        } else {
            insets.left += 10;
            insets.right += 10;
        }
        return insets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        int n2 = this.defaultWidth;
        Insets insets = null;
        switch (this.sizingMode) {
            case 2: {
                if (this.myContainer != null) {
                    n2 = this.getContainerWidth();
                    insets = this.getOffsets();
                } else if (this.getParent() != null) {
                    n2 = this.getContainerWidth();
                    insets = this.getOffsets();
                }
                if (n2 == 0) {
                    n2 = this.defaultWidth;
                } else if (insets != null) {
                    n2 -= insets.left + insets.right;
                }
                dimension = this.getCalculatedSize(n2, this.getText());
                break;
            }
            case 1: {
                n2 = this.forcedWidth;
                if (n2 == 0) {
                    n2 = this.defaultWidth;
                }
                dimension = this.getCalculatedSize(n2, this.getText());
                break;
            }
            case 3: {
                JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = MultiLineLabel.class$("javax.swing.JViewport")) : class$javax$swing$JViewport, this);
                if (jViewport != null) {
                    n2 = this.getContainerWidth();
                    insets = jViewport.getInsets();
                } else if (this.myContainer != null) {
                    n2 = this.getContainerWidth();
                    insets = this.getOffsets();
                } else if (this.getParent() != null) {
                    n2 = this.getContainerWidth();
                    insets = this.getOffsets();
                }
                if (n2 == 0) {
                    n2 = this.defaultWidth;
                } else if (insets != null) {
                    n2 -= insets.left + insets.right + 5;
                }
                n2 = Math.max(n2, this.minimumScrollingWidth);
                dimension = this.getCalculatedSize(n2, this.getText());
                break;
            }
            default: {
                dimension = this.getUnwrappedSize(this.preferredSize);
            }
        }
        return dimension;
    }

    /*
     * Unable to fully structure code
     */
    protected int getContainerWidth() {
        var1_1 = 0;
        switch (this.sizingMode) {
            case 2: {
                if (this.myContainer == null) ** GOTO lbl7
                var1_1 = this.myContainer.getSize().width;
                ** GOTO lbl9
lbl7:
                // 1 sources

                if (this.getParent() != null) {
                    var1_1 = this.getParent().getSize().width;
                }
            }
lbl9:
            // 5 sources

            case 3: {
                var2_2 = (JViewport)SwingUtilities.getAncestorOfClass(MultiLineLabel.class$javax$swing$JViewport == null ? (MultiLineLabel.class$javax$swing$JViewport = MultiLineLabel.class$("javax.swing.JViewport")) : MultiLineLabel.class$javax$swing$JViewport, this);
                if (var2_2 != null) {
                    var1_1 = var2_2.getWidth();
                    break;
                }
                if (this.myContainer != null) {
                    var1_1 = this.myContainer.getSize().width;
                    break;
                }
                if (this.getParent() == null) break;
                var1_1 = this.getParent().getSize().width;
            }
        }
        return var1_1;
    }

    protected Dimension getUnwrappedSize(Dimension dimension) {
        Dimension dimension2;
        Dimension dimension3 = this.getCalculatedSize(dimension.width, this.getText());
        if (dimension == null && this.unwrappedSize == null) {
            dimension2 = this.unwrappedSize = new Dimension(dimension3.width, dimension3.height);
        } else if (dimension != null) {
            dimension.width = dimension3.width;
            dimension.height = dimension3.height;
            dimension2 = dimension;
        } else {
            this.unwrappedSize.width = dimension3.width;
            this.unwrappedSize.height = dimension3.height;
            dimension2 = this.unwrappedSize;
        }
        return dimension2;
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            this.minimumSize = new Dimension();
        }
        if (this.preferredSize == null) {
            this.preferredSize = this.getPreferredSize();
        }
        if (0 == this.sizingMode) {
            this.minimumSize.width = this.preferredSize.width;
            this.minimumSize.height = this.preferredSize.height;
        } else if (3 == this.sizingMode) {
            this.minimumSize.width = Math.min(this.preferredSize.width, this.minimumScrollingWidth);
            this.minimumSize.height = this.preferredSize.height;
        } else {
            this.minimumSize.width = 0;
            this.minimumSize.height = this.preferredSize.height;
        }
        return this.minimumSize;
    }

    public Dimension getMaximumSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.getPreferredSize();
        }
        return this.preferredSize;
    }

    public int getPreferredHeight(int n2) {
        return this.getPreferredHeight(n2, this.getText());
    }

    public int getPreferredHeight(int n2, String string) {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 30 || dimension.height < 16) {
            dimension = this.getPreferredSize();
        }
        return dimension.height;
    }

    public Dimension getCalculatedSize(int n2, String string) {
        if (n2 != this.prevWidth) {
            this.configure(null, null);
            this.multiLineMsg = string;
            if (this.wrap) {
                this.wrap(n2);
            } else {
                this.wrap(1600);
            }
            this.prevWidth = n2;
            this.revalidate();
            this.repaint();
        }
        return super.getPreferredSize();
    }

    protected void redoLayout() {
        if (this.getParent() != null) {
            if (this.redoable == null) {
                this.redoable = new Redoable(this);
            }
            SwingUtilities.invokeLater(this.redoable);
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        if (n4 == 0 && n5 == 0) {
            if (rectangle.width != 0 && rectangle.height != 0) {
                this.redoLayout();
            }
            return;
        }
        int n6 = n4;
        int n7 = n5;
        if (n4 < 50) {
            n4 = 100;
        }
        if (n5 < 2) {
            n5 = 18;
        }
        if (n4 != rectangle.width || rectangle.x != n2 || rectangle.y != n3) {
            Dimension dimension = this.getCalculatedSize(n4, this.getText());
            this.maxWidth = dimension.width = this.minWidth;
            n4 = dimension.width;
            if (!this.wrap) {
                dimension.height = n5;
            }
            this.setPreferredSize(dimension);
            if (this.getParent() != null) {
                boolean bl = this.wrap ? rectangle.height != dimension.height : rectangle.width != dimension.width;
                if (bl) {
                    n5 = dimension.height;
                    super.setBounds(n2, n3, n4, n5);
                    this.redoLayout();
                    return;
                }
            }
            n5 = dimension.height;
        }
        super.setBounds(n2, n3, n4, n5);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void addDefinition(String string, String string2) {
        if (this.terms == null) {
            this.terms = new Vector();
            this.defs = new Vector();
        }
        this.terms.addElement(string);
        this.defs.addElement(string2);
        this.multiLineMsg = null;
    }

    public void clearDefinitions() {
        if (this.terms != null) {
            this.terms.setSize(0);
            this.defs.setSize(0);
        }
        this.multiLineMsg = null;
    }

    protected String taggedString() {
        if (this.htmlText == null) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.description);
            if (this.terms != null && this.terms.size() > 0) {
                stringBuffer.append("<dl>");
                Enumeration enumeration = this.terms.elements();
                Enumeration enumeration2 = this.defs.elements();
                while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
                    stringBuffer.append("<dt>").append(enumeration.nextElement());
                    stringBuffer.append("<dd>").append(enumeration2.nextElement());
                }
                stringBuffer.append("</dl>");
            }
            this.htmlText = stringBuffer.toString();
        }
        return this.htmlText;
    }

    public JScrollPane getScrollPane() {
        return (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = MultiLineLabel.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.viewRect = this.getBounds();
        Rectangle rectangle = ((JViewport)changeEvent.getSource()).getViewRect();
        this.viewRect = SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.viewRect);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getParent().getPreferredSize();
    }

    public boolean isCompact() {
        return this.paragraphSpacing == 1.0f;
    }

    public void setCompact(boolean bl) {
        this.paragraphSpacing = bl ? 1.0f : 1.5f;
    }

    public float getParagraphSpacing() {
        return this.paragraphSpacing;
    }

    public void setParagraphSpacing(float f2) {
        this.paragraphSpacing = f2;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component component) {
        Component component2 = this.labelFor;
        this.labelFor = component;
        this.firePropertyChange(LABEL_FOR_PROPERTY, component2, component);
        this.updateMnemonic();
        if (component2 instanceof JComponent) {
            ((JComponent)component2).putClientProperty(LABELED_BY_PROPERTY, null);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(LABELED_BY_PROPERTY, this);
        }
    }

    public void setDisplayedMnemonic(int n2) {
        int n3 = this.mnemonic;
        this.mnemonic = n2;
        this.firePropertyChange(DISPLAYED_MNEMONIC_PROPERTY, n3, this.mnemonic);
        this.updateMnemonic();
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getDisplayedMnemonic() {
        return this.mnemonic;
    }

    public void setDisplayedMnemonic(char n2) {
        int n3 = n2;
        if (n3 >= 97 && n3 <= 122) {
            n3 -= 32;
        }
        this.setDisplayedMnemonic(n3);
    }

    protected void updateMnemonic() {
        Component component = this.getLabelFor();
        int n2 = this.getDisplayedMnemonic();
        if (n2 != 0 && component != null) {
            InputMap inputMap;
            ActionMap actionMap = SwingUtilities.getUIActionMap(this);
            if (actionMap == null) {
                actionMap = new ActionMapUIResource();
                this.setActionMap(actionMap);
                actionMap.put("press", PressAction.getInstance());
                actionMap.put("release", ReleaseAction.getInstance());
                if (actionMap != null) {
                    SwingUtilities.replaceUIActionMap(this, actionMap);
                    UIManager.put("Label.actionMap", actionMap);
                }
            }
            if ((inputMap = SwingUtilities.getUIInputMap(this, 2)) == null) {
                inputMap = new ComponentInputMapUIResource(this);
                SwingUtilities.replaceUIInputMap(this, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n2, 8, false), "press");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(this, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiLineLabel();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleMultiLineLabel
    extends DiagnosisRenderer.AccessibleDiagnosisRenderer {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        protected AccessibleMultiLineLabel() {
            super(MultiLineLabel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null) {
                string = SmartManager.translateHtml(MultiLineLabel.this.getText(), true);
            }
            return string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                string = MultiLineLabel.this.getDescription();
            }
            return SmartManager.translateHtml(MultiLineLabel.this.getText(), true);
        }
    }

    protected static class ReleaseAction
    extends AbstractAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static ReleaseAction action;

        protected ReleaseAction() {
        }

        public static ReleaseAction getInstance() {
            if (action == null) {
                action = new ReleaseAction();
            }
            return action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiLineLabel multiLineLabel = (MultiLineLabel)actionEvent.getSource();
            Component component = multiLineLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(multiLineLabel, 0);
                if (inputMap != null) {
                    inputMap.remove(KeyStroke.getKeyStroke(multiLineLabel.getDisplayedMnemonic(), 8, true));
                    inputMap.remove(KeyStroke.getKeyStroke(0, 8, true));
                }
                multiLineLabel.getLabelFor().requestFocus();
                Component component2 = multiLineLabel.getLabelFor();
                if (component2 instanceof AbstractButton) {
                    ((AbstractButton)component2).doClick();
                }
            }
        }
    }

    protected static class PressAction
    extends AbstractAction {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static PressAction action;

        protected PressAction() {
        }

        public static PressAction getInstance() {
            if (action == null) {
                action = new PressAction();
            }
            return action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiLineLabel multiLineLabel = (MultiLineLabel)actionEvent.getSource();
            Component component = multiLineLabel.getLabelFor();
            if (component != null && component.isEnabled()) {
                InputMap inputMap = SwingUtilities.getUIInputMap(multiLineLabel, 0);
                if (inputMap == null) {
                    inputMap = new InputMapUIResource();
                    SwingUtilities.replaceUIInputMap(multiLineLabel, 0, inputMap);
                }
                int n2 = multiLineLabel.getDisplayedMnemonic();
                inputMap.put(KeyStroke.getKeyStroke(n2, 8, true), "release");
                inputMap.put(KeyStroke.getKeyStroke(0, 8, true), "release");
                multiLineLabel.requestFocus();
            }
        }
    }

    protected class Redoable
    implements Runnable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected MultiLineLabel label;
        protected Rectangle bounds;

        public Redoable(MultiLineLabel multiLineLabel2) {
            this.label = multiLineLabel2;
        }

        public void run() {
            if (!(MultiLineLabel.this.getParent() == null || this.bounds != null && this.bounds.equals(this.label.getBounds()))) {
                Component[] componentArray = this.label.getParent().getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    if (componentArray[n2] instanceof JComponent) {
                        ((JComponent)componentArray[n2]).revalidate();
                    }
                    ++n2;
                }
                this.label.getParent().doLayout();
                this.bounds = this.label.getBounds();
            }
        }
    }
}

