/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.AssistPassword;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonPanel;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.CommonUIManager;
import com.ibm.db2.tools.common.CommonWindowInterface;
import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class LogonPanel
extends CommonPanel
implements AssistListener,
Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected JButton ok;
    protected JButton cancel;
    protected JButton help;
    protected AssistField displayUserid;
    protected AssistPassword displayPassword;
    protected JTextArea messagesTA = new JTextArea();
    private String[] detailedMessages;
    private String[] informationLines;
    private boolean pressCancel = true;
    private boolean stripQuotes = true;

    public LogonPanel(String[] stringArray, String[] stringArray2, CommonWindowInterface commonWindowInterface, JRootPane jRootPane) {
        super("", "");
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "LogonPanel", this, "LogonPanel(String[] informationLines, String[] detailedMessages, CommonWindowInterface window, JRootPane rootPane)", new Object[]{stringArray, stringArray2, commonWindowInterface, jRootPane});
        }
        CommonUIManager.initialize();
        this.detailedMessages = stringArray2;
        this.informationLines = stringArray;
        this.makeLayout();
        this.displayUserid.addAssistListener(this);
        this.displayPassword.addAssistListener(this);
        jRootPane.setDefaultButton(this.ok);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = this.displayUserid.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
        this.displayPassword.setKeymap(keymap);
        this.refreshButtons();
        CommonTrace.exit(commonTrace);
    }

    public void validityChanged(AssistEvent assistEvent) {
        this.refreshButtons();
    }

    public JTextField getDisplayUserid() {
        return this.displayUserid;
    }

    public JTextField getDisplayPassword() {
        return this.displayPassword;
    }

    public void addActionListener(ActionListener actionListener) {
        this.ok.addActionListener(actionListener);
        this.cancel.addActionListener(actionListener);
        this.help.addActionListener(actionListener);
    }

    public void set(PasswordAuthentication passwordAuthentication) {
        if (null != passwordAuthentication) {
            this.displayUserid.setText(passwordAuthentication.getUserName());
            this.displayPassword.setText(String.valueOf(passwordAuthentication.getPassword()));
        }
        this.displayUserid.requestFocus();
    }

    public PasswordAuthentication get() {
        PasswordAuthentication passwordAuthentication = null;
        passwordAuthentication = this.stripQuotes ? new PasswordAuthentication(this.stripQuotes(this.displayUserid.getText().trim()), this.stripQuotes(this.displayPassword.getPassword())) : new PasswordAuthentication(this.displayUserid.getText().trim(), this.displayPassword.getPassword());
        return passwordAuthentication;
    }

    public JButton getButton(String string) {
        JButton jButton = null;
        if (this.ok.getText().equals(string)) {
            jButton = this.ok;
        } else if (this.cancel.getText().equals(string)) {
            jButton = this.cancel;
        } else if (this.help.getText().equals(string)) {
            jButton = this.help;
        }
        return jButton;
    }

    public boolean getStripQuotes() {
        return this.stripQuotes;
    }

    public void setStripQuotes(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create(this.getClass().getPackage().getName(), this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1), this, "setStripQuotes( final boolean aStripQuotes )", new Object[]{new Boolean(bl)});
        }
        this.stripQuotes = bl;
        CommonTrace.exit(commonTrace);
    }

    private void refreshButtons() {
        boolean bl = this.displayUserid.isValueValid() && this.displayPassword.isValueValid();
        this.ok.setEnabled(bl);
    }

    private String stripQuotes(String string) {
        String string2;
        String string3 = string;
        if (string != null && (string2 = string.trim()).length() > 0 && (string2.startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\""))) {
            string3 = string2.substring(1, string2.length() - 1);
        }
        return string3;
    }

    private char[] stripQuotes(char[] cArray) {
        char[] cArray2 = cArray;
        if (cArray != null && cArray.length > 0 && (cArray[0] == '\'' && cArray[cArray.length - 1] == '\'' || cArray[0] == '\"' && cArray[cArray.length - 1] == '\"')) {
            cArray2 = new char[cArray.length - 2];
            int n2 = 1;
            while (n2 <= cArray.length - 2) {
                cArray2[n2 - 1] = cArray[n2];
                ++n2;
            }
        }
        return cArray2;
    }

    private void makeLayout() {
        this.makeMainPanel(this);
    }

    private JPanel makeMainPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add("North", this.makeInformationPanel(this.getPanel()));
        jPanel.add("Center", this.makeCenterPanel(this.getPanel()));
        jPanel.add("South", this.makeSouthPanel(this.getPanel()));
        return jPanel;
    }

    private JPanel makeInformationPanel(JPanel jPanel) {
        if (this.informationLines != null) {
            jPanel.setLayout(new GridLayout(this.informationLines.length, 1, 6, 6));
            int n2 = 0;
            while (n2 < this.informationLines.length) {
                jPanel.add(new JLabel(this.informationLines[n2]));
                ++n2;
            }
        } else {
            jPanel.setLayout(new GridLayout(0, 1, 6, 6));
        }
        return jPanel;
    }

    private JPanel makeCenterPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("North", this.makeUseridPanel(this.getPanel()));
        if (this.detailedMessages != null && this.detailedMessages.length > 0) {
            jPanel.add("Center", this.makeMessagePanel(this.getPanel()));
        }
        return jPanel;
    }

    private JPanel makeUseridPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("West", this.makeUseridLabelPanel(this.getPanel()));
        jPanel.add("Center", this.makeUseridValuesPanel(this.getPanel()));
        return jPanel;
    }

    private JPanel makeMessagePanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createLineBorder(Color.black)));
        int n2 = 0;
        while (n2 < this.detailedMessages.length) {
            if (this.detailedMessages[n2] != null && this.detailedMessages[n2].length() > 0 && this.detailedMessages[n2].indexOf("\u0000") >= 0) {
                this.detailedMessages[n2] = this.detailedMessages[n2].substring(0, this.detailedMessages[n2].indexOf("\u0000"));
            }
            this.messagesTA.append(this.detailedMessages[n2]);
            ++n2;
        }
        this.messagesTA.setLineWrap(true);
        this.messagesTA.setWrapStyleWord(true);
        this.messagesTA.setEnabled(false);
        this.messagesTA.setColumns(30);
        this.messagesTA.setRows(10);
        this.messagesTA.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.messagesTA);
        jPanel.add("Center", jScrollPane);
        this.messagesTA.setFont(AppearanceManager.getFont("default"));
        this.messagesTA.setCaretPosition(1);
        return jPanel;
    }

    private JPanel makeUseridLabelPanel(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add(new JLabel(CmStringPool.get(198)));
        jPanel.add(new JLabel(CmStringPool.get(199)));
        return jPanel;
    }

    private JPanel makeUseridValuesPanel(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.displayUserid = new AssistField(true);
        this.displayPassword = new AssistPassword(true);
        jPanel.add(this.displayUserid);
        jPanel.add(this.displayPassword);
        return jPanel;
    }

    private JPanel makeSouthPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("East", this.makeButtonPanel(this.getPanel()));
        return jPanel;
    }

    private JPanel makeButtonPanel(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 3, 8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.ok = new JButton(CmStringPool.get(27));
        jPanel.add(this.ok);
        this.cancel = new JButton(CmStringPool.get(24));
        jPanel.add(this.cancel);
        this.help = new JButton(CmStringPool.get(26));
        this.help.setActionCommand("Help");
        jPanel.add(this.help);
        return jPanel;
    }
}

