/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.LogonPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.PasswordAuthentication;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LogonDialog
extends CommonDialog
implements Serializable {
    public static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PasswordAuthentication challengeUserInfo;
    private LogonPanel accountPanel;
    private boolean pressCancel = true;

    public LogonDialog() {
        super((JFrame)null, " ", false, 0L);
    }

    public LogonDialog(String string, String string2, String[] stringArray, String[] stringArray2, JFrame jFrame, boolean bl, String string3) {
        this(string, string2, stringArray, stringArray2, jFrame, bl);
    }

    public LogonDialog(String string, String string2, String[] stringArray, String[] stringArray2, JFrame jFrame, boolean bl) {
        super(jFrame, string + " " + string2, bl, 0L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "LogonDialog", this, "LogonDialog(String fixedTitle, String variableTitle, String[] informationLines, String[] detailedMessages, JFrame parent, boolean modal)", new Object[]{string, string2, stringArray, stringArray2, jFrame, new Boolean(bl)});
        }
        this.accountPanel = new LogonPanel(stringArray, stringArray2, this, this.getRootPane());
        this.accountPanel.addActionListener(this);
        this.makeLayout();
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            if (((JButton)actionEvent.getSource()).getText().equals(CmStringPool.get(27))) {
                this.pressOK();
            } else if (((JButton)actionEvent.getSource()).getText().equals(CmStringPool.get(24))) {
                this.pressCancel = true;
                this.shutdown();
            } else {
                super.actionPerformed(actionEvent);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        if (this.pressCancel) {
            this.pressCancel();
        }
        this.setVisible(false);
        this.dispose();
    }

    public PasswordAuthentication challengeUser() {
        return this.challengeUser(new PasswordAuthentication(null, new char[0]));
    }

    public PasswordAuthentication challengeUser(PasswordAuthentication passwordAuthentication) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "LogonDialog", this, "challengeUser(PasswordAuthentication currentUserInfo)", new Object[]{passwordAuthentication});
        }
        this.accountPanel.set(passwordAuthentication);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        LogonDialog.this.setVisible(true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                CommonTrace.catchBlock(commonTrace);
            }
            catch (InvocationTargetException invocationTargetException) {
                CommonTrace.catchBlock(commonTrace);
            }
        } else {
            this.setVisible(true);
        }
        return (PasswordAuthentication)CommonTrace.exit(commonTrace, this.challengeUserInfo);
    }

    private void makeLayout() {
        JPanel jPanel = this.getPanel();
        this.makeMainPanel(jPanel);
        this.setClient(jPanel);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }

    private JPanel makeMainPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add("Center", this.accountPanel);
        this.setDefaultFocusComponent(this.accountPanel.getDisplayUserid());
        return jPanel;
    }

    private void pressOK() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "LogonDialog", this, "pressOK()");
        }
        this.challengeUserInfo = this.accountPanel.get();
        this.pressCancel = false;
        this.shutdown();
        CommonTrace.exit(commonTrace);
    }

    private void pressCancel() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "LogonDialog", this, "pressCancel()");
        }
        this.challengeUserInfo = null;
        CommonTrace.exit(commonTrace);
    }

    private void shutdown() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

