/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonImageRepository;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class GradientMenuBar
extends JMenuBar
implements Serializable {
    protected boolean borderNeeded = false;
    protected URLListener urlListener = new URLListener();
    protected boolean inside = false;
    protected ImageIcon brandIcon = null;
    protected String brandURL = null;
    protected Image dimage;
    protected Color rightColor = new Color(123, 142, 181);
    protected Color right2Color = new Color(140, 142, 140);
    protected EventListenerList listenerList = new EventListenerList();
    protected transient MediaTracker tracker;
    static /* synthetic */ Class class$javax$swing$event$HyperlinkListener;

    public GradientMenuBar() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this.urlListener);
        this.setBrandIcon(CommonImageRepository.getCommonIcon(CommonImageRepository.NV_BRAND_IDENTIFIER));
    }

    public void setBrandIcon(ImageIcon imageIcon) {
        this.brandIcon = imageIcon;
    }

    public ImageIcon getBrandIcon() {
        return this.brandIcon;
    }

    public void setBrandURL(String string) {
        this.brandURL = string;
    }

    public String getBrandURL() {
        return this.brandURL;
    }

    public void setGradientColor(Color color) {
        this.rightColor = color;
    }

    public void setMixinGradientColor(Color color) {
        this.right2Color = color;
    }

    public Color getGradientColor() {
        return this.rightColor;
    }

    public Color getMixinGradientColor() {
        return this.right2Color;
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = GradientMenuBar.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = GradientMenuBar.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$HyperlinkListener == null ? GradientMenuBar.class$("javax.swing.event.HyperlinkListener") : class$javax$swing$event$HyperlinkListener)) {
                ((HyperlinkListener)objectArray[n2 + 1]).hyperlinkUpdate(hyperlinkEvent);
            }
            n2 -= 2;
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBorderPainted(this.borderNeeded || UIManager.getLookAndFeel().getID().equals("Motif"));
        this.dimage = null;
        this.invalidate();
    }

    public void setBorderNeeded(boolean bl) {
        this.borderNeeded = bl;
        this.setBorderPainted(this.borderNeeded || UIManager.getLookAndFeel().getID().equals("Motif"));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getSize();
        int n2 = dimension2.width - dimension.width;
        if (n2 > 0 && this.brandIcon != null && (n2 -= this.brandIcon.getIconWidth()) > 0) {
            Image image = this.makeDitherImage(n2 + 50, dimension2.height - 2);
            graphics.drawImage(image, dimension.width - 50, 0, null);
            if (this.brandIcon != null) {
                if (this.brandIcon.getIconHeight() != dimension2.height - 1) {
                    this.brandIcon = CommonImageRepository.getScaledImage(this.brandIcon, this.brandIcon.getIconWidth(), dimension2.height - 1);
                }
                this.brandIcon.paintIcon(this, graphics, dimension2.width - this.brandIcon.getIconWidth(), -1);
            }
        }
    }

    protected Image makeDitherImage(int n2, int n3) {
        if (this.dimage != null && this.dimage.getWidth(null) == n2 && this.dimage.getHeight(null) == n3) {
            return this.dimage;
        }
        this.dimage = this.createGradientBanner(n2, n3, this.getBackground(), this.rightColor, this.right2Color);
        return this.dimage;
    }

    public boolean contains(int n2, int n3) {
        if (n2 >= this.getWidth() || n3 >= this.getHeight()) {
            return false;
        }
        if (this.brandIcon != null && this.brandURL != null) {
            if (n2 >= this.getWidth() - this.brandIcon.getIconWidth()) {
                if (!this.inside) {
                    this.setToolTipText(this.brandURL);
                    this.inside = true;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    try {
                        URL uRL = new URL(this.brandURL);
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.ENTERED, uRL);
                        this.fireHyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (Exception exception) {}
                }
            } else if (this.inside) {
                this.inside = false;
                this.setToolTipText(null);
                this.setCursor(Cursor.getDefaultCursor());
                try {
                    URL uRL = new URL(this.brandURL);
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, uRL);
                    this.fireHyperlinkUpdate(hyperlinkEvent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.contains(n2, n3);
    }

    public Image createGradientBanner(int n2, int n3, Color color, Color color2, Color color3) {
        int[] nArray = new int[n2 * n3];
        int n4 = 0;
        Color color4 = color;
        if (color3 == null) {
            color3 = color2;
        }
        int n5 = color4.getRed() + 1;
        int n6 = color4.getGreen() + 1;
        int n7 = color4.getBlue() + 1;
        int n8 = color2.getRed();
        int n9 = color2.getGreen();
        int n10 = color2.getBlue();
        int n11 = n8 - n5;
        int n12 = n9 - n6;
        int n13 = n10 - n7;
        int n14 = color3.getRed();
        int n15 = color3.getGreen();
        int n16 = color3.getBlue();
        int n17 = n14 - n5;
        int n18 = n15 - n6;
        int n19 = n16 - n7;
        double d2 = n2 * n2;
        int n20 = 0;
        while (n20 < n3) {
            int n21 = 0;
            while (n21 < n2) {
                int n22;
                int n23;
                int n24;
                double d3 = n21 * n21;
                double d4 = d3 / d2;
                int n25 = 3;
                if ((n20 + n21) % 2 == 0) {
                    n24 = (int)(d4 * (double)n11) + n5;
                    n23 = (int)(d4 * (double)n12) + n6;
                    n22 = (int)(d4 * (double)n13) + n7;
                } else {
                    n24 = (int)(d4 * (double)n17) + n5;
                    n23 = (int)(d4 * (double)n18) + n6;
                    n22 = (int)(d4 * (double)n19) + n7;
                }
                int n26 = n25 + n25;
                int n27 = (int)(d4 * 255.0);
                nArray[n4++] = n27 << 24 | (n24 += (int)((double)n26 * Math.random() - (double)n25)) << 16 | (n23 += (int)((double)n26 * Math.random() - (double)n25)) << 8 | (n22 += (int)((double)n26 * Math.random() - (double)n25));
                ++n21;
            }
            ++n20;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
        this.tracker = new MediaTracker(this);
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return image;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class URLListener
    extends MouseAdapter
    implements Serializable {
        private URLListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (GradientMenuBar.this.inside) {
                GradientMenuBar.this.inside = false;
                if (GradientMenuBar.this.getBrandIcon() != null && GradientMenuBar.this.getBrandURL() != null) {
                    GradientMenuBar.this.setToolTipText(null);
                    ToolTipManager.sharedInstance().registerComponent(GradientMenuBar.this);
                    GradientMenuBar.this.setCursor(Cursor.getDefaultCursor());
                    try {
                        URL uRL = new URL(GradientMenuBar.this.getBrandURL());
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(GradientMenuBar.this, HyperlinkEvent.EventType.EXITED, uRL);
                        GradientMenuBar.this.fireHyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (GradientMenuBar.this.getBrandIcon() != null && GradientMenuBar.this.getBrandURL() != null) {
                Point point = mouseEvent.getPoint();
                if (point.x >= GradientMenuBar.this.getWidth() - GradientMenuBar.this.getBrandIcon().getIconWidth()) {
                    try {
                        URL uRL = new URL(GradientMenuBar.this.getBrandURL());
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(GradientMenuBar.this, HyperlinkEvent.EventType.ACTIVATED, uRL);
                        GradientMenuBar.this.fireHyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

