/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.DB2StringPoolFactory;
import com.ibm.db2.tools.common.SystemSpecific;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;

public class GeneratedStringPool {
    private static final int POOL_STRING_INDEX = 0;
    private static final int POOL_ACCELERATOR_INDEX = 1;
    private static final int POOL_MNEMONIC_INDEX = 2;
    private static final int NUMBER_OF_TYPES = 3;
    private static final String UNICODE = "Unicode";
    private static final String UNICODE_BIG = "UnicodeBig";
    private static final String UNICODE_LITTLE = "UnicodeLittle";
    private static final char BOM_BIG_ENDIAN = '\ufeff';
    private static final char BOM_LITTLE_ENDIAN = '\ufffe';
    private static final int BOM_SIZE = 2;
    protected String[][] txt;
    public byte[][][] unconvertedTextBytes;
    private static Hashtable keys = null;
    public static String TOKEN_PREFIX;
    public static String TEXT_STRINGS_ENCODING;
    private Object poolMonitor = new Object();
    private boolean stop = false;
    private String okDBCS = " ja_JP ja_JP.IBM-932 ja_JP.eucJP ja ja_JP.ujis ja_JP.EUC ko_KR ko_KR.eucKR ko ko_KR ko_KR.euc zh_CN zh_CN.GBK zh_CN.hp15CN zh zh_CN.EUC zh_TW zh_TW.eucTW zh_TW.big5 zh_TW.BIG5 ";

    public GeneratedStringPool() {
        this.loadKeys();
    }

    public void reset() {
        int n2 = 0;
        if (this.unconvertedTextBytes != null) {
            n2 = 0;
            while (n2 < this.unconvertedTextBytes.length) {
                this.unconvertedTextBytes[n2] = null;
                ++n2;
            }
        }
        if (this.txt != null) {
            n2 = 0;
            while (n2 < this.txt.length) {
                this.txt[n2] = null;
                ++n2;
            }
        }
        this.unconvertedTextBytes = null;
        this.txt = null;
    }

    public static void resetRuntimeStatics() {
        keys = null;
        TOKEN_PREFIX = null;
        TEXT_STRINGS_ENCODING = null;
    }

    public boolean weHaveMnemonicSupport_HACK() {
        boolean bl = true;
        String string = SystemSpecific.getOSName();
        if (!string.startsWith("Win")) {
            Locale locale = DB2StringPoolFactory.getLocale();
            String string2 = " " + locale.toString() + " ";
            if (this.okDBCS.indexOf(string2) < 0) {
                bl = false;
            }
        }
        return bl;
    }

    private String getString(byte[] byArray) throws UnsupportedEncodingException {
        String string = "";
        char c2 = (char)(byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF);
        string = c2 == '\ufeff' ? new String(byArray, 2, byArray.length - 2, UNICODE_BIG) : (c2 == '\ufffe' ? new String(byArray, 2, byArray.length - 2, UNICODE_LITTLE) : new String(byArray, UNICODE));
        return string;
    }

    private String getString(int n2, int n3) {
        try {
            Object object = this.poolMonitor;
            synchronized (object) {
                if (this.txt == null) {
                    if (this.unconvertedTextBytes != null) {
                        this.txt = new String[this.unconvertedTextBytes.length][3];
                    } else {
                        String string = "";
                        return string;
                    }
                }
                if (this.txt[n2][n3] == null) {
                    if (n3 == 2 && !this.weHaveMnemonicSupport_HACK()) {
                        this.txt[n2][n3] = "";
                        String string = this.txt[n2][n3];
                        return string;
                    }
                    try {
                        if (this.unconvertedTextBytes[n2][n3] != null) {
                            this.txt[n2][n3] = this.getString(this.unconvertedTextBytes[n2][n3]);
                            this.unconvertedTextBytes[n2][n3] = null;
                        } else {
                            this.txt[n2][n3] = "";
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.txt[n2][n3] = this.stringFromUnicode(this.unconvertedTextBytes[n2][n3]);
                        this.unconvertedTextBytes[n2][n3] = null;
                    }
                    catch (Exception exception) {
                        this.txt[n2][n3] = "";
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            return "";
        }
        return this.txt[n2][n3];
    }

    public String get(int n2) {
        return this.getString(n2, 0);
    }

    public String get(int n2, String[] stringArray) {
        String string = this.get(n2);
        if (!string.equals("")) {
            string = GeneratedStringPool.insertTokens(string, stringArray);
        }
        return string;
    }

    public static String insertTokens(String string, String[] stringArray) {
        if (string != null && string.length() > 0 && stringArray != null && stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = TOKEN_PREFIX + new Integer(n2 + 1).toString();
                int n3 = string.indexOf(string2);
                if (n3 < 0) break;
                String string3 = "";
                String string4 = "";
                if (n3 == 0) {
                    string4 = string.substring(0 + string2.length());
                } else if (n3 < string.length()) {
                    string3 = string.substring(0, n3);
                    string4 = string.substring(n3 + string2.length());
                } else if (n3 == string.length()) {
                    string3 = string.substring(0, n3);
                }
                string = string3 + stringArray[n2] + string4;
                ++n2;
            }
        }
        return string;
    }

    private void loadKeys() {
        if (keys == null) {
            TOKEN_PREFIX = "%";
            TEXT_STRINGS_ENCODING = UNICODE;
            keys = new Hashtable(120);
            keys.put("VK_A", new Integer(65));
            keys.put("VK_B", new Integer(66));
            keys.put("VK_C", new Integer(67));
            keys.put("VK_D", new Integer(68));
            keys.put("VK_E", new Integer(69));
            keys.put("VK_F", new Integer(70));
            keys.put("VK_G", new Integer(71));
            keys.put("VK_H", new Integer(72));
            keys.put("VK_I", new Integer(73));
            keys.put("VK_J", new Integer(74));
            keys.put("VK_K", new Integer(75));
            keys.put("VK_L", new Integer(76));
            keys.put("VK_M", new Integer(77));
            keys.put("VK_N", new Integer(78));
            keys.put("VK_O", new Integer(79));
            keys.put("VK_P", new Integer(80));
            keys.put("VK_Q", new Integer(81));
            keys.put("VK_R", new Integer(82));
            keys.put("VK_S", new Integer(83));
            keys.put("VK_T", new Integer(84));
            keys.put("VK_U", new Integer(85));
            keys.put("VK_V", new Integer(86));
            keys.put("VK_W", new Integer(87));
            keys.put("VK_X", new Integer(88));
            keys.put("VK_Y", new Integer(89));
            keys.put("VK_Z", new Integer(90));
            keys.put("VK_0", new Integer(48));
            keys.put("VK_1", new Integer(49));
            keys.put("VK_2", new Integer(50));
            keys.put("VK_3", new Integer(51));
            keys.put("VK_4", new Integer(52));
            keys.put("VK_5", new Integer(53));
            keys.put("VK_6", new Integer(54));
            keys.put("VK_7", new Integer(55));
            keys.put("VK_8", new Integer(56));
            keys.put("VK_9", new Integer(57));
            keys.put("VK_NUMPAD0", new Integer(96));
            keys.put("VK_NUMPAD1", new Integer(97));
            keys.put("VK_NUMPAD2", new Integer(98));
            keys.put("VK_NUMPAD3", new Integer(99));
            keys.put("VK_NUMPAD4", new Integer(100));
            keys.put("VK_NUMPAD5", new Integer(101));
            keys.put("VK_NUMPAD6", new Integer(102));
            keys.put("VK_NUMPAD7", new Integer(103));
            keys.put("VK_NUMPAD8", new Integer(104));
            keys.put("VK_NUMPAD9", new Integer(105));
            keys.put("VK_SPACE", new Integer(32));
            keys.put("VK_BACK_SPACE", new Integer(8));
            keys.put("VK_ENTER", new Integer(10));
            keys.put("VK_TAB", new Integer(9));
            keys.put("VK_ALT", new Integer(18));
            keys.put("VK_CAPS_LOCK", new Integer(20));
            keys.put("VK_CONTROL", new Integer(17));
            keys.put("VK_META", new Integer(157));
            keys.put("VK_SHIFT", new Integer(16));
            keys.put("VK_F1", new Integer(112));
            keys.put("VK_F2", new Integer(113));
            keys.put("VK_F3", new Integer(114));
            keys.put("VK_F4", new Integer(115));
            keys.put("VK_F5", new Integer(116));
            keys.put("VK_F6", new Integer(117));
            keys.put("VK_F7", new Integer(118));
            keys.put("VK_F8", new Integer(119));
            keys.put("VK_F9", new Integer(120));
            keys.put("VK_F10", new Integer(121));
            keys.put("VK_F11", new Integer(122));
            keys.put("VK_F12", new Integer(123));
            keys.put("VK_PRINTSCREEN", new Integer(154));
            keys.put("VK_SCROLL_LOCK", new Integer(145));
            keys.put("VK_DELETE", new Integer(127));
            keys.put("VK_INSERT", new Integer(155));
            keys.put("VK_PAUSE", new Integer(19));
            keys.put("VK_PAGE_DOWN", new Integer(34));
            keys.put("VK_PAGE_UP", new Integer(33));
            keys.put("VK_DOWN", new Integer(40));
            keys.put("VK_LEFT", new Integer(37));
            keys.put("VK_RIGHT", new Integer(39));
            keys.put("VK_UP", new Integer(38));
            keys.put("VK_END", new Integer(35));
            keys.put("VK_HOME", new Integer(36));
            keys.put("VK_ACCEPT", new Integer(30));
            keys.put("VK_NUM_LOCK", new Integer(144));
            keys.put("VK_CANCEL", new Integer(3));
            keys.put("VK_CLEAR", new Integer(12));
            keys.put("VK_CONVERT", new Integer(28));
            keys.put("VK_FINAL", new Integer(24));
            keys.put("VK_HELP", new Integer(156));
            keys.put("VK_KANA", new Integer(21));
            keys.put("VK_KANJI", new Integer(25));
            keys.put("VK_MODECHANGE", new Integer(31));
            keys.put("VK_NONCONVERT", new Integer(29));
            keys.put("VK_ADD", new Integer(107));
            keys.put("VK_BACK_QUOTE", new Integer(192));
            keys.put("VK_BACK_SLASH", new Integer(92));
            keys.put("VK_CLOSE_BRACKET", new Integer(93));
            keys.put("VK_COMMA", new Integer(44));
            keys.put("VK_DECIMAL", new Integer(110));
            keys.put("VK_DIVIDE", new Integer(111));
            keys.put("VK_EQUALS", new Integer(61));
            keys.put("VK_MULTIPLY", new Integer(106));
            keys.put("VK_OPEN_BRACKET", new Integer(91));
            keys.put("VK_PERIOD", new Integer(46));
            keys.put("VK_QUOTE", new Integer(222));
            keys.put("VK_SEMICOLON", new Integer(59));
            keys.put("VK_SEPARATER", new Integer(108));
            keys.put("VK_SLASH", new Integer(47));
            keys.put("VK_SUBTRACT", new Integer(109));
        }
    }

    private String stringFromUnicode(byte[] byArray) {
        boolean bl;
        int n2;
        char c2 = (char)(byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF);
        if (c2 == '\ufeff') {
            n2 = 2;
            bl = true;
        } else if (c2 == '\ufffe') {
            n2 = 2;
            bl = false;
        } else {
            n2 = 0;
            bl = true;
        }
        char[] cArray = new char[(byArray.length - n2) / 2];
        int n3 = 0;
        int n4 = n2;
        while (n3 < cArray.length) {
            cArray[n3] = bl ? (char)(byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF) : (char)(byArray[n4 + 1] << 8 & 0xFF00 | byArray[n4] & 0xFF);
            ++n3;
            n4 += 2;
        }
        return new String(cArray);
    }

    public int getAcceleratorCode(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "GeneratedStringPool", this, "getAcceleratorCode(int poolId)", new Object[]{new Integer(n2)});
        }
        int n3 = 0;
        String string = this.getString(n2, 1);
        if (string.equals("VK_BACKSLASH")) {
            string = "VK_BACK_SLASH";
        }
        if (string != null && keys.containsKey(string)) {
            try {
                n3 = (Integer)keys.get(string);
            }
            catch (Exception exception) {
                CommonTrace.catchBlock(commonTrace);
                CommonTrace.write(commonTrace, exception.toString());
            }
        }
        return CommonTrace.exit(commonTrace, n3);
    }

    public int getAcceleratorModifierCode(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "GeneratedStringPool", this, "getAcceleratorModifierCode(int poolId)", new Object[]{new Integer(n2)});
        }
        int n3 = 2;
        int n4 = this.getAcceleratorCode(n2);
        if (n4 >= 112 && n4 <= 127) {
            n3 = 0;
        }
        return CommonTrace.exit(commonTrace, n3);
    }

    public int getMnemonicCode(int n2) {
        int n3 = 0;
        String string = this.getString(n2, 2);
        if (string != null && string.length() > 0) {
            n3 = string.charAt(0);
        }
        return n3;
    }

    static {
        TEXT_STRINGS_ENCODING = UNICODE;
    }
}

