/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.TaskIndicator;
import com.ibm.db2.tools.common.plaf.FrameStatusLineUI;
import java.awt.Image;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FrameStatusLine
extends JComponent
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Icon okIcon;
    public static Icon waitIcon;
    public static Icon stopIcon;
    protected Vector ucomponents;
    protected String message;
    protected Icon icon;
    protected TaskIndicator task = new TaskIndicator();
    protected boolean historyEnabled = true;
    protected boolean canceled = false;
    protected boolean cancelEnabled = false;

    public FrameStatusLine() {
        okIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FSL_STATUS_OK);
        waitIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FSL_STATUS_WAIT);
        stopIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.FSL_STATUS_STOP);
        this.updateUI();
        this.setStatusIcon(okIcon);
    }

    public String getMessage() {
        return this.message;
    }

    public synchronized void setMessage(String string) {
        this.message = string;
        ((FrameStatusLineUI)this.ui).updateMessage(this);
    }

    public void setMessageHistoryEnabled(boolean bl) {
        this.historyEnabled = bl;
    }

    public boolean isMessageHistoryEnabled() {
        return this.historyEnabled;
    }

    public synchronized void setMessage(String string, int n2) {
        this.message = string;
        ((FrameStatusLineUI)this.ui).updateMessage(this, n2);
    }

    public Icon getStatusIcon() {
        return this.icon;
    }

    public synchronized void setStatusIcon(Icon icon) {
        this.icon = icon;
        ((FrameStatusLineUI)this.ui).updateIcon(this);
    }

    public Image getStatusImage() {
        return this.icon instanceof ImageIcon ? ((ImageIcon)this.icon).getImage() : (Image)null;
    }

    public void setStatusImage(Image image) {
        this.icon = new ImageIcon(image);
        ((FrameStatusLineUI)this.ui).updateIcon(this);
    }

    public void setBusyIndicatorActive(boolean bl) {
        ((FrameStatusLineUI)this.ui).updateBusyIndicator(this, bl);
    }

    public void startBusyIndicator() {
        ((FrameStatusLineUI)this.ui).updateBusyIndicator(this, true);
    }

    public void stopBusyIndicator() {
        ((FrameStatusLineUI)this.ui).updateBusyIndicator(this, false);
    }

    public void updateUI() {
        this.setUI((FrameStatusLineUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "FrameStatusLineUI";
    }

    public TaskIndicator getTaskIndicator() {
        return ((FrameStatusLineUI)this.ui).getTaskIndicator();
    }

    public void setCancelEnabled(boolean bl) {
        this.cancelEnabled = bl;
        ((FrameStatusLineUI)this.ui).updateCancel(this);
        if (this.cancelEnabled) {
            this.setCanceled(false);
        }
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
        ((FrameStatusLineUI)this.ui).updateCancel(this);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void addUserComponent(JComponent jComponent) {
        if (this.ucomponents == null) {
            this.ucomponents = new Vector();
        }
        this.ucomponents.addElement(jComponent);
    }

    public void removeUserComponent(JComponent jComponent) {
        if (this.ucomponents == null) {
            return;
        }
        this.ucomponents.removeElement(jComponent);
    }

    public Vector getUserComponents() {
        if (this.ucomponents == null) {
            return null;
        }
        return (Vector)this.ucomponents.clone();
    }

    public void removeAllUserComponents() {
        if (this.ucomponents != null) {
            this.ucomponents.removeAllElements();
        }
    }

    public FrameStatusLine(boolean bl) {
        this();
    }

    public void setStatus(String string) {
        if (string == null || string.length() == 0) {
            this.setMessage(" ");
        } else {
            this.setMessage(string);
        }
    }

    public void clear() {
        this.setMessage(" ");
    }

    public static void setHeight(int n2) {
    }
}

