/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.FontProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FontPropertyDisplay
extends JDialog
implements ActionListener,
WindowListener {
    private JButton closeButton = new JButton("Close");
    private Hashtable fontProperties;

    public FontPropertyDisplay(Hashtable hashtable) {
        super(new JFrame(), "Font property displayer", false);
        this.fontProperties = hashtable;
        this.makeLayout();
        this.closeButton.addActionListener(this);
        this.addWindowListener(this);
        this.pack();
        this.show();
    }

    private void makeLayout() {
        ((Component)this).setBackground(new Color(0xC0C0C0));
        BorderLayout borderLayout = new BorderLayout(0, 0);
        this.getContentPane().setLayout(borderLayout);
        this.getContentPane().add("Center", this.makeAllPanels(new JPanel()));
    }

    private Container makeAllPanels(Container container) {
        BorderLayout borderLayout = new BorderLayout(0, 0);
        container.setLayout(borderLayout);
        container.add("West", this.makeWestPanel(new JPanel()));
        container.add("Center", this.makeCenterPanel(new JPanel()));
        container.add("South", this.makeSouthPanel(new JPanel()));
        return container;
    }

    private Container makeWestPanel(Container container) {
        GridLayout gridLayout = new GridLayout(this.fontProperties.size(), 4, 0, 0);
        container.setLayout(gridLayout);
        Enumeration enumeration = this.fontProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FontProperty fontProperty = (FontProperty)this.fontProperties.get(string);
            JLabel jLabel = new JLabel(string);
            JLabel jLabel2 = new JLabel(fontProperty.fontName);
            JLabel jLabel3 = new JLabel(Integer.toString(fontProperty.style) + ":" + Integer.toString(fontProperty.size));
            JButton jButton = new JButton(fontProperty.color != null ? fontProperty.color.toString() : "C");
            container.add(jLabel);
            container.add(jLabel2);
            container.add(jLabel3);
            container.add(jButton);
            jButton.setBackground(fontProperty.color);
            jButton.setEnabled(false);
        }
        return container;
    }

    private Container makeCenterPanel(Container container) {
        GridLayout gridLayout = new GridLayout(this.fontProperties.size(), 1, 0, 0);
        container.setLayout(gridLayout);
        Enumeration enumeration = this.fontProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FontProperty fontProperty = (FontProperty)this.fontProperties.get(string);
            TextField textField = new TextField("abcdefghijklmnopqrstuvyxyzABCDEFGHIJKLOMNOPQRSTUVWXYZ1234567890!@#$%^&*");
            container.add(textField);
            textField.setFont(new Font(fontProperty.fontName, fontProperty.style, fontProperty.size));
            textField.setEnabled(false);
        }
        return container;
    }

    private Container makeSouthPanel(Container container) {
        BorderLayout borderLayout = new BorderLayout(0, 0);
        container.setLayout(borderLayout);
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 3, 0, 0);
        jPanel.setLayout(gridLayout);
        jPanel.add(this.closeButton);
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout(2, 10, 10);
        jPanel2.setLayout(flowLayout);
        jPanel2.add(jPanel);
        container.add("East", jPanel2);
        return container;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

