/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.FindInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindDialog
extends CommonDialog
implements DocumentListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FindInterface findInterface;
    private JCheckBox checkbox = new JCheckBox(CmStringPool.get(203));
    private boolean checkboxState = false;
    private AssistField textField = new AssistField(false, "                    ", 1);
    private String findString = null;
    private boolean textChanged = false;
    private JPanel dlgPanel;

    public FindDialog(JFrame jFrame, FindInterface findInterface) {
        super(jFrame, CmStringPool.get(201), true, 14L);
        this.findInterface = findInterface;
        this.init();
    }

    public FindDialog(CommonDialog commonDialog, FindInterface findInterface) {
        super(commonDialog, CmStringPool.get(201), true, 14L);
        this.findInterface = findInterface;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.checkbox) {
            this.findInterface.setCaseSensitive(!this.findInterface.getCaseSensitive());
        } else if (actionEvent.getActionCommand() == "OK") {
            this.find();
            this.close();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        new Exception("this method should never be called").printStackTrace();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.textField.getDocument()) {
            if (this.textField.getText().trim().equals("")) {
                this.getButton(2L).setEnabled(false);
            } else {
                this.getButton(2L).setEnabled(true);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.textField.requestFocus();
            this.textField.selectAll();
        }
        super.setVisible(bl);
    }

    public boolean processEnterKey() {
        this.find();
        return true;
    }

    private void init() {
        this.makeLayout();
        this.textField.setText(this.findInterface.getFindString());
        this.textField.requestFocus();
        this.setDefaultFocusComponent(this.textField);
        this.checkbox.addActionListener(this);
        this.checkbox.setSelected(this.findInterface.getCaseSensitive());
        this.textField.getDocument().addDocumentListener(this);
        this.addButtonsActionListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.setVisible(true);
    }

    private void makeLayout() {
        JPanel jPanel = this.getPanel();
        this.makeMainPanel(jPanel);
        this.setClient(jPanel);
        this.checkbox.setMnemonic(CmStringPool.getMnemonicCode(203));
    }

    private JPanel makeMainPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel.add("North", this.makeControlsPanel(this.getPanel()));
        return jPanel;
    }

    private JPanel makeControlsPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add("North", this.makeControlsN(this.getPanel()));
        jPanel.add("South", this.makeControlsS(this.getPanel()));
        return jPanel;
    }

    private JPanel makeControlsN(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add("West", this.makeControlLabelsW(this.getPanel()));
        jPanel.add("Center", this.makeControlFields(this.getPanel()));
        jPanel.add("East", this.makeControlLabelsE(this.getPanel()));
        return jPanel;
    }

    private JPanel makeControlLabelsW(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        JLabel jLabel = new JLabel(CmStringPool.get(202));
        jLabel.setDisplayedMnemonic(CmStringPool.getMnemonic(202));
        jLabel.setLabelFor(this.textField);
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel makeControlFields(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel.add(this.textField);
        return jPanel;
    }

    private JPanel makeControlLabelsE(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.add(new JLabel());
        return jPanel;
    }

    private JPanel makeControlsS(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        jPanel.add("West", this.makeSCB(new JPanel()));
        return jPanel;
    }

    private JPanel makeSCB(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.add(this.checkbox);
        return jPanel;
    }

    private void find() {
        this.setVisible(false);
        if (this.getButton(2L).isEnabled()) {
            this.findString = this.textField.getText();
            if (this.findInterface.find(this.findString, this.checkbox.isSelected()) == -1) {
                this.setVisible(true);
            }
        }
    }
}

