/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.ShadowBorder;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ExpandingLabel
extends JLabel
implements CellExpanderComponent,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CellExpander cellExpander;

    public ExpandingLabel(String string, Icon icon, int n2) {
        super(string, icon, n2);
        CellExpanderManager.sharedInstance().registerComponent(this);
    }

    public ExpandingLabel(String string, int n2) {
        this(string, null, n2);
    }

    public ExpandingLabel(String string) {
        this(string, null, 10);
    }

    public ExpandingLabel(Icon icon, int n2) {
        this(null, icon, n2);
    }

    public ExpandingLabel(Icon icon) {
        this(null, icon, 0);
    }

    public ExpandingLabel() {
        this("", null, 10);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        if (this.getParent() == null || this.getPreferredSize().width <= this.getSize().width) {
            return null;
        }
        Point point = new Point(0, 0);
        if (this.getIcon() != null) {
            point.x = 0;
            point.y = 0;
        }
        return point;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        Serializable serializable;
        Object object;
        Insets insets = this.getInsets();
        Point point = new Point(-3, 0);
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
            this.cellExpander.setFont(this.getFont());
            this.cellExpander.setForeground(this.getForeground());
            this.cellExpander.setBackground(this.getBackground());
            object = this.getBorder();
            if (object == null) {
                object = new ShadowBorder(1);
            }
            this.cellExpander.setBorder((Border)object);
        }
        this.cellExpander.setPreferredSize(this.getPreferredSize());
        this.cellExpander.setEnabled(this.isEnabled());
        object = this.getIcon();
        if (object != null) {
            String string;
            switch (this.getVerticalTextPosition()) {
                case 1: {
                    string = "TOP";
                    break;
                }
                case 0: {
                    string = "MIDDLE";
                    break;
                }
                default: {
                    string = "BOTTOM";
                }
            }
            serializable = new StringBuffer();
            DiagnosisRenderer.putIcon("CellExpander", (Icon)object);
            ((StringBuffer)serializable).append("<img align=").append(string).append(" src=\"").append("CellExpander").append("\"").append(" hspace=").append(this.getIconTextGap()).append(">").append(CellExpanderManager.untag(this.getText()));
            this.cellExpander.setTipText(((StringBuffer)serializable).toString());
            point.x -= 1 + insets.left;
            point.y -= 2;
        } else {
            this.cellExpander.setTipText(CellExpanderManager.untag(this.getText()));
        }
        serializable = this.cellExpander.getPreferredSize();
        int n2 = ((Dimension)serializable).height;
        Dimension dimension = this.getSize();
        if (((Dimension)serializable).height < dimension.height) {
            ((Dimension)serializable).height = dimension.height;
        }
        if (((Dimension)serializable).width < dimension.width) {
            ((Dimension)serializable).width = dimension.width;
        }
        switch (this.getVerticalAlignment()) {
            case 1: {
                break;
            }
            case 0: {
                insets = this.cellExpander.getInsets();
                point.y += Math.round((((Dimension)serializable).height - n2) / 2) + insets.top + insets.bottom + ((Dimension)serializable).height % 2 + 1;
                break;
            }
            default: {
                insets = this.cellExpander.getInsets();
                point.y += ((Dimension)serializable).height - (n2 + insets.bottom + 1);
            }
        }
        this.cellExpander.setPreferredSize((Dimension)serializable);
        this.cellExpander.putClientProperty("translate.point", point);
        return this.cellExpander;
    }
}

