/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.CalendarSheet;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.EllipsisIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class DropdownCalendar
extends JPanel
implements ActionListener,
FocusListener,
PropertyChangeListener {
    public static final Icon icon = new EllipsisIcon();
    public static final int YYYYMMDD = 1;
    public static final int YYYY_MM_DD = 2;
    public static final int DEFAULT = 3;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    JButton button;
    AssistField field;
    CalendarSheet calendar;
    DateFormat df;
    int dateFormat = 3;
    SimpleDateFormat formatter;
    JLayeredPane layeredPane = null;
    int position = 1;
    protected boolean required = false;
    String prevDate = "";

    public DropdownCalendar(int n2, int n3, int n4) {
        this.dateFormat = n3;
        this.setLayout(new BorderLayout());
        this.button = new JButton(icon);
        this.button.setActionCommand("showcal");
        this.button.setName("com.ibm.db2.tools.common.DropdownCalendarButton");
        this.button.addActionListener(this);
        this.calendar = new CalendarSheet(n4);
        this.calendar.addActionListener(this);
        this.calendar.setVisible(false);
        this.calendar.setBorder(new LineBorder(Color.black, 2));
        Dimension dimension = this.calendar.getPreferredSize();
        this.calendar.setSize(new Dimension((int)((double)dimension.width * 1.1), dimension.height));
        this.formatter = this.sdFormatter(n3);
        this.df = DateFormat.getDateInstance(n2);
        this.df.setTimeZone(TimeZone.getDefault());
        this.field = new AssistField(false, true, this.formatter.format(this.calendar.getDate().getTime()), 12);
        this.field.addFocusListener(this);
        this.field.setName("com.ibm.db2.tools.common.DropdownCalendarField");
        this.button.addKeyListener(this.calendar);
        this.add((Component)this.field, "Center");
        this.add((Component)this.button, "East");
        Dimension dimension2 = new Dimension();
        dimension2.width = icon.getIconWidth();
        dimension2.height = icon.getIconHeight();
        Border border = UIManager.getBorder("DropdownCalendarButton.border");
        if (null != border) {
            Insets insets = this.button.getMargin();
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setBorder(border);
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
        }
        this.button.setPreferredSize(dimension2);
        this.button.setSize(dimension2);
        this.addPropertyChangeListener("labeledBy", this);
        this.addPropertyChangeListener("UAKey", this);
        this.getAccessibleContext().addPropertyChangeListener(this);
        this.setBorder();
    }

    public DropdownCalendar(int n2, int n3) {
        this(n2, n3, 0);
    }

    public void setBorder() {
        Border border = AssistManager.getBorder("TextField.border");
        if (!border.equals(this.getBorder())) {
            this.setBorder(border);
            this.repaint();
        }
    }

    public DropdownCalendar(int n2) {
        this(n2, 3);
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public SimpleDateFormat sdFormatter(int n2) {
        SimpleDateFormat simpleDateFormat;
        switch (n2) {
            case 1: {
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                break;
            }
            case 2: {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            default: {
                Locale locale = AssistManager.getPreferredLocale();
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(1, locale);
            }
        }
        return simpleDateFormat;
    }

    public void setEnabled(boolean bl) {
        this.button.setEnabled(bl);
        this.field.setEnabled(bl);
        if (bl) {
            this.field.setRequired(this.required);
        } else {
            this.field.setRequired(false);
        }
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        if (this.field.isEnabled()) {
            this.field.setRequired(bl);
        } else {
            this.field.setRequired(false);
        }
    }

    public JButton getButton() {
        return this.button;
    }

    public JTextField getTextField() {
        return this.field;
    }

    public AssistField getAssistField() {
        return this.field;
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String string) {
        this.field.setText(string);
    }

    public Date getDate() {
        return this.calendar.getDate().getTime();
    }

    public Calendar getCalendar() {
        return this.calendar.getDate();
    }

    public void setDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(AssistManager.getPreferredLocale());
        gregorianCalendar.setTime(date);
        this.calendar.setDate(gregorianCalendar);
        this.field.setText(this.formatter.format(this.calendar.getDate().getTime()));
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        this.calendar.setDate(gregorianCalendar);
        this.field.setText(this.formatter.format(this.calendar.getDate().getTime()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "showcal") {
            if (this.calendar.isVisible()) {
                this.unPop();
            } else {
                this.pop();
            }
        } else if (actionEvent.getActionCommand() == "Date rolled back") {
            this.unPop();
            this.button.requestFocus();
        } else if (actionEvent.getActionCommand() == "Date committed") {
            this.field.setText(this.formatter.format(this.calendar.getDate().getTime()));
            this.unPop();
            this.button.requestFocus();
        }
    }

    public void pop() {
        if (this.layeredPane == null) {
            this.layeredPane = this.getParentLayeredPane();
        }
        if (!this.calendar.isVisible()) {
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            Container container = this.getParent();
            Point point2 = this.position == 0 ? SwingUtilities.convertPoint(container, point.x, point.y - this.calendar.getHeight(), this.layeredPane) : SwingUtilities.convertPoint(container, point.x, point.y + dimension.height, this.layeredPane);
            this.calendar.setLocation(point2);
            this.calendar.setVisible(true);
            this.layeredPane.add((Component)this.calendar, JLayeredPane.POPUP_LAYER);
            this.layeredPane.moveToFront(this.calendar);
        }
        this.calendar.requestFocus();
    }

    public void unPop() {
        if (this.layeredPane != null && this.calendar.isVisible()) {
            this.calendar.setVisible(false);
            this.layeredPane.remove(this.calendar);
            this.layeredPane.repaint();
        }
    }

    private JLayeredPane getParentLayeredPane() {
        Container container = this.getParent();
        JLayeredPane jLayeredPane = null;
        Container container2 = container;
        while (container2 != null && jLayeredPane == null) {
            if (container2 instanceof JRootPane) {
                jLayeredPane = ((JRootPane)container2).getLayeredPane();
            } else if (container2 instanceof JLayeredPane) {
                jLayeredPane = (JLayeredPane)container2;
            }
            container2 = container2.getParent();
        }
        return jLayeredPane;
    }

    public Dimension getCalendarDropDownSize() {
        return this.calendar.getPreferredSize();
    }

    public static void InsureSpaceFor(DropdownCalendar dropdownCalendar, CommonDialog commonDialog, JPanel jPanel) {
        Dimension dimension = dropdownCalendar.getCalendarDropDownSize();
        Point point = dropdownCalendar.getLocation();
        Point point2 = SwingUtilities.convertPoint(dropdownCalendar.getParent(), point, jPanel);
        point2.y = point2.y + dropdownCalendar.getPreferredSize().height + dimension.height + 10;
        Dimension dimension2 = jPanel.getSize();
        int n2 = jPanel.getHeight();
        int n3 = jPanel.getWidth();
        JLabel jLabel = new JLabel(" ");
        int n4 = point2.x + dimension.width + 10;
        int n5 = 5;
        if (dimension2.height < point2.y) {
            n5 = point2.y - dimension2.height;
        }
        jLabel.setPreferredSize(new Dimension(n4, n5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", jPanel);
        jPanel2.add("South", jLabel);
        commonDialog.setClient(jPanel2);
        commonDialog.pack();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this) {
            if (propertyChangeEvent.getPropertyName().equals("labeledBy")) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.button.getAccessibleContext().setAccessibleName(jLabel.getText());
                    this.field.getAccessibleContext().setAccessibleName(jLabel.getText());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("UAKey")) {
                Object object = propertyChangeEvent.getNewValue();
                this.field.putClientProperty("UAKey", object);
                this.button.putClientProperty("UAKey", object);
            }
        } else if (propertyChangeEvent.getSource() == this.getAccessibleContext() && propertyChangeEvent.getPropertyName().equals("AccessibleName")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            this.field.getAccessibleContext().setAccessibleName(string2);
            this.button.getAccessibleContext().setAccessibleName(string2);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.prevDate = this.field.getText();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.field.getText().equals(this.prevDate)) {
            boolean bl = this.formatter.isLenient();
            this.formatter.setLenient(false);
            try {
                Date date = this.formatter.parse(this.field.getText());
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                this.calendar.setDate(gregorianCalendar);
            }
            catch (ParseException parseException) {
                this.field.setText(this.prevDate);
            }
            this.formatter.setLenient(bl);
        }
    }
}

