/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistTabbedPane;
import com.ibm.db2.tools.common.CommonToolBar;
import com.ibm.db2.tools.common.DockingArea;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.DockingPaneLayout;
import com.ibm.db2.tools.common.support.DockingTitleBar;
import com.ibm.db2.tools.common.support.ReuseStringBuffer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DockingPane
extends JPanel
implements ChangeListener,
ComponentListener,
FocusListener,
Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    public static final int NORTH = 4;
    public static final int WEST = 5;
    public static final int SOUTH = 6;
    public static final int EAST = 7;
    public static final int CENTER = 8;
    public static final String DOCKING_CONTAINER = "DockingContainer";
    protected DockingArea[] areas = new DockingArea[4];
    protected static String[] mapping = new String[]{"North", "West", "South", "East"};
    protected Collection minimizedAreas;
    protected String minimizedDesc;
    protected ArrayList runnables;
    protected static Dimension nbminsize = new Dimension(50, 51);
    static /* synthetic */ Class class$com$ibm$db2$tools$common$AssistTabbedPane;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$CommonToolBar;

    public DockingPane() {
        this.setLayout(new DockingPaneLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.minimizedAreas = null;
        this.minimizedDesc = null;
    }

    public void setClient(Component component) {
        if (this.getClient() != null) {
            this.remove(this.getClient());
        }
        if (component != null) {
            this.add(component, "Center");
        }
        this.doLayout();
        this.repaint();
    }

    public Component getClient() {
        return ((DockingPaneLayout)this.getLayout()).getChild("Center", false);
    }

    public boolean isMaximized() {
        return this.minimizedAreas != null;
    }

    public boolean isDocked(Component component) {
        if (component instanceof DockingArea && ((DockingArea)component).isFloating()) {
            return false;
        }
        if (this.minimizedAreas == null) {
            return AssistManager.isDescendant(this, component);
        }
        Iterator iterator = this.minimizedAreas.iterator();
        while (iterator.hasNext()) {
            Container container = (Container)iterator.next();
            if (container != component && !AssistManager.isDescendant(container, component)) continue;
            return true;
        }
        return false;
    }

    public DockingArea getArea(int n2) {
        DockingArea dockingArea;
        if (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3) {
            dockingArea = this.areas[n2];
            if (dockingArea == null) {
                dockingArea = new DockingArea(n2 == 0 || n2 == 2 ? 0 : 1);
                dockingArea.setTop(n2 == 0);
                this.areas[n2] = dockingArea;
                this.add((Component)dockingArea, mapping[n2]);
            }
        } else {
            dockingArea = new DockingArea(true, n2, n2 == 4 || n2 == 6 ? 0 : 1);
            this.addArea(dockingArea, n2);
        }
        dockingArea.setDockingPane(this);
        return dockingArea;
    }

    public void maxRestoreArea(DockingArea dockingArea) {
        if (this.minimizedAreas == null) {
            dockingArea.setOrientation(0);
            this.minimizedDesc = this.getClientDescription();
            this.minimizedAreas = this.listDockedAreas();
            this.setClient(null);
            this.addArea(dockingArea, "C");
            this.requestFocus();
            dockingArea.requestFocus();
            dockingArea.revalidate();
            dockingArea.doLayout();
            dockingArea.repaint();
        } else {
            Collection collection = this.listDockedAreas();
            if (this.minimizedAreas != null && collection != null && collection.size() > 1) {
                DockingArea dockingArea2 = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DockingArea dockingArea3 = (DockingArea)iterator.next();
                    if (!this.minimizedAreas.contains(dockingArea3)) continue;
                    dockingArea2 = dockingArea3;
                    break;
                }
                if (dockingArea2 == null) {
                    JSplitPane jSplitPane = new JSplitPane();
                    jSplitPane.setName(DOCKING_CONTAINER);
                    jSplitPane.setOrientation(0);
                    jSplitPane.setLeftComponent(this.getClient());
                    JPanel jPanel = new JPanel();
                    jSplitPane.setRightComponent(jPanel);
                    this.restoreContainer(this.minimizedDesc, this.minimizedAreas, jPanel);
                    this.minimizedDesc = null;
                    this.minimizedAreas = null;
                    this.requestFocus();
                    dockingArea.requestFocus();
                    return;
                }
                AssistTabbedPane assistTabbedPane = (AssistTabbedPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTabbedPane == null ? (class$com$ibm$db2$tools$common$AssistTabbedPane = DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane")) : class$com$ibm$db2$tools$common$AssistTabbedPane, dockingArea2);
                if (assistTabbedPane == null) {
                    this.restoreContainer(this.minimizedDesc, this.minimizedAreas, dockingArea2);
                    this.minimizedDesc = null;
                    this.minimizedAreas = null;
                    this.requestFocus();
                    dockingArea.requestFocus();
                    return;
                }
                int n2 = assistTabbedPane.getTabPlacement();
                Component[] componentArray = assistTabbedPane.getComponents();
                ArrayList<Component> arrayList = new ArrayList<Component>(componentArray.length - 1);
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(componentArray.length - 1);
                int n3 = 0;
                while (n3 < componentArray.length) {
                    if (componentArray[n3] != dockingArea2) {
                        arrayList.add(componentArray[n3]);
                        arrayList2.add(new Integer(assistTabbedPane.indexOfComponent(componentArray[n3])));
                    }
                    ++n3;
                }
                int n4 = assistTabbedPane.indexOfComponent(dockingArea2);
                this.restoreContainer(this.minimizedDesc, this.minimizedAreas, assistTabbedPane);
                assistTabbedPane = (AssistTabbedPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTabbedPane == null ? (class$com$ibm$db2$tools$common$AssistTabbedPane = DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane")) : class$com$ibm$db2$tools$common$AssistTabbedPane, dockingArea2);
                Iterator iterator2 = ((AbstractList)arrayList).iterator();
                Iterator iterator3 = ((AbstractList)arrayList2).iterator();
                int n5 = 0;
                int n6 = 1;
                if (assistTabbedPane == null) {
                    n5 = (Integer)iterator3.next();
                    if (n5 < n4) {
                        this.addTabbedPane(dockingArea2, (DockingArea)iterator2.next(), n2, true);
                    } else {
                        this.addTabbedPane(dockingArea2, (DockingArea)iterator2.next(), n2, false);
                    }
                    assistTabbedPane = (AssistTabbedPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTabbedPane == null ? (class$com$ibm$db2$tools$common$AssistTabbedPane = DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane")) : class$com$ibm$db2$tools$common$AssistTabbedPane, dockingArea2);
                    ++n6;
                }
                int n7 = assistTabbedPane.indexOfComponent(dockingArea2);
                while (iterator2.hasNext()) {
                    if (iterator3.hasNext()) {
                        n5 = (Integer)iterator3.next();
                    }
                    DockingArea dockingArea4 = (DockingArea)iterator2.next();
                    if (n5 < n4) {
                        this.addTab((JTabbedPane)assistTabbedPane, dockingArea4, n7 + n6 - 1);
                    } else {
                        this.addTab((JTabbedPane)assistTabbedPane, dockingArea4, n7 + n6);
                    }
                    ++n6;
                }
                int n8 = assistTabbedPane.getTabCount();
                int n9 = n8 - 1;
                while (n9 > -1) {
                    DockingArea dockingArea5 = (DockingArea)assistTabbedPane.getComponentAt(n9);
                    assistTabbedPane.insertTab(dockingArea5.getDockingTitle().getText(), null, dockingArea5, null, n9);
                    --n9;
                }
                this.minimizedDesc = null;
                this.minimizedAreas = null;
                this.requestFocus();
                dockingArea.requestFocus();
                assistTabbedPane.revalidate();
                assistTabbedPane.repaint();
                return;
            }
            this.restoreClient(this.minimizedDesc, this.minimizedAreas);
            this.minimizedDesc = null;
            this.minimizedAreas = null;
            this.requestFocus();
            AssistTabbedPane assistTabbedPane = (AssistTabbedPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTabbedPane == null ? (class$com$ibm$db2$tools$common$AssistTabbedPane = DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane")) : class$com$ibm$db2$tools$common$AssistTabbedPane, dockingArea);
            if (assistTabbedPane != null) {
                int n10 = assistTabbedPane.getTabCount();
                int n11 = n10 - 1;
                while (n11 > -1) {
                    DockingArea dockingArea6 = (DockingArea)assistTabbedPane.getComponentAt(n11);
                    assistTabbedPane.insertTab(dockingArea6.getDockingTitle().getText(), null, dockingArea6, null, n11);
                    --n11;
                }
                assistTabbedPane.setSelectedIndex(assistTabbedPane.indexOfComponent(dockingArea));
            }
            dockingArea.requestFocus();
            this.revalidate();
            this.repaint();
        }
    }

    public void minRestoreArea(DockingArea dockingArea) {
        if (this.minimizedAreas != null) {
            this.maxRestoreArea(dockingArea);
        }
    }

    public void restoreClient(String string, Collection collection) {
        this.restoreContainer(string, collection, this.getClient());
    }

    protected void restoreContainer(String string, Collection collection, Component component) {
        if (string == null || string.length() == 0 || collection.size() == 0) {
            return;
        }
        String string2 = "[]{}:;";
        char c2 = '\u0000';
        int n2 = 0;
        int n3 = 0;
        Stack<JSplitPane> stack = new Stack<JSplitPane>();
        Stack<Double> stack2 = new Stack<Double>();
        Stack<Boolean> stack3 = new Stack<Boolean>();
        JSplitPane jSplitPane = null;
        AssistTabbedPane assistTabbedPane = null;
        double d2 = 0.5;
        while (n3 < string.length()) {
            c2 = string.charAt(n2);
            switch (c2) {
                case '[': {
                    jSplitPane = new JSplitPane();
                    jSplitPane.setName(DOCKING_CONTAINER);
                    if (stack.size() == 0) {
                        if (component != null && component.getParent() instanceof JSplitPane) {
                            if (component == ((JSplitPane)component.getParent()).getLeftComponent()) {
                                ((JSplitPane)component.getParent()).setLeftComponent(jSplitPane);
                            } else {
                                ((JSplitPane)component.getParent()).setRightComponent(jSplitPane);
                            }
                        } else {
                            this.setClient(jSplitPane);
                        }
                    } else if (stack3.size() > 0 && ((Boolean)stack3.peek()).booleanValue()) {
                        ((JSplitPane)stack.peek()).setLeftComponent(jSplitPane);
                    } else {
                        ((JSplitPane)stack.peek()).setRightComponent(jSplitPane);
                    }
                    stack.push(jSplitPane);
                    stack3.push(Boolean.TRUE);
                    c2 = string.charAt(++n3);
                    switch (c2) {
                        case 'H': {
                            if (stack.size() <= 0) break;
                            ((JSplitPane)stack.peek()).setOrientation(1);
                            break;
                        }
                        default: {
                            if (stack.size() <= 0) break;
                            ((JSplitPane)stack.peek()).setOrientation(0);
                        }
                    }
                    if ((c2 = string.charAt(++n3)) != '0') break;
                    n2 = n3;
                    n3 += 2;
                    while (Character.isDigit(string.charAt(n3))) {
                        ++n3;
                    }
                    String string3 = string.substring(n2, n3);
                    try {
                        d2 = Double.parseDouble(string3);
                        stack2.push(new Double(d2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        d2 = 0.5;
                        stack2.push(new Double(d2));
                    }
                    break;
                }
                case ']': {
                    if (stack.size() <= 0 || stack2.size() <= 0 || stack3.size() <= 0) break;
                    this.setDividerLocation(((JSplitPane)stack.peek()).getParent().getSize(), (JSplitPane)stack.peek(), (Double)stack2.peek());
                    stack.pop();
                    stack2.pop();
                    stack3.pop();
                    break;
                }
                case '{': {
                    assistTabbedPane = new AssistTabbedPane();
                    assistTabbedPane.setMinimumSize(nbminsize);
                    assistTabbedPane.addFocusListener(this);
                    assistTabbedPane.addChangeListener(this);
                    assistTabbedPane.setName(DOCKING_CONTAINER);
                    if (stack.size() == 0) {
                        if (component != null && component.getParent() instanceof JSplitPane) {
                            if (component == ((JSplitPane)component.getParent()).getLeftComponent()) {
                                ((JSplitPane)component.getParent()).setLeftComponent(assistTabbedPane);
                            } else {
                                ((JSplitPane)component.getParent()).setRightComponent(assistTabbedPane);
                            }
                        } else {
                            this.setClient(assistTabbedPane);
                        }
                    } else if (stack3.size() > 0 && ((Boolean)stack3.peek()).booleanValue()) {
                        ((JSplitPane)stack.peek()).setLeftComponent(assistTabbedPane);
                    } else {
                        ((JSplitPane)stack.peek()).setRightComponent(assistTabbedPane);
                    }
                    c2 = string.charAt(++n3);
                    switch (c2) {
                        case 'L': {
                            assistTabbedPane.setTabPlacement(2);
                            break;
                        }
                        case 'R': {
                            assistTabbedPane.setTabPlacement(4);
                            break;
                        }
                        case 'B': {
                            assistTabbedPane.setTabPlacement(3);
                            break;
                        }
                        default: {
                            assistTabbedPane.setTabPlacement(1);
                        }
                    }
                    ++n3;
                    break;
                }
                case '}': {
                    assistTabbedPane = null;
                    ++n3;
                    break;
                }
                case ':': {
                    ++n3;
                    break;
                }
                case ';': {
                    if (assistTabbedPane == null) {
                        if (stack3.size() > 0) {
                            stack3.pop();
                        }
                        stack3.push(Boolean.FALSE);
                    }
                    ++n3;
                    break;
                }
                default: {
                    n3 = n2 + 1;
                    while (n3 < string.length() && string2.indexOf(string.charAt(n3)) == -1) {
                        ++n3;
                    }
                    String string3 = string.substring(n2, n3);
                    DockingArea dockingArea = DockingPane.findArea(collection, string3);
                    if (dockingArea == null) break;
                    dockingArea.setDockingPane(this);
                    dockingArea.setConstraint(8);
                    if (assistTabbedPane == null && stack.size() > 0) {
                        if (stack3.size() > 0 && ((Boolean)stack3.peek()).booleanValue()) {
                            ((JSplitPane)stack.peek()).setLeftComponent(dockingArea);
                            break;
                        }
                        ((JSplitPane)stack.peek()).setRightComponent(dockingArea);
                        break;
                    }
                    if (assistTabbedPane == null) {
                        this.add(dockingArea);
                        break;
                    }
                    String string4 = dockingArea.getDockingTitle().getText();
                    assistTabbedPane.addTab(string4, dockingArea);
                }
            }
            n2 = ++n3;
        }
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    public void restoreView(DockingArea dockingArea) {
        this.restoreView(dockingArea, dockingArea.getDockingDescription());
    }

    public void restoreView(DockingArea dockingArea, String string) {
        AssistTabbedPane assistTabbedPane;
        Object object;
        boolean bl = AssistManager.isDescendant(this, dockingArea);
        boolean bl2 = false;
        if (dockingArea.isFloating()) {
            CommonToolBar commonToolBar = dockingArea.getClient();
            if (commonToolBar != null) {
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = DockingPane.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, commonToolBar);
                if (jFrame != null) {
                    if (jFrame.getState() == 1) {
                        jFrame.setState(0);
                    }
                    jFrame.toFront();
                    if (!jFrame.isVisible()) {
                        ((Component)jFrame).setVisible(true);
                    }
                } else {
                    CommonToolBar commonToolBar2 = (CommonToolBar)AssistManager.getDescendantOfClass(dockingArea, class$com$ibm$db2$tools$common$CommonToolBar == null ? (class$com$ibm$db2$tools$common$CommonToolBar = DockingPane.class$("com.ibm.db2.tools.common.CommonToolBar")) : class$com$ibm$db2$tools$common$CommonToolBar);
                    commonToolBar2.setFloating(true, commonToolBar2.getFloatingLocation());
                }
                dockingArea.setDockingPane(this);
            }
            return;
        }
        if (!bl && this.minimizedDesc != null && this.isDocked(dockingArea)) {
            this.maxRestoreArea(dockingArea);
        }
        if (!bl && !this.isDocked(dockingArea)) {
            String string2;
            bl2 = true;
            boolean bl3 = false;
            if (string != null && string.length() > 0 && (string2 = this.getClientDescription()).length() > 0) {
                object = DockingPane.taggify(DockingPane.getViewTitle(dockingArea));
                DNode dNode = this.parseDescription(string2);
                DNode dNode2 = this.parseDescription(string);
                DNode dNode3 = dNode2.findView((String)object);
                if (dNode3 != null) {
                    DNode dNode4;
                    int n2;
                    DNode dNode5;
                    DNode dNode6 = dNode3.getParent();
                    if (dNode6 != null && dNode6.getType() == 1) {
                        dNode5 = dNode.findNotebook(dNode6);
                        if (dNode5 != null) {
                            int n3 = dNode6.getChildIndex(dNode3);
                            dNode5.dockAt(new Integer(n3));
                            bl3 = true;
                        } else {
                            DNode dNode7 = dNode6.findSibling(dNode3);
                            n2 = dNode6.getChildIndex(dNode3);
                            DNode dNode8 = dNode.findView(dNode7.getName());
                            if (dNode8 != null) {
                                dNode8.dockAt(new Integer(n2));
                                bl3 = true;
                                if (dNode6.getOrientation() != 'T') {
                                    dNode8.setOrientation(dNode6.getOrientation());
                                }
                            }
                        }
                        if (bl3) {
                            this.minRestoreArea(dockingArea);
                            ReuseStringBuffer reuseStringBuffer = dNode.getDockingDesc(null);
                            this.addArea(dockingArea, ReuseStringBuffer.toString(reuseStringBuffer));
                        }
                    } else if (dNode6 != null && dNode != null && (dNode4 = dNode.findNode(dNode5 = dNode6.findSibling(dNode3))) != null) {
                        n2 = dNode4.getType();
                        char c2 = dNode6.getOrientation();
                        char c3 = 'S';
                        c3 = c2 == 'H' ? (dNode6.getChildIndex(dNode3) == 0 ? (n2 == 2 ? (char)'W' : 'L') : (n2 == 2 ? (char)'E' : 'R')) : (dNode6.getChildIndex(dNode3) == 0 ? (n2 == 2 ? (char)'N' : 'T') : (n2 == 2 ? (char)'S' : 'B'));
                        dNode4.dockAt(new Character(c3));
                        bl3 = true;
                        ReuseStringBuffer reuseStringBuffer = dNode.getDockingDesc(null);
                        this.addArea(dockingArea, ReuseStringBuffer.toString(reuseStringBuffer));
                    }
                }
            }
            if (!bl3) {
                this.addArea(dockingArea, dockingArea.getConstraint());
            }
        }
        if ((assistTabbedPane = (AssistTabbedPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTabbedPane == null ? (class$com$ibm$db2$tools$common$AssistTabbedPane = DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane")) : class$com$ibm$db2$tools$common$AssistTabbedPane, dockingArea)) != null) {
            if (bl2) {
                int n4 = assistTabbedPane.getTabCount();
                int n5 = 0;
                while (n5 < n4) {
                    object = (DockingArea)assistTabbedPane.getComponentAt(n5);
                    assistTabbedPane.insertTab(((DockingArea)object).getDockingTitle().getText(), null, (Component)object, null, n5);
                    ++n5;
                }
            }
            assistTabbedPane.setSelectedIndex(assistTabbedPane.indexOfComponent(dockingArea));
        }
        this.requestFocus();
        dockingArea.requestFocus();
    }

    public static String getViewTitle(ActionEvent actionEvent) {
        String string = null;
        Object object = actionEvent.getSource();
        if (object instanceof DockingArea) {
            string = DockingPane.getViewTitle((DockingArea)object);
        } else if (object instanceof Component && ((Component)object).getParent() != null && ((Component)object).getParent() instanceof DockingTitleBar) {
            string = ((DockingTitleBar)((Component)object).getParent()).getText();
        }
        return string;
    }

    public static String getViewTitle(DockingArea dockingArea) {
        return dockingArea.getDockingTitle().getText();
    }

    public Collection listDockedAreas() {
        ArrayList arrayList = new ArrayList();
        this.listDockedAreas(this, arrayList);
        return arrayList;
    }

    protected void listDockedAreas(Container container, Collection collection) {
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = container.getComponent(n3);
            if (component instanceof DockingArea && ((DockingArea)component).getDockingWindow() && ((DockingArea)component).hasClient()) {
                collection.add(component);
            } else if (component instanceof Container) {
                this.listDockedAreas((Container)component, collection);
            }
            ++n3;
        }
    }

    public static DockingArea findArea(Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof DockingArea)) continue;
            DockingTitleBar dockingTitleBar = ((DockingArea)e2).getDockingTitle();
            if (dockingTitleBar != null) {
                String string2 = dockingTitleBar.getText();
                if (string2 != null && DockingPane.taggify(string2).equals(string)) {
                    return (DockingArea)e2;
                }
                if (string2 != null) continue;
                System.err.println("dockingTitle null for area: " + e2);
                continue;
            }
            System.err.println("areaBar null for area: " + e2);
        }
        return null;
    }

    public String getClientDescription() {
        Collection collection = this.listDockedAreas();
        if (this.minimizedAreas != null && collection != null && collection.size() > 1) {
            this.maxRestoreArea((DockingArea)collection.iterator().next());
        }
        if (this.minimizedDesc != null) {
            return this.minimizedDesc;
        }
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        this.describeChildren((Container)this.getClient(), reuseStringBuffer);
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    protected void describeChildren(Container container, ReuseStringBuffer reuseStringBuffer) {
        if (container instanceof DockingArea) {
            String string = ((DockingArea)container).getDockingTitle().getText();
            reuseStringBuffer.append(DockingPane.taggify(string));
        } else if (container instanceof JSplitPane && DOCKING_CONTAINER.equals(container.getName())) {
            double d2;
            reuseStringBuffer.append('[');
            int n2 = ((JSplitPane)container).getOrientation();
            Dimension dimension = container.getSize();
            if (n2 == 0) {
                reuseStringBuffer.append('V');
                int n3 = ((JSplitPane)container).getDividerLocation();
                int n4 = ((JSplitPane)container).getDividerSize();
                d2 = (double)n3 / (double)(dimension.height - n4);
            } else {
                reuseStringBuffer.append('H');
                int n5 = ((JSplitPane)container).getDividerLocation();
                int n6 = ((JSplitPane)container).getDividerSize();
                d2 = (double)n5 / (double)(dimension.width - n6);
            }
            if (d2 < 0.2) {
                d2 = 0.2;
            }
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.applyPattern("0.0#");
            reuseStringBuffer.append(decimalFormat.format(d2));
            reuseStringBuffer.append(':');
            Component component = ((JSplitPane)container).getLeftComponent();
            if (component instanceof Container) {
                this.describeChildren((Container)component, reuseStringBuffer);
            }
            reuseStringBuffer.append(';');
            component = ((JSplitPane)container).getRightComponent();
            if (component instanceof Container) {
                this.describeChildren((Container)component, reuseStringBuffer);
            }
            reuseStringBuffer.append(']');
        } else if (container instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(container.getName())) {
            reuseStringBuffer.append('{');
            int n7 = ((JTabbedPane)container).getTabPlacement();
            if (n7 == 1) {
                reuseStringBuffer.append('T');
            } else if (n7 == 3) {
                reuseStringBuffer.append('B');
            } else if (n7 == 2) {
                reuseStringBuffer.append('L');
            } else if (n7 == 4) {
                reuseStringBuffer.append('R');
            }
            reuseStringBuffer.append(':');
            int n8 = ((JTabbedPane)container).getTabCount();
            int n9 = 0;
            while (n9 < n8) {
                reuseStringBuffer.append(DockingPane.taggify(((JTabbedPane)container).getTitleAt(n9)));
                if (++n9 >= n8) continue;
                reuseStringBuffer.append(';');
            }
            reuseStringBuffer.append('}');
        }
    }

    public String getClientDescription(Component component, DockingArea dockingArea) {
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
        this.describeChildren((Container)this.getClient(), component, reuseStringBuffer, dockingArea, false);
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    protected int scanBuf(ReuseStringBuffer reuseStringBuffer, char c2, boolean bl) {
        int n2;
        int n3 = reuseStringBuffer.length();
        if (bl) {
            n2 = n3 - 1;
            while (n2 > -1) {
                if (reuseStringBuffer.charAt(n2) != c2) {
                    --n2;
                    continue;
                }
                break;
            }
        } else {
            n2 = 0;
            while (n2 < n3) {
                if (reuseStringBuffer.charAt(n2) != c2) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        return n2;
    }

    protected void describeChildren(Container container, Component component, ReuseStringBuffer reuseStringBuffer, DockingArea dockingArea, boolean bl) {
        int n2 = 20;
        Point point = null;
        Point point2 = null;
        Rectangle rectangle = this.getClientBounds();
        Dimension dimension = null;
        if (component != null) {
            point = component.getLocation();
            SwingUtilities.convertPointFromScreen(point, this);
            dimension = component.getSize();
            point2 = new Point(point.x, point.y);
            dimension.width = dimension.width < n2 ? dimension.width : n2;
            dimension.height = dimension.height < n2 ? dimension.height : n2;
            point.x = point2.x - dimension.width / 2;
            point.y = point2.y - dimension.height / 2;
        }
        if (container == null) {
            if (rectangle.contains(point2)) {
                reuseStringBuffer.append('C');
            }
        } else if (container instanceof JSplitPane && DOCKING_CONTAINER.equals(container.getName())) {
            if (dockingArea.getParent() != container) {
                Component component2;
                Rectangle rectangle2;
                double d2;
                reuseStringBuffer.append('[');
                int n3 = ((JSplitPane)container).getOrientation();
                Dimension dimension2 = container.getSize();
                Point point3 = SwingUtilities.convertPoint(container.getParent(), container.getLocation(), this);
                if (n3 == 0) {
                    reuseStringBuffer.append('V');
                    int n4 = ((JSplitPane)container).getDividerLocation();
                    int n5 = ((JSplitPane)container).getDividerSize();
                    d2 = (double)n4 / (double)(dimension2.height - n5);
                } else {
                    reuseStringBuffer.append('H');
                    int n6 = ((JSplitPane)container).getDividerLocation();
                    int n7 = ((JSplitPane)container).getDividerSize();
                    d2 = (double)n6 / (double)(dimension2.width - n7);
                }
                if (d2 < 0.2) {
                    d2 = 0.2;
                }
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
                decimalFormat.applyPattern("0.0#");
                reuseStringBuffer.append(decimalFormat.format(d2));
                BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)((JSplitPane)container).getUI()).getDivider();
                Point point4 = basicSplitPaneDivider.getLocation();
                point4 = SwingUtilities.convertPoint(container, point4, this);
                Dimension dimension3 = basicSplitPaneDivider.getSize();
                if (component != null) {
                    if (n3 == 0) {
                        if (!bl && point4.y > point.y + n2 && this.deepestSplitter((JSplitPane)container, true, point2)) {
                            rectangle2 = ((JSplitPane)container).getLeftComponent().getBounds();
                            rectangle2 = SwingUtilities.convertRectangle(((JSplitPane)container).getLeftComponent().getParent(), rectangle2, this);
                            reuseStringBuffer.append(this.getQuadrant(dockingArea, ((JSplitPane)container).getLeftComponent(), rectangle2, point2));
                            bl = true;
                        } else if (point4.y > point.y && point4.y < point.y + n2) {
                            if (!bl && point4.x < point2.x && point4.x + dimension3.width / 2 >= point2.x) {
                                reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "L");
                                bl = true;
                            } else if (!bl && point4.x + dimension3.width > point2.x && point4.x + dimension3.width / 2 < point2.x) {
                                reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "R");
                                bl = true;
                            }
                        }
                    } else if (!bl && point4.x > point.x + n2 && this.deepestSplitter((JSplitPane)container, true, point2)) {
                        rectangle2 = ((JSplitPane)container).getLeftComponent().getBounds();
                        rectangle2 = SwingUtilities.convertRectangle(((JSplitPane)container).getLeftComponent().getParent(), rectangle2, this);
                        reuseStringBuffer.append(this.getQuadrant(dockingArea, ((JSplitPane)container).getLeftComponent(), rectangle2, point2));
                        bl = true;
                    } else if (point4.x > point.x && point4.x < point.x + n2) {
                        if (!bl && point4.y < point2.y && point4.y + dimension3.height / 2 >= point2.y) {
                            reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "T");
                            bl = true;
                        } else if (!bl && point4.y + dimension3.height > point2.y && point4.y + dimension3.height / 2 < point2.y) {
                            reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "B");
                            bl = true;
                        }
                    }
                }
                if ((component2 = ((JSplitPane)container).getLeftComponent()) instanceof Container) {
                    this.describeChildren((Container)component2, component, reuseStringBuffer, dockingArea, bl);
                }
                reuseStringBuffer.append(';');
                if (component != null) {
                    if (n3 == 0) {
                        if (!bl && point4.y + dimension3.height < point.y && this.deepestSplitter((JSplitPane)container, false, point2)) {
                            rectangle2 = ((JSplitPane)container).getRightComponent().getBounds();
                            rectangle2 = SwingUtilities.convertRectangle(((JSplitPane)container).getRightComponent().getParent(), rectangle2, this);
                            reuseStringBuffer.append(this.getQuadrant(dockingArea, ((JSplitPane)container).getRightComponent(), rectangle2, point2));
                            bl = true;
                        }
                    } else if (!bl && point4.x + dimension3.width < point.x && this.deepestSplitter((JSplitPane)container, false, point2)) {
                        rectangle2 = ((JSplitPane)container).getRightComponent().getBounds();
                        rectangle2 = SwingUtilities.convertRectangle(((JSplitPane)container).getRightComponent().getParent(), rectangle2, this);
                        reuseStringBuffer.append(this.getQuadrant(dockingArea, ((JSplitPane)container).getRightComponent(), rectangle2, point2));
                        bl = true;
                    }
                }
                if ((component2 = ((JSplitPane)container).getRightComponent()) instanceof Container) {
                    this.describeChildren((Container)component2, component, reuseStringBuffer, dockingArea, bl);
                }
                reuseStringBuffer.append(']');
            } else if (dockingArea.getParent() == container && DockingPane.betweenSplitters(this, dockingArea, point2)) {
                int n8 = ((JSplitPane)container).getOrientation();
                BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)((JSplitPane)container).getUI()).getDivider();
                Point point5 = basicSplitPaneDivider.getLocation();
                point5 = SwingUtilities.convertPoint(container, point5, this);
                Dimension dimension4 = basicSplitPaneDivider.getSize();
                if (n8 == 0) {
                    if (!bl && point5.x < point2.x && point5.x + dimension4.width / 2 >= point2.x) {
                        reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "L");
                        bl = true;
                    } else if (!bl && point5.x + dimension4.width > point2.x && point5.x + dimension4.width / 2 < point2.x) {
                        reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "R");
                        bl = true;
                    }
                } else if (!bl && point5.y < point2.y && point5.y + dimension4.height / 2 >= point2.y) {
                    reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "T");
                    bl = true;
                } else if (!bl && point5.y + dimension4.height > point2.y && point5.y + dimension4.height / 2 < point2.y) {
                    reuseStringBuffer.insert(this.scanBuf(reuseStringBuffer, '[', true), "B");
                    bl = true;
                }
            } else {
                Component component3 = ((JSplitPane)container).getLeftComponent();
                if (component3 != dockingArea) {
                    this.describeChildren((Container)component3, component, reuseStringBuffer, dockingArea, bl);
                } else {
                    component3 = ((JSplitPane)container).getRightComponent();
                    this.describeChildren((Container)component3, component, reuseStringBuffer, dockingArea, bl);
                }
            }
        } else if (container != null) {
            if (container instanceof JSplitPane && DOCKING_CONTAINER.equals(container.getName())) {
                int n9 = container.getComponentCount();
                int n10 = 0;
                while (n10 < n9) {
                    Component component4 = container.getComponent(n10);
                    if (component4 instanceof Container) {
                        this.describeChildren((Container)component4, component, reuseStringBuffer, dockingArea, bl);
                    }
                    ++n10;
                }
            } else if (!bl && container != dockingArea) {
                Rectangle rectangle3 = container.getBounds();
                rectangle3 = SwingUtilities.convertRectangle(container.getParent(), rectangle3, this);
                reuseStringBuffer.append(this.getQuadrant(dockingArea, container, rectangle3, point2));
                bl = true;
            }
        }
    }

    public static boolean betweenSplitters(DockingPane dockingPane, DockingArea dockingArea, Point point) {
        Rectangle rectangle = dockingArea.getBounds();
        rectangle = SwingUtilities.convertRectangle(dockingArea.getParent(), rectangle, dockingPane);
        if (point.x > rectangle.x && point.x < rectangle.x + rectangle.width && point.y > rectangle.y && point.y < rectangle.y + rectangle.height && dockingArea.getParent() != null && dockingArea.getParent().getParent() != null && dockingArea.getParent() instanceof JSplitPane && DOCKING_CONTAINER.equals(dockingArea.getParent().getName()) && dockingArea.getParent().getParent() instanceof JSplitPane && DOCKING_CONTAINER.equals(dockingArea.getParent().getParent().getName())) {
            JSplitPane jSplitPane = (JSplitPane)dockingArea.getParent();
            JSplitPane jSplitPane2 = (JSplitPane)dockingArea.getParent().getParent();
            if (jSplitPane.getOrientation() == jSplitPane2.getOrientation() && (jSplitPane == jSplitPane2.getLeftComponent() && dockingArea == jSplitPane.getRightComponent() || jSplitPane == jSplitPane2.getRightComponent() && dockingArea == jSplitPane.getLeftComponent())) {
                return true;
            }
        }
        return false;
    }

    protected boolean deepestSplitter(JSplitPane jSplitPane, boolean bl, Point point) {
        if (jSplitPane == null) {
            return false;
        }
        Component component = bl ? jSplitPane.getLeftComponent() : jSplitPane.getRightComponent();
        if (component == null || component instanceof JSplitPane && DOCKING_CONTAINER.equals(component.getName())) {
            return false;
        }
        Rectangle rectangle = component.getBounds();
        rectangle = SwingUtilities.convertRectangle(jSplitPane, rectangle, this);
        return rectangle.contains(point);
    }

    protected boolean inCenter(Rectangle rectangle, Point point) {
        int n2 = rectangle.width / 4;
        int n3 = rectangle.height / 4;
        return point.x > rectangle.x + n2 && point.x < rectangle.x + rectangle.width - n2 && point.y > rectangle.y + n3 && point.y < rectangle.y + rectangle.height - n3;
    }

    protected String getQuadrant(DockingArea dockingArea, Component component, Rectangle rectangle, Point point) {
        String string;
        if (!rectangle.contains(point)) {
            string = "";
        } else {
            boolean bl = this.inCenter(rectangle, point);
            if (bl && component instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(component.getName())) {
                int n2 = ((JTabbedPane)component).getTabPlacement();
                int n3 = ((JTabbedPane)component).getTabCount();
                if (dockingArea.getParent() != component) {
                    ++n3;
                }
                if (n2 == 1) {
                    int n4 = rectangle.width / 4;
                    int n5 = n4 + n4;
                    double d2 = n5 / n3;
                    int n6 = (int)((double)(point.x - rectangle.x - n4) / d2);
                    n6 = Math.min(n6, n3 - 1);
                    string = "n" + n6 + "/" + n3;
                } else if (n2 == 3) {
                    int n7 = rectangle.width / 4;
                    int n8 = n7 + n7;
                    double d3 = n8 / n3;
                    int n9 = (int)((double)(point.x - rectangle.x - n7) / d3);
                    n9 = Math.min(n9, n3 - 1);
                    string = "s" + n9 + "/" + n3;
                } else if (n2 == 2) {
                    int n10 = rectangle.height / 4;
                    int n11 = n10 + n10;
                    double d4 = n11 / n3;
                    int n12 = (int)((double)(point.y - rectangle.y - n10) / d4);
                    n12 = Math.min(n12, n3 - 1);
                    string = "w" + n12 + "/" + n3;
                } else {
                    int n13 = rectangle.height / 4;
                    int n14 = n13 + n13;
                    double d5 = n14 / n3;
                    int n15 = (int)((double)(point.y - rectangle.y - n13) / d5);
                    n15 = Math.min(n15, n3 - 1);
                    string = "e" + n15 + "/" + n3;
                }
            } else {
                string = point.y - rectangle.y == 0 ? "N" : (point.y - rectangle.y - rectangle.height == 0 ? "S" : ((float)(point.x - rectangle.x) / (float)(point.y - rectangle.y) <= (float)rectangle.width / (float)rectangle.height ? ((float)(point.x - rectangle.x) / (float)(point.y - rectangle.y - rectangle.height) <= (float)rectangle.width / (float)(rectangle.height * -1) ? (bl ? (point.x < rectangle.x + rectangle.width / 2 ? "s0/2" : "s1/2") : "S") : (bl ? (point.y < rectangle.y + rectangle.height / 2 ? "w0/2" : "w1/2") : "W")) : ((float)(point.x - rectangle.x) / (float)(point.y - rectangle.y - rectangle.height) <= (float)rectangle.width / (float)(rectangle.height * -1) ? (bl ? (point.y < rectangle.y + rectangle.height / 2 ? "e0/2" : "e1/2") : "E") : (bl ? (point.x < rectangle.x + rectangle.width / 2 ? "n0/2" : "n1/2") : "N"))));
            }
        }
        return string;
    }

    public void addArea(DockingArea dockingArea, String string) {
        Object object;
        if (dockingArea == null || string == null || string.length() == 0) {
            return;
        }
        if (this.getClient() == null) {
            this.setClient(dockingArea);
        } else {
            object = new StringTokenizer(string, "[];CEWNSTBLRewnstblr", true);
            String string2 = "0";
            char c2 = '\u0000';
            char c3 = '\u0000';
            int n2 = 0;
            int n3 = -1;
            Stack<Integer> stack = new Stack<Integer>();
            Container container = this;
            boolean bl = true;
            block49: while (((StringTokenizer)object).hasMoreTokens() && bl) {
                String string3 = ((StringTokenizer)object).nextToken();
                c2 = string3.charAt(0);
                if ("ewns".indexOf(string3) > -1 && ((StringTokenizer)object).hasMoreTokens()) {
                    string3 = string3 + ((StringTokenizer)object).nextToken();
                }
                switch (c2) {
                    case '[': {
                        if (container == null) {
                            System.err.println("DockingPane.addArea null comp at [");
                        }
                        container = container == this ? (Container)this.getClient() : (stack.size() > 0 && (Integer)stack.peek() == 1 ? (Container)((JSplitPane)container).getLeftComponent() : (Container)((JSplitPane)container).getRightComponent());
                        stack.push(new Integer(1));
                        break;
                    }
                    case 'e': 
                    case 'n': 
                    case 's': 
                    case 'w': {
                        if (stack.size() == 0) {
                            Component component = AssistManager.getDescendantOfClass(container, class$com$ibm$db2$tools$common$AssistTabbedPane == null ? DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane") : class$com$ibm$db2$tools$common$AssistTabbedPane);
                            if (component != null && !DOCKING_CONTAINER.equals(component.getName())) {
                                component = null;
                            }
                            n2 = 0;
                            if (string3.length() > 1) {
                                n3 = string3.indexOf(47);
                                try {
                                    n2 = n3 > -1 ? Integer.parseInt(string3.substring(1, n3)) : Integer.parseInt(string3.substring(1));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n2 = 0;
                                }
                            }
                            switch (c2) {
                                case 'e': {
                                    if (container == this && component != null) {
                                        this.addTab((JTabbedPane)component, dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(container, dockingArea, 4, n2 == 0);
                                    break;
                                }
                                case 'w': {
                                    if (container == this && component != null) {
                                        this.addTab((JTabbedPane)component, dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(container, dockingArea, 2, n2 == 0);
                                    break;
                                }
                                case 'n': {
                                    if (container == this && component != null) {
                                        this.addTab((JTabbedPane)component, dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(container, dockingArea, 1, n2 == 0);
                                    break;
                                }
                                case 's': {
                                    if (container == this && component != null) {
                                        this.addTab((JTabbedPane)component, dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(container, dockingArea, 3, n2 == 0);
                                }
                            }
                            bl = false;
                            break;
                        }
                        c3 = c2;
                        string2 = string3;
                        break;
                    }
                    case 'C': 
                    case 'E': 
                    case 'N': 
                    case 'S': 
                    case 'W': {
                        if (stack.size() == 0) {
                            switch (c2) {
                                case 'E': {
                                    this.addArea(dockingArea, 7);
                                    break;
                                }
                                case 'W': {
                                    this.addArea(dockingArea, 5);
                                    break;
                                }
                                case 'N': {
                                    this.addArea(dockingArea, 4);
                                    break;
                                }
                                case 'S': {
                                    this.addArea(dockingArea, 6);
                                    break;
                                }
                                default: {
                                    this.addArea(dockingArea, 8);
                                }
                            }
                            bl = false;
                            break;
                        }
                        c3 = c2;
                        string2 = string3;
                        break;
                    }
                    case 'T': {
                        container = container == this ? (Container)this.getClient() : (stack.size() > 0 && (Integer)stack.peek() == 1 ? (Container)((JSplitPane)container).getLeftComponent() : (Container)((JSplitPane)container).getRightComponent());
                        Container container2 = container.getParent();
                        JSplitPane jSplitPane = new JSplitPane(0, dockingArea, container);
                        jSplitPane.setName(DOCKING_CONTAINER);
                        container2.add(jSplitPane);
                        this.setDividerLocation(container2.getSize(), jSplitPane, 0.333);
                        bl = false;
                        break;
                    }
                    case 'B': {
                        container = container == this ? (Container)this.getClient() : (stack.size() > 0 && (Integer)stack.peek() == 1 ? (Container)((JSplitPane)container).getLeftComponent() : (Container)((JSplitPane)container).getRightComponent());
                        if (container == null) {
                            System.err.println("DockingPane B but no JSplitPane following");
                        }
                        Container container2 = container.getParent();
                        JSplitPane jSplitPane = new JSplitPane(0, container, dockingArea);
                        jSplitPane.setName(DOCKING_CONTAINER);
                        container2.add(jSplitPane);
                        this.setDividerLocation(container2.getSize(), jSplitPane, 0.666);
                        bl = false;
                        break;
                    }
                    case 'L': {
                        container = container == this ? (Container)this.getClient() : (stack.size() > 0 && (Integer)stack.peek() == 1 ? (Container)((JSplitPane)container).getLeftComponent() : (Container)((JSplitPane)container).getRightComponent());
                        if (container == null) {
                            System.err.println("DockingPane L but no JSplitPane following.");
                        }
                        Container container2 = container.getParent();
                        JSplitPane jSplitPane = new JSplitPane(1, dockingArea, container);
                        jSplitPane.setName(DOCKING_CONTAINER);
                        container2.add(jSplitPane);
                        this.setDividerLocation(container2.getSize(), jSplitPane, 0.333);
                        bl = false;
                        break;
                    }
                    case 'R': {
                        container = container == this ? (Container)this.getClient() : (stack.size() > 0 && (Integer)stack.peek() == 1 ? (Container)((JSplitPane)container).getLeftComponent() : (Container)((JSplitPane)container).getRightComponent());
                        if (container == null) {
                            System.err.println("DockingPane R but no JSplitPane following.");
                        }
                        Container container2 = container.getParent();
                        JSplitPane jSplitPane = new JSplitPane(1, container, dockingArea);
                        jSplitPane.setName(DOCKING_CONTAINER);
                        container2.add(jSplitPane);
                        this.setDividerLocation(container2.getSize(), jSplitPane, 0.666);
                        bl = false;
                        break;
                    }
                    case ';': {
                        JSplitPane jSplitPane;
                        if (c3 != '\u0000' && c3 != 'C') {
                            jSplitPane = null;
                            char c4 = '\u0000';
                            n2 = 0;
                            if (string2.length() > 1) {
                                n3 = string2.indexOf(47);
                                try {
                                    n2 = n3 > -1 ? Integer.parseInt(string2.substring(1, n3)) : Integer.parseInt(string2.substring(1));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n2 = 0;
                                }
                            }
                            switch (c3) {
                                case 'e': {
                                    if (((JSplitPane)container).getLeftComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getLeftComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getLeftComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getLeftComponent(), dockingArea, 4, n2 == 0);
                                    break;
                                }
                                case 'w': {
                                    if (((JSplitPane)container).getLeftComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getLeftComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getLeftComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getLeftComponent(), dockingArea, 2, n2 == 0);
                                    break;
                                }
                                case 'n': {
                                    if (((JSplitPane)container).getLeftComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getLeftComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getLeftComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getLeftComponent(), dockingArea, 1, n2 == 0);
                                    break;
                                }
                                case 's': {
                                    if (((JSplitPane)container).getLeftComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getLeftComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getLeftComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getLeftComponent(), dockingArea, 3, n2 == 0);
                                    break;
                                }
                                case 'N': {
                                    jSplitPane = new JSplitPane(0, dockingArea, ((JSplitPane)container).getLeftComponent());
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                case 'S': {
                                    jSplitPane = new JSplitPane(0, ((JSplitPane)container).getLeftComponent(), dockingArea);
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                case 'E': {
                                    jSplitPane = new JSplitPane(1, ((JSplitPane)container).getLeftComponent(), dockingArea);
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                case 'W': {
                                    jSplitPane = new JSplitPane(1, dockingArea, ((JSplitPane)container).getLeftComponent());
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                default: {
                                    c4 = c3;
                                }
                            }
                            if (jSplitPane != null) {
                                ((JSplitPane)container).setLeftComponent(jSplitPane);
                                this.setDividerLocation(container.getSize(), jSplitPane, 0.5);
                                bl = false;
                                break;
                            }
                            if (c4 == '\u0000') {
                                c3 = '\u0000';
                            }
                        }
                        if (stack.size() > 0) {
                            stack.pop();
                        }
                        stack.push(new Integer(2));
                        break;
                    }
                    case ']': {
                        JSplitPane jSplitPane;
                        if (container == null) {
                            System.err.println("DockingPane.addArea null comp at ]");
                        }
                        if (c3 != '\u0000' && c3 != 'C') {
                            jSplitPane = null;
                            char c5 = '\u0000';
                            n2 = 0;
                            if (string2.length() > 1) {
                                n3 = string2.indexOf(47);
                                try {
                                    n2 = n3 > -1 ? Integer.parseInt(string2.substring(1, n3)) : Integer.parseInt(string2.substring(1));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n2 = 0;
                                }
                            }
                            switch (c3) {
                                case 'e': {
                                    if (((JSplitPane)container).getRightComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getRightComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getRightComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getRightComponent(), dockingArea, 4, n2 == 0);
                                    break;
                                }
                                case 'w': {
                                    if (((JSplitPane)container).getRightComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getRightComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getRightComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getRightComponent(), dockingArea, 2, n2 == 0);
                                    break;
                                }
                                case 'n': {
                                    if (((JSplitPane)container).getRightComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getRightComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getRightComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getRightComponent(), dockingArea, 1, n2 == 0);
                                    break;
                                }
                                case 's': {
                                    if (((JSplitPane)container).getRightComponent() instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((JSplitPane)container).getRightComponent().getName())) {
                                        this.addTab((JTabbedPane)((JSplitPane)container).getRightComponent(), dockingArea, n2);
                                        break;
                                    }
                                    this.addTabbedPane(((JSplitPane)container).getRightComponent(), dockingArea, 3, n2 == 0);
                                    break;
                                }
                                case 'N': {
                                    jSplitPane = new JSplitPane(0, dockingArea, ((JSplitPane)container).getRightComponent());
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                case 'S': {
                                    jSplitPane = new JSplitPane(0, ((JSplitPane)container).getRightComponent(), dockingArea);
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                case 'E': {
                                    jSplitPane = new JSplitPane(1, ((JSplitPane)container).getRightComponent(), dockingArea);
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                case 'W': {
                                    jSplitPane = new JSplitPane(1, dockingArea, ((JSplitPane)container).getRightComponent());
                                    jSplitPane.setName(DOCKING_CONTAINER);
                                    break;
                                }
                                default: {
                                    c5 = c3;
                                }
                            }
                            if (jSplitPane != null) {
                                ((JSplitPane)container).setRightComponent(jSplitPane);
                                this.setDividerLocation(container.getSize(), jSplitPane, 0.5);
                                bl = false;
                                break;
                            }
                            if (c5 == '\u0000') {
                                c3 = '\u0000';
                            }
                        }
                        if (!((container = container.getParent()) instanceof JSplitPane) || !DOCKING_CONTAINER.equals(container.getName()) || stack.size() <= 0) continue block49;
                        stack.pop();
                        break;
                    }
                }
            }
        }
        dockingArea.setDockingPane(this);
        object = (AssistTabbedPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTabbedPane == null ? (class$com$ibm$db2$tools$common$AssistTabbedPane = DockingPane.class$("com.ibm.db2.tools.common.AssistTabbedPane")) : class$com$ibm$db2$tools$common$AssistTabbedPane, dockingArea);
        if (object != null) {
            ((JTabbedPane)object).setSelectedIndex(((JTabbedPane)object).indexOfComponent(dockingArea));
        }
        dockingArea.revalidate();
        this.revalidate();
        this.requestFocus();
        dockingArea.requestFocus();
        this.repaint();
    }

    protected void setDividerLocation(Dimension dimension, JSplitPane jSplitPane, double d2) {
        int n2 = 0;
        if (dimension.width > 0 && dimension.height > 0) {
            n2 = jSplitPane.getOrientation() == 0 ? (int)((double)dimension.height * d2) : (int)((double)dimension.width * d2);
            jSplitPane.setDividerLocation(n2);
        } else {
            if (this.runnables == null) {
                this.runnables = new ArrayList(7);
            }
            this.runnables.add(new SetDivider(jSplitPane, d2));
            jSplitPane.removeComponentListener(this);
            jSplitPane.addComponentListener(this);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        Dimension dimension = ((Component)object).getSize();
        int n2 = dimension.width + dimension.height;
        if (this.runnables != null && n2 > 0) {
            Iterator iterator = ((AbstractList)this.runnables).iterator();
            while (iterator.hasNext()) {
                SetDivider setDivider = (SetDivider)iterator.next();
                if (object != setDivider.getSplitter()) continue;
                setDivider.run();
                ((JSplitPane)object).removeComponentListener(this);
                ((AbstractCollection)this.runnables).remove(setDivider);
                break;
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component;
        Object object = focusEvent.getSource();
        if (object instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((AssistTabbedPane)object).getName()) && (component = ((AssistTabbedPane)object).getSelectedComponent()) instanceof DockingArea) {
            ((DockingArea)component).focusGained(focusEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component;
        Object object = focusEvent.getSource();
        if (object instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(((AssistTabbedPane)object).getName()) && (component = ((AssistTabbedPane)object).getSelectedComponent()) instanceof DockingArea) {
            ((DockingArea)component).focusLost(focusEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Component component;
        JComponent jComponent;
        if (changeEvent.getSource() instanceof JComponent && (jComponent = (JComponent)changeEvent.getSource()).hasFocus() && jComponent instanceof AssistTabbedPane && DOCKING_CONTAINER.equals(jComponent.getName()) && (component = ((AssistTabbedPane)jComponent).getSelectedComponent()) instanceof DockingArea) {
            FocusEvent focusEvent = new FocusEvent(jComponent, 1004);
            ((DockingArea)component).focusGained(focusEvent);
        }
    }

    public void addArea(DockingArea dockingArea, int n2) {
        Component component = this.getClient();
        if (component == null) {
            this.setClient(dockingArea);
        } else {
            JSplitPane jSplitPane = n2 == 6 ? new JSplitPane(0, component, dockingArea) : (n2 == 4 ? new JSplitPane(0, dockingArea, component) : (n2 == 5 ? new JSplitPane(1, dockingArea, component) : new JSplitPane(1, component, dockingArea)));
            jSplitPane.setName(DOCKING_CONTAINER);
            this.setClient(jSplitPane);
            Rectangle rectangle = this.getClientBounds();
            this.setDividerLocation(new Dimension(rectangle.width, rectangle.height), jSplitPane, 0.5);
        }
        dockingArea.setDockingPane(this);
        dockingArea.revalidate();
        this.revalidate();
        this.repaint();
    }

    public void addTab(JTabbedPane jTabbedPane, DockingArea dockingArea, boolean bl) {
        int n2 = jTabbedPane.getComponentCount();
        this.addTab(jTabbedPane, dockingArea, bl ? 0 : n2);
    }

    public void addTab(JTabbedPane jTabbedPane, DockingArea dockingArea, int n2) {
        String string = dockingArea.getDockingTitle().getText();
        int n3 = jTabbedPane.getTabCount();
        if (n2 > n3) {
            n2 = n3;
        } else if (n2 < 0) {
            n2 = 0;
        }
        jTabbedPane.insertTab(string, null, dockingArea, null, n2);
        jTabbedPane.setSelectedIndex(n2);
        dockingArea.setDockingPane(this);
        int n4 = jTabbedPane.getTabCount();
        int n5 = n4 - 1;
        while (n5 > -1) {
            DockingArea dockingArea2 = (DockingArea)jTabbedPane.getComponentAt(n5);
            jTabbedPane.insertTab(dockingArea2.getDockingTitle().getText(), null, dockingArea2, null, n5);
            --n5;
        }
        this.requestFocus();
        dockingArea.requestFocus();
    }

    public void addTabbedPane(Component component, DockingArea dockingArea, int n2, boolean bl) {
        Object object;
        Container container = null;
        if (component instanceof DockingPane) {
            container = (Container)component;
            component = this.getClient();
        } else {
            container = component.getParent();
        }
        if (component instanceof DockingArea) {
            ((DockingArea)component).setOrientation(dockingArea.getOrientation());
        }
        boolean bl2 = false;
        if (container instanceof JSplitPane && DOCKING_CONTAINER.equals(container.getName())) {
            bl2 = component == ((JSplitPane)container).getRightComponent();
        }
        AssistTabbedPane assistTabbedPane = new AssistTabbedPane(n2);
        assistTabbedPane.setMinimumSize(nbminsize);
        assistTabbedPane.addFocusListener(this);
        assistTabbedPane.addChangeListener(this);
        assistTabbedPane.setName(DOCKING_CONTAINER);
        String string = "";
        if (component instanceof DockingArea) {
            string = ((DockingArea)component).getDockingTitle().getText();
        } else {
            object = (CommonToolBar)AssistManager.getDescendantOfClass((Container)component, class$com$ibm$db2$tools$common$CommonToolBar == null ? (class$com$ibm$db2$tools$common$CommonToolBar = DockingPane.class$("com.ibm.db2.tools.common.CommonToolBar")) : class$com$ibm$db2$tools$common$CommonToolBar);
            if (object != null) {
                string = ((CommonToolBar)object).getDockingTitle();
            }
        }
        object = dockingArea.getDockingTitle().getText();
        if (bl) {
            assistTabbedPane.addTab((String)object, dockingArea);
            assistTabbedPane.addTab(string, component);
            assistTabbedPane.setSelectedIndex(0);
        } else {
            assistTabbedPane.addTab(string, component);
            assistTabbedPane.addTab((String)object, dockingArea);
            assistTabbedPane.setSelectedIndex(1);
        }
        if (container instanceof JSplitPane && DOCKING_CONTAINER.equals(container.getName())) {
            if (bl2) {
                ((JSplitPane)container).setRightComponent(assistTabbedPane);
            } else {
                ((JSplitPane)container).setLeftComponent(assistTabbedPane);
            }
        } else if (container instanceof DockingPane) {
            this.setClient(assistTabbedPane);
        } else {
            System.err.println("addTabbedPane wasn't added because parent isn't a JSplitPane or a DockingPane");
        }
        dockingArea.setDockingPane(this);
        this.requestFocus();
        dockingArea.requestFocus();
    }

    public Rectangle getClientBounds() {
        Rectangle rectangle;
        Component component = this.getClient();
        if (component == null) {
            Rectangle rectangle2;
            rectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), this);
            Component component2 = ((DockingPaneLayout)this.getLayout()).getChild("North", false);
            if (component2 != null) {
                rectangle2 = component2.getBounds();
                rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), rectangle2, this);
                rectangle.height -= rectangle2.height;
                rectangle.y += rectangle2.height;
            }
            if ((component2 = ((DockingPaneLayout)this.getLayout()).getChild("South", false)) != null) {
                rectangle2 = component2.getBounds();
                rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), rectangle2, this);
                rectangle.height -= rectangle2.height;
            }
            if ((component2 = ((DockingPaneLayout)this.getLayout()).getChild("West", false)) != null) {
                rectangle2 = component2.getBounds();
                rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), rectangle2, this);
                rectangle.width -= rectangle2.width;
                rectangle.x += rectangle2.width;
            }
            if ((component2 = ((DockingPaneLayout)this.getLayout()).getChild("East", false)) != null) {
                rectangle2 = component2.getBounds();
                rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), rectangle2, this);
                rectangle.width -= rectangle2.width;
            }
        } else {
            rectangle = component.getBounds();
            rectangle = SwingUtilities.convertRectangle(component.getParent(), rectangle, this);
        }
        return rectangle;
    }

    public static String taggify(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer(256);
        int n2 = string.length();
        char c2 = string.charAt(0);
        if (Character.isUnicodeIdentifierStart(c2)) {
            reuseStringBuffer.append(c2);
        } else {
            reuseStringBuffer.append('_');
        }
        int n3 = 1;
        while (n3 < n2) {
            c2 = string.charAt(n3);
            if (Character.isUnicodeIdentifierPart(c2) && Character.getType(c2) != 23) {
                reuseStringBuffer.append(c2);
            } else {
                reuseStringBuffer.append('_');
            }
            ++n3;
        }
        return ReuseStringBuffer.toString(reuseStringBuffer);
    }

    protected DNode parseDescription(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = "[]{}:;";
        DNode dNode = null;
        DNode dNode2 = null;
        DNode dNode3 = null;
        char c2 = '\u0000';
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            c2 = string.charAt(n2);
            switch (c2) {
                case '[': {
                    dNode3 = new DNode(0);
                    if (dNode == null) {
                        dNode = dNode3;
                    } else {
                        dNode2.addChild(dNode3);
                    }
                    dNode2 = dNode3;
                    c2 = string.charAt(++n3);
                    dNode2.setOrientation(c2);
                    c2 = string.charAt(++n3);
                    if (c2 != '0') break;
                    n2 = n3;
                    n3 += 2;
                    while (Character.isDigit(string.charAt(n3))) {
                        ++n3;
                    }
                    String string3 = string.substring(n2, n3);
                    dNode3.setProportion(string3);
                    break;
                }
                case ']': {
                    dNode2 = dNode2.getParent();
                    break;
                }
                case '{': {
                    dNode3 = new DNode(1);
                    if (dNode == null) {
                        dNode = dNode3;
                    } else {
                        dNode2.addChild(dNode3);
                    }
                    dNode2 = dNode3;
                    c2 = string.charAt(++n3);
                    dNode2.setOrientation(c2);
                    ++n3;
                    break;
                }
                case '}': {
                    dNode2 = dNode2.getParent();
                    ++n3;
                    break;
                }
                case ':': {
                    ++n3;
                    break;
                }
                case ';': {
                    ++n3;
                    break;
                }
                default: {
                    dNode3 = new DNode(2);
                    if (dNode == null) {
                        dNode = dNode3;
                    } else {
                        dNode2.addChild(dNode3);
                    }
                    n3 = n2 + 1;
                    while (n3 < string.length() && string2.indexOf(string.charAt(n3)) == -1) {
                        ++n3;
                    }
                    String string3 = string.substring(n2, n3);
                    dNode3.setName(string3);
                }
            }
            n2 = ++n3;
        }
        return dNode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DNode {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected static final int SPLITTER_TYPE = 0;
        protected static final int NOTEBOOK_TYPE = 1;
        protected static final int VIEW_TYPE = 2;
        protected int type;
        protected String proportion;
        protected String name;
        protected DNode parent;
        protected ArrayList kids;
        protected char orientation;
        protected Object docking;

        public DNode(int n2) {
            this.type = n2;
            this.name = null;
            this.proportion = null;
            this.parent = null;
            this.kids = null;
            this.docking = null;
        }

        public void setType(int n2) {
            this.type = n2;
        }

        public int getType() {
            return this.type;
        }

        public void setProportion(String string) {
            this.proportion = string;
        }

        public String getProportion() {
            return this.proportion;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            if (this.type == 2) {
                return this.name;
            }
            return null;
        }

        public void setParent(DNode dNode) {
            this.parent = dNode;
        }

        public DNode getParent() {
            return this.parent;
        }

        public void addChild(DNode dNode) {
            if (this.type != 2) {
                if (this.kids == null) {
                    this.kids = new ArrayList();
                }
                this.kids.add(dNode);
                dNode.setParent(this);
            }
        }

        public void removeChild(DNode dNode) {
            if (this.kids != null && this.kids.size() > 0) {
                ((AbstractCollection)this.kids).remove(dNode);
            }
        }

        public void replaceChild(DNode dNode, DNode dNode2) {
            int n2 = this.getChildIndex(dNode);
            if (n2 > -1) {
                this.kids.set(n2, dNode2);
                dNode2.setParent(this);
            }
        }

        public Collection getChildren() {
            return this.kids;
        }

        public void setOrientation(char c2) {
            this.orientation = c2;
            if (this.docking != null && this.docking instanceof String && "wsen".indexOf(((String)this.docking).charAt(0)) > -1 && ((String)this.docking).indexOf(47) > -1) {
                char c3 = '\u0000';
                switch (c2) {
                    case 'L': {
                        c3 = 'w';
                        break;
                    }
                    case 'B': {
                        c3 = 's';
                        break;
                    }
                    case 'R': {
                        c3 = 'e';
                        break;
                    }
                    default: {
                        c3 = 'n';
                    }
                }
                ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer((String)this.docking);
                reuseStringBuffer.setCharAt(0, c3);
                this.docking = ReuseStringBuffer.toString(reuseStringBuffer);
            }
        }

        public char getOrientation() {
            return this.orientation;
        }

        public boolean equals(Object object) {
            DNode dNode;
            return object instanceof DNode && this.type == (dNode = (DNode)object).getType() && (this.type != 2 || this.name != null && this.name.equals(dNode.getName()));
        }

        public DNode next() {
            if (this.kids != null && this.kids.size() > 0) {
                return (DNode)((AbstractList)this.kids).iterator().next();
            }
            if (this.parent != null) {
                ArrayList arrayList = (ArrayList)this.parent.getChildren();
                int n2 = this.parent.getChildIndex(this) + 1;
                DNode dNode = null;
                while (this.parent != null && n2 == arrayList.size()) {
                    dNode = this.parent.getParent();
                    if (dNode != null) {
                        n2 = dNode.getChildIndex(this.parent) + 1;
                    }
                    this.parent = dNode;
                    if (this.parent == null) continue;
                    arrayList = (ArrayList)this.parent.getChildren();
                }
                if (n2 < arrayList.size()) {
                    return (DNode)arrayList.get(n2);
                }
            }
            return null;
        }

        public DNode getChildAt(int n2) {
            DNode dNode = null;
            if (n2 > -1 && n2 < this.kids.size()) {
                dNode = (DNode)this.kids.get(n2);
            }
            return dNode;
        }

        public int getChildIndex(DNode dNode) {
            if (this.kids != null && this.kids.size() > 0) {
                return this.kids.indexOf(dNode);
            }
            return -1;
        }

        public Collection getAllViews(Collection arrayList) {
            if (arrayList == null) {
                arrayList = new ArrayList<DNode>();
            }
            if (this.type == 2) {
                arrayList.add(this);
            } else {
                Iterator iterator = ((AbstractList)this.kids).iterator();
                while (iterator.hasNext()) {
                    ((DNode)iterator.next()).getAllViews(arrayList);
                }
            }
            return arrayList;
        }

        public DNode findNode(DNode dNode) {
            DNode dNode2 = null;
            dNode2 = dNode.getType() == 0 ? this.findSplitter(dNode) : (dNode.getType() == 1 ? this.findNotebook(dNode) : this.findView(dNode.getName()));
            return dNode2;
        }

        public DNode findView(String string) {
            DNode dNode = null;
            if ((this.type == 0 || this.type == 1) && this.kids != null) {
                Iterator iterator = ((AbstractList)this.kids).iterator();
                while (dNode == null && iterator.hasNext()) {
                    dNode = ((DNode)iterator.next()).findView(string);
                }
            } else if (this.type == 2 && this.name.equals(string)) {
                dNode = this;
            }
            return dNode;
        }

        public DNode findSplitter(DNode dNode) {
            if (this.type == 2) {
                return null;
            }
            DNode dNode2 = this;
            Collection collection = dNode.getAllViews(new ArrayList());
            int n2 = collection.size();
            ArrayList arrayList = new ArrayList();
            int n3 = this.rankMatchingViews(collection, this.getAllViews(arrayList));
            DNode dNode3 = this.next();
            while (dNode3 != null) {
                if (dNode3.getType() != 2) {
                    arrayList.clear();
                    int n4 = this.rankMatchingViews(collection, dNode3.getAllViews(arrayList));
                    if (n4 >= n3 && n4 <= n2) {
                        n3 = n4;
                        dNode2 = dNode3;
                    }
                }
                dNode3 = dNode3.next();
            }
            return dNode2;
        }

        protected int rankMatchingViews(Collection collection, Collection collection2) {
            int n2 = 0;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                ++n2;
            }
            return n2;
        }

        public DNode findNotebook(DNode dNode) {
            DNode dNode2;
            block3: {
                block2: {
                    dNode2 = null;
                    if (this.type != 0) break block2;
                    Iterator iterator = ((AbstractList)this.kids).iterator();
                    while (dNode2 == null && iterator.hasNext()) {
                        dNode2 = ((DNode)iterator.next()).findNotebook(dNode);
                    }
                    break block3;
                }
                if (this.type != 1) break block3;
                Collection collection = dNode.getChildren();
                Iterator iterator = ((AbstractList)this.kids).iterator();
                DNode dNode3 = null;
                while (iterator.hasNext() && dNode2 == null) {
                    dNode3 = (DNode)iterator.next();
                    if (!collection.contains(dNode3)) continue;
                    dNode2 = this;
                }
            }
            return dNode2;
        }

        public DNode findSibling(DNode dNode) {
            DNode dNode2 = null;
            if (this.kids != null && this.kids.size() > 1) {
                Iterator iterator = ((AbstractList)this.kids).iterator();
                DNode dNode3 = null;
                while (iterator.hasNext() && dNode2 == null) {
                    dNode3 = (DNode)iterator.next();
                    if (dNode3 == dNode) continue;
                    dNode2 = dNode3;
                }
            }
            return dNode2;
        }

        public void dockAt(Object object) {
            if (this.type == 0) {
                this.docking = object;
            } else if (this.type == 1) {
                if (object instanceof Integer) {
                    ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
                    switch (this.orientation) {
                        case 'L': {
                            reuseStringBuffer.append('w');
                            break;
                        }
                        case 'B': {
                            reuseStringBuffer.append('s');
                            break;
                        }
                        case 'R': {
                            reuseStringBuffer.append('e');
                            break;
                        }
                        default: {
                            reuseStringBuffer.append('n');
                        }
                    }
                    reuseStringBuffer.append(object).append('/').append(this.kids.size() + 1);
                    this.docking = ReuseStringBuffer.toString(reuseStringBuffer);
                } else {
                    this.docking = object;
                }
            } else if (this.type == 2) {
                if (object instanceof Integer) {
                    DNode dNode = new DNode(2);
                    dNode.setName(this.name);
                    this.type = 1;
                    this.setOrientation('T');
                    this.name = null;
                    this.addChild(dNode);
                    this.dockAt(object);
                } else {
                    this.docking = object;
                }
            }
        }

        public String toString() {
            ReuseStringBuffer reuseStringBuffer = ReuseStringBuffer.getBuffer();
            this.getDescription(reuseStringBuffer);
            return ReuseStringBuffer.toString(reuseStringBuffer);
        }

        public ReuseStringBuffer getDescription(ReuseStringBuffer reuseStringBuffer) {
            if (reuseStringBuffer == null) {
                reuseStringBuffer = ReuseStringBuffer.getBuffer();
            }
            if (this.type == 0) {
                reuseStringBuffer.append('[').append(this.orientation).append(this.proportion).append(':');
                Iterator iterator = ((AbstractList)this.kids).iterator();
                while (iterator.hasNext()) {
                    ((DNode)iterator.next()).getDescription(reuseStringBuffer);
                    if (!iterator.hasNext()) continue;
                    reuseStringBuffer.append(';');
                }
                reuseStringBuffer.append(']');
            } else if (this.type == 1) {
                reuseStringBuffer.append('{').append(this.orientation).append(':');
                Iterator iterator = ((AbstractList)this.kids).iterator();
                while (iterator.hasNext()) {
                    ((DNode)iterator.next()).getDescription(reuseStringBuffer);
                    if (!iterator.hasNext()) continue;
                    reuseStringBuffer.append(';');
                }
                reuseStringBuffer.append('}');
            } else {
                reuseStringBuffer.append(this.name);
            }
            return reuseStringBuffer;
        }

        public ReuseStringBuffer getDockingDesc(ReuseStringBuffer reuseStringBuffer) {
            if (reuseStringBuffer == null) {
                reuseStringBuffer = ReuseStringBuffer.getBuffer();
            }
            if (this.docking != null) {
                reuseStringBuffer.append(this.docking);
            }
            if (this.type == 0) {
                reuseStringBuffer.append('[').append(this.orientation).append(this.proportion);
                Iterator iterator = ((AbstractList)this.kids).iterator();
                while (iterator.hasNext()) {
                    ((DNode)iterator.next()).getDockingDesc(reuseStringBuffer);
                    if (!iterator.hasNext()) continue;
                    reuseStringBuffer.append(';');
                }
                reuseStringBuffer.append(']');
            }
            return reuseStringBuffer;
        }
    }

    public class SetDivider
    implements Runnable {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected JSplitPane splitter;
        protected double span;

        public SetDivider(JSplitPane jSplitPane, double d2) {
            this.splitter = jSplitPane;
            this.span = d2;
        }

        public JSplitPane getSplitter() {
            return this.splitter;
        }

        public void run() {
            if (this.splitter.getParent().getSize().width == 0) {
                SwingUtilities.invokeLater(this);
            } else {
                this.splitter.setDividerLocation(this.span);
            }
        }
    }
}

