/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonMenuBar;
import com.ibm.db2.tools.common.CommonToolBar;
import com.ibm.db2.tools.common.DockingAreaLayout;
import com.ibm.db2.tools.common.DockingPane;
import com.ibm.db2.tools.common.plaf.DockingAreaUI;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.DockingTitleBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DockingArea
extends JComponent
implements MouseListener,
FocusListener,
ActionListener,
ContainerListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    protected int orientation;
    protected Border savedBorder;
    protected boolean top;
    protected boolean dockingWindow;
    protected int location;
    protected DockingPane dockingPane;
    protected WeakReference toolBarRef;
    protected DockingTitleBar dockingTitle;
    protected String dockingDescription;
    protected static GridBagConstraints gbtH;
    protected static GridBagConstraints gbtV;
    protected static GridBagConstraints gbcC;
    protected static Dimension minsize;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$DockingPane;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$CommonToolBar;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public DockingArea() {
        this(false, -1, 0, null);
    }

    public DockingArea(int n2) {
        this(false, -1, n2, null);
    }

    public DockingArea(boolean bl, int n2, int n3) {
        this(bl, n2, n3, "Close");
    }

    public DockingArea(boolean bl, int n2, int n3, String string) {
        this(null, 4 + (string == null ? 0 : 1), bl, n2, n3);
        if (bl && string != null) {
            this.dockingTitle.setCloseCommand(string);
        }
    }

    public DockingArea(Object object, int n2, boolean bl, int n3, int n4) {
        this.setDockingWindow(bl);
        this.setConstraint(n3);
        if (bl) {
            this.setLayout(new GridBagLayout());
            if (gbtV == null) {
                gbtV = new GridBagConstraints();
                gbtH = new GridBagConstraints();
                Insets insets = new Insets(1, 1, 1, 1);
                AssistManager.setGridBagConstraints(gbtH, 0, 0, 0, 1, 2, insets, -1, 1.0, 0.0);
                AssistManager.setGridBagConstraints(gbtV, 0, 0, 1, 0, 3, insets, -1, 0.0, 1.0);
                gbcC = new GridBagConstraints();
                AssistManager.setGridBagConstraints(gbcC, -1, -1, 1, 1, 1, null, 10, 1.0, 1.0);
            }
            if (n4 == 0) {
                this.dockingTitle = new DockingTitleBar(object, n2, 0, "", null, 10);
                this.add((Component)this.dockingTitle, gbtH);
            } else {
                this.dockingTitle = new DockingTitleBar(object, n2, 1, "", null, 10);
                this.add((Component)this.dockingTitle, gbtV);
            }
            this.dockingTitle.addActionListener(this);
            this.dockingTitle.addMouseListener(this);
            this.setMinimumSize(minsize);
            this.setPreferredSize(minsize);
        } else {
            this.setLayout(new DockingAreaLayout());
        }
        this.setOrientation(n4);
        this.updateUI();
        this.addContainerListener(this);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        super.setVisible(true);
        if (containerEvent.getChild() instanceof CommonToolBar) {
            if (this.dockingWindow) {
                this.toolBarRef = new WeakReference<Component>(containerEvent.getChild());
            }
            containerEvent.getChild().addFocusListener(this);
        }
        if (this.getBorder() == null) {
            this.setBorder(this.savedBorder);
            DockingArea.compensateMenuBar(this, false);
        }
        if (this.dockingPane == null) {
            this.dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingArea.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof CommonToolBar) {
            if (this.dockingWindow) {
                this.toolBarRef = new WeakReference<Component>(containerEvent.getChild());
            }
            containerEvent.getChild().removeFocusListener(this);
        }
        if (this.getComponentCount() == 0) {
            this.setBorder(null);
            if (this.top) {
                DockingArea.compensateMenuBar(this, true);
            }
        }
        if (this.dockingWindow) {
            Container container;
            this.dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingArea.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this);
            if (this.dockingPane == null) {
                return;
            }
            if (this.dockingWindow) {
                this.dockingPane.minRestoreArea(this);
            }
            if ((container = this.getParent()) instanceof JSplitPane) {
                Component component = ((JSplitPane)container).getLeftComponent() == this ? ((JSplitPane)container).getRightComponent() : ((JSplitPane)container).getLeftComponent();
                Container container2 = ((JSplitPane)container).getParent();
                if (container2 instanceof JSplitPane) {
                    if (((JSplitPane)container2).getLeftComponent() == container) {
                        ((JSplitPane)container2).setLeftComponent(component);
                    } else {
                        ((JSplitPane)container2).setRightComponent(component);
                    }
                } else {
                    this.dockingPane.remove(container);
                    this.dockingPane.setClient(component);
                }
                ((JSplitPane)container).remove(this);
            } else if (container instanceof JTabbedPane) {
                int n2 = container.getComponentCount();
                int n3 = ((JTabbedPane)container).indexOfComponent(this);
                Component component = null;
                if (n2 == 2) {
                    component = n3 == 0 ? ((JTabbedPane)container).getComponentAt(1) : ((JTabbedPane)container).getComponentAt(0);
                }
                ((JTabbedPane)container).removeTabAt(n3);
                boolean bl = false;
                Container container3 = container.getParent();
                if (component != null && container3 instanceof JSplitPane) {
                    boolean bl2 = bl = container == ((JSplitPane)container3).getRightComponent();
                }
                if (component != null) {
                    if (container3 instanceof JSplitPane) {
                        if (bl) {
                            ((JSplitPane)container3).setRightComponent(component);
                        } else {
                            ((JSplitPane)container3).setLeftComponent(component);
                        }
                    } else {
                        container3.add(component);
                    }
                }
                if (n2 == 2) {
                    container3.remove(container);
                }
            } else {
                this.dockingPane.setClient(null);
            }
            this.dockingPane.invalidate();
            Container container4 = this.dockingPane.getParent();
            if (container4 != null) {
                container4.validate();
            }
            this.dockingPane.repaint();
        }
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
        CommonToolBar commonToolBar = (CommonToolBar)AssistManager.getDescendantOfClass(this, class$com$ibm$db2$tools$common$CommonToolBar == null ? (class$com$ibm$db2$tools$common$CommonToolBar = DockingArea.class$("com.ibm.db2.tools.common.CommonToolBar")) : class$com$ibm$db2$tools$common$CommonToolBar);
        if (commonToolBar != null) {
            commonToolBar.setOrientation(n2);
        }
        if (this.dockingTitle != null) {
            this.dockingTitle.setRotation(n2);
            if (n2 == 0) {
                ((GridBagLayout)this.getLayout()).setConstraints(this.dockingTitle, gbtH);
            } else {
                ((GridBagLayout)this.getLayout()).setConstraints(this.dockingTitle, gbtV);
            }
            if (this.dockingPane != null) {
                this.invalidate();
                this.dockingPane.invalidate();
                Container container = this.dockingPane.getParent();
                if (container != null) {
                    container.validate();
                }
                this.dockingPane.doLayout();
                this.dockingPane.repaint();
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public CommonToolBar getClient() {
        if (this.toolBarRef != null && this.toolBarRef.get() != null) {
            return (CommonToolBar)this.toolBarRef.get();
        }
        if (this.dockingWindow) {
            return (CommonToolBar)AssistManager.getDescendantOfClass(this, class$com$ibm$db2$tools$common$CommonToolBar == null ? (class$com$ibm$db2$tools$common$CommonToolBar = DockingArea.class$("com.ibm.db2.tools.common.CommonToolBar")) : class$com$ibm$db2$tools$common$CommonToolBar);
        }
        return null;
    }

    public boolean hasClient() {
        int n2 = this.getComponentCount();
        return n2 > 1 || n2 == 1 && this.getComponent(0) != this.getDockingTitle();
    }

    public boolean isFloating() {
        CommonToolBar commonToolBar = null;
        if (this.toolBarRef != null) {
            commonToolBar = (CommonToolBar)this.toolBarRef.get();
        }
        if (commonToolBar == null) {
            commonToolBar = (CommonToolBar)AssistManager.getDescendantOfClass(this, class$com$ibm$db2$tools$common$CommonToolBar == null ? (class$com$ibm$db2$tools$common$CommonToolBar = DockingArea.class$("com.ibm.db2.tools.common.CommonToolBar")) : class$com$ibm$db2$tools$common$CommonToolBar);
        }
        if (commonToolBar == null) {
            return true;
        }
        return commonToolBar.isFloating();
    }

    public void setDockingWindow(boolean bl) {
        this.dockingWindow = bl;
    }

    public boolean getDockingWindow() {
        return this.dockingWindow;
    }

    public DockingTitleBar getDockingTitle() {
        return this.dockingTitle;
    }

    public void setDockingPane(DockingPane dockingPane) {
        this.dockingPane = dockingPane;
    }

    public DockingPane getDockingPane() {
        return this.dockingPane;
    }

    public void setConstraint(int n2) {
        this.location = n2;
    }

    public int getConstraint() {
        return this.location;
    }

    public void setDockingDescription(String string) {
        this.dockingDescription = string;
    }

    public String getDockingDescription() {
        return this.dockingDescription;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DockingArea.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DockingArea.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void setCloseCommand(String string) {
        if (this.dockingTitle != null) {
            this.dockingTitle.setCloseCommand(string);
        }
    }

    public int getCollapseState() {
        if (this.dockingTitle != null) {
            return this.dockingTitle.getCollapseState();
        }
        return 0;
    }

    public void setCollapseState(int n2) {
        if (this.dockingTitle != null) {
            this.dockingTitle.setCollapseState(n2);
        }
    }

    public void updateMaxRestoreState() {
        if (this.dockingTitle != null) {
            this.dockingTitle.updateMaxRestoreState();
        }
    }

    public void updateUI() {
        this.setUI((DockingAreaUI)UIManager.getUI(this));
        this.savedBorder = this.getBorder();
        if (this.getComponentCount() == 0) {
            this.setBorder(null);
            if (this.top) {
                DockingArea.compensateMenuBar(this, true);
            }
        }
        this.invalidate();
    }

    public String getUIClassID() {
        return "DockingAreaUI";
    }

    public void add(Component component, Object object) {
        if (this.dockingPane == null) {
            this.dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingArea.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this);
        }
        if (this.dockingWindow && this.dockingPane != null) {
            DockingPane dockingPane = this.dockingPane;
            if (this.dockingTitle != null && component instanceof CommonToolBar) {
                CommonToolBar commonToolBar = (CommonToolBar)component;
                if (this.dockingWindow) {
                    this.toolBarRef = new WeakReference<Component>(component);
                }
                this.dockingTitle.setText(commonToolBar.getDockingTitle());
                if (commonToolBar.getDockingMotionListener() != null) {
                    this.dockingTitle.addMouseMotionListener(commonToolBar.getDockingMotionListener());
                }
                if (commonToolBar.getDockingListener() != null) {
                    this.dockingTitle.addMouseListener(commonToolBar.getDockingListener());
                }
            }
            super.add(component, gbcC);
            this.setDockingPane(dockingPane);
            this.dockingPane.addArea(this, (String)object);
        } else {
            super.add(component, object);
        }
    }

    public void add(CommonToolBar commonToolBar) {
        commonToolBar.setOrientation(this.getOrientation());
        super.add((Component)commonToolBar, gbcC);
        if (this.dockingTitle != null) {
            this.toolBarRef = new WeakReference<CommonToolBar>(commonToolBar);
            this.dockingTitle.setText(commonToolBar.getDockingTitle());
            if (commonToolBar.getDockingMotionListener() != null) {
                this.dockingTitle.addMouseMotionListener(commonToolBar.getDockingMotionListener());
            }
            if (commonToolBar.getDockingListener() != null) {
                this.dockingTitle.addMouseListener(commonToolBar.getDockingListener());
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.dockingTitle.setActive(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.dockingTitle.setActive(false);
    }

    public boolean fireCloseAction() {
        int n2;
        if (this.dockingTitle != null && ((n2 = this.dockingTitle.getButtonFlags()) & 1) > 0) {
            if (this.dockingPane.isDocked(this)) {
                this.dockingPane.minRestoreArea(this);
            }
            Object[] objectArray = this.listenerList.getListenerList();
            ActionEvent actionEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == (class$java$awt$event$ActionListener == null ? DockingArea.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener) && objectArray[n3 + 1] != this) {
                    if (actionEvent == null) {
                        actionEvent = this.dockingTitle.getCloseActionEvent();
                    }
                    ((ActionListener)objectArray[n3 + 1]).actionPerformed(actionEvent);
                }
                n3 -= 2;
            }
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Maximize".equals(string) || "Minimize".equals(string) || "Restore".equals(string)) {
            return;
        }
        if ("Max_restore".equals(string)) {
            if (this.dockingPane == null) {
                this.dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingArea.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this);
            }
            this.dockingPane.maxRestoreArea(this);
            this.updateMaxRestoreState();
        } else {
            if (this.dockingPane == null) {
                this.dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingArea.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this);
            }
            this.setDockingDescription(this.dockingPane.getClientDescription());
            this.fireCloseAction();
            CommonToolBar commonToolBar = (CommonToolBar)AssistManager.getDescendantOfClass(this, class$com$ibm$db2$tools$common$CommonToolBar == null ? (class$com$ibm$db2$tools$common$CommonToolBar = DockingArea.class$("com.ibm.db2.tools.common.CommonToolBar")) : class$com$ibm$db2$tools$common$CommonToolBar);
            if (commonToolBar != null) {
                this.remove(commonToolBar);
                super.add((Component)commonToolBar, gbcC);
                this.toolBarRef = null;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            if (this.dockingPane == null) {
                this.dockingPane = (DockingPane)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$DockingPane == null ? (class$com$ibm$db2$tools$common$DockingPane = DockingArea.class$("com.ibm.db2.tools.common.DockingPane")) : class$com$ibm$db2$tools$common$DockingPane, this);
            }
            this.dockingPane.maxRestoreArea(this);
            this.updateMaxRestoreState();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setTop(boolean bl) {
        this.top = bl;
    }

    protected static void compensateMenuBar(Component component, boolean bl) {
        CommonMenuBar commonMenuBar = null;
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof JFrame) {
                commonMenuBar = (CommonMenuBar)((JFrame)container).getJMenuBar();
                break;
            }
            if (container instanceof JDialog) {
                commonMenuBar = (CommonMenuBar)((JDialog)container).getJMenuBar();
                break;
            }
            container = container.getParent();
        }
        if (commonMenuBar == null) {
            return;
        }
        commonMenuBar.setBorderNeeded(bl);
    }

    public void requestFocus() {
        Component component = AssistManager.getFocusableChild(this);
        if (component != null) {
            component.requestFocus();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        minsize = new Dimension(16, 16);
    }
}

