/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CellLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;

public class DialogButtons
extends JComponent
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private JComponent buttons = new JComponent(){};
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton helpButton;
    private boolean inWorkbook;

    public DialogButtons(boolean bl) {
        this.inWorkbook = bl;
        Container container = new Container(){};
        Container container2 = new Container(){};
        this.createButtons();
        GridLayout gridLayout = new GridLayout(1, 3);
        gridLayout.setHgap(10);
        GridLayout gridLayout2 = new GridLayout(1, 2);
        container.setLayout(gridLayout);
        container2.setLayout(gridLayout2);
        container.add(this.okButton);
        container.add(this.cancelButton);
        container.add(this.helpButton);
        container2.add(this.backButton);
        container2.add(this.nextButton);
        CellLayout cellLayout = new CellLayout(this.buttons);
        cellLayout.setWeight(1, 1);
        cellLayout.setFill(1);
        cellLayout.setInsets(5, 5, 5, 5);
        cellLayout.addToCell(container2, 0, 0);
        cellLayout.setInsets(5, 5, 5, 0);
        cellLayout.addToCell(container, 1, 0);
        CellLayout cellLayout2 = new CellLayout(this);
        cellLayout2.setWeight(1, 1);
        cellLayout2.setPadding(10, 0);
        cellLayout2.setFill(3);
        if (bl) {
            cellLayout2.setInsets(6, 10, 4, 5);
        } else {
            cellLayout2.setInsets(5, 10, 4, 10);
        }
        cellLayout2.setAnchor(13);
        cellLayout2.addToCell(this.buttons, 0, 0);
    }

    public void createButtons() {
        JButton jButton = new JButton();
        jButton.setActionCommand("ok");
        this.okButton = jButton;
        jButton = new JButton();
        jButton.setActionCommand("cancel");
        this.cancelButton = jButton;
        jButton = new HelpButton();
        jButton.setActionCommand("help");
        this.helpButton = jButton;
        jButton = new JButton();
        jButton.setActionCommand("back");
        this.backButton = jButton;
        jButton = new JButton();
        jButton.setActionCommand("next");
        this.nextButton = jButton;
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Dimension dimension = this.getSize();
        if (this.inWorkbook) {
            graphics.setColor(color.darker());
            graphics.drawLine(1, 0, dimension.width - 2, 0);
            graphics.setColor(color.brighter());
            graphics.drawLine(1, 1, dimension.width - 2, 1);
        } else {
            super.paintComponent(graphics);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        this.helpButton.addActionListener(actionListener);
        this.backButton.addActionListener(actionListener);
        this.nextButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.okButton.removeActionListener(actionListener);
        this.cancelButton.removeActionListener(actionListener);
        this.helpButton.removeActionListener(actionListener);
        this.backButton.removeActionListener(actionListener);
        this.nextButton.removeActionListener(actionListener);
    }

    class HelpButton
    extends JButton {
        public HelpButton() {
            this.setRequestFocusEnabled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

