/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.TiledComponent;
import com.ibm.db2.tools.common.plaf.ComponentSplitterUI;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;

public class ComponentSplitter
extends JLayeredPane
implements ItemSelectable,
Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TiledComponent root;
    protected int splitterSize = 6;
    protected boolean light = true;
    protected boolean continuous = false;
    protected boolean focusEnabled = true;
    protected boolean borderPainted = true;
    protected Color focusColor = SystemColor.activeCaption;
    protected Color splitterColor = Color.red.darker().darker();
    protected Component selcomp = null;
    protected TiledComponent maxedComp = null;
    ItemListener itemListener = null;

    public ComponentSplitter() {
        this(null);
    }

    public ComponentSplitter(TiledComponent tiledComponent) {
        this.setDoubleBuffered(true);
        this.updateUI();
        if (tiledComponent != null) {
            this.setRoot(tiledComponent);
        }
    }

    public void setRoot(TiledComponent tiledComponent) {
        if (this.root != null) {
            this.removeTiledComponent(this.root);
        }
        this.root = tiledComponent;
        if (this.root != null) {
            this.addTiledComponent(tiledComponent);
        }
    }

    public TiledComponent getRoot() {
        return this.root;
    }

    protected void leafComponentAdded(TiledComponent tiledComponent) {
    }

    protected void leafComponentRemoved(TiledComponent tiledComponent) {
    }

    void addTiledComponent(TiledComponent tiledComponent) {
        block3: {
            block2: {
                if (tiledComponent.getType() != 3) break block2;
                if (!tiledComponent.isVisible()) {
                    return;
                }
                Component component = tiledComponent.getComponent();
                if (component == null) break block3;
                this.add(component, JLayeredPane.DEFAULT_LAYER);
                this.leafComponentAdded(tiledComponent);
                if (this.ui == null) break block3;
                ((ComponentSplitterUI)this.ui).componentAdded(this, tiledComponent);
                break block3;
            }
            int n2 = 0;
            while (n2 < tiledComponent.getChildCount()) {
                this.addTiledComponent(tiledComponent.getChildAt(n2));
                ++n2;
            }
        }
    }

    void removeTiledComponent(TiledComponent tiledComponent) {
        block2: {
            block1: {
                if (tiledComponent.getType() != 3) break block1;
                Component component = tiledComponent.getComponent();
                if (component == null) break block2;
                this.remove(component);
                this.leafComponentRemoved(tiledComponent);
                if (this.ui == null) break block2;
                ((ComponentSplitterUI)this.ui).componentRemoved(this, tiledComponent);
                break block2;
            }
            int n2 = 0;
            while (n2 < tiledComponent.getChildCount()) {
                this.removeTiledComponent(tiledComponent.getChildAt(n2));
                ++n2;
            }
        }
    }

    public String getUIClassID() {
        return "ComponentSplitterUI";
    }

    public void setSplitBarSize(int n2) {
        this.splitterSize = n2;
    }

    public int getSplitBarSize() {
        return this.splitterSize;
    }

    public void setSplitBarHighlightColor(Color color) {
        this.splitterColor = color;
    }

    public Color getSplitBarHighlightColor() {
        return this.splitterColor;
    }

    public void setFocusIndicationEnabled(boolean bl) {
        this.focusEnabled = bl;
    }

    public boolean isFocusIndicationEnabled() {
        return this.focusEnabled;
    }

    public void setFocusIndicationColor(Color color) {
        this.focusColor = color;
    }

    public Color getFocusIndicationColor() {
        return this.focusColor;
    }

    public void setBorderPainted(boolean bl) {
        if (this.borderPainted != bl) {
            this.borderPainted = bl;
            ((ComponentSplitterUI)this.ui).borderUpdated();
        }
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public Component getSelectedComponent() {
        return this.selcomp;
    }

    public void setMaximizedComponent(TiledComponent tiledComponent) {
        this.maxedComp = tiledComponent;
    }

    public TiledComponent getMaximizedComponent() {
        return this.maxedComp;
    }

    public Object[] getSelectedObjects() {
        if (this.selcomp == null) {
            return null;
        }
        Object[] objectArray = new Object[]{this.selcomp};
        return objectArray;
    }

    public void setSelectedComponent(Component component) {
        if (this.itemListener != null) {
            if (this.selcomp != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selcomp, 2));
            }
            if (component != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, component, 1));
            }
        }
        this.selcomp = component;
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void setContinuousLayout(boolean bl) {
        this.continuous = bl;
    }

    public boolean isContinuousLayout() {
        return this.continuous;
    }

    public void updateUI() {
        this.setUI((ComponentSplitterUI)UIManager.getUI(this));
        this.invalidate();
    }

    public boolean isMenuFocus() {
        return false;
    }
}

