/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ComponentGroup
extends ButtonGroup
implements FocusListener,
Runnable,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int RADIO_CLASS = 0;
    public static final int CHECK_CLASS = 1;
    public static final int PUSH_CLASS = 2;
    public static final int FIELD_CLASS = 3;
    public static final int MIXED_CLASS = 4;
    public static final String GROUP_KEY = "key.navigation.group";
    protected int defButton = -1;
    protected int groupClass = 0;
    protected Vector allComponents = new Vector();
    protected JButton lostButton;

    public Enumeration getElements() {
        if (this.groupClass == 0) {
            return this.buttons.elements();
        }
        return this.allComponents.elements();
    }

    public boolean isRadioGroup() {
        return this.groupClass == 0;
    }

    public boolean isCheckGroup() {
        return this.groupClass == 1;
    }

    public boolean isPushGroup() {
        return this.groupClass == 2;
    }

    public boolean isFieldGroup() {
        return this.groupClass == 3;
    }

    public boolean isMixedGroup() {
        return this.groupClass == 4;
    }

    public int getGroupClass() {
        return this.groupClass;
    }

    public void add(AbstractButton abstractButton) {
        if (abstractButton == null) {
            return;
        }
        if (this.allComponents.size() == 0) {
            if (abstractButton instanceof JCheckBox) {
                this.groupClass = 1;
            } else if (abstractButton instanceof JButton) {
                this.groupClass = 2;
            } else if (!(abstractButton instanceof JRadioButton)) {
                this.groupClass = 4;
            }
        } else if (this.groupClass == 0 && !(abstractButton instanceof JRadioButton) || this.groupClass == 1 && !(abstractButton instanceof JCheckBox) || this.groupClass == 2 && !(abstractButton instanceof JButton) || this.groupClass == 3) {
            this.groupClass = 4;
        }
        abstractButton.putClientProperty(GROUP_KEY, this);
        if (abstractButton instanceof JRadioButton) {
            super.add(abstractButton);
        }
        if (!this.allComponents.contains(abstractButton)) {
            this.allComponents.addElement(abstractButton);
            if (abstractButton instanceof JButton && this.defButton > -1) {
                abstractButton.addFocusListener(this);
            }
        }
    }

    public void add(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.allComponents.size() == 0) {
            if (jComponent instanceof JCheckBox) {
                this.groupClass = 1;
            } else if (jComponent instanceof JButton) {
                this.groupClass = 2;
            } else if (jComponent instanceof JTextField) {
                this.groupClass = 3;
            } else if (!(jComponent instanceof JRadioButton)) {
                this.groupClass = 4;
            }
        } else if (this.groupClass == 0 && !(jComponent instanceof JRadioButton) || this.groupClass == 1 && !(jComponent instanceof JCheckBox) || this.groupClass == 2 && !(jComponent instanceof JButton) || this.groupClass == 3 && !(jComponent instanceof JTextField)) {
            this.groupClass = 4;
        }
        jComponent.putClientProperty(GROUP_KEY, this);
        if (jComponent instanceof JRadioButton) {
            super.add((AbstractButton)jComponent);
        }
        if (!this.allComponents.contains(jComponent)) {
            this.allComponents.addElement(jComponent);
            if (jComponent instanceof JButton && this.defButton > -1) {
                jComponent.addFocusListener(this);
            }
        }
    }

    public void add(JButton jButton, boolean bl) {
        if (jButton == null) {
            return;
        }
        this.add(jButton);
        if (bl) {
            this.defButton = this.allComponents.indexOf(jButton);
            this.lostButton = jButton;
            SwingUtilities.invokeLater(this);
        }
    }

    public JButton getDefaultButton() {
        if (this.defButton == -1) {
            return null;
        }
        return (JButton)this.allComponents.elementAt(this.defButton);
    }

    public void remove(AbstractButton abstractButton) {
        int n2;
        if (abstractButton == null) {
            return;
        }
        if (abstractButton instanceof JRadioButton) {
            super.remove(abstractButton);
        }
        abstractButton.putClientProperty(GROUP_KEY, null);
        if (abstractButton instanceof JButton && (n2 = this.allComponents.indexOf(abstractButton)) > -1 && n2 == this.defButton) {
            n2 = -1;
        }
        this.allComponents.removeElement(abstractButton);
    }

    public void remove(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (jComponent instanceof JRadioButton) {
            super.remove((AbstractButton)jComponent);
        }
        jComponent.putClientProperty(GROUP_KEY, null);
        this.allComponents.removeElement(jComponent);
    }

    public boolean contains(Component component) {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(component)) continue;
            return true;
        }
        return false;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.lostButton = (JButton)focusEvent.getSource();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        JRootPane jRootPane;
        Container container = this.getGroupFocusRoot(this.lostButton);
        Component component = SwingUtilities.findFocusOwner(container);
        if (component != null && !(component instanceof JButton) && (jRootPane = SwingUtilities.getRootPane(container)) != null && this.defButton > -1) {
            jRootPane.setDefaultButton((JButton)this.allComponents.elementAt(this.defButton));
        }
    }

    protected Container getGroupFocusRoot(JButton jButton) {
        Container container = jButton.getParent();
        while (container != null) {
            if (container instanceof JComponent && ((JComponent)container).isFocusCycleRoot() || container instanceof Window || container instanceof Dialog) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }
}

