/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AnimatedGearsButton;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.SpinningGearsStatusInterface;
import com.ibm.db2.tools.common.ViewTable;
import com.ibm.db2.tools.common.ViewToolBar;
import com.ibm.db2.tools.common.support.TableCellExpanderProvider;
import com.ibm.db2.tools.common.support.ViewTableColumn;
import com.ibm.db2.tools.common.support.ViewTableColumnModel;
import com.ibm.db2.tools.common.support.ViewTableColumnModelEvent;
import com.ibm.db2.tools.common.support.ViewTableDefaultRendererProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class CommonView
extends JPanel
implements PropertyChangeListener,
TableColumnModelListener,
SpinningGearsStatusInterface {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int OUTER_TOOLBAR = 0;
    protected static PageFormat pageFormat;
    protected Window owner;
    protected JPanel infoAreaPanel;
    protected int infoAreaLocation = 1;
    protected JLabel infoAreaLabel;
    protected String infoAreaText;
    protected Icon holderIcon = CommonImageRepository.getCommonIcon(CommonImageRepository.HOLDER_INFOLINE_IMAGE);
    protected JLabel sortLabel;
    protected JLabel filterLabel;
    protected JLabel customLabel;
    protected JScrollPane scrollPane;
    protected JPanel tablePanel;
    protected ViewTable table;
    protected JPanel gearPanel;
    protected Thread gearThread;
    protected AnimatedGearsButton gearButton;
    protected JPanel toolBarPanel;

    public CommonView(JFrame jFrame, TableModel tableModel) {
        this.init(jFrame);
        this.table.setModel(tableModel);
    }

    public CommonView(CommonDialog commonDialog) {
        this.init(commonDialog);
    }

    public CommonView(JFrame jFrame) {
        this.init(jFrame);
    }

    public boolean isEnabled() {
        return super.isEnabled() && !this.table.isUpdating();
    }

    public void setEnabled(boolean bl) {
        if (null != this.infoAreaLabel) {
            this.infoAreaLabel.setEnabled(bl);
        }
        if (null != this.sortLabel) {
            this.sortLabel.setEnabled(bl);
        }
        if (null != this.filterLabel) {
            this.filterLabel.setEnabled(bl);
        }
        if (null != this.customLabel) {
            this.customLabel.setEnabled(bl);
        }
        this.table.setEnabled(bl);
        if (null != this.toolBarPanel) {
            this.toolBarPanel.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("columnModel")) {
            Object object;
            Object object2;
            TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getOldValue();
            if (null != tableColumnModel) {
                tableColumnModel.removeColumnModelListener(this);
                object2 = tableColumnModel.getColumns();
                while (object2.hasMoreElements()) {
                    object = (TableColumn)object2.nextElement();
                    ((TableColumn)object).removePropertyChangeListener(this);
                }
            }
            this.updateInfoAreaIcons();
            object2 = (TableColumnModel)propertyChangeEvent.getNewValue();
            if (null != object2) {
                object2.addColumnModelListener(this);
                object = object2.getColumns();
                while (object.hasMoreElements()) {
                    TableColumn tableColumn = (TableColumn)object.nextElement();
                    tableColumn.addPropertyChangeListener(this);
                }
            }
        } else if (string.equals("UAKey")) {
            this.updateUAKeys();
        } else if (propertyChangeEvent.getSource() instanceof ViewTableColumn) {
            this.updateInfoAreaIcons();
        }
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent instanceof ViewTableColumnModelEvent) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)((ViewTableColumnModelEvent)tableColumnModelEvent).getColumn();
            viewTableColumn.addPropertyChangeListener(this);
            this.updateInfoAreaIcons();
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent instanceof ViewTableColumnModelEvent) {
            ViewTableColumn viewTableColumn = (ViewTableColumn)((ViewTableColumnModelEvent)tableColumnModelEvent).getColumn();
            viewTableColumn.removePropertyChangeListener(this);
            this.updateInfoAreaIcons();
        }
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.updateInfoAreaIcons();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected JPanel createDefaultToolBarPanel(int n2) {
        return new ViewToolBar(this, n2);
    }

    public Window getOwner() {
        return this.owner;
    }

    public static PageFormat getPageFormat() {
        return pageFormat;
    }

    public static void setPageFormat(PageFormat pageFormat) {
        CommonView.pageFormat = pageFormat;
    }

    public String getInfoAreaText() {
        return this.infoAreaText;
    }

    public void setInfoAreaText(String string) {
        String string2 = this.infoAreaText;
        this.infoAreaText = string;
        if (null == this.infoAreaText) {
            if (null != this.infoAreaPanel) {
                this.remove(this.infoAreaPanel);
                this.infoAreaPanel = null;
                this.infoAreaLabel = null;
                this.sortLabel = null;
                this.filterLabel = null;
                this.customLabel = null;
                this.table.removePropertyChangeListener("columnModel", this);
                this.table.getColumnModel().removeColumnModelListener(this);
            }
        } else {
            if (null == this.infoAreaPanel) {
                this.infoAreaLabel = new JLabel();
                this.infoAreaLabel.setBackground(this.getBackground());
                this.infoAreaLabel.setBorder(null);
                this.infoAreaLabel.setLabelFor(this.table);
                JPanel jPanel = new JPanel(new FlowLayout());
                jPanel.setBorder(null);
                this.sortLabel = new JLabel();
                this.sortLabel.setBorder(null);
                this.sortLabel.setIcon(this.holderIcon);
                this.filterLabel = new JLabel();
                this.filterLabel.setBorder(null);
                this.filterLabel.setIcon(this.holderIcon);
                this.customLabel = new JLabel();
                this.customLabel.setBorder(null);
                this.customLabel.setIcon(this.holderIcon);
                jPanel.add(this.sortLabel);
                jPanel.add(this.filterLabel);
                jPanel.add(this.customLabel);
                this.infoAreaPanel = new JPanel();
                this.infoAreaPanel.setLayout(new BorderLayout());
                this.infoAreaPanel.setBorder(new BevelBorder(1));
                this.infoAreaPanel.add("Center", this.infoAreaLabel);
                this.infoAreaPanel.add("East", jPanel);
                this.setInfoAreaLocation(this.getInfoAreaLocation());
                this.table.getColumnModel().addColumnModelListener(this);
                this.table.addPropertyChangeListener("columnModel", this);
            }
            this.infoAreaLabel.setText(string);
        }
    }

    public int getInfoAreaLocation() {
        return this.infoAreaLocation;
    }

    public void setInfoAreaLocation(int n2) {
        if (null != this.toolBarPanel && this.toolBarPanel instanceof ViewToolBar && n2 == ((ViewToolBar)this.toolBarPanel).getToolBarLocation()) {
            throw new IllegalArgumentException("Cannot set the info area at the same location as the toolbar");
        }
        if (null != this.infoAreaPanel) {
            this.remove(this.infoAreaPanel);
        }
        if (n2 == 3) {
            this.add((Component)this.infoAreaPanel, "South");
        } else if (n2 == 1) {
            this.add((Component)this.infoAreaPanel, "North");
        } else {
            throw new IllegalArgumentException("The toolbar location can only be SwingConstants.TOP or SwingConstants.BOTTOM");
        }
        this.infoAreaLocation = n2;
    }

    public ViewTable getTable() {
        return this.table;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JPanel getToolBarPanel() {
        return this.toolBarPanel;
    }

    public void setToolBarLocation(int n2) {
        int n3 = -1;
        if (null != this.toolBarPanel && this.toolBarPanel instanceof ViewToolBar) {
            n3 = ((ViewToolBar)this.toolBarPanel).getToolBarLocation();
            this.remove(this.toolBarPanel);
        }
        if (n3 != n2) {
            if (n2 == this.infoAreaLocation) {
                throw new IllegalArgumentException("Cannot set the toolbar at the same location as the info area.");
            }
            if (null != this.toolBarPanel && this.toolBarPanel instanceof ViewToolBar) {
                ((ViewToolBar)this.toolBarPanel).setToolBarLocation(n2);
            } else {
                this.toolBarPanel = this.createDefaultToolBarPanel(n2);
            }
            if (n2 != 0) {
                if (n2 == 3) {
                    this.add((Component)this.toolBarPanel, "South");
                } else if (n2 == 1) {
                    this.add((Component)this.toolBarPanel, "North");
                } else if (n2 == 4) {
                    this.add((Component)this.toolBarPanel, "East");
                } else if (n2 == 2) {
                    this.add((Component)this.toolBarPanel, "West");
                } else {
                    throw new IllegalArgumentException("The toolbar location can only beCommonView.OUTER_TOOLBAR, SwingConstants.TOP, SwingConstants.BOTTOM, SwingConstants.RIGHT or SwingConstants.BOTTOM");
                }
            }
        }
    }

    public synchronized void setUpdating(boolean bl) {
        if (bl) {
            if (null == this.gearPanel) {
                this.gearPanel = new JPanel();
                this.gearPanel.setBackground(this.tablePanel.getBackground());
                if (this.gearButton == null) {
                    this.gearButton = new AnimatedGearsButton();
                    this.gearButton.setGearsBackground(this.tablePanel.getBackground());
                    this.gearPanel.add("Center", this.gearButton);
                }
                this.tablePanel.add((Component)this.gearPanel, "gearbutton");
            }
            if (!this.gearButton.isTurning()) {
                this.gearButton.startTurning();
            }
            ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, "gearbutton");
        } else {
            ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, "scrollpane");
            this.tablePanel.repaint();
            if (this.gearButton != null && this.gearButton.isTurning()) {
                this.gearButton.stopTurning();
            }
        }
    }

    protected void init(Window window) {
        this.owner = window;
        this.tablePanel = new JPanel(new CardLayout());
        this.table = new ViewTable();
        this.table.setRendererProvider(new ViewTableDefaultRendererProvider());
        this.table.addPropertyChangeListener("updating", this);
        this.table.setTipProvider(new TableCellExpanderProvider(this.table));
        this.table.setAutoResizeMode(0);
        this.table.setModel(new DefaultTableModel());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setMinimumSize(new Dimension(0, 0));
        this.scrollPane.getViewport().setBackground(this.table.getBackground());
        this.tablePanel.add((Component)this.scrollPane, "scrollpane");
        this.tablePanel.setBackground(this.table.getBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tablePanel, "Center");
        this.setBorder(new EtchedBorder());
        this.addPropertyChangeListener("UAKey", this);
    }

    protected void updateInfoAreaIcons() {
        if (null != this.infoAreaPanel) {
            this.sortLabel.setIcon(this.holderIcon);
            this.filterLabel.setIcon(this.holderIcon);
            this.customLabel.setIcon(this.holderIcon);
            if (this.table.getColumnModel() instanceof ViewTableColumnModel) {
                ViewTableColumnModel viewTableColumnModel = (ViewTableColumnModel)this.table.getColumnModel();
                if (viewTableColumnModel.getHiddenColumnCount() > 0) {
                    this.customLabel.setIcon(CommonImageRepository.getCommonIcon(CommonImageRepository.COLUMN_INFOLINE_IMAGE));
                }
                int n2 = 0;
                Enumeration enumeration = viewTableColumnModel.getAllColumns();
                while (enumeration.hasMoreElements()) {
                    ViewTableColumn viewTableColumn = (ViewTableColumn)enumeration.nextElement();
                    if (viewTableColumnModel.isFilterEnabled() && null != viewTableColumn.getFilterValues() && viewTableColumn.getFilterValues().length > 0) {
                        this.filterLabel.setIcon(CommonImageRepository.getCommonIcon(CommonImageRepository.FILTER_INFOLINE_IMAGE));
                    }
                    if (1 != viewTableColumn.getSortDirection()) {
                        this.sortLabel.setIcon(CommonImageRepository.getCommonIcon(CommonImageRepository.SORT_INFOLINE_IMAGE));
                    }
                    if (n2 != viewTableColumn.getModelIndex()) {
                        this.customLabel.setIcon(CommonImageRepository.getCommonIcon(CommonImageRepository.COLUMN_INFOLINE_IMAGE));
                    }
                    ++n2;
                }
            }
        }
    }

    protected void updateUAKeys() {
        String string = (String)this.getClientProperty("UAKey");
        if (null != this.scrollPane) {
            this.scrollPane.putClientProperty("UAKey", string + "_scrollPane");
        }
        if (null != this.table) {
            this.table.putClientProperty("UAKey", string + "_table");
        }
        if (null != this.toolBarPanel) {
            this.toolBarPanel.putClientProperty("UAKey", string + "_toolBarPanel");
        }
    }

    public void setGearsStatusText(String string) {
        if (this.gearButton != null) {
            this.gearButton.setStatusText(string);
        }
    }
}

