/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.plaf.windows.DB2WindowsLookAndFeel;
import com.ibm.db2.tools.common.smartx.support.SmartConstants;
import com.ibm.db2.tools.common.support.AssistConstants;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.DashedBorder;
import com.ibm.db2.tools.common.support.GroupFocusManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CommonUIManager
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static LookAndFeel lf = null;
    protected static Vector listeners;
    protected static String currentPlatform;

    private static void setLookAndFeel(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "setLookAndFeel(String className)", new Object[]{string});
        }
        try {
            LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
            CommonUIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            exception.printStackTrace();
        }
        CommonTrace.exit(commonTrace);
    }

    public static void addChangeListener(ChangeListener changeListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "addChangeListener(ChangeListener listener)", new Object[]{changeListener});
        }
        if (listeners == null) {
            listeners = new Vector();
        }
        listeners.addElement(changeListener);
        CommonTrace.exit(commonTrace);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "removeChangeListener(ChangeListener listener)", new Object[]{changeListener});
        }
        listeners.removeElement(changeListener);
        CommonTrace.exit(commonTrace);
    }

    private static void fireLFChanged() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "fireLFChanged()");
        }
        if (listeners == null) {
            CommonTrace.exit(commonTrace);
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(lf);
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
            changeListener.stateChanged(changeEvent);
        }
        CommonTrace.exit(commonTrace);
    }

    private static void setLookAndFeel(LookAndFeel lookAndFeel) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "setLookAndFeel(LookAndFeel lf)", new Object[]{lookAndFeel});
        }
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            exception.printStackTrace();
        }
        lf = lookAndFeel;
        UIDefaults uIDefaults = lookAndFeel.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            UIManager.put(string, uIDefaults.get(string));
        }
        CommonUIManager.fireLFChanged();
        CommonTrace.exit(commonTrace);
    }

    public static LookAndFeel getLookAndFeel() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "getLookAndFeel()");
        }
        return (LookAndFeel)CommonTrace.exit(commonTrace, lf);
    }

    public static String getCurrentPlatform() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "getCurrentPlatform()");
        }
        return (String)CommonTrace.exit(commonTrace, currentPlatform);
    }

    public static void initialize() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "initialize()");
        }
        CommonUIManager.initialize("");
        CommonTrace.exit(commonTrace);
    }

    public static void initialize(String string) {
        Object object;
        Boolean bl;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "initialize(String platform)", new Object[]{string});
        }
        if ((bl = (Boolean)UIManager.get("CommonUIManager")) != null && bl.booleanValue()) {
            CommonTrace.exit(commonTrace);
            return;
        }
        Locale locale = Locale.getDefault();
        Locale.setDefault(AssistManager.getPreferredLanguage());
        if (null == string || string.length() == 0) {
            object = System.getProperty("os.name").substring(0, 3);
            string = ((String)object).equalsIgnoreCase("win") ? "Windows" : "Motif";
        } else if (!string.equalsIgnoreCase("windows") && !string.equalsIgnoreCase("motif")) {
            string = "Motif";
        }
        if (CommonTrace.isTrace()) {
            CommonTrace.write(commonTrace, "platform = " + string);
        }
        currentPlatform = string;
        try {
            if (string.equalsIgnoreCase("windows")) {
                CommonUIManager.setLookAndFeel("com.ibm.db2.tools.common.plaf.windows.DB2WindowsLookAndFeel");
                UIManager.put("AssistComboUI", "com.ibm.db2.tools.common.plaf.windows.WindyComboBoxUI");
                UIManager.put("AssistCheckUI", "com.ibm.db2.tools.common.plaf.windows.WindowsAssistCheckUI");
                UIManager.put("AssistRadioUI", "com.ibm.db2.tools.common.plaf.windows.WindowsAssistRadioUI");
                UIManager.put("Assist.simple.TextField.border", UIManager.getBorder("TextField.border"));
                UIManager.put("Tree.focusBorder", DashedBorder.createBlackDashedBorder());
            } else if (string.equalsIgnoreCase("motif")) {
                CommonUIManager.setLookAndFeel("com.ibm.db2.tools.common.plaf.motif.DB2MotifLookAndFeel");
                UIManager.put("SplitPane.dividerSize", new Integer(6));
                UIManager.put("AssistComboUI", "com.ibm.db2.tools.common.plaf.motif.MotifyComboBoxUI");
                UIManager.put("AssistCheckUI", "com.ibm.db2.tools.common.plaf.motif.MotifAssistCheckUI");
                UIManager.put("AssistRadioUI", "com.ibm.db2.tools.common.plaf.motif.MotifAssistRadioUI");
                UIManager.put("FileChooserUI", "com.ibm.db2.tools.common.plaf.motif.MotifFileChooserUI");
                UIManager.put("Assist.simple.TextField.border", UIManager.getBorder("TextField.border"));
                UIManager.put("Tree.focusBorder", BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1));
            } else if (string.equalsIgnoreCase("metal")) {
                UIManager.put("Assist.simple.TextField.border", new SimpleFieldBorder());
                UIManager.put("ComboBox.border", UIManager.getBorder("TextField.border"));
            }
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            exception.printStackTrace();
        }
        if (!AssistManager.isJavaVersionAtLeast(1, 4, 0)) {
            GroupFocusManager.register();
        }
        UIManager.put("FileChooser.acceptAllFileFilterText", CmStringPool.get(233));
        UIManager.put("FileChooser.cancelButtonText", CmStringPool.get(234));
        UIManager.put("FileChooser.cancelButtonToolTipText", CmStringPool.get(235));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", CmStringPool.get(236));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", CmStringPool.get(237));
        UIManager.put("FileChooser.directoryDescriptionText", CmStringPool.get(238));
        UIManager.put("FileChooser.fileDescriptionText", CmStringPool.get(239));
        UIManager.put("FileChooser.fileNameLabelText", CmStringPool.get(240));
        UIManager.put("FileChooser.fileNameLabelMnemonic", String.valueOf(CmStringPool.getMnemonic(240)));
        UIManager.put("FileChooser.filesOfTypeLabelText", CmStringPool.get(241));
        UIManager.put("FileChooser.filesOfTypeLabelMnemonic", String.valueOf(CmStringPool.getMnemonic(241)));
        UIManager.put("FileChooser.genericNewFolderText", CmStringPool.get(242));
        UIManager.put("FileChooser.helpButtonText", CmStringPool.get(243));
        UIManager.put("FileChooser.helpButtonMnemonic", String.valueOf(CmStringPool.getMnemonic(243)));
        UIManager.put("FileChooser.helpButtonToolTipText", CmStringPool.get(244));
        UIManager.put("FileChooser.homeFolderAccessibleName", CmStringPool.get(245));
        UIManager.put("FileChooser.homeFolderToolTipText", CmStringPool.get(246));
        UIManager.put("FileChooser.listViewButtonAccessibleName", CmStringPool.get(247));
        UIManager.put("FileChooser.listViewButtonToolTipText", CmStringPool.get(248));
        UIManager.put("FileChooser.lookInLabelText", CmStringPool.get(249));
        UIManager.put("FileChooser.lookInLabelMnemonic", String.valueOf(CmStringPool.getMnemonic(249)));
        UIManager.put("FileChooser.newFolderAccessibleName", CmStringPool.get(250));
        UIManager.put("FileChooser.newFolderErrorSeparator", CmStringPool.get(251));
        UIManager.put("FileChooser.newFolderErrorText", CmStringPool.get(252));
        UIManager.put("FileChooser.newFolderToolTipText", CmStringPool.get(253));
        UIManager.put("FileChooser.openButtonText", CmStringPool.get(254));
        UIManager.put("FileChooser.openButtonMnemonic", String.valueOf(CmStringPool.getMnemonic(254)));
        UIManager.put("FileChooser.openButtonToolTipText", CmStringPool.get(255));
        UIManager.put("FileChooser.saveButtonText", CmStringPool.get(256));
        UIManager.put("FileChooser.saveButtonMnemonic", String.valueOf(CmStringPool.getMnemonic(256)));
        UIManager.put("FileChooser.saveButtonToolTipText", CmStringPool.get(257));
        UIManager.put("FileChooser.updateButtonText", CmStringPool.get(258));
        UIManager.put("FileChooser.updateButtonMnemonic", String.valueOf(CmStringPool.getMnemonic(258)));
        UIManager.put("FileChooser.updateButtonToolTipText", CmStringPool.get(259));
        UIManager.put("FileChooser.upFolderAccessibleName", CmStringPool.get(260));
        UIManager.put("FileChooser.upFolderToolTipText", CmStringPool.get(261));
        UIManager.put("FileChooser.unixNewFolderText", CmStringPool.get(262));
        UIManager.put("FileChooser.windowsNewFolderText", CmStringPool.get(263));
        if (!AssistManager.getPreferredLanguage().toString().equals("en_US")) {
            UIManager.put("FileChooser.pathLabelText", CmStringPool.get(249));
            UIManager.put("FileChooser.pathLabelMnemonic", String.valueOf(CmStringPool.getMnemonic(249)));
            UIManager.put("FileChooser.enterFileNameLabelText", CmStringPool.get(240));
            UIManager.put("FileChooser.enterFileNameLabelMnemonic", String.valueOf(CmStringPool.getMnemonic(240)));
            UIManager.put("FileChooser.filterLabelText", CmStringPool.get(162));
            UIManager.put("FileChooser.filterLabelMnemonic", String.valueOf(CmStringPool.getMnemonic(162)));
            UIManager.put("FileChooser.foldersLabelText", "");
            UIManager.put("FileChooser.filesLabelText", "");
        }
        UIManager.put("TabbedPane.tabRunOverlay", new Integer(-2));
        UIManager.put("ComboBox.disabledForeground", UIManager.getColor("ComboBox.foreground"));
        UIManager.put("ToolBar.dockingBackground", SystemColor.textHighlight);
        UIManager.put("ToolBar.dockingForeground", SystemColor.controlDkShadow);
        UIManager.put("ToolBar.floatingForeground", SystemColor.infoText);
        object = UIManager.getFont("ToolBar.font");
        UIManager.put("ToolBar.font", ((Font)object).deriveFont(1, ((Font)object).getSize2D() - 1.0f));
        UIManager.put("AssistFieldUI", "com.ibm.db2.tools.common.plaf.AssistFieldUI");
        UIManager.put("SmartFieldUI", "com.ibm.db2.tools.common.plaf.SmartFieldUI");
        UIManager.put("AssistTableUI", "com.ibm.db2.tools.common.plaf.AssistTableUI");
        UIManager.put("AssistTabbedPaneUI", "com.ibm.db2.tools.common.plaf.AssistTabbedPaneUI");
        UIManager.put("ViewTableHeaderUI", "com.ibm.db2.tools.common.plaf.ViewTableHeaderUI");
        UIManager.put("AssistTableHeaderUI", "com.ibm.db2.tools.common.plaf.AssistTableHeaderUI");
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        UIManager.put("TableHeader.cellBorder", BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 1, 0, 2)));
        UIManager.put("AssistField.margin", new Insets(0, 0, 0, 0));
        UIManager.put("AssistTable.editor.border", BorderFactory.createLineBorder(AssistConstants.EDITOR_BORDER_COLOR, 1));
        UIManager.put("Assist.error.border", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createLineBorder(AssistConstants.ERROR_BORDER_COLOR, 1)));
        UIManager.put("Assist.nested.border", BorderFactory.createEmptyBorder(1, 1, 1, 1));
        UIManager.put("Assist.nested.error.border", BorderFactory.createLineBorder(AssistConstants.ERROR_BORDER_COLOR, 1));
        UIManager.put("Cell.expansion.border", BorderFactory.createLineBorder(UIManager.getColor("Table.gridColor"), 1));
        UIManager.put("SmartComponent.focus.border", BorderFactory.createLineBorder(SmartConstants.FOCUS_BORDER_COLOR, 1));
        UIManager.put("CommonUIManager", Boolean.TRUE);
        Locale.setDefault(locale);
        AppearanceManager.updateUIManagerFonts();
        CommonClassLoader commonClassLoader = new CommonClassLoader();
        new Thread(commonClassLoader).start();
        CommonTrace.exit(commonTrace);
    }

    static void initializeImpl(boolean bl, boolean bl2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonUIManager", "initializeImpl(boolean set, boolean platformLook)", new Object[]{new Boolean(bl), new Boolean(bl2)});
        }
        if (bl2) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                CommonTrace.catchBlock(commonTrace);
                System.out.println(classNotFoundException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                CommonTrace.catchBlock(commonTrace);
                System.out.println(unsupportedLookAndFeelException);
            }
            catch (IllegalAccessException illegalAccessException) {
                CommonTrace.catchBlock(commonTrace);
                System.out.println(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                CommonTrace.catchBlock(commonTrace);
                System.out.println(instantiationException);
            }
        }
        if (bl) {
            CommonUIManager.setLookAndFeel((LookAndFeel)((Object)new DB2WindowsLookAndFeel()));
        }
        CommonTrace.exit(commonTrace);
    }

    public static class SimpleFieldBorder
    extends MetalBorders.Flush3DBorder {
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "SimpleFieldBorder", "paintBorder(Component c, Graphics g, int x, int y, int w, int h)", new Object[]{component, graphics, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)});
            }
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            CommonTrace.exit(commonTrace);
        }
    }

    public static class CommonClassLoader
    implements Runnable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public CommonClassLoader() {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonClassLoader", "CommonClassLoader()");
            }
            CommonTrace.exit(commonTrace);
        }

        public void run() {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonClassLoader", "run()");
            }
            this.loadJava();
            this.loadCommon();
            CommonTrace.exit(commonTrace);
        }

        protected void loadJava() {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonClassLoader", "loadJava()");
            }
            try {
                Class.forName("java.text.BreakIterator");
                Class.forName("java.text.DateFormatSymbols");
                Class.forName("java.text.DecimalFormat");
                Class.forName("java.text.DecimalFormatSymbols");
                Class.forName("java.text.DigitList");
                Class.forName("java.text.NumberFormat");
                Class.forName("java.text.SimpleDateFormat");
                Class.forName("java.text.StringCharacterIterator");
                Class.forName("javax.swing.JApplet");
                Class.forName("java.text.BreakIterator$BreakIteratorCache");
                Class.forName("java.text.CharSet");
                Class.forName("java.text.CharSet$Enumeration");
                Class.forName("java.text.RuleBasedBreakIterator");
                Class.forName("java.text.RuleBasedBreakIterator$Builder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                CommonTrace.catchBlock(commonTrace);
            }
            CommonTrace.exit(commonTrace);
        }

        protected void loadCommon() {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonClassLoader", "loadCommon()");
            }
            try {
                Class.forName("com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer");
                Class.forName("com.ibm.db2.tools.common.smartx.support.HtmlSymbols");
                Class.forName("com.ibm.db2.tools.common.smartx.support.SmartManager");
                Class.forName("com.ibm.db2.tools.common.support.AssistRole");
                Class.forName("com.ibm.db2.tools.common.support.CellExpander");
            }
            catch (ClassNotFoundException classNotFoundException) {
                CommonTrace.catchBlock(commonTrace);
                System.out.println("Error while preloading commmon classes: " + classNotFoundException.getMessage());
            }
            CommonTrace.exit(commonTrace);
        }
    }
}

