/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CCEnvironment;
import com.ibm.db2.tools.common.TimestampCalendar;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;

public class CommonTrace {
    public static final int TRACE_ON = 1;
    public static final int TRACE_PACKAGE = 2;
    public static final int TRACE_CLASS = 3;
    public static final int TRACE_DEFINITION = 4;
    public static final int TRACE_FINALIZE = 5;
    public static final int TRACE_TIME = 6;
    public static final int TRACE_TRUNCATE = 7;
    public static final int TRACE_COMMS_ON = 8;
    public static final int TRACE_FILTER_ON = 9;
    public static final int TRACE_FILE = 10;
    private static final String SEPARATOR = "^";
    private static final char SEPARATOR_CHAR = '^';
    private static final int MAX_TIMESTAMP_LENGTH = 23;
    protected static int maximumLineLength = 80;
    protected static BitSet traceFlag;
    protected static Vector traceFilter;
    protected static FileOutputStream outputStream;
    protected String functionName;
    protected String className;
    protected String classWhereDefined;
    protected String packageName;
    protected String methodSignature;
    private String finalizerThread = "Finalizer";

    private CommonTrace(String string, String string2, Object object, String string3) {
        this.traceEntry(string, string2, object, string3);
    }

    public static void clear(int n2) {
        traceFlag.clear(n2);
    }

    public static void set(int n2) {
        traceFlag.set(n2);
    }

    public static void setTraceFile(String string) throws IOException {
        outputStream = new FileOutputStream(string, true);
        String string2 = "\n\n---------- Beginning of Trace " + CommonTrace.time() + " ---------- \n\n";
        byte[] byArray = new byte[2];
        byArray = string2.getBytes();
        outputStream.write(byArray);
        traceFlag.set(10);
    }

    public static void closeTraceFile() throws IOException {
        if (outputStream != null) {
            outputStream.close();
            traceFlag.clear(10);
        }
    }

    public static boolean isTrace() {
        return traceFlag.get(1);
    }

    public static void setFilter(Vector vector) {
        traceFilter = vector;
    }

    public static void setMaximumLineLength(int n2) {
        if (n2 > 0) {
            maximumLineLength = n2;
        }
    }

    public static CommonTrace create(String string, String string2, String string3) {
        return CommonTrace.create(string, string2, null, string3, null);
    }

    public static CommonTrace create(String string, String string2, String string3, Object[] objectArray) {
        return CommonTrace.create(string, string2, null, string3, objectArray);
    }

    public static CommonTrace create(String string, String string2, Object object, String string3) {
        return CommonTrace.create(string, string2, object, string3, null);
    }

    public static CommonTrace create(String string, String string2, Object object, String string3, Object[] objectArray) {
        if (traceFlag.get(1)) {
            String string4;
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray != null) {
                int n2 = string3.indexOf("(");
                if (n2 != -1 && n2 + 1 < string3.length()) {
                    stringBuffer.append(string3.substring(0, n2));
                    stringBuffer.append(SEPARATOR);
                    string3 = string3.substring(n2 + 1);
                    int n3 = string3.indexOf(",");
                    int n4 = 0;
                    while (n3 != -1 && n3 + 1 < string3.length() && n4 < objectArray.length - 1) {
                        stringBuffer.append(string3.substring(0, n3));
                        CommonTrace.checkForDelimiters(stringBuffer, objectArray[n4], true);
                        stringBuffer.append(SEPARATOR);
                        string3 = string3.substring(n3 + 1);
                        n3 = string3.indexOf(",");
                        ++n4;
                    }
                    if (n4 == objectArray.length - 1) {
                        n2 = string3.indexOf(")");
                        if (n2 != -1) {
                            stringBuffer.append(string3.substring(0, n2));
                            CommonTrace.checkForDelimiters(stringBuffer, objectArray[n4], true);
                            stringBuffer.append("^^");
                            string4 = stringBuffer.toString();
                        } else {
                            string4 = string3 + "^^^";
                        }
                    } else {
                        string4 = string3 + "^^^";
                    }
                } else {
                    string4 = string3 + "^^^";
                }
            } else {
                string4 = string3 + "^^^";
            }
            return new CommonTrace(string, string2, object, string4);
        }
        return null;
    }

    public static void write(CommonTrace commonTrace, Object object) {
        if (commonTrace != null) {
            commonTrace.write(object != null ? object.toString() : "***null***", false);
        }
    }

    public static void write(CommonTrace commonTrace, int n2) {
        if (commonTrace != null) {
            commonTrace.write(String.valueOf(n2), false);
        }
    }

    public static void write(CommonTrace commonTrace, long l2) {
        if (commonTrace != null) {
            commonTrace.write(String.valueOf(l2), false);
        }
    }

    public static void write(CommonTrace commonTrace, double d2) {
        if (commonTrace != null) {
            commonTrace.write(String.valueOf(d2), false);
        }
    }

    public static void write(CommonTrace commonTrace, boolean bl) {
        if (commonTrace != null) {
            commonTrace.write(String.valueOf(bl), false);
        }
    }

    public static void write(CommonTrace commonTrace, Throwable throwable) {
        if (commonTrace != null) {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            throwable.printStackTrace(new PrintWriter((Writer)charArrayWriter, true));
            commonTrace.write(charArrayWriter.toString(), true);
        }
    }

    public static Object exit(CommonTrace commonTrace, Object object) {
        if (commonTrace != null) {
            commonTrace.exitMethod(object != null ? object.toString() : "***null***");
        }
        return object;
    }

    public static char exit(CommonTrace commonTrace, char c2) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(c2));
        }
        return c2;
    }

    public static int exit(CommonTrace commonTrace, int n2) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(n2));
        }
        return n2;
    }

    public static byte exit(CommonTrace commonTrace, byte by) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(by));
        }
        return by;
    }

    public static short exit(CommonTrace commonTrace, short s2) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(s2));
        }
        return s2;
    }

    public static long exit(CommonTrace commonTrace, long l2) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(l2));
        }
        return l2;
    }

    public static double exit(CommonTrace commonTrace, double d2) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(d2));
        }
        return d2;
    }

    public static float exit(CommonTrace commonTrace, float f2) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(f2));
        }
        return f2;
    }

    public static boolean exit(CommonTrace commonTrace, boolean bl) {
        if (commonTrace != null) {
            commonTrace.exitMethod(String.valueOf(bl));
        }
        return bl;
    }

    public static void exit(CommonTrace commonTrace) {
        if (commonTrace != null) {
            commonTrace.exitMethod(null);
        }
    }

    public static Throwable throwException(CommonTrace commonTrace, Throwable throwable) {
        if (commonTrace != null) {
            commonTrace.throwException(throwable);
        }
        return throwable;
    }

    public static RuntimeException throwException(CommonTrace commonTrace, RuntimeException runtimeException) {
        if (commonTrace != null) {
            commonTrace.throwException(runtimeException);
        }
        return runtimeException;
    }

    public static void catchBlock(CommonTrace commonTrace) {
        if (commonTrace != null) {
            commonTrace.catchBlock();
        }
    }

    protected void traceEntry(String string, String string2, Object object, String string3) {
        if (traceFlag.get(1)) {
            this.className = "UNKNOWN";
            this.classWhereDefined = "UNKNOWN";
            this.functionName = string3;
            this.packageName = "UNKNOWN";
            if (string != null) {
                this.packageName = string;
            }
            if (string2 != null) {
                this.classWhereDefined = string2;
            }
            if (object != null) {
                this.className = object.getClass().getName();
                if (!traceFlag.get(2) && this.className.lastIndexOf(46) + 1 < this.className.length()) {
                    this.className = this.className.substring(this.className.lastIndexOf(46) + 1);
                }
            } else if (string2 != null) {
                this.className = traceFlag.get(2) ? string + "." + string2 : string2;
            }
            if (this.classWhereDefined != null && this.classWhereDefined.indexOf(":") != -1 && this.classWhereDefined.indexOf(":") < this.classWhereDefined.length()) {
                this.classWhereDefined = this.classWhereDefined.substring(0, this.classWhereDefined.indexOf(":"));
            }
            if (this.functionName != null && this.functionName.startsWith(":")) {
                this.functionName = this.functionName.substring(1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (traceFlag.get(3)) {
                stringBuffer.append(this.className);
                if (traceFlag.get(4)) {
                    stringBuffer.append("<");
                    if (traceFlag.get(2)) {
                        stringBuffer.append(this.packageName);
                        stringBuffer.append(".");
                    }
                    stringBuffer.append(this.classWhereDefined);
                    stringBuffer.append(">");
                }
                stringBuffer.append(":");
            }
            stringBuffer.append(this.functionName);
            this.methodSignature = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            stringBuffer.append(CommonTrace.time());
            stringBuffer.append(this.methodSignature);
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" entry ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
            stringBuffer.append(CCEnvironment.getThreadName());
            this.println(stringBuffer.toString());
        }
    }

    private void exitMethod(String string) {
        if (traceFlag.get(1)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CommonTrace.time());
            stringBuffer.append(this.methodSignature);
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" return(");
            if (string != null) {
                CommonTrace.checkForDelimiters(stringBuffer, string, false);
            }
            stringBuffer.append(") ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
            stringBuffer.append(CCEnvironment.getThreadName());
            this.println(stringBuffer.toString());
        }
    }

    private void write(Object object, boolean bl) {
        if (traceFlag.get(1)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CommonTrace.time());
            stringBuffer.append(this.methodSignature);
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
            CommonTrace.checkForDelimiters(stringBuffer, object, false);
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
            stringBuffer.append(CCEnvironment.getThreadName());
            this.println(stringBuffer.toString(), bl);
        }
    }

    private void throwException(Throwable throwable) {
        if (traceFlag.get(1)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CommonTrace.time());
            stringBuffer.append(this.methodSignature);
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" throw(");
            if (throwable != null) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                throwable.printStackTrace(new PrintWriter((Writer)charArrayWriter, true));
                CommonTrace.checkForDelimiters(stringBuffer, charArrayWriter.toString(), false);
            }
            stringBuffer.append(") ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
            stringBuffer.append(CCEnvironment.getThreadName());
            this.println(stringBuffer.toString(), false);
        }
    }

    private void catchBlock() {
        if (traceFlag.get(1)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CommonTrace.time());
            stringBuffer.append(this.methodSignature);
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" catch ");
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
            stringBuffer.append(CCEnvironment.getThreadName());
            this.println(stringBuffer.toString(), false);
        }
    }

    private static String time() {
        StringBuffer stringBuffer = new StringBuffer();
        if (traceFlag.get(6)) {
            TimestampCalendar timestampCalendar = new TimestampCalendar();
            Timestamp timestamp = new Timestamp(timestampCalendar.getTimeInMillis());
            String string = timestamp.toString();
            stringBuffer.append(string);
            stringBuffer.append(CommonTrace.createEmptyString(23 - string.length()));
            stringBuffer.append(" ");
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String createEmptyString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(" ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    private boolean okToTrace(String string) {
        return traceFlag.get(8) && (this.className.indexOf("JDBC_CC_ExtensionsDriver") != -1 || this.className.indexOf("Connection") != -1) || traceFlag.get(9) && this.filterHit(string) || !traceFlag.get(8) && !traceFlag.get(9);
    }

    private void print(String string, boolean bl) {
        if (bl || this.okToTrace(string)) {
            String string2 = CCEnvironment.getThreadName();
            if (traceFlag.get(5) || string2.indexOf(this.finalizerThread) < 0) {
                if (traceFlag.get(7) && string.length() >= maximumLineLength - 1) {
                    string = string.substring(0, maximumLineLength - 1);
                }
                System.out.print(string);
            }
        }
    }

    private void println(String string) {
        this.println(string, false);
    }

    private void println(String string, boolean bl) {
        if (string != null && (bl || this.okToTrace(string))) {
            if (traceFlag.get(10)) {
                try {
                    byte[] byArray = new byte[string.length() + 1];
                    string = string + '\n';
                    byArray = string.getBytes();
                    outputStream.write(byArray);
                }
                catch (IOException iOException) {}
            } else {
                this.print(string + "\n", bl);
            }
        }
    }

    private boolean filterHit(String string) {
        if (traceFilter != null) {
            int n2 = 0;
            while (n2 < traceFilter.size()) {
                if (string.indexOf((String)traceFilter.elementAt(n2)) >= 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void checkForDelimiters(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object == null) {
            stringBuffer.append(" = null");
        } else {
            String string = object.toString();
            if (string == null) {
                stringBuffer.append(" = null");
            } else {
                string.replace('^', '&');
                if (bl) {
                    stringBuffer.append(" = ");
                }
                stringBuffer.append(string);
            }
        }
    }

    public CommonTrace() {
    }

    public CommonTrace(Object object, String string) {
        this.traceEntry(object, string);
    }

    public CommonTrace(String string, String string2) {
        this.traceEntry(string, string2);
    }

    public void x() {
        this.x("");
    }

    public void x(int n2) {
        this.x(new Integer(n2).toString());
    }

    public void x(boolean bl) {
        this.x(new Boolean(bl).toString());
    }

    public void x(String string) {
        this.exitMethod(string);
    }

    public void write(String string) {
        this.write(string, false);
    }

    public void write(Hashtable hashtable) {
        if (hashtable != null) {
            this.write(hashtable.toString());
        }
    }

    public void write(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter((Writer)charArrayWriter, true));
        this.write(charArrayWriter.toString(), true);
    }

    protected void traceEntry(String string, String string2) {
        this.traceEntry("UNKNOWN", string, null, string2 + "^^^");
    }

    protected void traceEntry(Object object, String string) {
        this.traceEntry("UNKNOWN", null, object, string + "^^^");
    }

    public static CommonTrace create() {
        if (traceFlag.get(1)) {
            return new CommonTrace();
        }
        return null;
    }

    public static CommonTrace create(Object object, String string) {
        if (traceFlag.get(1)) {
            return new CommonTrace(object, string);
        }
        return null;
    }

    public static CommonTrace create(String string, String string2) {
        if (traceFlag.get(1)) {
            return new CommonTrace(string, string2);
        }
        return null;
    }

    static {
        traceFilter = null;
        outputStream = null;
        traceFlag = new BitSet(10);
        traceFlag.clear(1);
        traceFlag.clear(4);
        traceFlag.set(2);
        traceFlag.set(3);
        traceFlag.clear(5);
        traceFlag.set(6);
        traceFlag.clear(8);
        traceFlag.clear(9);
        traceFlag.clear(10);
    }
}

