/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommonToolBarButton
extends JButton
implements PropertyChangeListener,
Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int BORDER_NEVER = 1;
    public static final int BORDER_ROLLOVER = 2;
    public static final int BORDER_ALWAYS = 3;
    int borderMode;
    boolean softBorder;

    public CommonToolBarButton() {
        this(null, null);
    }

    public CommonToolBarButton(Icon icon) {
        this(null, icon);
    }

    public CommonToolBarButton(String string) {
        this(string, null);
    }

    public CommonToolBarButton(String string, Icon icon) {
        super(string, icon);
        this.setModel(new ToolBarModel());
        this.setRequestFocusEnabled(false);
        this.setSoftBorderEnabled(true);
        this.setBorderMode(2);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.updateUI();
        this.addChangeListener(new RolloverHandler());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("UAKey")) {
            this.putClientProperty("UAKey", (String)propertyChangeEvent.getNewValue());
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        action.addPropertyChangeListener(this);
        this.setActionCommand((String)action.getValue("ActionCommandKey"));
        this.putClientProperty("UAKey", action.getValue("UAKey"));
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        JLabel jLabel = new JLabel(this.getToolTipText());
        jLabel.setFont(this.getFont());
        jToolTip.setPreferredSize(new Dimension(6 + jLabel.getPreferredSize().width, 5 + jLabel.getPreferredSize().height));
        return jToolTip;
    }

    public boolean isFocusTraversable() {
        return this.isRequestFocusEnabled() && this.isEnabled();
    }

    public void setBorderMode(int n2) {
        this.borderMode = n2;
        this.setRolloverEnabled(this.borderMode == 2);
        this.setBorderPainted(this.borderMode == 3);
    }

    public int getBorderMode() {
        return this.borderMode;
    }

    public void setSoftBorderEnabled(boolean bl) {
        if (bl != this.softBorder) {
            this.softBorder = bl;
            this.updateUI();
        }
    }

    public void updateUI() {
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    public boolean isSoftBorderEnabled() {
        return this.softBorder;
    }

    public String getUIClassID() {
        if (this.softBorder) {
            return "CommonToolBarButtonUI";
        }
        return "ButtonUI";
    }

    public boolean isOpaque() {
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.borderMode == 2) {
            this.repaint();
        }
    }

    private class RolloverHandler
    implements ChangeListener {
        private RolloverHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (CommonToolBarButton.this.borderMode != 2 || CommonToolBarButton.this.softBorder) {
                return;
            }
            ButtonModel buttonModel = CommonToolBarButton.this.getModel();
            CommonToolBarButton.this.setBorderPainted(buttonModel.isRollover());
        }
    }

    class ToolBarModel
    extends DefaultButtonModel {
        public void setRollover(boolean bl) {
            super.setRollover(bl);
            if (super.isRollover() && !bl && !super.isEnabled()) {
                this.stateMask &= 0xFFFFFFEF;
                super.fireStateChanged();
            }
        }
    }
}

