/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonAction;
import com.ibm.db2.tools.common.CommonToggleToolBarButton;
import com.ibm.db2.tools.common.CommonToolBarButton;
import com.ibm.db2.tools.common.plaf.CommonToolBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicToolBarUI;

public class CommonToolBar
extends JToolBar
implements Serializable,
ContainerListener {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int orientation = 0;
    protected Dimension floatingSize;
    protected Point floatingLocation;
    protected JFrame frame;
    protected boolean dockingWindow;
    protected String dockingTitle;
    protected transient MouseListener dockingListener;
    protected transient MouseMotionListener dockingMotionListener;
    protected boolean puzzleEdge = true;
    protected ButtonGroup buttonGroup;
    protected Object userObject;
    protected int helpPanelID = 0;
    static /* synthetic */ Class class$java$awt$event$FocusListener;

    public CommonToolBar() {
        this(false, 0, null);
    }

    public CommonToolBar(JFrame jFrame) {
        this(false, 0, null);
        this.frame = jFrame;
    }

    public CommonToolBar(int n2) {
        this(false, n2, null);
    }

    public CommonToolBar(boolean bl, int n2, String string) {
        this.putClientProperty("JToolBar.isRollover", new Boolean(true));
        this.setDockingWindow(bl);
        this.setOrientation(n2);
        this.setDockingTitle(string);
        this.addContainerListener(this);
        this.updateUI();
    }

    public CommonToolBar(JFrame jFrame, int n2, String string) {
        this(true, n2, string);
        this.frame = jFrame;
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void syncOrientation(int n2) {
        if (this.orientation != n2) {
            this.setOrientation(n2);
        }
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
        ((CommonToolBarUI)this.ui).syncOrientation(n2 == 0 ? 0 : 1);
        this.invalidate();
        this.doLayout();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setFloatingSize(Dimension dimension) {
        this.floatingSize = dimension;
    }

    public Dimension getFloatingSize() {
        return this.floatingSize;
    }

    public void setFloatingLocation(Point point) {
        this.floatingLocation = point;
    }

    public Point getFloatingLocation() {
        return this.floatingLocation;
    }

    public void setDockingWindow(boolean bl) {
        this.dockingWindow = bl;
        if (bl) {
            this.setBorder(null);
        }
    }

    public boolean getDockingWindow() {
        return this.dockingWindow;
    }

    public void setDockingTitle(String string) {
        this.dockingTitle = string;
    }

    public String getDockingTitle() {
        return this.dockingTitle;
    }

    public void setFloating(boolean bl, Point point) {
        if (this.isFloatable()) {
            ((BasicToolBarUI)this.getUI()).setFloating(bl, point);
        }
    }

    public boolean isFloating() {
        return ((BasicToolBarUI)this.getUI()).isFloating();
    }

    public void addDockingListeners(MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        this.dockingListener = mouseListener;
        this.dockingMotionListener = mouseMotionListener;
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseMotionListener);
    }

    public void removeDockingListeners(MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        this.dockingListener = null;
        this.dockingMotionListener = null;
        this.removeMouseListener(mouseListener);
        this.removeMouseMotionListener(mouseMotionListener);
    }

    public MouseMotionListener getDockingMotionListener() {
        return this.dockingMotionListener;
    }

    public MouseListener getDockingListener() {
        return this.dockingListener;
    }

    public void addFocusListener(FocusListener focusListener) {
        this.listenerList.add(class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = CommonToolBar.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener, focusListener);
        this.updateDescendingFocusListeners(true, this, focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.listenerList.remove(class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = CommonToolBar.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener, focusListener);
        this.updateDescendingFocusListeners(false, this, focusListener);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void updateDescendingFocusListeners(boolean bl, Component component, FocusListener focusListener) {
        if (component == null || focusListener == null) {
            return;
        }
        if (component.isFocusTraversable()) {
            if (bl) {
                component.addFocusListener(focusListener);
            } else {
                component.removeFocusListener(focusListener);
            }
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = componentArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (componentArray[n3] instanceof JScrollPane) {
                    this.updateDescendingFocusListeners(bl, ((JScrollPane)componentArray[n3]).getViewport().getView(), focusListener);
                } else {
                    this.updateDescendingFocusListeners(bl, componentArray[n3], focusListener);
                }
                ++n3;
            }
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (this.dockingWindow) {
            Component component = containerEvent.getChild();
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$java$awt$event$FocusListener == null ? CommonToolBar.class$("java.awt.event.FocusListener") : class$java$awt$event$FocusListener)) {
                    this.updateDescendingFocusListeners(true, component, (FocusListener)objectArray[n2 + 1]);
                }
                n2 -= 2;
            }
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.dockingWindow) {
            Component component = containerEvent.getChild();
            Object[] objectArray = this.listenerList.getListenerList();
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$java$awt$event$FocusListener == null ? CommonToolBar.class$("java.awt.event.FocusListener") : class$java$awt$event$FocusListener)) {
                    this.updateDescendingFocusListeners(false, component, (FocusListener)objectArray[n2 + 1]);
                }
                n2 -= 2;
            }
        }
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setPuzzleEdge(boolean bl) {
        if (this.puzzleEdge != bl) {
            this.puzzleEdge = bl;
            ((CommonToolBarUI)this.ui).syncOrientation(this.orientation == 0 ? 0 : 1);
        }
    }

    public boolean isPuzzleEdge() {
        return this.puzzleEdge;
    }

    public String getUIClassID() {
        return "CommonToolBarUI";
    }

    public boolean isOpaque() {
        return false;
    }

    public void dispose() {
    }

    public void setEnabled(boolean bl) {
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            Component component = this.getComponent(n2);
            component.setEnabled(bl);
            ++n2;
        }
        super.setEnabled(bl);
    }

    public void addSeparator(boolean bl) {
        CommonSeparator commonSeparator = new CommonSeparator(bl);
        commonSeparator.setBackground(this.getBackground());
        this.add(commonSeparator);
    }

    public void addSeparator() {
        CommonSeparator commonSeparator = new CommonSeparator(this.isPuzzleEdge());
        commonSeparator.setBackground(this.getBackground());
        this.add(commonSeparator);
    }

    public void addSeparator(Dimension dimension) {
        CommonSeparator commonSeparator = new CommonSeparator(dimension, this.isPuzzleEdge());
        commonSeparator.setBackground(this.getBackground());
        this.add(commonSeparator);
    }

    public JButton addButton(ImageIcon imageIcon, ActionListener actionListener, String string, String string2, KeyStroke keyStroke) {
        final ActionListener actionListener2 = actionListener;
        CommonAction commonAction = new CommonAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                actionListener2.actionPerformed(actionEvent);
            }
        };
        commonAction.setSmallIcon(imageIcon);
        commonAction.putValue("ShortDescription", string);
        if (null != string2) {
            commonAction.putValue("ActionCommandKey", string2);
        }
        return this.addButton(commonAction);
    }

    public JButton addButton(CommonAction commonAction) {
        JButton jButton = this.createDefaultButton();
        jButton.setAction(commonAction);
        jButton.setMnemonic(0);
        this.add(jButton);
        return jButton;
    }

    public JButton addButton(String string, ImageIcon imageIcon, ActionListener actionListener, String string2, KeyStroke keyStroke) {
        final ActionListener actionListener2 = actionListener;
        CommonAction commonAction = new CommonAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                actionListener2.actionPerformed(actionEvent);
            }
        };
        commonAction.putValue("ShortDescription", string);
        commonAction.setSmallIcon(imageIcon);
        if (null != string2) {
            commonAction.putValue("ActionCommandKey", string2);
        }
        return this.addButton(commonAction);
    }

    public JToggleButton addToggleButton(ImageIcon imageIcon, ActionListener actionListener, String string, String string2, KeyStroke keyStroke, boolean bl) {
        final ActionListener actionListener2 = actionListener;
        CommonAction commonAction = new CommonAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                actionListener2.actionPerformed(actionEvent);
            }
        };
        commonAction.setSmallIcon(imageIcon);
        commonAction.putValue("ShortDescription", string);
        if (null != string2) {
            commonAction.putValue("ActionCommandKey", string2);
        }
        return this.addToggleButton(commonAction, bl);
    }

    public JToggleButton addToggleButton(CommonAction commonAction, boolean bl) {
        JToggleButton jToggleButton = this.createDefaultToggleButton();
        jToggleButton.setAction(commonAction);
        jToggleButton.setMnemonic(0);
        this.add(jToggleButton);
        if (bl) {
            if (null == this.buttonGroup) {
                this.buttonGroup = new ButtonGroup();
            }
            this.buttonGroup.add(jToggleButton);
        }
        return jToggleButton;
    }

    public JToggleButton addToggleButton(String string, ImageIcon imageIcon, ActionListener actionListener, String string2, KeyStroke keyStroke, boolean bl) {
        final ActionListener actionListener2 = actionListener;
        CommonAction commonAction = new CommonAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                actionListener2.actionPerformed(actionEvent);
            }
        };
        commonAction.putValue("ShortDescription", string);
        commonAction.setSmallIcon(imageIcon);
        if (null != string2) {
            commonAction.putValue("ActionCommandKey", string2);
        }
        return this.addToggleButton(commonAction, bl);
    }

    protected JButton createDefaultButton() {
        CommonToolBarButton commonToolBarButton = new CommonToolBarButton();
        commonToolBarButton.putClientProperty("hideActionText", Boolean.TRUE);
        return commonToolBarButton;
    }

    protected JToggleButton createDefaultToggleButton() {
        CommonToggleToolBarButton commonToggleToolBarButton = new CommonToggleToolBarButton();
        commonToggleToolBarButton.putClientProperty("hideActionText", Boolean.TRUE);
        return commonToggleToolBarButton;
    }

    public void setHelpPanelID(int n2) {
        this.helpPanelID = n2;
    }

    public int getHelpPanelID() {
        return this.helpPanelID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CommonSeparator
    extends JSeparator
    implements Serializable {
        private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Dimension separatorSize;
        protected final int DEFAULT_SIZE_BASE = 29;
        protected int bend = 5;
        protected int pad = 5;
        protected boolean puzzle;

        public CommonSeparator() {
            this.puzzle = true;
        }

        public CommonSeparator(boolean bl) {
            this.puzzle = bl;
        }

        public CommonSeparator(Dimension dimension) {
            super(0);
            this.setSeparatorSize(dimension);
            this.puzzle = true;
        }

        public void setSeparatorSize(Dimension dimension) {
            this.separatorSize = dimension != null ? dimension : this.calculateSize(29);
            this.invalidate();
        }

        public CommonSeparator(Dimension dimension, boolean bl) {
            super(0);
            this.setSeparatorSize(dimension);
            this.puzzle = bl;
        }

        public Dimension getSeparatorSize() {
            return this.separatorSize;
        }

        public Dimension getPreferredSize() {
            if (null != this.separatorSize) {
                return this.separatorSize.getSize();
            }
            return this.calculateSize(29);
        }

        private Dimension calculateSize(int n2) {
            if (this.puzzle) {
                return 0 == CommonToolBar.this.orientation ? new Dimension(this.pad + this.bend + this.pad, n2) : new Dimension(n2, this.pad + this.pad + this.bend);
            }
            return 0 == CommonToolBar.this.orientation ? new Dimension(this.pad, n2) : new Dimension(n2, this.pad);
        }

        public Dimension getMinimumSize() {
            return this.calculateSize(0);
        }

        public Dimension getMaximumSize() {
            return this.calculateSize(Short.MAX_VALUE);
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = super.getSize();
            Dimension dimension2 = CommonToolBar.this.getSize();
            Color color = CommonToolBar.this.getBackground();
            if (this.puzzle) {
                if (1 == CommonToolBar.this.orientation) {
                    super.setSize(new Dimension(dimension2.width, dimension.height));
                    int n2 = 0;
                    int n3 = this.pad;
                    int n4 = dimension2.width;
                    int n5 = dimension.height - this.pad;
                    int n6 = dimension2.width / 2;
                    int n7 = n5 - 1;
                    int[] nArray = new int[]{n2, n6 - 1 - this.bend, n6 - 1, n6 - 1 + this.bend, n4 - 1};
                    int[] nArray2 = new int[]{n7, n7, n7 - this.bend, n7, n7};
                    graphics.setColor(color.brighter());
                    graphics.drawPolyline(nArray, nArray2, 5);
                    graphics.translate(0, -1);
                    graphics.setColor(color.darker());
                    graphics.drawPolyline(nArray, nArray2, 5);
                    graphics.translate(0, 1);
                } else {
                    super.setSize(new Dimension(dimension.width, dimension2.height));
                    int n8 = this.pad;
                    int n9 = 0;
                    int n10 = dimension.width - this.pad - 1;
                    int n11 = dimension2.height;
                    int n12 = n10;
                    int n13 = dimension2.height / 2;
                    int[] nArray = new int[]{n10, n10, n10 - this.bend, n10, n10};
                    int[] nArray3 = new int[]{n9, n13 - 1 - this.bend, n13 - 1, n13 - 1 + this.bend, n11 - 1};
                    graphics.setColor(color.brighter());
                    graphics.drawPolyline(nArray, nArray3, 5);
                    graphics.translate(-1, 0);
                    graphics.setColor(color.darker());
                    graphics.drawPolyline(nArray, nArray3, 5);
                    graphics.translate(1, 0);
                }
            } else if (1 == CommonToolBar.this.orientation) {
                super.setSize(new Dimension(dimension2.width, dimension.height));
                int n14 = 0;
                int n15 = this.pad / 2;
                graphics.setColor(color.brighter());
                graphics.drawLine(n14, n15, dimension2.width, n15);
                graphics.setColor(color.darker());
                graphics.drawLine(n14, n15 - 1, dimension2.width, n15 - 1);
            } else {
                super.setSize(new Dimension(dimension.width, dimension2.height));
                int n16 = this.pad / 2;
                int n17 = 0;
                graphics.setColor(color.brighter());
                graphics.drawLine(n16, n17, n16, dimension2.height);
                graphics.setColor(color.darker());
                graphics.drawLine(n16 - 1, n17, n16 - 1, dimension2.height);
            }
        }
    }
}

