/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonImageRepository;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public class CommonToggleToolBarButton
extends JToggleButton
implements PropertyChangeListener,
Serializable {
    protected ImageIcon upstate;
    protected ImageIcon dnstate;
    protected boolean focusable = false;

    public CommonToggleToolBarButton() {
        this(null, null, false);
    }

    public CommonToggleToolBarButton(String string) {
        this(string, null, false);
    }

    public CommonToggleToolBarButton(ImageIcon imageIcon) {
        this(null, imageIcon, false);
    }

    public CommonToggleToolBarButton(String string, ImageIcon imageIcon) {
        this(null, imageIcon, false);
    }

    public CommonToggleToolBarButton(String string, ImageIcon imageIcon, boolean bl) {
        this.loadIcons();
        this.setText(string);
        this.setIcon(imageIcon);
        this.focusable = bl;
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.setRolloverEnabled(true);
        this.loadIcons();
        this.calculateMargins();
        this.setOpaque(false);
        if (bl) {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    CommonToggleToolBarButton commonToggleToolBarButton = (CommonToggleToolBarButton)focusEvent.getSource();
                    commonToggleToolBarButton.setRolloverEnabled(false);
                    commonToggleToolBarButton.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    CommonToggleToolBarButton commonToggleToolBarButton = (CommonToggleToolBarButton)focusEvent.getSource();
                    commonToggleToolBarButton.setRolloverEnabled(true);
                    commonToggleToolBarButton.repaint();
                }
            });
        }
        this.addPropertyChangeListener("UAKey", this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("UAKey")) {
            this.putClientProperty("UAKey", (String)propertyChangeEvent.getNewValue());
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        action.addPropertyChangeListener(this);
        this.setActionCommand((String)action.getValue("ActionCommandKey"));
        this.putClientProperty("UAKey", action.getValue("UAKey"));
    }

    public boolean isFocusTraversable() {
        if (!this.focusable) {
            return false;
        }
        return (!this.model.isArmed() || !this.model.isPressed()) && !this.isSelected();
    }

    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.calculateMargins();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl;
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = !this.isRolloverEnabled() || buttonModel.isRollover();
        boolean bl3 = bl = buttonModel.isArmed() && buttonModel.isPressed() || this.isSelected();
        if (bl2) {
            ImageIcon imageIcon = bl ? this.dnstate : this.upstate;
            imageIcon.paintIcon(this, graphics, 0, 0);
        } else if (bl) {
            ImageIcon imageIcon = this.dnstate;
            imageIcon.paintIcon(this, graphics, 0, 0);
        }
        super.paintComponent(graphics);
    }

    private void calculateMargins() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ImageIcon imageIcon = (ImageIcon)this.getIcon();
        int n6 = this.upstate.getIconWidth();
        int n7 = this.upstate.getIconHeight();
        if (imageIcon != null) {
            int n8;
            int n9 = imageIcon.getIconWidth();
            int n10 = imageIcon.getIconHeight();
            int n11 = n6 - n9;
            if (n11 > 0) {
                n3 = n11 / 2;
                n5 = n11 - n2;
            }
            if ((n8 = n7 - n10) > 0) {
                n2 = n8 / 2;
                n4 = n8 - n2;
            }
        }
        this.setBorder(new EmptyBorder(n2, n3, n4, n5));
    }

    private void loadIcons() {
        if (this.upstate != null) {
            return;
        }
        this.upstate = CommonImageRepository.getCommonIcon(CommonImageRepository.NV_UP_BUTTON);
        this.dnstate = CommonImageRepository.getCommonIcon(CommonImageRepository.NV_DOWN_BUTTON);
    }
}

