/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.ProgressWindow;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public abstract class CommonPrintDriver
implements Printable,
Runnable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ProgressWindow progress;

    public void printToPrinter() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public abstract Frame getFrame();

    public abstract PageFormat getPageFormat();

    public abstract void setPageFormat(PageFormat var1);

    public abstract String getTitle();

    public String getProgressTitle() {
        return "";
    }

    public abstract int print(Graphics var1, PageFormat var2, int var3) throws PrinterException;

    public void run() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonPrintDriver", this, "run()");
        }
        boolean bl = RepaintManager.currentManager(this.getFrame()).isDoubleBufferingEnabled();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.getPageFormat();
        pageFormat = null != pageFormat ? printerJob.validatePage(pageFormat) : printerJob.defaultPage();
        this.setPageFormat(pageFormat);
        printerJob.setJobName(this.getTitle());
        printerJob.setPrintable(this, pageFormat);
        if (System.getProperty("os.name").indexOf("Windows") >= 0 && System.getProperty("java.version").indexOf("1.3.1") >= 0 || printerJob.printDialog()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CommonPrintDriver.this.progress = new ProgressWindow((JFrame)CommonPrintDriver.this.getFrame(), CommonPrintDriver.this.getProgressTitle());
                }
            });
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                CommonTrace.catchBlock(commonTrace);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CommonPrintDriver.this.progress.stop();
                }
            });
        }
        RepaintManager.currentManager(this.getFrame()).setDoubleBufferingEnabled(bl);
        CommonTrace.exit(commonTrace);
    }
}

