/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.CCEnvironment;
import com.ibm.db2.tools.common.CommonAction;
import com.ibm.db2.tools.common.CommonMenu;
import com.ibm.db2.tools.common.CommonTrace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CommonPopupMenu
extends JPopupMenu
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int FONT_HEIGHT = 12;
    private static boolean fInitialized = false;
    public static final String CHECKBOX = "CheckBox";

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuElement[] menuElementArray = this.getSubElements();
        if (null != menuElementArray && menuElementArray.length > 0) {
            int n2 = 0;
            while (n2 < menuElementArray.length) {
                MenuElement[] menuElementArray2 = new MenuElement[]{this, (JMenuItem)menuElementArray[n2]};
                ((JMenuItem)menuElementArray[n2]).processKeyEvent(keyEvent, menuElementArray2, MenuSelectionManager.defaultManager());
                ++n2;
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void add(Action[] actionArray) {
        int n2 = 0;
        while (n2 < actionArray.length) {
            this.add(actionArray[n2]);
            ++n2;
        }
    }

    public JMenuItem add(Action action) {
        AbstractButton abstractButton = null;
        if (action instanceof CommonAction && ((CommonAction)action).isCascade()) {
            this.add(new CommonMenu(action));
        } else if (action instanceof CommonAction && ((CommonAction)action).isDivider()) {
            this.addSeparator();
        } else {
            if (action.getValue(CHECKBOX) == null) {
                abstractButton = new JMenuItem(new HelperAction(action));
            } else {
                abstractButton = new JCheckBoxMenuItem(new HelperAction(action));
                abstractButton.setSelected((Boolean)action.getValue(CHECKBOX));
            }
            abstractButton.setHorizontalTextPosition(4);
            abstractButton.setVerticalTextPosition(0);
            ((JMenuItem)abstractButton).setEnabled(action.isEnabled());
            if (action instanceof CommonAction && ((CommonAction)action).isDefault()) {
                Font font = abstractButton.getFont();
                abstractButton.setFont(AppearanceManager.getLanguageDependentFont(font.getName(), font.getStyle() | 1, font.getSize()));
            }
            if (action instanceof CommonAction && null != ((CommonAction)action).getAccelerator() && 0 != ((CommonAction)action).getAccelerator().getKeyCode()) {
                ((JMenuItem)abstractButton).setAccelerator(((CommonAction)action).getAccelerator());
            }
            if (action instanceof CommonAction && 0 != ((CommonAction)action).getMnemonic()) {
                abstractButton.setMnemonic(((CommonAction)action).getMnemonic());
            }
            this.add((JMenuItem)abstractButton);
        }
        if (null != abstractButton) {
            abstractButton.setIcon(null);
        }
        return abstractButton;
    }

    public void show(Component component, int n2, int n3) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonPopupMenu", this, "show(Component component, int xPopup, int yPopup)", new Object[]{component, new Integer(n2), new Integer(n3)});
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Component component2 = null;
        Point point = null;
        if (!component.isShowing()) {
            return;
        }
        point = component.getLocationOnScreen();
        Dimension dimension2 = this.getPreferredSize();
        if (FONT_HEIGHT != 12) {
            float f2 = (float)(FONT_HEIGHT + 2) / 14.0f;
            dimension2.height = (int)((float)dimension2.height * f2);
            dimension2.width = (int)((float)dimension2.width * f2);
            if (!fInitialized) {
                fInitialized = true;
                this.setPreferredSize(dimension2);
            } else {
                this.setPopupSize(dimension2);
            }
        }
        if (point.y + n3 + dimension2.height > dimension.height - 20) {
            if (point.y + (n3 -= dimension2.height) < 0) {
                n3 = -point.y;
            }
            if (component2 == null) {
                component2 = this.getFrameParent(component);
            }
            Point point2 = null;
            if (!component2.isShowing()) {
                return;
            }
            point2 = component2.getLocationOnScreen();
            if (point.y + n3 >= point2.y && point.y + n3 <= point2.y + 30) {
                n3 = point2.y + 30 - point.y;
            }
        }
        if (CCEnvironment.getApplet() != null) {
            if (component2 == null) {
                component2 = this.getFrameParent(component);
            }
            if (component2 != null) {
                Dimension dimension3 = component2.getSize();
                Point point3 = null;
                if (!component2.isShowing()) {
                    return;
                }
                point3 = component2.getLocationOnScreen();
                if (point.y + n3 + dimension2.height <= point3.y + dimension3.height + 2 && point.y + n3 + dimension2.height >= point3.y + dimension3.height - 30 && point.y + (n3 -= 32) < 0) {
                    n3 = dimension.height - point.y - dimension2.height - 30;
                }
            }
        }
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                CommonPopupMenu.this.getInvoker().requestFocus();
                CommonPopupMenu.this.removePopupMenuListener(this);
            }
        });
        super.show(component, n2, n3);
        this.requestFocus();
        CommonTrace.exit(commonTrace);
    }

    public static void setFontHeight(int n2) {
        FONT_HEIGHT = n2;
    }

    private Component getFrameParent(Component component) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonPopupMenu", this, "getFrameParent(Component comp)", new Object[]{component});
        }
        Component component2 = component;
        do {
            component2 = component2.getParent();
            CommonTrace.write(commonTrace, "Tracing popupParent = " + component2);
        } while (!(component2 instanceof JFrame) && component2 != null);
        return (Component)CommonTrace.exit(commonTrace, component2);
    }

    private class RunAction
    implements Runnable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Action action;
        protected ActionEvent event;

        public RunAction(Action action, ActionEvent actionEvent) {
            this.action = action;
            this.event = actionEvent;
        }

        public void run() {
            this.action.actionPerformed(this.event);
        }
    }

    private class HelperAction
    extends AbstractAction
    implements PropertyChangeListener {
        private Action action;

        HelperAction(Action action) {
            CommonTrace commonTrace = null;
            if (CommonTrace.isTrace()) {
                commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "HelperAction", "HelperAction(Action anAction)", new Object[]{action});
            }
            this.action = action;
            this.action.addPropertyChangeListener(this);
            if (this.action instanceof AbstractAction) {
                Object[] objectArray = ((AbstractAction)this.action).getKeys();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof String) {
                        this.putValue((String)objectArray[n2], ((AbstractAction)this.action).getValue((String)objectArray[n2]));
                    }
                    ++n2;
                }
            } else {
                throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("The actions used with CommonMenu have to extend at least AbstractAction. It is recommended to use subclases of CommonAction. The current action is " + this.action));
            }
            CommonTrace.exit(commonTrace);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new RunAction(this.action, actionEvent));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                super.setEnabled(bl);
            } else {
                Object object = this.action.getValue(string);
                if (propertyChangeEvent.getNewValue() != null && null != object || propertyChangeEvent.getNewValue() == null && null == object && propertyChangeEvent.getOldValue() != null) {
                    this.putValue(string, propertyChangeEvent.getNewValue());
                }
            }
        }
    }
}

