/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.EnhancedTextArea;
import com.ibm.db2.tools.common.ResultProcessor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class CommonMessage
extends CommonDialog
implements Serializable {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    private EnhancedTextArea messageText;
    private String text;
    private String text2ndLevel;
    private String messageId;
    private ResultProcessor rp;
    private JButton[] button = new JButton[5];
    private JButton okRetry;
    private JButton help;
    private JButton cancel;
    private JButton noButton;
    private JButton ignore;
    private JButton showSQL = null;
    private int iconIndex = CommonImageRepository.MESSAGE_ERROR;
    private int flags;
    private JPanel msgPanel = null;
    private String[] sqlText = null;
    public static final int MSG_OK = 0;
    public static final int MSG_CANCEL = 1;
    public static final int MSG_RETRYCANCEL = 2;
    public static final int MSG_ALARM = 4;
    public static final int MSG_MODELESS = 8;
    public static final int MSG_YESNO = 16;
    public static final int MSG_RETRYIGNORECANCEL = 32;
    public static final int MSG_OKCANCEL = 64;
    public static final int MSG_YESNOCANCEL = 128;
    public static final int MSG_APPENDREPLACECANCEL = 256;
    public static final int MSG_CLOSE = 512;
    public static final String retryCommand = "Retry";
    public static final String ignoreCommand = "Ignore";
    public static final String alarmCommand = "Alarm";
    public static final String yesCommand = "Yes";
    public static final String noCommand = "No";
    public static final String appendCommand = "Append";
    public static final String replaceCommand = "Replace";
    public static final String YES_STRING = "OK_RETRY";
    public static final String NO_STRING = "NO";
    public static final String CANCEL_STRING = "CANCEL";
    public static final String OK_STRING = "OK_RETRY";
    public static final String RETRY_STRING = "OK_RETRY";
    public static final String IGNORE_STRING = "IGNORE";

    public static String fillParms(String string, String[] stringArray) {
        String string2 = string;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = "";
            int n3 = 0;
            while (n3 < string2.length()) {
                if (string2.charAt(n3) == '%' && string2.charAt(n3 + 1) == String.valueOf(n2 + 1).charAt(0)) {
                    string3 = string3 + stringArray[n2];
                    ++n3;
                } else {
                    string3 = string3 + string2.charAt(n3);
                }
                ++n3;
            }
            string2 = string3;
            ++n2;
        }
        return string2;
    }

    public CommonMessage(CommonDialog commonDialog, String string, String string2, int n2, String string3, String string4, int n3, ResultProcessor resultProcessor, boolean bl) {
        this(commonDialog, string, string2, n2, string3, string4, n3, resultProcessor, bl, true);
    }

    public CommonMessage(JFrame jFrame, String string, String string2, int n2, String string3, String string4, int n3, ResultProcessor resultProcessor, boolean bl) {
        this(jFrame, string, string2, n2, string3, string4, n3, resultProcessor, bl, true);
    }

    public CommonMessage(JDialog jDialog, String string, String string2, int n2, String string3, String string4, int n3, ResultProcessor resultProcessor, boolean bl, boolean bl2) {
        super(jDialog, string, bl, 0L);
        this.constructor(string2, n2, string3, string4, n3, resultProcessor, bl, bl2);
    }

    public CommonMessage(JFrame jFrame, String string, String string2, int n2, String string3, String string4, int n3, ResultProcessor resultProcessor, boolean bl, boolean bl2) {
        super(jFrame, string, bl, 0L);
        this.constructor(string2, n2, string3, string4, n3, resultProcessor, bl, bl2);
    }

    private final void constructor(String string, int n2, String string2, String string3, int n3, ResultProcessor resultProcessor, boolean bl, boolean bl2) {
        this.text = string;
        this.text2ndLevel = string3;
        this.messageId = string2;
        this.rp = resultProcessor;
        this.flags = n3;
        if (n2 == 2) {
            this.iconIndex = CommonImageRepository.MESSAGE_INFO;
        } else if (n2 == 1) {
            this.iconIndex = CommonImageRepository.MESSAGE_WARNING;
        } else if (n2 == 0) {
            this.iconIndex = CommonImageRepository.MESSAGE_ERROR;
        }
        this.makeLayout();
        this.pack();
        if (bl2) {
            this.showDialog();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.rp != null) {
            this.rp.processResult(this, actionEvent.getActionCommand());
        }
        this.lastActionCommand = actionEvent.getActionCommand();
        if (this.lastActionCommand != null && (this.lastActionCommand.equals("OK") || this.lastActionCommand.equals(yesCommand) || this.lastActionCommand.equals(noCommand))) {
            this.close();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void makeLayout() {
        this.setClient(this.makeFirstPanel(this.getPanel()));
    }

    private Container makeFirstPanel(Container container) {
        container.setLayout(new BorderLayout(5, 5));
        ((JPanel)container).setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add("West", this.makeWestPanel(this.getPanel()));
        this.msgPanel = this.getPanel();
        container.add("Center", this.makeCenterPanel(this.msgPanel));
        container.add("South", this.makeSouthButtonPanel(this.getPanel()));
        return container;
    }

    public void setLineWrap(boolean bl) {
        this.messageText.setLineWrap(bl);
        this.messageText.setWrapStyleWord(bl);
    }

    private Container makeCenterPanel(Container container) {
        container.setLayout(new GridLayout(1, 1));
        ((JPanel)container).setBorder(new EmptyBorder(0, 0, 0, 0));
        this.messageText = new EnhancedTextArea();
        this.messageText.setLineWrap(true);
        this.messageText.setWrapStyleWord(true);
        this.messageText.setColumns(30);
        this.messageText.setRows(10);
        JScrollPane jScrollPane = new JScrollPane(this.messageText);
        this.messageText.setEditable(false);
        container.add(jScrollPane);
        this.messageText.setFont(AppearanceManager.getFont("default"));
        this.messageText.append(this.text);
        return container;
    }

    private Container makeWestPanel(Container container) {
        container.setLayout(new BorderLayout(5, 5));
        container.add("North", this.makeImagePanel(this.getPanel()));
        container.add("Center", this.makeLabelPanel(this.getPanel()));
        return container;
    }

    private Container makeImagePanel(Container container) {
        container.setLayout(new FlowLayout(1));
        if (this.iconIndex != -1) {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(CommonImageRepository.getScaledIcon(this.iconIndex));
            jButton.setBorderPainted(false);
            jPanel.add(jButton);
            container.add(jPanel);
        }
        return container;
    }

    private Container makeLabelPanel(Container container) {
        container.setLayout(new BorderLayout(5, 5));
        container.add("North", new JLabel(this.messageId + "  ", 0));
        return container;
    }

    private Container makeSouthButtonPanel(Container container) {
        container.setLayout(new BorderLayout(0, 0));
        ((JPanel)container).setBorder(new EmptyBorder(10, 0, 0, 0));
        container.add("East", this.makeButtonsPanel(this.getPanel()));
        return container;
    }

    private Container makeButtonsPanel(Container container) {
        int n2;
        int n3 = 0;
        if ((this.flags & 0) != 0) {
            this.okRetry = new JButton(CmStringPool.get(25));
            this.okRetry.setActionCommand("Close");
            this.okRetry.putClientProperty("UAKey", "CM_UD_BVCLOSE");
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCLOSE");
            if (this.okRetry.getText().length() == 0) {
                this.okRetry.setText("Close");
            }
            this.button[0] = this.okRetry;
            n3 = 1;
        } else if ((this.flags & 0x10) != 0) {
            this.okRetry = new JButton(CmStringPool.get(43));
            this.okRetry.setActionCommand(yesCommand);
            this.okRetry.setMnemonic(CmStringPool.getMnemonic(43));
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVYES");
            this.noButton = new JButton(CmStringPool.get(44));
            this.noButton.setActionCommand(noCommand);
            this.noButton.setMnemonic(CmStringPool.getMnemonic(44));
            this.noButton.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVNO");
            this.button[0] = this.okRetry;
            this.button[1] = this.noButton;
            this.setDefaultFocusComponent(this.noButton);
            n3 = 2;
            if ((this.flags & 1) != 0) {
                this.cancel = new JButton(CmStringPool.get(24));
                this.cancel.setActionCommand("Cancel");
                this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
                this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
                this.button[2] = this.cancel;
                this.setDefaultFocusComponent(this.cancel);
                n3 = 3;
            }
        } else if ((this.flags & 1) != 0) {
            this.cancel = new JButton(CmStringPool.get(24));
            this.cancel.setActionCommand("Cancel");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
            if (this.cancel.getText().length() == 0) {
                this.cancel.setText("Cancel");
            }
            this.button[0] = this.cancel;
            n3 = 1;
        } else if ((this.flags & 0x200) != 0) {
            this.cancel = new JButton(CmStringPool.get(25));
            this.cancel.setActionCommand("Close");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCLOSE");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCLOSE");
            if (this.cancel.getText().length() == 0) {
                this.cancel.setText("Close");
            }
            this.button[0] = this.cancel;
            n3 = 1;
        } else if ((this.flags & 2) != 0) {
            this.okRetry = new JButton(CmStringPool.get(45));
            this.okRetry.setActionCommand(retryCommand);
            this.okRetry.setMnemonic(CmStringPool.getMnemonic(45));
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVRETRY");
            this.cancel = new JButton(CmStringPool.get(24));
            this.cancel.setActionCommand("Cancel");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
            this.button[0] = this.okRetry;
            this.button[1] = this.cancel;
            n3 = 2;
        } else if ((this.flags & 0x20) != 0) {
            this.okRetry = new JButton(CmStringPool.get(45));
            this.okRetry.setActionCommand(retryCommand);
            this.okRetry.setMnemonic(CmStringPool.getMnemonic(45));
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVRETRY");
            this.ignore = new JButton(CmStringPool.get(46));
            this.ignore.setActionCommand(ignoreCommand);
            this.ignore.setMnemonic(CmStringPool.getMnemonic(46));
            this.ignore.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVIGNORE");
            this.cancel = new JButton(CmStringPool.get(24));
            this.cancel.setActionCommand("Cancel");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
            this.button[0] = this.okRetry;
            this.button[1] = this.ignore;
            this.button[2] = this.cancel;
            n3 = 3;
        } else if ((this.flags & 0x80) != 0) {
            this.okRetry = new JButton(CmStringPool.get(43));
            this.okRetry.setActionCommand(yesCommand);
            this.okRetry.setMnemonic(CmStringPool.getMnemonic(43));
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVYES");
            this.noButton = new JButton(CmStringPool.get(44));
            this.noButton.setActionCommand(noCommand);
            this.noButton.setMnemonic(CmStringPool.getMnemonic(44));
            this.noButton.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVNO");
            this.cancel = new JButton(CmStringPool.get(24));
            this.cancel.setActionCommand("Cancel");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
            this.button[0] = this.okRetry;
            this.button[1] = this.noButton;
            this.button[2] = this.cancel;
            n3 = 3;
        } else if ((this.flags & 0x40) != 0) {
            this.okRetry = new JButton(CmStringPool.get(27));
            this.okRetry.setActionCommand("OK");
            this.okRetry.putClientProperty("UAKey", "CM_UD_BVOK");
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVOK");
            this.cancel = new JButton(CmStringPool.get(24));
            this.cancel.setActionCommand("Cancel");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
            this.button[0] = this.okRetry;
            this.button[1] = this.cancel;
            n3 = 2;
        } else if ((this.flags & 0x100) != 0) {
            this.okRetry = new JButton(CmStringPool.get(40));
            this.okRetry.setActionCommand(appendCommand);
            this.okRetry.setMnemonic(CmStringPool.getMnemonic(40));
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVAPPEND");
            this.noButton = new JButton(CmStringPool.get(41));
            this.noButton.setActionCommand(replaceCommand);
            this.noButton.setMnemonic(CmStringPool.getMnemonic(41));
            this.noButton.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVREPLACE");
            this.cancel = new JButton(CmStringPool.get(24));
            this.cancel.setActionCommand("Cancel");
            this.cancel.putClientProperty("UAKey", "CM_UD_BVCANCEL");
            this.cancel.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCANCEL");
            this.button[0] = this.okRetry;
            this.button[1] = this.noButton;
            this.button[2] = this.cancel;
            n3 = 3;
        } else {
            this.okRetry = new JButton(CmStringPool.get(25));
            this.okRetry.setActionCommand("Close");
            this.okRetry.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVCLOSE");
            if (this.okRetry.getText().length() == 0) {
                this.okRetry.setText("Close");
            }
            this.button[0] = this.okRetry;
            n3 = 1;
        }
        if (this.text2ndLevel != null && !this.text2ndLevel.equals("") && !this.text2ndLevel.startsWith("SQL10007")) {
            this.help = new JButton(CmStringPool.get(26));
            this.help.setActionCommand("Help");
            this.help.putClientProperty("UAKey", "CM_UD_BVHELP");
            this.help.setName("com.ibm.db2.tools.common.CmStringPool.CM_UD_BVHELP");
            if (this.help.getText().length() == 0) {
                this.help.setText("Help");
            }
            this.button[n3] = this.help;
            ++n3;
        }
        if (this.sqlText != null && n3 < this.button.length) {
            this.showSQL = new JButton(CmStringPool.get(8));
            this.showSQL.setActionCommand("SQL");
            this.showSQL.setName("com.ibm.db2.tools.common.CmStringPool.CM_ERRORMSG_SQL_BT_NOMNEM");
            n2 = n3;
            while (n2 > 0) {
                this.button[n2] = this.button[n2 - 1];
                --n2;
            }
            this.button[0] = this.showSQL;
            ++n3;
        }
        container.setLayout(new GridLayout(1, n3, 10, 0));
        n2 = 0;
        while (n2 < n3) {
            container.add(this.button[n2]);
            this.button[n2].addActionListener(this);
            ++n2;
        }
        return container;
    }

    public void showDialog() {
        if (this.button[0] != null) {
            this.setDefaultFocusComponent(this.button[0]);
            this.getRootPane().setDefaultButton(this.button[0]);
        }
        this.setMessageCaretPosition(1);
        this.setVisible(true);
    }

    public void appendMessage(String string) {
        this.messageText.append(string);
    }

    protected void setMessageCaretPosition(int n2) {
        this.messageText.setCaretPosition(n2);
    }
}

