/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonUIManager;
import com.ibm.db2.tools.common.support.ImageUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CommonMenuBar
extends JMenuBar
implements Serializable {
    private static final String kCBIBMCopyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Image dimage;
    protected boolean isWindowsLF;
    protected boolean borderNeeded = false;
    protected URLListener urlListener = new URLListener();
    protected boolean inside = false;
    protected Color rightColor = new Color(20, 44, 120);

    public CommonMenuBar() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this.urlListener);
    }

    public void updateUI() {
        super.updateUI();
        String string = CommonUIManager.getLookAndFeel().getID();
        this.isWindowsLF = string.equals("Windows");
        this.setBorderPainted(this.borderNeeded || UIManager.getLookAndFeel().getID().equals("Motif"));
        this.dimage = null;
        this.invalidate();
    }

    void setBorderNeeded(boolean bl) {
        this.borderNeeded = bl;
        this.setBorderPainted(this.borderNeeded || UIManager.getLookAndFeel().getID().equals("Motif"));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isWindowsLF) {
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getSize();
            int n2 = dimension2.width - dimension.width - 1;
            if (n2 > 0) {
                Image image = this.makeDitherImage(n2, dimension2.height);
                graphics.drawImage(image, dimension.width, 0, null);
                Icon icon = (Icon)this.getClientProperty("BrandIcon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, dimension2.width - icon.getIconWidth(), 0);
                }
            }
        }
    }

    protected Image makeDitherImage(int n2, int n3) {
        if (this.dimage != null && this.dimage.getWidth(null) == n2 && this.dimage.getHeight(null) == n3) {
            return this.dimage;
        }
        this.dimage = ImageUtil.createGradientBanner(n2, n3, this.getBackground(), this.rightColor);
        return this.dimage;
    }

    public boolean contains(int n2, int n3) {
        if (n2 >= this.getWidth() || n3 >= this.getHeight()) {
            return false;
        }
        Icon icon = (Icon)this.getClientProperty("BrandIcon");
        String string = (String)this.getClientProperty("BrandURL");
        if (icon != null && string != null) {
            HyperlinkListener hyperlinkListener = (HyperlinkListener)this.getClientProperty("BrandListener");
            if (n2 >= this.getWidth() - icon.getIconWidth()) {
                if (!this.inside) {
                    this.setToolTipText(string);
                    this.inside = true;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    if (hyperlinkListener != null) {
                        try {
                            URL uRL = new URL(string);
                            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.ENTERED, uRL);
                            hyperlinkListener.hyperlinkUpdate(hyperlinkEvent);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (this.inside) {
                this.inside = false;
                this.setToolTipText(null);
                this.setCursor(Cursor.getDefaultCursor());
                if (hyperlinkListener != null) {
                    try {
                        URL uRL = new URL(string);
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, uRL);
                        hyperlinkListener.hyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return super.contains(n2, n3);
    }

    private class URLListener
    extends MouseAdapter
    implements Serializable {
        private URLListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            CommonMenuBar.this.inside = false;
            Icon icon = (Icon)CommonMenuBar.this.getClientProperty("BrandIcon");
            String string = (String)CommonMenuBar.this.getClientProperty("BrandURL");
            if (icon != null && string != null) {
                HyperlinkListener hyperlinkListener = (HyperlinkListener)CommonMenuBar.this.getClientProperty("BrandListener");
                CommonMenuBar.this.setToolTipText(null);
                ToolTipManager.sharedInstance().registerComponent(CommonMenuBar.this);
                CommonMenuBar.this.setCursor(Cursor.getDefaultCursor());
                if (hyperlinkListener != null) {
                    try {
                        URL uRL = new URL(string);
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(CommonMenuBar.this, HyperlinkEvent.EventType.EXITED, uRL);
                        hyperlinkListener.hyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Icon icon = (Icon)CommonMenuBar.this.getClientProperty("BrandIcon");
            String string = (String)CommonMenuBar.this.getClientProperty("BrandURL");
            HyperlinkListener hyperlinkListener = (HyperlinkListener)CommonMenuBar.this.getClientProperty("BrandListener");
            if (icon != null && string != null && hyperlinkListener != null) {
                Point point = mouseEvent.getPoint();
                if (point.x >= CommonMenuBar.this.getWidth() - icon.getIconWidth()) {
                    try {
                        URL uRL = new URL(string);
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(CommonMenuBar.this, HyperlinkEvent.EventType.ACTIVATED, uRL);
                        hyperlinkListener.hyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

