/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonAction;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CommonMenu
extends JMenu
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int FONT_HEIGHT = 12;
    private static boolean fInitialized = false;

    public CommonMenu() {
        this("Default");
    }

    public CommonMenu(String string) {
        super(string);
    }

    public CommonMenu(Action action) {
        super(action);
        if (action instanceof CommonAction) {
            Vector vector = ((CommonAction)action).getCascade();
            CommonAction commonAction = null;
            int n2 = 0;
            while (n2 < vector.size()) {
                commonAction = (CommonAction)vector.elementAt(n2);
                if (commonAction.isDivider()) {
                    this.addSeparator();
                } else {
                    this.add(commonAction);
                }
                ++n2;
            }
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        KeyStroke keyStroke;
        super.configurePropertiesFromAction(action);
        if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
            this.setAccelerator(keyStroke);
        }
        this.setIcon(null);
    }

    public void add(Action[] actionArray) {
        int n2 = 0;
        while (n2 < actionArray.length) {
            this.add(actionArray[n2]);
            ++n2;
        }
    }

    public JMenuItem add(Action action) {
        AbstractButton abstractButton = null;
        if (action instanceof CommonAction && ((CommonAction)action).isCascade()) {
            this.add(new CommonMenu(action));
        } else if (action instanceof CommonAction && ((CommonAction)action).isDivider()) {
            this.addSeparator();
        } else {
            if (action.getValue("CheckBox") == null) {
                abstractButton = new JMenuItem(new HelperAction(action));
            } else {
                abstractButton = new JCheckBoxMenuItem(new HelperAction(action));
                abstractButton.setSelected((Boolean)action.getValue("CheckBox"));
            }
            abstractButton.setHorizontalTextPosition(4);
            abstractButton.setVerticalTextPosition(0);
            ((JMenuItem)abstractButton).setEnabled(action.isEnabled());
            if (action instanceof CommonAction && null != ((CommonAction)action).getAccelerator() && 0 != ((CommonAction)action).getAccelerator().getKeyCode()) {
                ((JMenuItem)abstractButton).setAccelerator(((CommonAction)action).getAccelerator());
            }
            this.add((JMenuItem)abstractButton);
        }
        if (null != abstractButton) {
            abstractButton.setIcon(null);
        }
        return abstractButton;
    }

    public void setPopupMenuVisible(boolean bl) {
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2) {
            if (bl && this.isShowing()) {
                Point point = this.getPopupMenuOrigin();
                if (point != null) {
                    this.getPopupMenu().show(this, point.x, point.y);
                }
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        int n2 = 0;
        int n3 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jPopupMenu.getSize();
        if (dimension3.width == 0) {
            dimension3 = jPopupMenu.getPreferredSize();
            if (FONT_HEIGHT != 12) {
                float f2 = (float)(FONT_HEIGHT + 2) / 14.0f;
                dimension3.height = (int)((float)dimension3.height * f2);
                dimension3.width = (int)((float)dimension3.width * f2);
                if (!fInitialized) {
                    fInitialized = true;
                    jPopupMenu.setPreferredSize(dimension3);
                } else {
                    jPopupMenu.setPopupSize(dimension3);
                }
            }
        }
        Point point = null;
        if (!this.isShowing()) {
            return null;
        }
        point = this.getLocationOnScreen();
        Container container = this.getParent();
        if (container instanceof JPopupMenu) {
            n2 = point.x + dimension2.width + dimension3.width < dimension.width || point.x - dimension3.width < 0 ? dimension2.width : 0 - dimension3.width;
            n3 = point.y + dimension3.height < dimension.height - 20 ? 0 : dimension2.height - dimension3.height;
        } else {
            n2 = point.x + dimension3.width < dimension.width ? 0 : dimension2.width - dimension3.width;
            n3 = point.y + dimension2.height + dimension3.height < dimension.height - 20 || point.y - dimension3.height < 0 ? dimension2.height : 0 - dimension3.height;
        }
        return new Point(n2, n3);
    }

    public static void setFontHeight(int n2) {
        FONT_HEIGHT = n2;
    }

    private class RunAction
    implements Runnable {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected Action action;
        protected ActionEvent event;

        public RunAction(Action action, ActionEvent actionEvent) {
            this.action = action;
            this.event = actionEvent;
        }

        public void run() {
            this.action.actionPerformed(this.event);
        }
    }

    private class HelperAction
    extends AbstractAction
    implements PropertyChangeListener {
        private Action action;

        HelperAction(Action action) {
            this.action = action;
            this.action.addPropertyChangeListener(this);
            if (this.action instanceof AbstractAction) {
                Object[] objectArray = ((AbstractAction)this.action).getKeys();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof String) {
                        this.putValue((String)objectArray[n2], ((AbstractAction)this.action).getValue((String)objectArray[n2]));
                    }
                    ++n2;
                }
            } else {
                throw new IllegalArgumentException("The actions used with CommonMenu have to extend at least AbstractAction. It is recommended to use subclases of CommonAction. The current action is " + this.action);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new RunAction(this.action, actionEvent));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                super.setEnabled(bl);
            } else {
                Object object = this.action.getValue(string);
                if (propertyChangeEvent.getNewValue() != null && null != object || propertyChangeEvent.getNewValue() == null && null == object && propertyChangeEvent.getOldValue() != null) {
                    this.putValue(string, propertyChangeEvent.getNewValue());
                }
            }
        }
    }
}

