/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonPanel;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.CommonUtils;
import com.ibm.db2.tools.common.CommonWindowInterface;
import com.ibm.db2.tools.common.ResultProcessor;
import com.ibm.db2.tools.common.StatusLine;
import com.ibm.db2.tools.common.support.ButtonAction;
import com.ibm.db2.tools.common.uamanager.UAMCustomizerWindowAdapter;
import com.ibm.db2.tools.common.uamanager.UAManager;
import com.ibm.db2.tools.common.uamanager.UAWindowAdapter;
import com.ibm.db2.tools.common.ui.progress.BasicProgressIndicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CommonFrame
extends JFrame
implements CommonWindowInterface,
Serializable,
ActionListener,
AdjustmentListener,
ComponentListener,
ContainerListener,
FocusListener,
ItemListener,
KeyListener,
MouseListener,
MouseMotionListener,
TextListener,
ChangeListener,
WindowListener,
ListSelectionListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String helpCommand = "Help";
    private static JFrame currentActiveFrame = null;
    public static Vector instances = new Vector();
    private JComponent componentToLeaveEnabled = null;
    private ResultProcessor rp;
    private boolean autoPosition = false;
    private int helpPanelID = 0;
    private Window relativeTo;
    private BasicProgressIndicator progressIndicator = null;
    private StatusLine statusLine = new StatusLine(false);
    private boolean enable = true;
    private Hashtable disabledComponents = new Hashtable();
    private UAWindowAdapter uaManagerListener = null;
    private boolean overridesAppearanceManager = false;
    private boolean firstActivation = true;
    private boolean isComponentL = false;
    private boolean isContainerL = false;
    private boolean isFocusL = false;
    private boolean isKeyL = false;
    private boolean isMouseL = false;
    private boolean isMouseMotionL = false;
    private boolean isWindowL = false;

    public static JFrame getCurrentActiveFrame() {
        return currentActiveFrame;
    }

    public static void setCurrentActiveFrame(JFrame jFrame) {
        currentActiveFrame = jFrame;
    }

    public CommonFrame(String string, boolean bl) {
        this(string, null, null, bl);
    }

    public CommonFrame(String string, Window window, boolean bl) {
        this(string, "", "", null, window, bl);
    }

    public CommonFrame(String string, String string2, String string3, ResultProcessor resultProcessor, boolean bl) {
        this(string, resultProcessor, bl);
    }

    public CommonFrame(String string, ResultProcessor resultProcessor, boolean bl) {
        this(string, resultProcessor, null, bl);
    }

    public CommonFrame(String string, String string2, String string3, ResultProcessor resultProcessor, Window window, boolean bl) {
        this(string, resultProcessor, window, bl);
    }

    public CommonFrame(String string, ResultProcessor resultProcessor, Window window, boolean bl) {
        super(string);
        this.setDefaultCloseOperation(2);
        CommonUtils.removeFreedReferences(instances);
        instances.addElement(new WeakReference<CommonFrame>(this));
        this.setUAWindowAdapter(new UAMCustomizerWindowAdapter(this.getUAMToken()));
        this.rp = resultProcessor;
        this.addWindowListener(this);
        this.relativeTo = window;
        if (window != null && window instanceof JFrame) {
            ((Frame)this).setIconImage(((JFrame)window).getIconImage());
        } else if (window != null && window instanceof CommonDialog) {
            ((Frame)this).setIconImage(((CommonDialog)window).getParentFrame().getIconImage());
        }
        this.setAutoposition(window != null);
        this.addContainerListener(this);
        this.addKeyListener(this);
        this.getRootPane().getContentPane().setLayout(new BorderLayout());
        if (bl) {
            this.getRootPane().getContentPane().add("South", this.statusLine);
        }
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n2) {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.getInputMap(n2).put(keyStroke, string);
        jRootPane.getActionMap().put(string, new ButtonAction(string, actionListener));
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, int n2) {
        this.registerKeyboardAction(actionListener, string, KeyStroke.getKeyStroke(n2, 0, false), 2);
    }

    public void setUAWindowAdapter(UAWindowAdapter uAWindowAdapter) {
        if (this.uaManagerListener != null) {
            this.removeWindowListener(this.uaManagerListener);
        }
        this.uaManagerListener = uAWindowAdapter;
        if (this.uaManagerListener != null) {
            this.addWindowListener(this.uaManagerListener);
        }
    }

    protected String getUAMToken() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        string = string.substring(string.lastIndexOf(46) + 1);
        return string;
    }

    public void removeUAManagerListener() {
        this.removeWindowListener(this.uaManagerListener);
    }

    public void setClient(Component component) {
        this.getRootPane().getContentPane().add("Center", component);
    }

    public void showProgressIndicator(String string, boolean bl) {
        if (bl) {
            if (this.progressIndicator == null) {
                this.progressIndicator = new BasicProgressIndicator(this, string, true);
            } else {
                this.progressIndicator.setVisible(true);
            }
        } else if (this.progressIndicator != null) {
            this.progressIndicator.stop();
            this.progressIndicator = null;
        }
    }

    public void showProgressIndicator(boolean bl) {
        if (bl) {
            if (this.progressIndicator == null) {
                this.progressIndicator = new BasicProgressIndicator(this, "", true);
            } else {
                this.progressIndicator.setVisible(true);
            }
        } else if (this.progressIndicator != null) {
            this.progressIndicator.stop();
            this.progressIndicator = null;
        }
    }

    public void progressWindowStop() {
        this.progressIndicator = null;
    }

    public void setHelp(String string, String string2) {
    }

    public String getHelpName() {
        return null;
    }

    public String getHelpIndex() {
        return null;
    }

    public JFrame getFrame() {
        return this;
    }

    public JFrame getParentFrame() {
        if (this.relativeTo instanceof JFrame) {
            return (JFrame)this.relativeTo;
        }
        return this;
    }

    public Window getParentWindow() {
        return this.relativeTo;
    }

    public synchronized ResultProcessor getResultProcessor() {
        return this.rp;
    }

    public synchronized void setVisible(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonFrame", this, "setVisible(boolean v)", new Object[]{new Boolean(bl)});
        }
        if (bl) {
            if (this.autoPosition) {
                CommonTrace.write(commonTrace, "autoPosition TRUE");
                CommonDialog.moveRelative(this, this.relativeTo);
                this.autoPosition = false;
            } else {
                CommonTrace.write(commonTrace, "autoPosition FALSE");
            }
        }
        if (bl && !this.isOverridesAppearanceManager()) {
            AppearanceManager.updateFont(this);
        }
        super.setVisible(bl);
        CommonTrace.exit(commonTrace);
    }

    public synchronized void commandLineSetVisible(boolean bl) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonFrame", this, "commandLineSetVisible(boolean v)", new Object[]{new Boolean(bl)});
        }
        if (bl) {
            if (this.autoPosition) {
                CommonTrace.write(commonTrace, "autoPosition TRUE");
                CommonDialog.moveRelative(this, this.relativeTo);
                this.autoPosition = false;
            } else {
                CommonTrace.write(commonTrace, "autoPosition FALSE");
            }
        }
        if (bl) {
            AppearanceManager.commandLineUpdateFont(this);
            this.validate();
        }
        super.setVisible(bl);
        CommonTrace.exit(commonTrace);
    }

    public void setAutoposition(boolean bl) {
        this.autoPosition = bl;
    }

    public void setHelpPanelID(int n2) {
        this.helpPanelID = n2;
    }

    public int getHelpPanelID() {
        return this.helpPanelID;
    }

    public void showHelp() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, helpCommand);
        UAManager uAManager = new UAManager(true, actionEvent);
    }

    public JPanel getPanel() {
        return new CommonPanel("", "");
    }

    public boolean processEnterKey() {
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && string.equals(helpCommand)) {
            UAManager uAManager = new UAManager(true, actionEvent);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentAdded(ContainerEvent containerEvent) {
    }

    public void componentRemoved(ContainerEvent containerEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        CommonFrame.setCurrentActiveFrame(this);
        if (this.firstActivation) {
            this.firstActivation = false;
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        if (componentListener == this && !this.isComponentL) {
            this.isComponentL = true;
            super.addComponentListener(componentListener);
        }
        if (componentListener != this) {
            super.addComponentListener(componentListener);
        }
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == this && !this.isContainerL) {
            this.isContainerL = true;
            super.addContainerListener(containerListener);
        }
        if (containerListener != this) {
            super.addContainerListener(containerListener);
        }
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (focusListener == this && !this.isFocusL) {
            this.isFocusL = true;
            super.addFocusListener(focusListener);
        }
        if (focusListener != this) {
            super.addFocusListener(focusListener);
        }
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (keyListener == this && !this.isKeyL) {
            this.isKeyL = true;
            super.addKeyListener(keyListener);
        }
        if (keyListener != this) {
            super.addKeyListener(keyListener);
        }
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == this && !this.isMouseL) {
            this.isMouseL = true;
            super.addMouseListener(mouseListener);
        }
        if (mouseListener != this) {
            super.addMouseListener(mouseListener);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == this && !this.isMouseMotionL) {
            this.isMouseMotionL = true;
            super.addMouseMotionListener(mouseMotionListener);
        }
        if (mouseMotionListener != this) {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        if (windowListener == this && !this.isWindowL) {
            this.isWindowL = true;
            super.addWindowListener(windowListener);
        }
        if (windowListener != this) {
            super.addWindowListener(windowListener);
        }
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == this) {
            this.isContainerL = false;
        }
        super.removeContainerListener(containerListener);
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        if (componentListener == this) {
            this.isComponentL = false;
        }
        super.removeComponentListener(componentListener);
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (focusListener == this) {
            this.isFocusL = false;
        }
        super.removeFocusListener(focusListener);
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (keyListener == this) {
            this.isKeyL = false;
        }
        super.removeKeyListener(keyListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == this) {
            this.isMouseL = false;
        }
        super.removeMouseListener(mouseListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == this) {
            this.isMouseMotionL = false;
        }
        super.removeMouseMotionListener(mouseMotionListener);
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        if (windowListener == this) {
            this.isWindowL = false;
        }
        super.removeWindowListener(windowListener);
    }

    public void showStatusInfo(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonFrame", this, "showStatusInfo(String text)", new Object[]{string});
        }
        this.statusLine.setStatus(string);
        CommonTrace.exit(commonTrace);
    }

    public void clearStatusInfo() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonFrame", this, "clearStatusInfo()");
        }
        this.statusLine.clear();
        CommonTrace.exit(commonTrace);
    }

    public void setComponentToLeaveEnabled(JComponent jComponent) {
        this.componentToLeaveEnabled = jComponent;
    }

    public void setEnabled(boolean bl) {
        CommonFrame commonFrame = this;
        synchronized (commonFrame) {
            this.enable = bl;
            if (bl) {
                this.enableAllComponents();
            } else {
                this.disableAllComponents();
            }
        }
    }

    public boolean areAllComponentsEnabled() {
        return this.enable;
    }

    protected void disableAllComponents() {
        if (this.componentToLeaveEnabled != null) {
            this.componentToLeaveEnabled.grabFocus();
        }
        this.disabledComponents = new Hashtable();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            this.disableComponent(componentArray[n2]);
            ++n2;
        }
    }

    private void disableComponent(Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                this.disableComponent(componentArray[n2]);
                ++n2;
            }
        }
        if (component.isEnabled() && component != this.componentToLeaveEnabled) {
            component.setEnabled(false);
        } else {
            this.disabledComponents.put(component, "");
        }
    }

    protected void enableAllComponents() {
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            this.enableComponent(componentArray[n2]);
            ++n2;
        }
    }

    protected void enableComponent(Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                this.enableComponent(componentArray[n2]);
                ++n2;
            }
        }
        if (!this.disabledComponents.containsKey(component)) {
            component.setEnabled(true);
        }
    }

    protected boolean isOverridesAppearanceManager() {
        return this.overridesAppearanceManager;
    }

    protected void setOverridesAppearanceManager(boolean bl) {
        this.overridesAppearanceManager = bl;
    }
}

