/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistManager;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CommonDateFormat {
    public static String formatDateForScheduling(Calendar calendar) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateForScheduling(java.util.Calendar date)", new Object[]{calendar});
        }
        String string = Integer.toString(calendar.get(1));
        String string2 = Integer.toString(calendar.get(2) + 1);
        String string3 = Integer.toString(calendar.get(5));
        if (calendar.get(2) + 1 < 10) {
            string2 = "0" + string2;
        }
        if (calendar.get(5) < 10) {
            string3 = "0" + string3;
        }
        String string4 = string + string2 + string3;
        return (String)CommonTrace.exit(commonTrace, string4);
    }

    public static SimpleDateFormat getTimeFormat() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "getTimeFormat()");
        }
        return (SimpleDateFormat)CommonTrace.exit(commonTrace, CommonDateFormat.getTimeFormat(AssistManager.getPreferredLocale()));
    }

    private static SimpleDateFormat getTimeFormat(Locale locale) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "getTimeFormat(Locale locale)", new Object[]{locale});
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(2, locale);
        return (SimpleDateFormat)CommonTrace.exit(commonTrace, simpleDateFormat);
    }

    public static SimpleDateFormat getDateFormat() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "getDateFormat()");
        }
        return (SimpleDateFormat)CommonTrace.exit(commonTrace, CommonDateFormat.getDateFormat(AssistManager.getPreferredLocale()));
    }

    private static SimpleDateFormat getDateFormat(Locale locale) {
        int n2;
        SimpleDateFormat simpleDateFormat;
        String string;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "getDateFormat(Locale locale)", new Object[]{locale});
        }
        if ((string = (simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern()).indexOf("y") == -1) {
            simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
            string = simpleDateFormat.toPattern();
        }
        if (string.indexOf("yyyy") == -1 && (n2 = string.indexOf("y")) > -1) {
            string = string.indexOf("yy") == -1 ? string.substring(0, n2) + "yyy" + string.substring(n2) : string.substring(0, n2) + "yy" + string.substring(n2);
        }
        if (string.indexOf("MM") == -1 && (n2 = string.indexOf("M")) > -1) {
            string = string.substring(0, n2) + "M" + string.substring(n2);
        }
        if (string.indexOf("dd") == -1 && (n2 = string.indexOf("d")) > -1) {
            string = string.substring(0, n2) + "d" + string.substring(n2);
        }
        simpleDateFormat.applyPattern(string);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        simpleDateFormat.setLenient(false);
        return (SimpleDateFormat)CommonTrace.exit(commonTrace, simpleDateFormat);
    }

    public static SimpleDateFormat getDateTimeFormat() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "getDateTimeFormat()");
        }
        return (SimpleDateFormat)CommonTrace.exit(commonTrace, CommonDateFormat.getDateTimeFormat(AssistManager.getPreferredLocale()));
    }

    private static SimpleDateFormat getDateTimeFormat(Locale locale) {
        int n2;
        SimpleDateFormat simpleDateFormat;
        String string;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "getDateTimeFormat(Locale locale)", new Object[]{locale});
        }
        if ((string = (simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale)).toPattern()).indexOf("y") == -1) {
            simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, locale);
            string = simpleDateFormat.toPattern();
        }
        if (string.indexOf("yyyy") == -1 && (n2 = string.indexOf("y")) > -1) {
            string = string.substring(0, n2) + "yy" + string.substring(n2);
        }
        if (string.indexOf("MM") == -1 && (n2 = string.indexOf("M")) > -1) {
            string = string.substring(0, n2) + "M" + string.substring(n2);
        }
        if (string.indexOf("dd") == -1 && (n2 = string.indexOf("d")) > -1) {
            string = string.substring(0, n2) + "d" + string.substring(n2);
        }
        simpleDateFormat.applyPattern(string);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return (SimpleDateFormat)CommonTrace.exit(commonTrace, simpleDateFormat);
    }

    public static String formatDateForDisplay(Calendar calendar) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateForDisplay(java.util.Calendar date)", new Object[]{calendar});
        }
        return (String)CommonTrace.exit(commonTrace, CommonDateFormat.getDateFormat().format(calendar.getTime()));
    }

    public static String formatDateForDisplay(Timestamp timestamp) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateForDisplay(Timestamp t)", new Object[]{timestamp});
        }
        Calendar calendar = AssistManager.getCalendar();
        calendar.setTime(timestamp);
        return (String)CommonTrace.exit(commonTrace, CommonDateFormat.formatDateForDisplay(calendar));
    }

    public static String formatDateForDisplay(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateForDisplay(String date)", new Object[]{string});
        }
        String string2 = "YYYYMMDD";
        String string3 = "??/??/????";
        try {
            if (string != null && string.length() == string2.length()) {
                String string4 = string.substring(0, 4);
                String string5 = string.substring(4, 6);
                String string6 = string.substring(6);
                Calendar calendar = AssistManager.getCalendar();
                calendar.set(1, Integer.parseInt(string4));
                calendar.set(2, Integer.parseInt(string5) - 1);
                calendar.set(5, Integer.parseInt(string6));
                string3 = CommonDateFormat.formatDateForDisplay(calendar);
            }
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            string3 = "??/??/????";
        }
        return (String)CommonTrace.exit(commonTrace, string3);
    }

    public static String formatTimeForDisplay(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatTimeForDisplay(String time)", new Object[]{string});
        }
        String string2 = "24MMSS";
        String string3 = "??:??:??AP";
        try {
            if (string != null && string.length() == string2.length()) {
                int n2 = Integer.parseInt(string.substring(0, 2));
                int n3 = Integer.parseInt(string.substring(2, 4));
                int n4 = Integer.parseInt(string.substring(4));
                long l2 = ((n2 * 60 + n3) * 60 + n4) * 1000;
                Date date = new Date(l2);
                DateFormat dateFormat = DateFormat.getTimeInstance(2, AssistManager.getPreferredLocale());
                TimeZone timeZone = TimeZone.getTimeZone("GMT");
                dateFormat.setTimeZone(timeZone);
                string3 = dateFormat.format(date);
            }
        }
        catch (Exception exception) {
            CommonTrace.catchBlock(commonTrace);
            string3 = "??:??:??AP";
        }
        return (String)CommonTrace.exit(commonTrace, string3);
    }

    public static String formatTimeForDisplay(Calendar calendar) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatTimeForDisplay(java.util.Calendar date)", new Object[]{calendar});
        }
        DateFormat dateFormat = DateFormat.getTimeInstance(2, AssistManager.getPreferredLocale());
        dateFormat.setTimeZone(TimeZone.getDefault());
        return (String)CommonTrace.exit(commonTrace, dateFormat.format(calendar.getTime()));
    }

    public static String formatTimeForDisplay(Timestamp timestamp) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatTimeForDisplay(Timestamp t)", new Object[]{timestamp});
        }
        Calendar calendar = AssistManager.getCalendar();
        calendar.setTime(timestamp);
        return (String)CommonTrace.exit(commonTrace, CommonDateFormat.formatTimeForDisplay(calendar));
    }

    public static String formatDateTimeForDisplay(Timestamp timestamp) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateTimeForDisplay(Timestamp t)", new Object[]{timestamp});
        }
        Calendar calendar = AssistManager.getCalendar();
        calendar.setTime(timestamp);
        return (String)CommonTrace.exit(commonTrace, CommonDateFormat.formatDateTimeForDisplay(calendar));
    }

    public static String formatDateTimeForDisplay(Calendar calendar) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateTimeForDisplay(java.util.Calendar date)", new Object[]{calendar});
        }
        SimpleDateFormat simpleDateFormat = CommonDateFormat.getDateTimeFormat();
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return (String)CommonTrace.exit(commonTrace, simpleDateFormat.format(calendar.getTime()));
    }

    public static String formatDateTimeForDisplay(Date date) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonDateFormat", "formatDateTimeForDisplay(java.util.Date date)", new Object[]{date});
        }
        return (String)CommonTrace.exit(commonTrace, CommonDateFormat.getDateTimeFormat().format(date));
    }
}

