/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AppearanceManager;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.CommonDialog;
import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.CommonView;
import com.ibm.db2.tools.common.ConfirmationViewObject;
import com.ibm.db2.tools.common.MultiLineLabel;
import com.ibm.db2.tools.common.support.ViewObjectColumnSettings;
import com.ibm.db2.tools.common.support.ViewObjectInterface;
import com.ibm.db2.tools.common.support.ViewTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CommonConfirmationDialog
extends CommonDialog
implements ActionListener,
PropertyChangeListener {
    private JLabel instructionLabel;
    private MultiLineLabel instructionMultiLineLabel;
    protected CommonView container;
    protected ViewTableModel dataModel;
    protected Vector confirmList;
    protected Vector candidateList;
    protected String columnTitle;
    protected String[] columnNames = null;
    protected ViewObjectColumnSettings[] columnSettings = null;
    protected boolean initialCheckBoxState = true;

    public CommonConfirmationDialog(JFrame jFrame, String string, Vector vector, boolean bl, boolean bl2) {
        this(jFrame, string, vector, bl, bl2, null, null, CmStringPool.get(196), true);
    }

    public CommonConfirmationDialog(CommonDialog commonDialog, String string, Vector vector, boolean bl, boolean bl2) {
        this(commonDialog, string, vector, bl, bl2, null, null, CmStringPool.get(196), true);
    }

    public CommonConfirmationDialog(JFrame jFrame, String string, Vector vector, boolean bl) {
        this(jFrame, string, vector, bl, true, null, null, CmStringPool.get(196), true);
    }

    public CommonConfirmationDialog(CommonDialog commonDialog, String string, Vector vector, boolean bl) {
        this(commonDialog, string, vector, bl, true, null, null, CmStringPool.get(196), true);
    }

    public CommonConfirmationDialog(JFrame jFrame, String string, Vector vector, boolean bl, boolean bl2, String[] stringArray, ViewObjectColumnSettings[] viewObjectColumnSettingsArray, String string2, boolean bl3) {
        super(jFrame, string2, bl2, 14L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "CommonConfirmationDialog(JFrame parent, String colTitle, Vector viewObjects, boolean setVisibleImmediately, boolean modality, String[] columnNames, ViewObjectColumnSettings[] columnSettings, String title, boolean initialCheckBoxState)", new Object[]{jFrame, string, vector, new Boolean(bl), new Boolean(bl2), stringArray, viewObjectColumnSettingsArray, string2, new Boolean(bl3)});
        }
        this.initialCheckBoxState = bl3;
        this.columnNames = stringArray;
        this.columnSettings = viewObjectColumnSettingsArray;
        this.columnTitle = string;
        this.candidateList = this.buildConfirmableRows(vector);
        this.makeLayout();
        ((Component)this).addPropertyChangeListener("UAKey", this);
        if (bl) {
            this.setVisible(true);
        }
        CommonTrace.exit(commonTrace);
    }

    public CommonConfirmationDialog(CommonDialog commonDialog, String string, Vector vector, boolean bl, boolean bl2, String[] stringArray, ViewObjectColumnSettings[] viewObjectColumnSettingsArray, String string2, boolean bl3) {
        super(commonDialog, string2, bl2, 14L);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "CommonConfirmationDialog(CommonDialog parent, String colTitle, Vector viewObjects, boolean setVisibleImmediately, boolean modality, String[] columnNames, ViewObjectColumnSettings[] columnSettings, String title, boolean initialCheckBoxState)", new Object[]{commonDialog, string, vector, new Boolean(bl), new Boolean(bl2), stringArray, viewObjectColumnSettingsArray, string2, new Boolean(bl3)});
        }
        this.initialCheckBoxState = bl3;
        this.columnNames = stringArray;
        this.columnSettings = viewObjectColumnSettingsArray;
        this.columnTitle = string;
        this.candidateList = this.buildConfirmableRows(vector);
        this.makeLayout();
        ((Component)this).addPropertyChangeListener("UAKey", this);
        if (bl) {
            this.setVisible(true);
        }
        CommonTrace.exit(commonTrace);
    }

    public void setColumnTitle(String string) {
        this.columnTitle = string;
    }

    private void makeLayout() {
        JPanel jPanel = new JPanel();
        this.makeMainPanel(jPanel);
        this.setClient(jPanel);
        this.addButtonsActionListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }

    private void makeMainPanel(JPanel jPanel) {
        JPanel jPanel2 = this.getPanel();
        JPanel jPanel3 = this.getPanel();
        this.makeNorthPanel(jPanel2);
        this.makeCenterPanel(jPanel3);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = this.makeSouthPane(this.getPanel());
        if (jPanel4 != null) {
            jPanel.add((Component)jPanel4, "South");
        }
    }

    private void makeNorthPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 5, 5));
        this.instructionMultiLineLabel = this.makeInstructionMultiLineLabel();
        if (this.instructionMultiLineLabel == null) {
            this.instructionLabel = this.makeInstructionLabel();
            jPanel.add((Component)this.instructionLabel, "West");
        } else {
            jPanel.add((Component)this.instructionMultiLineLabel, "South");
        }
    }

    private void makeCenterPanel(JPanel jPanel) {
        JPanel jPanel2 = this.getPanel();
        this.makeContainerPanel(jPanel2);
        JPanel jPanel3 = this.makeButtonPanel(this.getPanel());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        if (jPanel3 != null) {
            jPanel.add((Component)jPanel3, "East");
        }
    }

    private void makeContainerPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.container = new CommonView(this.parentFrame);
        this.container.getTable().setRowHeight(Math.max(AppearanceManager.getTextFontHeight(), 20));
        this.dataModel = new ViewTableModel(this.candidateList, (ViewObjectInterface)this.candidateList.elementAt(0), null);
        this.container.getTable().setModel(this.dataModel);
        this.container.getTable().setSelectionMode(0);
        this.container.getTable().getTableHeader().setReorderingAllowed(false);
        if (null != this.instructionMultiLineLabel) {
            this.instructionMultiLineLabel.setLabelFor(this.container.getTable());
        } else if (null != this.instructionLabel) {
            this.instructionLabel.setLabelFor(this.container.getTable());
        }
        jPanel.add((Component)this.container, "Center");
        this.container.setPreferredSize(new Dimension(300, 12 * this.container.getTable().getRowHeight()));
        if (this.candidateList.size() > 0) {
            this.container.getTable().setRowSelectionInterval(0, 0);
        }
    }

    protected JPanel makeButtonPanel(JPanel jPanel) {
        return null;
    }

    protected JLabel makeInstructionLabel() {
        return new JLabel(CmStringPool.get(197));
    }

    protected MultiLineLabel makeInstructionMultiLineLabel() {
        return null;
    }

    protected Vector buildConfirmableRows(Vector vector) {
        Vector<ConfirmationViewObject> vector2 = new Vector<ConfirmationViewObject>(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            ViewObjectInterface viewObjectInterface = (ViewObjectInterface)vector.elementAt(n2);
            vector2.addElement(new ConfirmationViewObject(viewObjectInterface, this.columnTitle, this.columnNames, this.columnSettings, this.initialCheckBoxState));
            ++n2;
        }
        return vector2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "actionPerformed(ActionEvent e)", new Object[]{actionEvent});
        }
        this.lastActionCommand = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (this.lastActionCommand == "OK") {
            this.okAction();
            this.setVisible(false);
        } else if (this.lastActionCommand == "Cancel") {
            this.cancelAction();
            this.setVisible(false);
        } else {
            super.actionPerformed(actionEvent);
        }
        CommonTrace.exit(commonTrace);
    }

    protected void cancelAction() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "cancelAction()");
        }
        this.confirmList = new Vector();
        CommonTrace.exit(commonTrace);
    }

    protected void okAction() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "okAction()");
        }
        this.confirmList = this.getCheckedVector();
        CommonTrace.exit(commonTrace);
    }

    public Vector getCheckedVector() {
        Vector<ViewObjectInterface> vector = new Vector<ViewObjectInterface>();
        int n2 = 0;
        while (n2 < this.candidateList.size()) {
            if (((Boolean)((ConfirmationViewObject)this.candidateList.elementAt(n2)).getData(0, null)).booleanValue()) {
                vector.addElement(((ConfirmationViewObject)this.candidateList.elementAt(n2)).getViewObject());
            }
            ++n2;
        }
        return vector;
    }

    public Vector confirm() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "confirm()");
        }
        return (Vector)CommonTrace.exit(commonTrace, this.confirmList);
    }

    public void shutdown() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.setVisible(false);
        this.dispose();
    }

    protected JPanel makeSouthPane(JPanel jPanel) {
        return null;
    }

    public ViewTableModel getModel() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CommonConfirmationDialog", this, "getModel()");
        }
        return (ViewTableModel)CommonTrace.exit(commonTrace, this.dataModel);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals("UAKey")) {
            Object object = propertyChangeEvent.getNewValue();
            this.container.putClientProperty("UAKey", object + "_container");
        }
    }
}

