/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CommonAction
extends AbstractAction
implements ActionListener {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ACCELERATOR = "AcceleratorKey";
    public static final String CASCADE = "Cascade";
    public static final String CHECKBOX = "CheckBox";
    public static final String MNEMONIC = "MnemonicKey";
    public static final String OWNER_WINDOW = "OwnerWindow";
    public static final String UAKEY = "UAKey";

    public CommonAction() {
    }

    public CommonAction(String string) {
        super(string);
    }

    public CommonAction(String string, Icon icon) {
        super(string, icon);
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CommonAction commonAction = (CommonAction)object;
        if (this.isEnabled() != commonAction.isEnabled() || this.isCascade() != commonAction.isCascade() || this.isDefault() != commonAction.isDefault() || this.isDivider() != commonAction.isDivider() || this.getMnemonic() != commonAction.getMnemonic()) {
            return false;
        }
        if (this.isCascade() && !Arrays.equals(this.getCascade().toArray(), commonAction.getCascade().toArray())) {
            return false;
        }
        KeyStroke keyStroke = this.getAccelerator();
        KeyStroke keyStroke2 = commonAction.getAccelerator();
        if (null == keyStroke ? null != keyStroke2 : !keyStroke.equals(keyStroke2)) {
            return false;
        }
        String string = this.getName();
        String string2 = commonAction.getName();
        if (null == string ? null != string2 : !string.equals(string2)) {
            return false;
        }
        Window window = this.getOwnerWindow();
        Window window2 = commonAction.getOwnerWindow();
        if (null == window ? null != window2 : !window.equals(window2)) {
            return false;
        }
        Icon icon = this.getSmallIcon();
        Icon icon2 = commonAction.getSmallIcon();
        if (null == icon ? null != icon2 : !icon.equals(icon2)) {
            return false;
        }
        String string3 = this.getToolTipText();
        String string4 = commonAction.getToolTipText();
        if (null == string3 ? null != string4 : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getUAKey();
        String string6 = commonAction.getUAKey();
        return !(null == string5 ? null != string6 : !string5.equals(string6));
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void add(CommonAction commonAction) {
        Vector<CommonAction> vector = this.getCascade();
        if (null == vector) {
            vector = new Vector<CommonAction>();
        }
        vector.addElement(commonAction);
        this.putValue(CASCADE, vector);
    }

    public KeyStroke getAccelerator() {
        KeyStroke keyStroke = null;
        Object object = this.getValue(ACCELERATOR);
        if (object != null) {
            keyStroke = (KeyStroke)object;
        }
        return keyStroke;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        if (null == keyStroke || null != keyStroke && 0 != keyStroke.getKeyCode()) {
            this.putValue(ACCELERATOR, keyStroke);
        }
    }

    public Vector getCascade() {
        return (Vector)this.getValue(CASCADE);
    }

    public boolean isCascade() {
        return null != this.getValue(CASCADE);
    }

    public boolean isCheckBox() {
        boolean bl = false;
        Object object = this.getValue(CHECKBOX);
        if (object != null) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public void setCheckBox(boolean bl) {
        this.putValue(CHECKBOX, new Boolean(bl));
    }

    public boolean isDefault() {
        boolean bl = false;
        Object object = this.getValue("Default");
        if (object != null) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public void setDefault(boolean bl) {
        this.putValue("Default", new Boolean(bl));
    }

    public boolean isDivider() {
        return null == this.getName() && null == this.getValue("SmallIcon");
    }

    public int getMnemonic() {
        int n2 = 0;
        Object object = this.getValue(MNEMONIC);
        if (object != null) {
            n2 = (Integer)object;
        }
        return n2;
    }

    public void setMnemonic(int n2) {
        this.putValue(MNEMONIC, new Integer(n2));
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setName(String string) {
        this.putValue("Name", string);
    }

    public Window getOwnerWindow() {
        return (Window)this.getValue(OWNER_WINDOW);
    }

    public void setOwnerWindow(Window window) {
        this.putValue(OWNER_WINDOW, window);
        if (this.isCascade()) {
            Vector vector = this.getCascade();
            int n2 = 0;
            while (n2 < vector.size()) {
                ((CommonAction)vector.elementAt(n2)).setOwnerWindow(window);
                ++n2;
            }
        }
    }

    public Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public String getToolTipText() {
        return (String)this.getValue("ShortDescription");
    }

    public void setToolTipText(String string) {
        this.putValue("ShortDescription", string);
    }

    public String getUAKey() {
        return (String)this.getValue(UAKEY);
    }

    public void setUAKey(String string) {
        this.putValue(UAKEY, string);
    }
}

