/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CalendarSheet
extends JPanel
implements Serializable,
ActionListener,
FocusListener,
KeyListener {
    public static final int No_Names = 0;
    public static final int Short_Names = 1;
    public static final int Long_Names = 2;
    public static final String Current_Date_Has_Changed = "Date changed";
    public static final String DATE_COMMITTED = "Date committed";
    public static final String DATE_ROLLEDBACK = "Date rolled back";
    protected Locale calendarLocale = AssistManager.getPreferredLocale();
    protected int startOfWeekOffset = Calendar.getInstance(TimeZone.getDefault(), this.calendarLocale).getFirstDayOfWeek() - 1;
    protected GregorianCalendar current;
    protected GregorianCalendar today;
    protected JLabel todayInText;
    protected JPanel dayColumnTitles;
    protected JLabel[] titles;
    protected JButton previousMonth;
    protected JButton nextMonth;
    protected JButton[] buttonSet;
    protected int titleStyle;
    protected ActionListener actionListener;
    private DateFormat formatter = DateFormat.getDateInstance(1, this.calendarLocale);
    private final String[] weekdays = new DateFormatSymbols(this.calendarLocale).getWeekdays();
    private final String[] shortWeekdays = new DateFormatSymbols(this.calendarLocale).getShortWeekdays();
    private final String NEXT_MONTH = "Next month";
    private final String PREV_MONTH = "Prev month";
    private JButton focusButton = null;

    public CalendarSheet() {
        this(2);
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "CalendarSheet()");
        }
        CommonTrace.exit(commonTrace);
    }

    public CalendarSheet(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "CalendarSheet(int newStyle)", new Object[]{new Integer(n2)});
        }
        this.formatter.setTimeZone(TimeZone.getDefault());
        this.today = new GregorianCalendar(this.calendarLocale);
        this.current = new GregorianCalendar(this.calendarLocale);
        Date date = new Date();
        this.today.setTime(date);
        this.current.setTime(date);
        this.makeComponents();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.nextMonth, "East");
        jPanel.add((Component)this.previousMonth, "West");
        jPanel.add((Component)this.todayInText, "Center");
        jPanel.add((Component)this.dayColumnTitles, "South");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(6, 7));
        int n3 = 0;
        while (n3 < this.buttonSet.length) {
            jPanel2.add(this.buttonSet[n3]);
            ++n3;
        }
        this.add((Component)jPanel2, "Center");
        this.setTitleStyle(n2);
        this.showButtons();
        CommonTrace.exit(commonTrace);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component component;
                Window window = SwingUtilities.getWindowAncestor(CalendarSheet.this);
                if (null != window && null != (component = window.getFocusOwner()) && !CalendarSheet.this.isAncestorOf(component)) {
                    CalendarSheet.this.processActionEvent(new ActionEvent(this, 1001, CalendarSheet.DATE_ROLLEDBACK));
                }
            }
        });
    }

    private void makeComponents() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "makeComponents()");
        }
        Insets insets = new Insets(4, 4, 4, 4);
        this.nextMonth = new JButton(" >> ");
        this.previousMonth = new JButton(" << ");
        this.nextMonth.setActionCommand("Next month");
        this.previousMonth.setActionCommand("Prev month");
        this.nextMonth.addActionListener(this);
        this.previousMonth.addActionListener(this);
        this.nextMonth.addFocusListener(this);
        this.previousMonth.addFocusListener(this);
        this.nextMonth.setMargin(insets);
        this.previousMonth.setMargin(insets);
        this.todayInText = new JLabel("", 0);
        this.dayColumnTitles = new JPanel();
        this.dayColumnTitles.setLayout(new GridLayout(1, 7));
        this.titles = new JLabel[7];
        int n2 = 0;
        while (n2 < 7) {
            this.titles[n2] = new JLabel("", 0);
            this.dayColumnTitles.add(this.titles[n2]);
            ++n2;
        }
        this.buttonSet = new JButton[42];
        int n3 = 0;
        while (n3 < this.buttonSet.length) {
            this.buttonSet[n3] = new JButton("");
            this.buttonSet[n3].setMargin(insets);
            this.buttonSet[n3].setActionCommand(n3 + "");
            this.buttonSet[n3].addActionListener(this);
            this.buttonSet[n3].addFocusListener(this);
            this.buttonSet[n3].addKeyListener(this);
            ++n3;
        }
        CommonTrace.exit(commonTrace);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "keyPressed(KeyEvent e)", new Object[]{keyEvent});
        }
        if (keyEvent.getKeyCode() == 37) {
            this.current.add(5, -1);
            this.showButtons();
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
        } else if (keyEvent.getKeyCode() == 39) {
            this.current.add(5, 1);
            this.showButtons();
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
        } else if (keyEvent.getKeyCode() == 38) {
            this.current.add(5, -7);
            this.showButtons();
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
        } else if (keyEvent.getKeyCode() == 40) {
            this.current.add(5, 7);
            this.showButtons();
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
        } else if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.processActionEvent(new ActionEvent(this, 1001, DATE_COMMITTED));
        } else if (keyEvent.getKeyCode() == 27) {
            keyEvent.consume();
            this.processActionEvent(new ActionEvent(this, 1001, DATE_ROLLEDBACK));
        }
        CommonTrace.exit(commonTrace);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private int getColumn(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "getColumn(int buttonNumber)", new Object[]{new Integer(n2)});
        }
        return CommonTrace.exit(commonTrace, (n2 + 1) % 7 - 1);
    }

    private boolean selectButton(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "selectButton(int index)", new Object[]{new Integer(n2)});
        }
        if (n2 < 0 || n2 > 41) {
            return CommonTrace.exit(commonTrace, false);
        }
        if (this.buttonSet[n2].isVisible()) {
            this.buttonSet[n2].requestFocus();
            return CommonTrace.exit(commonTrace, true);
        }
        return CommonTrace.exit(commonTrace, false);
    }

    private void selectLastButton(int n2) {
        int n3;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "selectLastButton(int column)", new Object[]{new Integer(n2)});
        }
        int n4 = n2 >= 0 ? 7 : 1;
        int n5 = n3 = n2 >= 0 ? 35 + n2 : 41;
        while (n5 >= 0) {
            if (this.buttonSet[n5].isVisible()) {
                this.buttonSet[n5].requestFocus();
                break;
            }
            n5 -= n4;
        }
        CommonTrace.exit(commonTrace);
    }

    private void selectFirstButton(int n2) {
        int n3;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "selectFirstButton(int column)", new Object[]{new Integer(n2)});
        }
        int n4 = n2 >= 0 ? 7 : 1;
        int n5 = n3 = n2 >= 0 ? n2 : 0;
        while (n5 < 42) {
            if (this.buttonSet[n5].isVisible()) {
                this.buttonSet[n5].requestFocus();
                break;
            }
            n5 += n4;
        }
        CommonTrace.exit(commonTrace);
    }

    public void setTitleStyle(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "setTitleStyle(int newStyle)", new Object[]{new Integer(n2)});
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("Invalid title style specification."));
        }
        this.titleStyle = n2;
        if (this.titleStyle == 0) {
            this.dayColumnTitles.setVisible(false);
            this.doLayout();
        } else {
            int n3 = 0;
            while (n3 < 7) {
                this.titles[n3].setText(this.getWeekdayName(n3, this.titleStyle));
                ++n3;
            }
        }
        if (!this.dayColumnTitles.isVisible()) {
            this.dayColumnTitles.setVisible(true);
            this.doLayout();
        }
        CommonTrace.exit(commonTrace);
    }

    public int getTitleStyle() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "getTitleStyle()");
        }
        return CommonTrace.exit(commonTrace, this.titleStyle);
    }

    public void setDate(Calendar calendar) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "setDate(Calendar calendar)", new Object[]{calendar});
        }
        if (calendar == null) {
            throw (IllegalArgumentException)CommonTrace.throwException(commonTrace, new IllegalArgumentException("Null date is not allowed."));
        }
        this.current.setTime(calendar.getTime());
        this.showButtons();
        CommonTrace.exit(commonTrace);
    }

    public Calendar getDate() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "getDate()");
        }
        return (Calendar)CommonTrace.exit(commonTrace, this.current);
    }

    protected void showButtons() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "showButtons()");
        }
        this.todayInText.setText(this.formatter.format(this.current.getTime()));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(this.current.get(1), this.current.get(2), 1);
        int n2 = 0;
        int n3 = this.current.get(5) - 1;
        int n4 = this.getDaysInMonth(this.current);
        int n5 = gregorianCalendar.get(7) - this.startOfWeekOffset;
        if (n5 <= 0) {
            n5 += 7;
        }
        n2 = 0;
        while (n2 < n5 - 1) {
            this.buttonSet[n2].setVisible(false);
            this.buttonSet[n2].setText("");
            ++n2;
        }
        int n6 = 0;
        while (n6 < n4) {
            this.buttonSet[n2].setText("" + (n6 + 1));
            this.buttonSet[n2].setName("CalendarSheetButton" + (n6 + 1));
            if (!this.buttonSet[n2].isVisible()) {
                this.buttonSet[n2].setVisible(true);
            }
            if (n6 == n3) {
                this.buttonSet[n2].requestFocus();
                this.focusButton = this.buttonSet[n2];
            }
            ++n2;
            ++n6;
        }
        while (n2 < this.buttonSet.length) {
            this.buttonSet[n2].setVisible(false);
            ++n2;
        }
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "actionPerformed(ActionEvent event)", new Object[]{actionEvent});
        }
        if ((jButton = (JButton)actionEvent.getSource()).getActionCommand() == "Next month") {
            this.current.add(2, 1);
            this.showButtons();
            this.todayInText.setText(this.formatter.format(this.current.getTime()));
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
        } else if (jButton.getActionCommand() == "Prev month") {
            this.current.add(2, -1);
            this.showButtons();
            this.todayInText.setText(this.formatter.format(this.current.getTime()));
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
        } else {
            this.current.set(5, Integer.parseInt(jButton.getText()));
            this.todayInText.setText(this.formatter.format(this.current.getTime()));
            this.showButtons();
            this.processActionEvent(new ActionEvent(this, 1001, Current_Date_Has_Changed));
            this.processActionEvent(new ActionEvent(this, 1001, DATE_COMMITTED));
        }
        CommonTrace.exit(commonTrace);
    }

    public void addActionListener(ActionListener actionListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "addActionListener(ActionListener listener)", new Object[]{actionListener});
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        CommonTrace.exit(commonTrace);
    }

    public void removeActionListener(ActionListener actionListener) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "removeActionListener(ActionListener listener)", new Object[]{actionListener});
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        CommonTrace.exit(commonTrace);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "processActionEvent(ActionEvent event)", new Object[]{actionEvent});
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
        CommonTrace.exit(commonTrace);
    }

    public String getWeekdayName(int n2, int n3) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "getWeekdayName(int day, int style)", new Object[]{new Integer(n2), new Integer(n3)});
        }
        int n4 = (n2 + this.startOfWeekOffset) % 7 + 1;
        if (n3 == 2) {
            return (String)CommonTrace.exit(commonTrace, this.weekdays[n4]);
        }
        return (String)CommonTrace.exit(commonTrace, this.shortWeekdays[n4]);
    }

    public int getDaysInMonth(GregorianCalendar gregorianCalendar) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "getDaysInMonth(GregorianCalendar currentDate)", new Object[]{gregorianCalendar});
        }
        int n2 = 0;
        switch (gregorianCalendar.get(2)) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 31;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 30;
                break;
            }
            case 1: {
                n2 = gregorianCalendar.isLeapYear(gregorianCalendar.get(1)) ? 29 : 28;
            }
        }
        return CommonTrace.exit(commonTrace, n2);
    }

    public void requestFocus() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CalendarSheet", this, "requestFocus()");
        }
        if (this.focusButton != null) {
            this.focusButton.requestFocus();
        }
        CommonTrace.exit(commonTrace);
    }
}

