/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonTrace;
import com.ibm.db2.tools.common.SystemSpecific;
import java.awt.Image;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JApplet;

public class CCEnvironment {
    static JApplet applet = null;
    static String hostname;
    static int portNumber;
    public static final String CC_CLIENT_VERSION_TOKEN_5 = "WEBCC001";
    public static final String CC_SERVER_VERSION_TOKEN_5 = "WEBCCS01";
    public static final String CC_CLIENT_VERSION_TOKEN_6 = "WEBCC002";
    public static final String CC_SERVER_VERSION_TOKEN_6 = "WEBCCS60";
    public static final String CC_CLIENT_VERSION_TOKEN_710 = "CC_C_710";
    public static final String CC_SERVER_VERSION_TOKEN_710 = "CC_S_710";
    private static final String CC_CLIENT_VERSION_CURRENT_TOKEN = "CC_C_710";
    public static final int CC_CLIENT_VERSION_5 = 500;
    public static final int CC_SERVER_VERSION_5 = 500;
    public static final int CC_CLIENT_VERSION_6 = 600;
    public static final int CC_SERVER_VERSION_6 = 600;
    public static final int CC_CLIENT_VERSION_701 = 701;
    public static final int CC_SERVER_VERSION_701 = 701;
    public static final int CC_CLIENT_VERSION_CURRENT = 701;
    private static int serverVersion;
    private static String serverVersionToken;
    private static String defaultServerPortNumberString;
    private static final String localHostName = "localhost";
    private static final String defaultLanguageSubDirectory = "prime";
    private static final int socketTimeout = 30000;
    private static final long maxConnectionIdleTime = 1800000L;
    private static boolean isCCServerJni;
    private static String LANG;

    public static RootClass getRootResourseClass() {
        return RootClass.getSingleInstance();
    }

    public static String getLocalHostName() {
        return localHostName;
    }

    public static String getDefaultServerPortNumberString() {
        return defaultServerPortNumberString;
    }

    public static JApplet getApplet() {
        return applet;
    }

    public static void setApplet(JApplet jApplet) {
        applet = jApplet;
    }

    public static boolean isCCServerLocal() {
        if (CCEnvironment.isApplet()) {
            return false;
        }
        if (CCEnvironment.isCCServerJni()) {
            return true;
        }
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostname.equals(localHostName) || hostname.equals(string);
    }

    public static boolean isCCServerJni() {
        return isCCServerJni;
    }

    public static void setCCServerJni(boolean bl) {
        isCCServerJni = bl;
    }

    public static void setHostname(String string) {
        hostname = string;
    }

    public static void setPortNumber(int n2) {
        portNumber = n2;
    }

    public static String getHostname() {
        return hostname;
    }

    public static int getPortNumber() {
        return portNumber;
    }

    public static String getDefaultLanguageSubDirectory() {
        return defaultLanguageSubDirectory;
    }

    public static String getLang() {
        return LANG;
    }

    public static void setLang(String string) {
        if (LANG == null) {
            if (string.compareTo("?") == 0) {
                string = "";
            }
            LANG = string;
        }
    }

    public static long maxConnectionIdleTime() {
        return 1800000L;
    }

    public static boolean isApplet() {
        return applet != null;
    }

    public static boolean isApplication() {
        return applet == null;
    }

    public static int socketTimeout() {
        return 30000;
    }

    public static String getThreadName() {
        String string = " ?Thread? ";
        try {
            string = Thread.currentThread().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static ImageIcon loadImageIconUnscaled(String string) {
        ImageIcon imageIcon = CCEnvironment.loadImageIcon(string, "");
        return imageIcon;
    }

    public static ImageIcon loadImageIcon(String string) {
        ImageIcon imageIcon = CCEnvironment.loadImageIcon(string, "");
        Image image = imageIcon.getImage();
        imageIcon = new ImageIcon(image.getScaledInstance(20, 20, 1));
        return imageIcon;
    }

    public static ImageIcon loadImageIcon(String string, String string2) {
        URL uRL;
        if (applet == null) {
            return new ImageIcon(string, string2);
        }
        try {
            uRL = new URL(applet.getCodeBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return new ImageIcon(uRL, string2);
    }

    public static String getClientVersionToken() {
        return "CC_C_710";
    }

    public static int getClientVersion() {
        return 701;
    }

    public static void setServerVersion(String string) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CCEnvironment", "setServerVersion(String version)", new Object[]{string});
        }
        if (serverVersionToken == null) {
            serverVersionToken = string;
            serverVersion = serverVersionToken.equals(CC_SERVER_VERSION_TOKEN_5) ? 500 : (serverVersionToken.equals(CC_SERVER_VERSION_TOKEN_6) ? 600 : (serverVersionToken.equals(CC_SERVER_VERSION_TOKEN_710) ? 701 : Integer.MAX_VALUE));
        }
        CommonTrace.exit(commonTrace);
    }

    public static String getServerVersionToken() {
        return serverVersionToken;
    }

    public static int getServerVersion() {
        return serverVersion;
    }

    public static boolean serverVersionKnown() {
        return serverVersionToken != null;
    }

    public static boolean serverVersionAtLeast(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CCEnvironment", "serverVersionAtLeast(int version)", new Object[]{new Integer(n2)});
        }
        boolean bl = serverVersion >= n2;
        return CommonTrace.exit(commonTrace, bl);
    }

    public static boolean clientVersionAtLeast(int n2) {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "CCEnvironment", "clientVersionAtLeast(int version)", new Object[]{new Integer(n2)});
        }
        boolean bl = 701 >= n2;
        return CommonTrace.exit(commonTrace, bl);
    }

    static {
        serverVersion = -1;
        serverVersionToken = null;
        defaultServerPortNumberString = "6789";
        isCCServerJni = true;
        LANG = null;
        try {
            if (SystemSpecific.getOSName().startsWith("Win") || SystemSpecific.getOSName().startsWith("OS/2")) {
                defaultServerPortNumberString = "6790";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

