/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.smartx.support.DiagnosisRenderer;
import com.ibm.db2.tools.common.support.AssistBlankRenderer;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistTreeCellEditor;
import com.ibm.db2.tools.common.support.AssistTreeCellRenderer;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.CellExpanderRenderer;
import com.ibm.db2.tools.common.support.TransferableTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AssistTree
extends JTree
implements AssistComponent,
AssistListener,
CellExpanderComponent,
TreeModelListener,
ClipboardOwner,
ActionListener,
PopupMenuListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean required;
    protected boolean clearDisabled;
    protected boolean isEnabling;
    protected Boolean localBeepPolicy;
    protected TreeCellRenderer origRenderer;
    protected TreeCellRenderer blankRenderer;
    protected boolean collapsedRoot;
    TreePath origPath;
    protected TreePath focusPath;
    protected TreePath actionPath;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected boolean modelValid;
    protected boolean dataValid;
    protected Hashtable editorsValid;
    boolean valuePreviouslyValid;
    protected String prevBorderType;
    JScrollPane scrollpane;
    CellExpander cellExpander;
    protected static Border expansionBorder;
    protected JPopupMenu mPopup;
    protected transient Clipboard clipboard;
    protected boolean ownsClipboard;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;
    static /* synthetic */ Class class$javax$swing$tree$TreePath;

    public AssistTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.init(true);
    }

    public AssistTree(TreeModel treeModel) {
        super(treeModel);
        this.init(true);
    }

    public AssistTree(boolean bl, TreeNode treeNode, boolean bl2) {
        super(treeNode, bl2);
        this.init(bl);
    }

    public AssistTree(boolean bl, TreeModel treeModel) {
        super(treeModel);
        this.init(bl);
    }

    protected void init(boolean bl) {
        this.modelValid = true;
        this.dataValid = true;
        this.valuePreviouslyValid = true;
        this.required = bl;
        this.clearDisabled = AssistManager.getClearDisabledPolicy();
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        AssistTreeCellRenderer assistTreeCellRenderer = new AssistTreeCellRenderer();
        this.setCellRenderer(assistTreeCellRenderer);
        this.setCellEditor(new AssistTreeCellEditor(this, assistTreeCellRenderer));
        this.scrollpane = new JScrollPane(this);
        CellExpanderManager.sharedInstance().registerComponent(this);
        expansionBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Table.gridColor"), 1), BorderFactory.createEmptyBorder(1, 0, 1, 1));
        this.selectionModel.setSelectionMode(1);
        TreePath treePath = new TreePath(this.treeModel.getRoot());
        this.setLeadSelectionPathA(treePath);
        this.selectionModel.setSelectionPath(treePath);
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.ownsClipboard = false;
        this.setInvokesStopCellEditing(true);
        this.registerKeyboardAction(this, "cut", KeyStroke.getKeyStroke(88, 2), 0);
        this.registerKeyboardAction(this, "copy", KeyStroke.getKeyStroke(67, 2), 0);
        this.registerKeyboardAction(this, "paste", KeyStroke.getKeyStroke(86, 2), 0);
        this.registerKeyboardAction(this, "delete", KeyStroke.getKeyStroke(127, 0), 0);
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.getModel();
        if (treeModel2 != null) {
            treeModel2.removeTreeModelListener(this);
        }
        super.setModel(treeModel);
        treeModel.addTreeModelListener(this);
        this.editorsValid = new Hashtable(this.getRowCount());
        this.verifyData(null);
        this.verifyImmediately(false);
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[1] = 82;
        cArray[2] = 115;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        JScrollPane jScrollPane = this.hasScrollPane();
        if (jScrollPane == null) {
            cArray[3] = 111;
            if (this.isEnabled() && !this.modelValid && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 107;
                string = String.copyValueOf(cArray);
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.getBorder("List.border", false, string));
                }
            } else {
                cArray[5] = 118;
                string = String.copyValueOf(cArray);
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.getBorder("List.border"));
                }
            }
        } else {
            cArray[3] = 112;
            if (this.getBorder() != null) {
                this.setBorder(null);
            }
            if (this.isEnabled() && !this.modelValid && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 107;
                string = String.copyValueOf(cArray);
                if (!string.equals(this.prevBorderType)) {
                    if (AssistManager.getInsideBordersPolicy()) {
                        jScrollPane.setViewportBorder(AssistManager.getBorder("List.border", false, string));
                    } else {
                        jScrollPane.setViewportBorder(AssistManager.getBorder("TextField.border"));
                    }
                }
            } else {
                cArray[5] = 118;
                if (jScrollPane.getViewportBorder() != null) {
                    jScrollPane.setViewportBorder(null);
                }
                string = String.copyValueOf(cArray);
            }
        }
        this.prevBorderType = string;
        if (jScrollPane != null) {
            jScrollPane.doLayout();
        }
    }

    public JScrollPane hasScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.getParent().getParent();
        }
        return null;
    }

    public JScrollPane getScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.getParent().getParent();
        }
        return new JScrollPane(this);
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.localBeepPolicy;
        if (!bl) {
            this.localBeepPolicy = Boolean.FALSE;
        }
        this.verifyImmediately(false);
        if (!bl) {
            this.localBeepPolicy = bl2;
        }
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        if (!this.isEnabled() && this.getRowCount() > 0) {
            this.setEnabled(false);
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl2 != bl || this.isEnabling) {
            if (bl) {
                this.setForeground(UIManager.getColor("List.foreground"));
                this.setBackground(UIManager.getColor("List.background"));
                if (this.origRenderer != null) {
                    this.setCellRenderer(this.origRenderer);
                }
                if (!this.collapsedRoot) {
                    this.expandRow(0);
                }
            } else if (this.clearDisabled) {
                Color color = UIManager.getColor("control");
                this.setForeground(color);
                this.setBackground(color);
                if (!(this.getCellRenderer() instanceof AssistBlankRenderer)) {
                    this.origRenderer = this.getCellRenderer();
                }
                if (this.blankRenderer == null) {
                    this.blankRenderer = new AssistBlankRenderer();
                }
                this.setCellRenderer(this.blankRenderer);
                this.collapsedRoot = this.isCollapsed(0);
                this.collapseRow(0);
            } else {
                this.setForeground(UIManager.getColor("List.foreground"));
                this.setBackground(UIManager.getColor("control"));
                if (this.origRenderer != null) {
                    this.setCellRenderer(this.origRenderer);
                }
                if (!this.collapsedRoot) {
                    this.expandRow(0);
                }
            }
            this.verifyImmediately(false);
            this.setBorder();
        }
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistTree.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        this.verifyImmediately(false);
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistTree.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean isValueValid() {
        return this.modelValid && this.dataValid && AssistManager.getKeysValue(this.editorsValid);
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.verify(bl, false);
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public void verify(boolean bl, boolean bl2) {
        if (this.isEnabled() && this.required && this.getModel().getChildCount(this.getModel().getRoot()) == 0) {
            if (this.valuePreviouslyValid && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.modelValid = false;
        } else {
            this.modelValid = true;
        }
        this.setBorder();
        this.fireValidityChanged();
    }

    public boolean verifyData(TreeModelEvent treeModelEvent) {
        this.dataValid = true;
        if (this.isEnabled() && this.required && this.isEditable()) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            if (treeModelEvent != null) {
                defaultTreeModel = (DefaultTreeModel)treeModelEvent.getSource();
            }
            int n2 = this.getRowCount();
            int n3 = 0;
            while (n3 < n2) {
                if (this.getRenderingText(n3).length() == 0) {
                    if (this.valuePreviouslyValid && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    this.dataValid = false;
                    return false;
                }
                ++n3;
            }
        }
        return this.dataValid;
    }

    public String getRenderingText(int n2) {
        Object object = ((DefaultMutableTreeNode)this.getPathForRow(n2).getLastPathComponent()).getUserObject();
        boolean bl = this.getModel().isLeaf(this.getPathForRow(n2).getLastPathComponent());
        boolean bl2 = this.isRowSelected(n2);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        int n3 = this.getLeadSelectionRow();
        Component component = treeCellRenderer.getTreeCellRendererComponent(this, object, bl2, this.isExpanded(n2), bl, n2, n3 == n2);
        if (component instanceof CellExpanderRenderer) {
            return ((CellExpanderRenderer)((Object)component)).getText();
        }
        if (component instanceof JLabel) {
            return ((JLabel)component).getText();
        }
        return object.toString();
    }

    public void validityChanged(AssistEvent assistEvent) {
        int n2 = (Integer)assistEvent.getContext();
        AssistManager.setKey(this.editorsValid, (DefaultMutableTreeNode)this.getPathForRow(n2).getLastPathComponent(), assistEvent.isValueValid());
        if (!AssistManager.getKeysValue(this.editorsValid) && this.valuePreviouslyValid && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.fireValidityChanged();
    }

    public boolean isRowValid(int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.getPathForRow(n2);
        if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
            return AssistManager.getKey(this.editorsValid, defaultMutableTreeNode);
        }
        return true;
    }

    protected void fireValidityChanged() {
        boolean bl;
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        boolean bl2 = bl = this.modelValid && this.dataValid && AssistManager.getKeysValue(this.editorsValid);
        if (this.valuePreviouslyValid != bl && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistTree.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = bl;
    }

    public void expandFromNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        int n2 = defaultMutableTreeNode.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            this.expandFromNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3));
            ++n3;
        }
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Point point = mouseEvent.getPoint();
        int n2 = this.getRowForLocation(point.x, point.y);
        if (n2 == -1 || this.mPopup != null && this.mPopup.isVisible()) {
            return null;
        }
        Rectangle rectangle = this.getRowBounds(n2);
        if (rectangle == null) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width;
        boolean bl = this.getModel().isLeaf(this.getPathForRow(n2).getLastPathComponent());
        boolean bl2 = this.isRowSelected(n2);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        Component component = treeCellRenderer.getTreeCellRendererComponent(this, defaultMutableTreeNode = (DefaultMutableTreeNode)this.getPathForRow(n2).getLastPathComponent(), bl2, this.isExpanded(n2), bl, n2, false);
        if (component instanceof CellExpanderRenderer) {
            rectangle.x += ((CellExpanderRenderer)((Object)component)).getTextOffset();
        }
        int n4 = this.scrollpane.getViewport().getSize(null).width;
        int n5 = this.scrollpane.getHorizontalScrollBar().getValue();
        if (n3 - n5 > n4 - 3 || rectangle.x < n5) {
            point = new Point(rectangle.x - 2, rectangle.y - 1);
            if (component instanceof JLabel) {
                int n6 = this.getRowHeight();
                Dimension dimension = ((JLabel)component).getPreferredSize();
                int n7 = ((JLabel)component).getVerticalAlignment();
                if (n6 > dimension.height) {
                    if (n7 == 3) {
                        point.y += n6 - dimension.height;
                    } else if (n7 == 0) {
                        point.y += Math.round((n6 - dimension.height) / 2);
                    }
                }
            }
            return point;
        }
        return null;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        Serializable serializable;
        Object object;
        Object object2;
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
            this.cellExpander.putClientProperty("UAKey", this.getClientProperty("UAKey"));
        }
        Point point = mouseEvent.getPoint();
        int n2 = this.getRowForLocation(point.x, point.y);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getPathForRow(n2).getLastPathComponent();
        boolean bl = this.getModel().isLeaf(this.getPathForRow(n2).getLastPathComponent());
        boolean bl2 = this.isRowSelected(n2);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        int n3 = -1;
        if (this.hasFocus()) {
            n3 = this.getLeadSelectionRow();
        }
        Component component = treeCellRenderer.getTreeCellRendererComponent(this, defaultMutableTreeNode, bl2, this.isExpanded(n2), bl, n2, n3 == n2);
        this.cellExpander.setForeground(component.getForeground());
        this.cellExpander.setBackground(component.getBackground());
        if (component instanceof JComponent) {
            this.cellExpander.setAlignmentX(((JComponent)component).getAlignmentX());
            this.cellExpander.setAlignmentY(((JComponent)component).getAlignmentY());
        }
        this.cellExpander.setFont(component.getFont());
        if (component instanceof CellExpanderRenderer) {
            this.cellExpander.setTipText(CellExpanderManager.untag(((CellExpanderRenderer)((Object)component)).getText()));
        } else if (component instanceof JLabel) {
            object2 = ((JLabel)component).getIcon();
            if (object2 != null) {
                switch (((JLabel)component).getVerticalTextPosition()) {
                    case 1: {
                        object = "TOP";
                        break;
                    }
                    case 0: {
                        object = "MIDDLE";
                        break;
                    }
                    default: {
                        object = "BOTTOM";
                    }
                }
                serializable = new StringBuffer();
                DiagnosisRenderer.putIcon("CellExpander", (Icon)object2);
                ((StringBuffer)serializable).append("<img align=").append((String)object).append(" src=\"").append("CellExpander").append("\"").append(" hspace=").append(((JLabel)component).getIconTextGap()).append(">").append(CellExpanderManager.untag(((JLabel)component).getText()));
                this.cellExpander.setTipText(((StringBuffer)serializable).toString());
            } else {
                this.cellExpander.setTipText(CellExpanderManager.untag(((JLabel)component).getText()));
            }
        } else {
            this.cellExpander.setTipText(CellExpanderManager.untag(((Object)defaultMutableTreeNode).toString()));
        }
        object2 = new Point();
        object = ((JComponent)component).getBorder();
        if (object == null || object instanceof EmptyBorder) {
            this.cellExpander.setBorder(expansionBorder);
        } else {
            this.cellExpander.setBorder(BorderFactory.createCompoundBorder((Border)object, BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        }
        serializable = this.getRowBounds(n2);
        Insets insets = ((JComponent)component).getInsets();
        int n4 = 16;
        if (defaultMutableTreeNode != null) {
            n4 = (int)AssistManager.getLineMetrics(((Object)defaultMutableTreeNode).toString(), this, component.getFont()).getHeight();
        }
        ((Point)object2).x -= 2 + insets.left;
        ((Point)object2).y = ((Rectangle)serializable).height / 2 - n4 / 2 - insets.top;
        this.cellExpander.putClientProperty("translate.point", object2);
        return this.cellExpander;
    }

    public void registerPopup(JPopupMenu jPopupMenu) {
        if (this.mPopup == null) {
            this.enableEvents(24L);
        } else {
            this.mPopup.removePopupMenuListener(this);
        }
        this.mPopup = jPopupMenu;
        this.mPopup.addPopupMenuListener(this);
    }

    public boolean isPopupShowing() {
        return this.mPopup != null && this.mPopup.isVisible();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.isPopupShowing()) {
            AssistManager.redirectKeyEvent(keyEvent, this.mPopup);
            return;
        }
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        if ((n3 == 9 || keyEvent.getKeyChar() == '\t') && this.mPopup != null && this.mPopup.isVisible()) {
            keyEvent.consume();
        } else if (n2 == 402) {
            this.processKeyReleased(keyEvent);
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setLeadSelectionPathA(TreePath treePath) {
        if (AssistManager.isJavaVersionAtLeast(1, 3, 0)) {
            Class[] classArray = new Class[]{class$javax$swing$tree$TreePath == null ? (class$javax$swing$tree$TreePath = AssistTree.class$("javax.swing.tree.TreePath")) : class$javax$swing$tree$TreePath};
            try {
                Method method = this.getClass().getSuperclass().getMethod("setLeadSelectionPath", classArray);
                Object[] objectArray = new Object[]{treePath};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getModifiers();
        if ((n3 == 1 && n2 == 121 || n3 == 0 && n2 == 93) && this.mPopup != null) {
            this.origPath = super.getSelectionPath();
            this.focusPath = super.getLeadSelectionPath();
            this.setLeadSelectionPathA(this.origPath);
            super.setSelectionPath(this.focusPath);
            this.setLeadSelectionPathA(this.origPath);
            boolean bl = this.isEditable();
            this.scrollPathToVisible(this.focusPath);
            int n4 = this.getRowForPath(this.focusPath);
            Rectangle rectangle = this.getRowBounds(n4);
            if (rectangle == null) {
                return;
            }
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            this.mPopup.show(this, point.x, point.y);
            keyEvent.consume();
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: 
            case 502: {
                if (!mouseEvent.isPopupTrigger() || this.mPopup == null || !this.isEnabled()) break;
                Point point = mouseEvent.getPoint();
                this.origPath = super.getSelectionPath();
                this.focusPath = super.getPathForLocation(point.x, point.y);
                if (this.focusPath == null) break;
                this.setLeadSelectionPathA(this.origPath);
                super.setSelectionPath(this.focusPath);
                this.setLeadSelectionPathA(this.origPath);
                this.mPopup.show(this, point.x, point.y);
                mouseEvent.consume();
                break;
            }
        }
        if (!mouseEvent.isConsumed()) {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cut")) {
            this.cut();
        } else if (string.equals("copy")) {
            this.copy();
        } else if (string.equals("paste")) {
            this.paste();
        } else if (string.equals("delete")) {
            this.delete();
        }
    }

    public void cut() {
        TreeNode treeNode;
        TreePath treePath = null;
        if (this.actionPath != null) {
            treePath = this.actionPath;
            this.actionPath = null;
        } else {
            treePath = super.getSelectionPath();
        }
        if (treePath != null && this.treeModel.isLeaf(treeNode = (TreeNode)treePath.getLastPathComponent()) && treeNode instanceof DefaultMutableTreeNode) {
            this.editorsValid.remove(treeNode);
            int n2 = this.getRowForPath(treePath);
            if (treeNode.getParent() != null && (this.treeModel.getChildCount(treeNode.getParent()) == 1 || this.treeModel.getIndexOfChild(treeNode.getParent(), treeNode) == this.treeModel.getChildCount(treeNode.getParent()) - 1)) {
                --n2;
            }
            TransferableTreeNode transferableTreeNode = new TransferableTreeNode((DefaultMutableTreeNode)treeNode);
            if (this.clipboard == null) {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            this.clipboard.setContents(transferableTreeNode, this);
            this.ownsClipboard = true;
            if (this.treeModel instanceof DefaultTreeModel && treeNode instanceof MutableTreeNode) {
                ((DefaultTreeModel)this.treeModel).removeNodeFromParent((MutableTreeNode)treeNode);
            }
        }
    }

    public void copy() {
        TreeNode treeNode;
        TreePath treePath = null;
        if (this.actionPath != null) {
            treePath = this.actionPath;
            this.actionPath = null;
        } else {
            treePath = super.getSelectionPath();
        }
        if (treePath != null && this.treeModel.isLeaf(treeNode = (TreeNode)treePath.getLastPathComponent()) && treeNode instanceof DefaultMutableTreeNode) {
            this.ownsClipboard = true;
            TransferableTreeNode transferableTreeNode = new TransferableTreeNode((DefaultMutableTreeNode)treeNode);
            if (this.clipboard == null) {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            this.clipboard.setContents(transferableTreeNode, this);
        }
    }

    public void paste() {
        TreePath treePath = null;
        if (this.actionPath != null) {
            treePath = this.actionPath;
            this.actionPath = null;
        } else {
            treePath = super.getSelectionPath();
        }
        if (treePath != null && this.ownsClipboard && treePath.getPathCount() > 2) {
            Transferable transferable;
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (this.clipboard == null) {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            if ((transferable = this.clipboard.getContents(this)) != null) {
                int n2 = this.getRowForPath(treePath);
                TreeNode treeNode2 = treeNode;
                if (this.treeModel.isLeaf(treeNode)) {
                    treeNode2 = treeNode.getParent();
                }
                int n3 = 0;
                if (this.treeModel.isLeaf(treeNode) && this.treeModel instanceof DefaultTreeModel) {
                    n3 = ((DefaultTreeModel)this.treeModel).getIndexOfChild(treeNode2, treeNode) + 1;
                }
                try {
                    TreeNode treeNode3 = (TreeNode)transferable.getTransferData(TransferableTreeNode.flavors[0]);
                    if (this.treeModel instanceof DefaultTreeModel && treeNode3 instanceof MutableTreeNode && treeNode2 instanceof MutableTreeNode) {
                        ((DefaultTreeModel)this.treeModel).insertNodeInto((MutableTreeNode)((DefaultMutableTreeNode)treeNode3).clone(), (MutableTreeNode)treeNode2, n3);
                    }
                }
                catch (Exception exception) {
                    this.ownsClipboard = false;
                }
            }
        }
    }

    public void delete() {
        TreeNode treeNode;
        TreePath treePath = null;
        if (this.actionPath != null) {
            treePath = this.actionPath;
            this.actionPath = null;
        } else {
            treePath = super.getSelectionPath();
        }
        if (treePath != null && this.treeModel.isLeaf(treeNode = (TreeNode)treePath.getLastPathComponent())) {
            this.editorsValid.remove(treeNode);
            int n2 = this.getRowForPath(treePath);
            if (treeNode.getParent() != null && (this.treeModel.getChildCount(treeNode.getParent()) == 1 || this.treeModel.getIndexOfChild(treeNode.getParent(), treeNode) == this.treeModel.getChildCount(treeNode.getParent()) - 1)) {
                --n2;
            }
            if (treeNode.getParent() != null && this.treeModel instanceof DefaultTreeModel && treeNode instanceof MutableTreeNode) {
                ((DefaultTreeModel)this.treeModel).removeNodeFromParent((MutableTreeNode)treeNode);
            }
        }
    }

    public void rename() {
        TreePath treePath = null;
        if (this.actionPath != null) {
            treePath = this.actionPath;
            this.actionPath = null;
        } else {
            treePath = super.getSelectionPath();
        }
        if (this.isEditable() && treePath != null) {
            this.startEditingAtPath(treePath);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.ownsClipboard = false;
    }

    public boolean canPaste() {
        return this.ownsClipboard;
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.verifyData(treeModelEvent);
        this.verify(false);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.verifyData(treeModelEvent);
        this.verify(false);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.verify(false);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.verify(false);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.actionPath = super.getSelectionPath();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.focusPath != null) {
            this.setLeadSelectionPathA(this.focusPath);
            if (this.origPath != null) {
                super.setSelectionPath(this.origPath);
            }
            this.setLeadSelectionPathA(this.focusPath);
            this.focusPath = null;
        }
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.actionPath = null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAssistTree();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleAssistTree
    extends JTree.AccessibleJTree {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public AccessibleAssistTree() {
            super(AssistTree.this);
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount() + 1;
        }

        public Accessible getAccessibleChild(int n2) {
            Accessible accessible = super.getAccessibleChild(n2);
            if (accessible != null) {
                return accessible;
            }
            if (n2 < this.getAccessibleChildrenCount()) {
                return AssistTree.this.mPopup;
            }
            return null;
        }
    }
}

