/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.RunSelectAll;
import com.ibm.db2.tools.common.RunSpin;
import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.ArrowheadIcon;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistRole;
import com.ibm.db2.tools.common.support.MinimalButtonBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class AssistSpinner
extends JPanel
implements AssistComponent,
ComponentListener,
DocumentListener,
ActionListener,
KeyListener,
MouseListener,
PropertyChangeListener,
Runnable,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final boolean singleButton = false;
    public static final boolean insideField = true;
    public static final boolean twoDBorders = false;
    protected AssistField spinField;
    protected SpinButton spinButton;
    protected SpinButton downButton;
    protected boolean required;
    protected boolean clearDisabled;
    protected boolean isEnabling;
    protected boolean nested;
    protected String prevBorderType;
    protected Boolean localBeepPolicy;
    protected boolean allowWhitespace;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected boolean valueValid;
    protected boolean inRange;
    protected boolean valuePreviouslyValid;
    protected Timer verifyTimer;
    protected long upperBound;
    protected long lowerBound;
    protected int increment;
    protected long defaultValue;
    protected long spinValue;
    protected long prevValue;
    protected boolean spinDirection;
    protected Thread spinThread;
    protected static final int SPIN_TIME = 180;
    public static final String VALUE_CHANGED = "value changed";
    protected boolean killThread;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;

    public AssistSpinner() {
        this(true, Long.MIN_VALUE, Long.MAX_VALUE, new AssistField(), true);
    }

    public AssistSpinner(int n2, int n3) {
        this(true, (long)n2, (long)n3, new AssistField(), true);
    }

    public AssistSpinner(JTextField jTextField, boolean bl) {
        this(true, Long.MIN_VALUE, Long.MAX_VALUE, new AssistField(), true);
    }

    public AssistSpinner(AssistField assistField, boolean bl) {
        this(true, Long.MIN_VALUE, Long.MAX_VALUE, assistField, true);
    }

    public AssistSpinner(long l2, long l3, JTextField jTextField, boolean bl) {
        this(true, l2, l3, new AssistField(), true);
    }

    public AssistSpinner(long l2, long l3, AssistField assistField, boolean bl) {
        this(true, l2, l3, assistField, true);
    }

    public AssistSpinner(boolean bl) {
        this(bl, Long.MIN_VALUE, Long.MAX_VALUE, new AssistField(), true);
    }

    public AssistSpinner(boolean bl, int n2, int n3) {
        this(bl, (long)n2, (long)n3, new AssistField(), true);
    }

    public AssistSpinner(boolean bl, long l2, long l3, JTextField jTextField, boolean bl2) {
        this(bl, l2, l3, new AssistField(), true);
    }

    public AssistSpinner(boolean bl, long l2, long l3, AssistField assistField, boolean bl2) {
        this.spinValue = this.defaultValue = 0L;
        this.prevValue = this.defaultValue;
        this.increment = 1;
        this.valueValid = true;
        this.valuePreviouslyValid = true;
        this.lowerBound = l2;
        this.upperBound = l3;
        this.setLayout(new GridBagLayout());
        this.spinField = assistField;
        this.spinField.setRequired(false);
        AccessibleAssistSpinner accessibleAssistSpinner = (AccessibleAssistSpinner)this.getAccessibleContext();
        accessibleAssistSpinner.setTextFieldContext(this.spinField.getAccessibleContext());
        this.spinField.setAccessibleContext(accessibleAssistSpinner);
        this.setBackground(this.spinField.getBackground());
        this.required = bl;
        this.clearDisabled = AssistManager.getClearDisabledPolicy();
        this.allowWhitespace = false;
        this.spinField.setHorizontalAlignment(4);
        if (this.defaultValue < this.lowerBound || this.defaultValue > this.upperBound) {
            this.defaultValue = this.lowerBound;
        }
        this.setValue(this.defaultValue);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        this.add((Component)this.spinField, gridBagConstraints);
        if (bl2) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 15;
            this.spinButton = new SpinButton(false, true, false);
            this.downButton = new SpinButton(false, false, false);
            accessibleAssistSpinner.setSpinButtonContext(this.spinButton.getAccessibleContext(), true);
            this.spinButton.setAccessibleContext(accessibleAssistSpinner);
            accessibleAssistSpinner.setSpinButtonContext(this.downButton.getAccessibleContext(), false);
            this.downButton.setAccessibleContext(accessibleAssistSpinner);
            this.spinButton.addMouseListener(this);
            this.downButton.addMouseListener(this);
            JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
            jPanel.setBackground(this.spinField.getBackground());
            jPanel.add(this.spinButton);
            jPanel.add(this.downButton);
            gridBagConstraints.insets = UIManager.getLookAndFeel().getName().equals("Metal") ? new Insets(0, 1, 0, 0) : new Insets(1, 1, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        this.nested = false;
        this.setBorder();
        this.killThread = false;
        this.addComponentListener(this);
        this.spinField.addKeyListener(this);
        this.addPropertyChangeListener("labeledBy", this);
        this.addPropertyChangeListener("UAKey", this);
        if (this.spinField.getDocument() != null) {
            this.spinField.getDocument().addDocumentListener(this);
        }
    }

    public void requestFocus() {
        this.spinField.requestFocus();
    }

    public void setRange(long l2, long l3) {
        if (l2 == l3) {
            return;
        }
        if (l2 > l3) {
            long l4 = l2;
            l3 = l2;
            l2 = l4;
        }
        int n2 = Long.toString(l2).length();
        int n3 = Long.toString(l3).length();
        if (n3 > n2) {
            this.spinField.setColumns(n3);
        } else {
            this.spinField.setColumns(n2);
        }
        this.lowerBound = l2;
        this.upperBound = l3;
        if (this.spinValue < l2) {
            this.setValue(l2);
        } else if (this.spinValue > l3) {
            this.setValue(l3);
        }
    }

    public void setIncrement(int n2) {
        this.increment = n2 > 0 ? n2 : 1;
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAllowWhitespace(boolean bl) {
        this.allowWhitespace = bl;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void setDocument(Document document) {
        if (this.spinField.getDocument() != null) {
            this.spinField.getDocument().removeDocumentListener(this);
        }
        this.spinField.setDocument(document);
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    public int getColumns() {
        return this.spinField.getColumns();
    }

    public void setColumns(int n2) {
        this.spinField.setColumns(n2);
    }

    public void setValue(long l2) {
        this.spinValue = l2;
        Boolean bl = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        this.spinField.setText(this.getStringValue());
        this.verifyImmediately(false);
        this.localBeepPolicy = bl;
        this.fireValueChanged();
    }

    protected String getStringValue() {
        return String.valueOf(this.spinValue);
    }

    public long getValue() {
        return this.spinValue;
    }

    public void setDefaultValue(long l2) {
        if (this.defaultValue >= this.lowerBound && this.defaultValue <= this.upperBound) {
            this.defaultValue = l2;
            this.setValue(this.defaultValue);
        }
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public String getText() {
        return this.spinField.getText();
    }

    public void setText(String string) {
        String string2 = string == null ? String.valueOf(this.defaultValue) : this.filterText(string.toString());
        Boolean bl = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        try {
            this.spinValue = Long.parseLong(string2);
            this.spinField.setText(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.spinValue = this.defaultValue;
            this.spinField.setText(String.valueOf(this.defaultValue));
        }
        this.localBeepPolicy = bl;
        this.fireValueChanged();
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        this.verifyImmediately(false);
        this.localBeepPolicy = bl2;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        Boolean bl2 = this.localBeepPolicy;
        if (bl) {
            this.localBeepPolicy = Boolean.FALSE;
        }
        this.setEnabled(this.isEnabled());
        if (bl) {
            this.localBeepPolicy = bl2;
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setBorder() {
        if (this.nested) {
            if (this.getBorder() != null) {
                this.setBorder(null);
            }
            if (this.spinField.getBorder() != null) {
                this.spinField.setBorder(null);
            }
        } else {
            char[] cArray = new char[7];
            cArray[0] = 97;
            cArray[1] = 83;
            cArray[4] = 101;
            cArray[6] = 32;
            String string = null;
            if (this.spinField.isEnabled() && (!this.inRange || !this.valueValid) && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                if (AssistManager.getInsideBordersPolicy()) {
                    cArray[3] = 105;
                    Border border = AssistManager.getBorder("TextField.border");
                    if (this.getBorder() == null || !this.getBorder().equals(border)) {
                        this.setBorder(border);
                    }
                    if (AssistManager.getThinBordersPolicy()) {
                        cArray[6] = 116;
                        string = String.copyValueOf(cArray);
                        if (!string.equals(this.prevBorderType)) {
                            this.spinField.setBorder(AssistManager.padBorder(2, this.spinField, AssistManager.getBorder("Assist.nested.error.border"), string));
                        }
                    } else {
                        cArray[6] = 107;
                        string = String.copyValueOf(cArray);
                        if (!string.equals(this.prevBorderType)) {
                            this.spinField.setBorder(AssistManager.padBorder(2, this.spinField, AssistManager.getBorder("Assist.error.border"), string));
                        }
                    }
                } else {
                    cArray[3] = 111;
                    cArray[5] = 118;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("TextField.border", false, string));
                        Insets insets = this.getBorder().getBorderInsets(this);
                        this.spinField.setBorder(AssistManager.padBorder(2 - insets.left, this, null, string));
                    }
                }
            } else {
                cArray[5] = 118;
                cArray[3] = 105;
                string = String.copyValueOf(cArray);
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.getBorder("TextField.border"));
                    this.spinField.setBorder(AssistManager.padBorder(2, this, null, string));
                }
            }
            this.prevBorderType = string;
        }
        this.repaint();
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        this.spinField.setEnabled(bl);
        if (bl2 != bl || this.isEnabling) {
            int n2 = this.spinField.getCaretPosition();
            if (n2 >= 0 && n2 <= this.spinField.getText().length()) {
                this.spinField.setCaretPosition(n2);
            }
            if (bl) {
                this.spinField.setForeground(UIManager.getColor("TextField.foreground"));
                this.spinField.setBackground(UIManager.getColor("TextField.background"));
                this.spinField.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.spinField.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
                this.spinField.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
            } else if (this.clearDisabled) {
                Color color = null;
                color = AssistManager.getDefaultColorsPolicy() ? UIManager.getColor("TextField.background") : UIManager.getColor("control");
                this.spinField.setBackground(color);
                this.spinField.setForeground(color);
                this.spinField.setSelectionColor(color);
                this.spinField.setSelectedTextColor(color);
                this.spinField.setDisabledTextColor(color);
            } else {
                if (AssistManager.getDefaultColorsPolicy()) {
                    this.spinField.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    this.spinField.setBackground(UIManager.getColor("TextField.background"));
                    this.spinField.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
                } else {
                    this.spinField.setForeground(UIManager.getColor("TextField.foreground"));
                    this.spinField.setBackground(UIManager.getColor("control"));
                    this.spinField.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
                }
                this.spinField.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.spinField.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
            }
            this.verifyImmediately(false);
            this.spinButton.setEnabled(bl);
            this.downButton.setEnabled(bl);
            this.setBorder();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.spinField != null) {
            this.spinField.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.spinField != null) {
            this.spinField.setBackground(color);
        }
    }

    public void setTextField(JTextField jTextField) {
        this.setTextField(new AssistField());
    }

    public void setTextField(AssistField assistField) {
        this.spinField.removeKeyListener(this);
        this.spinField.getDocument().removeDocumentListener(this);
        this.spinField = assistField;
        this.spinField.setRequired(false);
        AccessibleAssistSpinner accessibleAssistSpinner = (AccessibleAssistSpinner)this.getAccessibleContext();
        accessibleAssistSpinner.setTextFieldContext(this.spinField.getAccessibleContext());
        this.spinField.setAccessibleContext(accessibleAssistSpinner);
        this.spinField.setHorizontalAlignment(4);
        this.spinField.addKeyListener(this);
        this.spinField.getDocument().addDocumentListener(this);
        try {
            this.spinValue = Long.parseLong(this.spinField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.spinValue = this.defaultValue;
            this.spinField.setText(String.valueOf(this.defaultValue));
        }
        this.fireValueChanged();
    }

    public AssistField getTextField() {
        return this.spinField;
    }

    public AssistSpinner clone(String string) {
        return this.getRenderer(true, string);
    }

    public AssistSpinner getRenderer(boolean bl, String string) {
        AssistSpinner assistSpinner = new AssistSpinner(this.required, this.lowerBound, this.upperBound, new AssistField(string), bl);
        assistSpinner.setBorder(this.getBorder());
        assistSpinner.setClearDisabled(this.clearDisabled);
        assistSpinner.setNestedBorders(true);
        assistSpinner.setBeepPolicy(false);
        assistSpinner.verifyImmediately(false);
        if (this.localBeepPolicy == null) {
            assistSpinner.resetBeepPolicy();
        } else {
            assistSpinner.setBeepPolicy(this.localBeepPolicy);
        }
        return assistSpinner;
    }

    public void putClientProperties(Object object, Object object2) {
        super.putClientProperty(object, object2);
        this.spinField.putClientProperty(object, object2);
        this.spinButton.putClientProperty(object, object2);
        if (this.downButton != null) {
            this.downButton.putClientProperty(object, object2);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AssistSpinner.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AssistSpinner.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (this.spinField != null) {
            this.spinField.addFocusListener(focusListener);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (this.spinField != null) {
            this.spinField.removeFocusListener(focusListener);
        }
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (this.spinField != null) {
            this.spinField.addKeyListener(keyListener);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (this.spinField != null) {
            this.spinField.removeKeyListener(keyListener);
        }
    }

    public synchronized void addDocumentListener(DocumentListener documentListener) {
        if (this.spinField != null) {
            this.spinField.getDocument().addDocumentListener(documentListener);
        }
    }

    public synchronized void removeDocumentListener(DocumentListener documentListener) {
        if (this.spinField != null) {
            this.spinField.getDocument().removeDocumentListener(documentListener);
        }
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.spinField != null) {
            this.spinField.addMouseListener(mouseListener);
        }
        if (this.spinButton != null) {
            this.spinButton.addMouseListener(mouseListener);
        }
        if (this.downButton != null) {
            this.downButton.addMouseListener(mouseListener);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (this.spinField != null) {
            this.spinField.removeMouseListener(mouseListener);
        }
        if (this.spinButton != null) {
            this.spinButton.removeMouseListener(mouseListener);
        }
        if (this.downButton != null) {
            this.downButton.removeMouseListener(mouseListener);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this) {
            Rectangle rectangle = this.spinField.getBounds();
            rectangle.height = this.getBounds().height;
            rectangle.width = this.getBounds().width;
            if (this.spinButton != null) {
                rectangle.width -= this.spinButton.getBounds().width;
            }
            this.spinField.setBounds(rectangle);
            this.doLayout();
            ((JPanel)object).repaint();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if ((object == this.spinField || object == this.spinButton || object == this.downButton) && this.spinField.isEditable() && this.spinField.isEnabled()) {
            int n2 = keyEvent.getModifiers();
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    this.killThread = false;
                    if (this.spinThread == null) {
                        this.spinDirection = false;
                        if (this.spinThread == null) {
                            this.spin(false);
                        }
                        this.downButton.doClick();
                        this.spinThread = new Thread(this);
                        this.spinThread.start();
                    }
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.killThread = false;
                    if (this.spinThread == null) {
                        this.spinDirection = true;
                        if (this.spinThread == null) {
                            this.spin(true);
                        }
                        this.spinButton.doClick();
                        this.spinThread = new Thread(this);
                        this.spinThread.start();
                    }
                    keyEvent.consume();
                    break;
                }
                case 86: {
                    if (n2 != 2) break;
                    this.checkPaste(keyEvent);
                    break;
                }
                case 155: {
                    if (n2 != 1) break;
                    this.checkPaste(keyEvent);
                    break;
                }
                default: {
                    this.filterKey(keyEvent);
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.filterKey(keyEvent);
        if (this.spinThread != null) {
            this.killThread = true;
            this.spinThread = null;
            this.spinField.requestFocus();
            SwingUtilities.invokeLater(RunSelectAll.getInstance(this.spinField));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.filterKey(keyEvent);
    }

    protected void checkPaste(KeyEvent keyEvent) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this.spinField);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                String string2 = this.filterText(string);
                if (string != null && !string.equals(string2)) {
                    this.spinField.replaceSelection(string2);
                    keyEvent.consume();
                }
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
            try {
                this.spinValue = Long.parseLong(this.spinField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.spinValue = this.defaultValue;
                this.spinField.setText(String.valueOf(this.defaultValue));
            }
            this.fireValueChanged();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.spinThread != null) {
            this.killThread = true;
            this.spinThread = null;
            this.spinField.requestFocus();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.spinField.isEditable() && this.spinField.isEnabled()) {
            Object object = mouseEvent.getSource();
            if (object == this.spinButton) {
                this.spinDirection = true;
                this.spin(this.spinDirection);
                this.killThread = false;
                if (this.spinThread == null) {
                    this.spinThread = new Thread(this);
                    this.spinThread.start();
                }
                this.spinField.requestFocus();
            } else if (object == this.downButton) {
                this.spinDirection = false;
                this.spin(this.spinDirection);
                this.killThread = false;
                if (this.spinThread == null) {
                    this.spinThread = new Thread(this);
                    this.spinThread.start();
                }
                this.spinField.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.spinThread != null) {
            this.killThread = true;
            this.spinThread = null;
            this.spinField.requestFocus();
            SwingUtilities.invokeLater(RunSelectAll.getInstance(this.spinField));
        }
    }

    protected synchronized void spin(boolean bl) {
        if (bl) {
            if (this.spinValue >= this.upperBound) {
                this.setValue(this.lowerBound);
            } else {
                this.setValue(this.spinValue + (long)this.increment);
            }
        } else if (this.spinValue <= this.lowerBound) {
            this.setValue(this.upperBound);
        } else {
            this.setValue(this.spinValue - (long)this.increment);
        }
        if (this.spinThread == null) {
            SwingUtilities.invokeLater(RunSelectAll.getInstance(this.spinField));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this) {
            if (propertyChangeEvent.getPropertyName().equals("labeledBy")) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.spinField.getAccessibleContext().setAccessibleName(jLabel.getText());
                    this.spinButton.getAccessibleContext().setAccessibleName(jLabel.getText());
                    if (null != this.downButton) {
                        this.downButton.getAccessibleContext().setAccessibleName(jLabel.getText());
                    }
                }
            } else if (propertyChangeEvent.getPropertyName().equals("UAKey")) {
                Object object = propertyChangeEvent.getNewValue();
                this.putClientProperties("UAKey", object);
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(360L);
            int n2 = 0;
            while (n2 < 5 && !this.killThread) {
                SwingUtilities.invokeAndWait(new RunSpin(this, this.spinDirection));
                Thread.sleep(180L);
                ++n2;
            }
            while (!this.killThread) {
                SwingUtilities.invokeAndWait(new RunSpin(this, this.spinDirection));
                Thread.sleep(60L);
            }
        }
        catch (Exception exception) {
            System.out.println("AssistSpinner.run can't sleep: " + exception.getMessage());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.verifyTimer) {
            this.verifyImmediately(false);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.verify();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n2 = AssistManager.getVerifyDelayPolicy();
        if (n2 > 0 && this.verifyTimer == null) {
            this.verifyTimer = new Timer(n2, this);
            this.verifyTimer.setInitialDelay(n2);
            this.verifyTimer.setRepeats(false);
        }
        if (n2 > 0) {
            this.verifyTimer.restart();
        } else {
            this.verify();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistSpinner.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        Boolean bl = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        this.verifyImmediately(false);
        this.localBeepPolicy = bl;
        this.valuePreviouslyValid = this.valueValid;
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistSpinner.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    protected void fireValueChanged() {
        if (this.prevValue == this.spinValue) {
            return;
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Long(this.prevValue), new Long(this.spinValue));
        }
        this.prevValue = this.spinValue;
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.getText());
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ActionListener == null ? AssistSpinner.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)objectArray[n2 + 1]).actionPerformed(actionEvent);
            }
            n2 -= 2;
        }
    }

    public boolean isValueValid() {
        if (this.verifyTimer != null && this.verifyTimer.isRunning()) {
            this.verifyTimer.stop();
            this.verifyImmediately(false);
        }
        return this.inRange && this.valueValid;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.inRange = true;
        String string = this.spinField.getText();
        if (!this.allowWhitespace) {
            string = string.trim();
        }
        if (this.spinField.isEnabled() && this.required && string.length() == 0) {
            this.valueValid = false;
        } else {
            this.valueValid = true;
            try {
                long l2 = Long.parseLong(this.spinField.getText());
                this.inRange = l2 >= this.lowerBound && l2 <= this.upperBound;
                if (l2 < this.lowerBound) {
                    this.spinValue = this.lowerBound;
                } else if (l2 > this.upperBound) {
                    this.spinValue = this.upperBound;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.inRange = false;
            }
        }
        if (this.valueValid && this.inRange) {
            try {
                this.spinValue = Long.parseLong(this.spinField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.spinValue = this.defaultValue;
                this.spinField.setText(String.valueOf(this.defaultValue));
            }
        } else if (!bl && this.valuePreviouslyValid != (this.valueValid && this.inRange) && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (!bl) {
            if (this.valuePreviouslyValid != (this.valueValid && this.inRange)) {
                this.setBorder();
            }
            this.fireValidityChanged();
        }
        this.fireValueChanged();
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    protected String filterText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            int n4 = Character.getType(c2);
            if (n4 == 9 || c2 == '-') {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected void filterKey(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        int n2 = Character.getType(c2);
        if (n2 != 9 && n2 != 15 && c2 != '-' && keyEvent.getModifiers() != 8) {
            keyEvent.consume();
            if (keyEvent.getID() == 401 && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    protected void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (this.valuePreviouslyValid != (this.inRange && this.valueValid) && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistSpinner.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.inRange && this.valueValid;
    }

    public void validityChanged(AssistEvent assistEvent) {
        boolean bl = assistEvent.isValueValid();
        if (this.valuePreviouslyValid != (bl && this.inRange)) {
            this.setBorder();
            if (!(bl && this.inRange || !(this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy()))) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        this.fireValidityChanged();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAssistSpinner();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleAssistSpinner
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected AccessibleContext textFieldContext;
        protected AccessibleContext upButtonContext;
        protected AccessibleContext downButtonContext;

        public AccessibleAssistSpinner() {
            super(AssistSpinner.this);
        }

        public void setTextFieldContext(AccessibleContext accessibleContext) {
            if (accessibleContext != this) {
                this.textFieldContext = accessibleContext;
            }
        }

        public void setSpinButtonContext(AccessibleContext accessibleContext, boolean bl) {
            if (accessibleContext != this) {
                if (bl) {
                    this.upButtonContext = accessibleContext;
                } else {
                    this.downButtonContext = accessibleContext;
                }
            }
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 2;
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return "up";
            }
            return "down";
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                AssistSpinner.this.spin(true);
            } else {
                AssistSpinner.this.spin(false);
            }
            return true;
        }

        public AccessibleRole getAccessibleRole() {
            return AssistRole.NUMERIC_SPINNER;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Long(AssistSpinner.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            long l2 = number.longValue();
            if (l2 < AssistSpinner.this.lowerBound || l2 > AssistSpinner.this.upperBound) {
                return false;
            }
            AssistSpinner.this.setValue(l2);
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Long(AssistSpinner.this.lowerBound);
        }

        public Number getMaximumAccessibleValue() {
            return new Long(AssistSpinner.this.upperBound);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }
    }

    public static class SpinButton
    extends JButton {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public SpinButton(boolean bl, boolean bl2, boolean bl3) {
            this.setDefaultCapable(false);
            this.setFocusPainted(false);
            this.setOpaque(true);
            this.setActionCommand(AssistSpinner.VALUE_CHANGED);
            if (bl) {
                this.setIcon(new ArrowheadIcon(true, true, true));
                if (bl3) {
                    this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.shadow").darker()), BorderFactory.createEmptyBorder(0, 2, 0, 1)));
                } else {
                    this.setBorder(this.getLAFBorder());
                }
            } else {
                this.setIcon(new ArrowheadIcon(bl2, false, true));
                if (bl3) {
                    this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.shadow").darker()), BorderFactory.createEmptyBorder(1, 2, 0, 2)));
                } else {
                    this.setBorder(this.getLAFBorder());
                }
            }
        }

        protected Border getLAFBorder() {
            return MinimalButtonBorder.getInstance();
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void setAccessibleContext(AccessibleContext accessibleContext) {
            this.accessibleContext = accessibleContext;
        }
    }
}

