/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistEditorKit;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class AssistPassword
extends JPasswordField
implements AssistComponent,
DocumentListener,
ActionListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean required;
    protected boolean clearDisabled;
    protected boolean isEnabling;
    protected boolean clipText;
    protected boolean clipped;
    protected boolean nested = false;
    protected Boolean localBeepPolicy;
    protected boolean allowWhitespace;
    protected boolean unlinkEditableEnabled;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected boolean valueValid = true;
    protected boolean valuePreviouslyValid = true;
    protected Timer verifyTimer;
    protected String prevBorderType;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;

    public AssistPassword() {
        this(true, null, null, 0, false);
    }

    public AssistPassword(String string) {
        this(true, null, string, 0, false);
    }

    public AssistPassword(int n2) {
        this(true, null, null, n2, false);
    }

    public AssistPassword(String string, int n2) {
        this(true, null, string, n2, false);
    }

    public AssistPassword(Document document, String string, int n2) {
        this(true, document, string, n2, false);
    }

    public AssistPassword(boolean bl) {
        this(bl, null, null, 0, false);
    }

    public AssistPassword(boolean bl, String string) {
        this(bl, null, string, 0, false);
    }

    public AssistPassword(boolean bl, int n2) {
        this(bl, null, null, n2, false);
    }

    public AssistPassword(boolean bl, String string, int n2) {
        this(bl, null, string, n2, false);
    }

    public AssistPassword(boolean bl, String string, int n2, boolean bl2) {
        this(bl, null, string, n2, false);
    }

    public AssistPassword(boolean bl, Document document, String string, int n2, boolean bl2) {
        super(document, string, n2);
        if (string == null || string.length() == 0) {
            this.valueValid = false;
        }
        this.setBorder();
        this.clipText = bl2;
        this.clipped = false;
        this.clearDisabled = AssistManager.getClearDisabledPolicy();
        this.allowWhitespace = false;
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        this.setRequired(bl);
        this.unlinkEditableEnabled = false;
    }

    public void setAllowWhitespace(boolean bl) {
        this.allowWhitespace = bl;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        super.setDocument(document);
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[1] = 80;
        cArray[3] = 111;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        Border border = null;
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistPassword.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            cArray[2] = 116;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("Assist.nested.error.border");
            } else {
                boolean bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
                cArray[5] = bl ? 102 : 118;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("Assist.nested.border", true, bl, string);
            }
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(border);
            }
        } else if (this.nested) {
            cArray[2] = 110;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                border = AssistManager.getBorder("Assist.nested.error.border");
            } else {
                cArray[5] = 118;
                border = AssistManager.getBorder("Assist.nested.border");
            }
            string = String.copyValueOf(cArray);
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(2, this, border, string));
            }
        } else {
            cArray[2] = 115;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 107;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("TextField.border", false, string);
            } else {
                cArray[5] = 118;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("TextField.border");
            }
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(this, border, string));
            }
        }
        this.prevBorderType = string;
        this.repaint();
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.verifyImmediately(false);
        if (bl2 == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl2);
        }
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        Boolean bl2 = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.setEnabled(this.isEnabled());
        if (bl2 == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl2);
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.unlinkEditableEnabled = true;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (!this.unlinkEditableEnabled) {
            super.setEditable(bl);
        }
        if (bl2 != bl || this.isEnabling) {
            int n2 = this.getCaretPosition();
            if (n2 >= 0 && n2 <= this.getPassword().length) {
                this.setCaretPosition(n2);
            }
            if (bl) {
                this.setForeground(UIManager.getColor("TextField.foreground"));
                this.setBackground(UIManager.getColor("TextField.background"));
                this.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
                this.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
            } else if (this.clearDisabled) {
                Color color = null;
                color = AssistManager.getDefaultColorsPolicy() ? UIManager.getColor("TextField.background") : UIManager.getColor("control");
                this.setBackground(color);
                this.setForeground(color);
                this.setSelectionColor(color);
                this.setSelectedTextColor(color);
                this.setDisabledTextColor(color);
            } else {
                if (AssistManager.getDefaultColorsPolicy()) {
                    this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    this.setBackground(UIManager.getColor("TextField.background"));
                    this.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
                } else {
                    this.setForeground(UIManager.getColor("TextField.foreground"));
                    this.setBackground(UIManager.getColor("control"));
                    this.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
                }
                this.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
            }
            this.verifyImmediately(false);
        }
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void setText(String string) {
        Boolean bl = this.getBeepPolicy();
        this.setBeepPolicy(false);
        super.setText(string);
        this.setCaretPosition(this.getPassword().length);
        if (bl == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl);
        }
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistPassword.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        Boolean bl = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.verifyImmediately(false);
        if (bl == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl);
        }
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistPassword.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean isValueValid() {
        if (this.verifyTimer != null && this.verifyTimer.isRunning()) {
            this.verifyTimer.stop();
            this.verifyImmediately(false);
        }
        return this.valueValid;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.verify(bl, false);
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public void verify(boolean bl, boolean bl2) {
        String string = new String(this.getPassword());
        if (!this.allowWhitespace) {
            string = string.trim();
        }
        if (this.isEnabled() && this.getRequired() && string.length() == 0) {
            if (!bl2 && this.valueValid && AssistManager.getErrorBordersPolicy() && (this.getBeepPolicy() != null ? this.getBeepPolicy() : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.valueValid = false;
        } else {
            this.valueValid = true;
        }
        if (!bl2) {
            this.setBorder();
            this.fireValidityChanged();
        }
    }

    public void paste() {
        String string;
        Clipboard clipboard;
        if (this.isEditable() && this.isEnabled() && (clipboard = this.getToolkit().getSystemClipboard()) != null && AssistEditorKit.canPaste(this) && (string = AssistEditorKit.getPastable(this)) != null) {
            this.replaceSelection(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.verifyTimer) {
            this.verifyImmediately(true);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.clipped) {
            return;
        }
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.verify(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.clipped) {
            return;
        }
        int n2 = AssistManager.getVerifyDelayPolicy();
        if (n2 > 0 && this.verifyTimer == null) {
            this.verifyTimer = new Timer(n2, this);
            this.verifyTimer.setInitialDelay(n2);
            this.verifyTimer.setRepeats(false);
        }
        if (n2 > 0) {
            this.verifyTimer.setDelay(n2);
            this.verifyTimer.restart();
        } else {
            this.verify(true);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (this.valuePreviouslyValid != this.valueValid && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistPassword.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.valueValid;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.repaint();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistPassword.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            if (n2 == 401 && (n3 == 9 || keyEvent.getKeyChar() == '\t' || n3 == 27)) {
                AssistManager.redirectKeyEvent(keyEvent, jTable);
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if (n2 == 402) {
            if (n3 == 10) {
                JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)keyEvent.getSource());
                JButton jButton = jRootPane.getDefaultButton();
                if (jButton != null) {
                    jButton.getModel().setPressed(false);
                    keyEvent.consume();
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if (n2 == 401) {
            if (n3 == 10) {
                JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)keyEvent.getSource());
                JButton jButton = jRootPane.getDefaultButton();
                if (jButton != null) {
                    ButtonModel buttonModel = jButton.getModel();
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                    keyEvent.consume();
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public AssistPassword clone(String string) {
        return this.getRenderer(false, string);
    }

    public AssistPassword getRenderer(boolean bl, String string) {
        AssistPassword assistPassword = new AssistPassword(this.getRequired(), string, this.getColumns(), bl);
        assistPassword.setRequired(this.getRequired());
        assistPassword.setClearDisabled(this.getClearDisabled());
        assistPassword.setBorder(this.getBorder());
        assistPassword.setNestedBorders(this.nested);
        assistPassword.setBeepPolicy(false);
        assistPassword.verifyImmediately(false);
        Boolean bl2 = this.getBeepPolicy();
        if (bl2 == null) {
            assistPassword.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            assistPassword.setBeepPolicy(bl2);
        }
        return assistPassword;
    }

    public void setPaintClipped(boolean bl) {
        this.clipText = bl;
    }

    public boolean getPaintClipped() {
        return this.clipText;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

