/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.AssistBlankRenderer;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistListRenderer;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AssistList
extends JList
implements AssistComponent,
ListDataListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean required;
    protected boolean selectionRequired;
    protected boolean clearDisabled;
    protected boolean isEnabling;
    protected boolean nested;
    protected Boolean localBeepPolicy;
    protected String prevBorderType;
    protected ListCellRenderer origRenderer;
    protected ListCellRenderer blankRenderer;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected boolean valueValid;
    boolean valuePreviouslyValid;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;

    public AssistList() {
        super(new DefaultListModel());
        this.init(true);
    }

    public AssistList(Vector vector) {
        super(new DefaultListModel());
        this.setListData(vector);
        this.init(true);
    }

    public AssistList(Object[] objectArray) {
        super(new DefaultListModel());
        this.setListData(objectArray);
        this.init(true);
    }

    public AssistList(DefaultListModel defaultListModel) {
        super(defaultListModel);
        this.init(true);
    }

    public AssistList(boolean bl) {
        super(new DefaultListModel());
        this.init(bl);
    }

    public AssistList(boolean bl, boolean bl2) {
        super(new DefaultListModel());
        this.init(bl);
        this.setSelectionRequired(bl2);
    }

    public AssistList(boolean bl, Vector vector) {
        super(new DefaultListModel());
        this.setListData(vector);
        this.init(bl);
    }

    public AssistList(boolean bl, Object[] objectArray) {
        super(new DefaultListModel());
        this.setListData(objectArray);
        this.init(bl);
    }

    public AssistList(boolean bl, DefaultListModel defaultListModel) {
        super(defaultListModel);
        this.init(bl);
    }

    protected void init(boolean bl) {
        this.valueValid = true;
        this.valuePreviouslyValid = true;
        this.required = bl;
        this.selectionRequired = true;
        this.clearDisabled = AssistManager.getClearDisabledPolicy();
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        this.setCellRenderer(new AssistListRenderer());
        this.nested = false;
        if (this.getModel() != null) {
            this.getModel().addListDataListener(this);
        }
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void setModel(ListModel listModel) {
        if (listModel instanceof DefaultListModel) {
            if (this.getModel() != null) {
                this.getModel().removeListDataListener(this);
            }
            super.setModel(listModel);
            if (this.getModel() != null) {
                this.getModel().addListDataListener(this);
            }
        }
    }

    public void setListData(Object[] objectArray) {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.clear();
        int n2 = 0;
        while (n2 < objectArray.length) {
            defaultListModel.addElement(objectArray[n2]);
            ++n2;
        }
    }

    public void setListData(Vector vector) {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.clear();
        int n2 = 0;
        while (n2 < vector.size()) {
            defaultListModel.addElement(vector.elementAt(n2));
            ++n2;
        }
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[1] = 76;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        JScrollPane jScrollPane = this.hasScrollPane();
        if (this.nested) {
            cArray[2] = 110;
            if (jScrollPane == null) {
                cArray[3] = 111;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 116;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
                    }
                } else {
                    boolean bl = this.isEnabled() ? this.hasFocus() : false;
                    cArray[5] = bl ? 102 : 118;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("Assist.nested.border", true, bl, string));
                    }
                }
            } else {
                cArray[3] = 111;
                if (this.getBorder() != null) {
                    this.setBorder(null);
                }
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        jScrollPane.setViewportBorder(AssistManager.getBorder("Assist.nested.error.border"));
                    }
                } else {
                    cArray[5] = 118;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        jScrollPane.setViewportBorder(AssistManager.getBorder("Assist.nested.border"));
                    }
                }
            }
        } else {
            cArray[2] = 115;
            if (jScrollPane == null) {
                cArray[3] = 111;
                Border border = null;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    string = String.copyValueOf(cArray);
                    border = AssistManager.getBorder("List.border", false, string);
                } else {
                    cArray[5] = 118;
                    border = AssistManager.getBorder("List.border");
                }
                if (string == null) {
                    string = String.copyValueOf(cArray);
                }
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.padBorder(0, this, border, string));
                }
            } else {
                cArray[3] = 112;
                Border border = null;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    string = String.copyValueOf(cArray);
                    border = AssistManager.getInsideBordersPolicy() ? AssistManager.getBorder("List.border", false, string) : AssistManager.getBorder("List.border");
                } else {
                    cArray[5] = 118;
                    string = String.copyValueOf(cArray);
                    border = AssistManager.getBorder("List.border");
                }
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.padBorder(0, this, border, string));
                }
            }
        }
        this.prevBorderType = string;
        this.repaint();
    }

    public JScrollPane hasScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.getParent().getParent();
        }
        return null;
    }

    public JScrollPane getScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.getParent().getParent();
        }
        return new JScrollPane(this);
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.localBeepPolicy;
        if (!bl) {
            this.localBeepPolicy = Boolean.FALSE;
        }
        this.verifyImmediately(false);
        if (!bl) {
            this.localBeepPolicy = bl2;
        }
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setSelectionRequired(boolean bl) {
        this.selectionRequired = bl;
        boolean bl2 = AssistManager.getBeepPolicy();
        if (bl) {
            AssistManager.setBeepPolicy(false);
        }
        this.verifyImmediately(false);
        if (bl) {
            AssistManager.setBeepPolicy(bl2);
        }
    }

    public boolean getSelectionRequired() {
        return this.selectionRequired;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl || this.isEnabling) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        Boolean bl2 = this.localBeepPolicy;
        if (bl) {
            this.localBeepPolicy = Boolean.FALSE;
        }
        this.setEnabled(this.isEnabled());
        if (bl) {
            this.localBeepPolicy = bl2;
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl2 != bl) {
            if (bl) {
                this.setForeground(UIManager.getColor("List.foreground"));
                this.setBackground(UIManager.getColor("List.background"));
                if (this.origRenderer != null) {
                    this.setCellRenderer(this.origRenderer);
                }
            } else if (this.clearDisabled) {
                Color color = null;
                color = AssistManager.getDefaultColorsPolicy() ? UIManager.getColor("List.background") : UIManager.getColor("control");
                this.setForeground(color);
                this.setBackground(color);
                if (!(this.getCellRenderer() instanceof AssistBlankRenderer)) {
                    this.origRenderer = this.getCellRenderer();
                }
                if (this.blankRenderer == null) {
                    this.blankRenderer = new AssistBlankRenderer();
                }
                this.setCellRenderer(this.blankRenderer);
            } else {
                if (AssistManager.getDefaultColorsPolicy()) {
                    this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    this.setBackground(UIManager.getColor("List.background"));
                } else {
                    this.setForeground(UIManager.getColor("List.foreground"));
                    this.setBackground(UIManager.getColor("control"));
                }
                if (this.origRenderer != null) {
                    this.setCellRenderer(this.origRenderer);
                }
            }
            this.verifyImmediately(false);
            this.setBorder();
        }
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistList.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        this.verifyImmediately(false);
        this.valuePreviouslyValid = this.valueValid;
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistList.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean isValueValid() {
        return this.valueValid;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.verify(bl, false);
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public void verify(boolean bl, boolean bl2) {
        if (this.isEnabled() && (this.required && this.getModel().getSize() == 0 || this.selectionRequired && this.getSelectedIndex() == -1)) {
            if (this.valueValid && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.valueValid = false;
        } else {
            this.valueValid = true;
        }
        this.setBorder();
        this.fireValidityChanged();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        Boolean bl = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        this.verify(false);
        this.localBeepPolicy = bl;
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.getModel().getSize() == 0) {
            this.verify(false);
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.verify(false);
    }

    protected void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (this.valuePreviouslyValid != this.valueValid && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistList.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.valueValid;
    }

    protected void fireSelectionValueChanged(int n2, int n3, boolean bl) {
        super.fireSelectionValueChanged(n2, n3, bl);
        this.verify(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

