/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistEditorKit;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AssistField
extends JTextField
implements AssistComponent,
DocumentListener,
ActionListener,
CellExpanderComponent,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean required;
    protected boolean clearDisabled;
    protected boolean isEnabling;
    protected boolean clipText;
    protected boolean clipped;
    protected boolean nested;
    protected Boolean localBeepPolicy;
    protected boolean allowWhitespace;
    protected boolean unlinkEditableEnabled;
    protected boolean isDottedTextField;
    protected boolean selectWhenFocusGained;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected boolean valueValid;
    protected boolean valuePreviouslyValid;
    protected Timer verifyTimer;
    protected int delay = AssistManager.getVerifyDelayPolicy();
    protected String prevBorderType;
    protected boolean expandField = false;
    private CellExpander cellExpander;
    private Point cep;
    protected AccessibleContext originalContext;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;

    public AssistField() {
        this(true, null, 0, false);
    }

    public AssistField(String string) {
        this(true, string, 0, false);
    }

    public AssistField(int n2) {
        this(true, null, n2, false);
    }

    public AssistField(String string, int n2) {
        this(true, string, n2, false);
    }

    public AssistField(Document document, String string, int n2) {
        this(true, string, n2, false);
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
    }

    public AssistField(boolean bl) {
        this(bl, null, 0, false);
    }

    public AssistField(boolean bl, String string) {
        this(bl, string, 0, false);
    }

    public AssistField(boolean bl, int n2) {
        this(bl, null, n2, false);
    }

    public AssistField(boolean bl, String string, int n2) {
        this(bl, string, n2, false);
    }

    public AssistField(boolean bl, boolean bl2, String string, int n2) {
        this(bl, string, n2, false);
        if (bl2) {
            this.isDottedTextField = bl2;
            this.setNestedBorders(true);
        }
    }

    public AssistField(boolean bl, String string, int n2, boolean bl2) {
        super(string, n2);
        if (this.delay < 1) {
            this.delay = 1;
        }
        this.valueValid = true;
        this.valuePreviouslyValid = true;
        this.nested = false;
        if (string == null || string.length() == 0) {
            this.valueValid = false;
        }
        this.setBorder();
        this.clipText = bl2;
        this.clipped = false;
        this.clearDisabled = AssistManager.getClearDisabledPolicy();
        this.allowWhitespace = false;
        this.selectWhenFocusGained = true;
        if (this.expandField) {
            CellExpanderManager.sharedInstance().registerComponent(this);
            this.cep = new Point(0, 0);
        }
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        this.setRequired(bl);
        this.unlinkEditableEnabled = false;
    }

    public String getUIClassID() {
        return "AssistFieldUI";
    }

    public void setAllowWhitespace(boolean bl) {
        this.allowWhitespace = bl;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setSelectWhenFocusGained(boolean bl) {
        this.selectWhenFocusGained = bl;
    }

    public boolean getSelectWhenFocusGained() {
        return this.selectWhenFocusGained;
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void updateRequired() {
        this.valueValid = false;
        this.setBorder();
        this.selectAll();
        this.fireValidityChanged();
    }

    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        AccessibleContext accessibleContext = null;
        if (this.originalContext != null) {
            accessibleContext = this.accessibleContext;
            this.accessibleContext = this.originalContext;
        }
        super.setDocument(document);
        if (accessibleContext != null) {
            this.accessibleContext = accessibleContext;
        }
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[1] = 70;
        cArray[3] = 111;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        Border border = null;
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistField.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            cArray[2] = 116;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("Assist.nested.error.border");
            } else {
                boolean bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
                cArray[5] = bl ? 102 : 118;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("Assist.nested.border", true, bl, string);
            }
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(border);
            }
        } else if (this.nested) {
            cArray[2] = 110;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                border = AssistManager.getBorder("Assist.nested.error.border");
            } else {
                cArray[5] = 118;
                border = AssistManager.getBorder("Assist.nested.border");
            }
            string = String.copyValueOf(cArray);
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(2, this, border, string));
            }
        } else {
            cArray[2] = 115;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 107;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("TextField.border", false, string);
            } else {
                cArray[5] = 118;
                string = String.copyValueOf(cArray);
                border = AssistManager.getBorder("TextField.border");
            }
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(this, border, string));
            }
        }
        this.prevBorderType = string;
        this.repaint();
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.verifyImmediately(false);
        if (bl2 == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl2);
        }
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        Boolean bl2 = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.setEnabled(this.isEnabled());
        if (bl2 == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl2);
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.unlinkEditableEnabled = true;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (!this.unlinkEditableEnabled) {
            super.setEditable(bl);
        }
        if (bl2 != bl || this.isEnabling) {
            int n2 = this.getCaretPosition();
            if (n2 >= 0 && n2 <= this.getText().length()) {
                this.setCaretPosition(n2);
            }
            if (bl) {
                this.setForeground(UIManager.getColor("TextField.foreground"));
                this.setBackground(UIManager.getColor("TextField.background"));
                this.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
                this.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
            } else if (this.clearDisabled) {
                Color color = null;
                color = AssistManager.getDefaultColorsPolicy() ? UIManager.getColor("TextField.background") : UIManager.getColor("control");
                this.setBackground(color);
                this.setForeground(color);
                this.setSelectionColor(color);
                this.setSelectedTextColor(color);
                this.setDisabledTextColor(color);
            } else {
                if (AssistManager.getDefaultColorsPolicy()) {
                    this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    this.setBackground(UIManager.getColor("TextField.background"));
                    this.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
                } else {
                    this.setForeground(UIManager.getColor("TextField.foreground"));
                    this.setBackground(UIManager.getColor("control"));
                    this.setDisabledTextColor(UIManager.getColor("TextField.foreground"));
                }
                this.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
                this.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
            }
            this.verifyImmediately(false);
        }
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void setText(String string) {
        Boolean bl = this.getBeepPolicy();
        this.setBeepPolicy(false);
        super.setText(AssistManager.blankWhitespaces(string));
        this.setCaretPosition(this.getText().length());
        if (bl == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl);
        }
    }

    public void replaceSelection(String string) {
        super.replaceSelection(AssistManager.blankWhitespaces(string));
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistField.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        Boolean bl = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.verifyImmediately(false);
        if (bl == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl);
        }
        this.valuePreviouslyValid = this.valueValid;
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistField.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean isValueValid() {
        if (this.verifyTimer != null && this.verifyTimer.isRunning()) {
            this.verifyTimer.stop();
            this.verifyImmediately(false);
        }
        return this.valueValid;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.verify(bl, false);
    }

    public void verify(boolean bl, boolean bl2) {
        String string = this.getText();
        if (!this.allowWhitespace) {
            string = string.trim();
        }
        if (this.isEnabled() && this.getRequired() && string.length() == 0) {
            if (!bl2 && this.valueValid && AssistManager.getErrorBordersPolicy() && (this.getBeepPolicy() != null ? this.getBeepPolicy() : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.valueValid = false;
        } else {
            this.valueValid = true;
        }
        if (!bl2) {
            this.setBorder();
            this.fireValidityChanged();
        }
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public void setExpandField(boolean bl) {
        if (bl && !this.expandField) {
            CellExpanderManager.sharedInstance().registerComponent(this);
            this.cep = new Point(0, 0);
        } else if (!bl && this.expandField) {
            CellExpanderManager.sharedInstance().unregisterComponent(this);
        }
        this.expandField = bl;
    }

    public boolean getExpandField() {
        return this.expandField;
    }

    public void paste() {
        String string;
        Clipboard clipboard;
        if (this.isEditable() && this.isEnabled() && (clipboard = this.getToolkit().getSystemClipboard()) != null && AssistEditorKit.canPaste(this) && (string = AssistEditorKit.getPastable(this)) != null) {
            this.replaceSelection(string);
        }
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        if (!this.expandField || this.hasFocus() || this.getPreferredSize().width <= this.getSize().width) {
            return null;
        }
        return this.cep;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
        }
        this.cellExpander.setForeground(this.getForeground());
        this.cellExpander.setBackground(this.getBackground());
        Border border = this.getBorder();
        this.cellExpander.setBorder(BorderFactory.createCompoundBorder(AssistManager.getBorder("Cell.expansion.border"), border));
        Dimension dimension = this.getSize();
        Insets insets = this.cellExpander.getInsets();
        LineMetrics lineMetrics = AssistManager.getLineMetrics(this.getText(), this.cellExpander, this.cellExpander.getFont());
        int n2 = Math.round(lineMetrics.getHeight());
        Point point = new Point(0, 0);
        point.x -= insets.left;
        point.y = Math.round(dimension.height / 2) - Math.round(n2 / 2) - insets.top;
        this.cellExpander.putClientProperty("translate.point", point);
        this.cellExpander.setFont(this.getFont());
        this.cellExpander.setTipText(CellExpanderManager.untag(this.getText()));
        this.cellExpander.setPreferredSize(this.getPreferredSize());
        return this.cellExpander;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.verifyTimer) {
            this.verifyImmediately(this.verifyTimer.getDelay() == this.delay);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.clipped) {
            return;
        }
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.verify(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.clipped) {
            return;
        }
        if (this.delay > 0 && this.verifyTimer == null) {
            this.verifyTimer = new Timer(this.delay, this);
            this.verifyTimer.setInitialDelay(0);
            this.verifyTimer.setRepeats(false);
        }
        this.verifyTimer.setDelay(this.delay);
        this.verifyTimer.restart();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (this.valuePreviouslyValid != this.valueValid && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistField.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.valueValid;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.repaint();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistField.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            if (n2 == 401 && (n3 == 9 || keyEvent.getKeyChar() == '\t' || n3 == 27)) {
                AssistManager.redirectKeyEvent(keyEvent, jTable);
            }
        } else if (n2 == 402) {
            if (n3 == 10) {
                JRootPane jRootPane;
                JButton jButton;
                super.processKeyEvent(keyEvent);
                if (!keyEvent.isConsumed() && (jButton = (jRootPane = SwingUtilities.getRootPane((JComponent)keyEvent.getSource())).getDefaultButton()) != null) {
                    jButton.getModel().setPressed(false);
                    keyEvent.consume();
                }
            }
        } else if (n2 == 401 && n3 == 10) {
            JRootPane jRootPane;
            JButton jButton;
            super.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed() && (jButton = (jRootPane = SwingUtilities.getRootPane((JComponent)keyEvent.getSource())).getDefaultButton()) != null) {
                ButtonModel buttonModel = jButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public AssistField clone(String string) {
        return this.getRenderer(false, string);
    }

    public AssistField getRenderer(boolean bl, String string) {
        AssistField assistField = new AssistField(this.getRequired(), string, this.getColumns(), bl);
        assistField.setRequired(this.getRequired());
        assistField.setClearDisabled(this.getClearDisabled());
        assistField.setBorder(this.getBorder());
        assistField.setNestedBorders(this.nested);
        assistField.setBeepPolicy(false);
        assistField.verifyImmediately(false);
        Boolean bl2 = this.getBeepPolicy();
        if (bl2 == null) {
            assistField.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            assistField.setBeepPolicy(bl2);
        }
        return assistField;
    }

    public void setPaintClipped(boolean bl) {
        this.clipText = bl;
    }

    public boolean getPaintClipped() {
        return this.clipText;
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        if (this.accessibleContext instanceof JTextComponent.AccessibleJTextComponent) {
            this.originalContext = this.accessibleContext;
        }
        this.accessibleContext = accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

