/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistArea;
import com.ibm.db2.tools.common.AssistField;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.ComponentGroup;
import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.AssistRole;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import com.ibm.db2.tools.common.support.EllipsisDialog;
import com.ibm.db2.tools.common.support.EllipsisIcon;
import com.ibm.db2.tools.common.support.MinimalButtonBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.LineMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class AssistEllipsis
extends JPanel
implements AssistComponent,
AssistListener,
ComponentListener,
ActionListener,
CellExpanderComponent,
PropertyChangeListener,
UndoableEditListener,
FocusListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected AssistField textField;
    protected AssistButton ellipsisButton;
    protected EllipsisIcon icon;
    protected ComponentGroup group;
    protected Object cellValue;
    protected String editTitleStem;
    protected String okText;
    protected String cancelText;
    protected StringBuffer editTitle;
    protected EllipsisDialog ellipsisDialog;
    protected boolean nested;
    protected String prevBorderType;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected String selectItem = CmStringPool.get(94);
    protected boolean expandField = false;
    private CellExpander cellExpander;
    private Point cep;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;

    public AssistEllipsis() {
        this(true, "", null);
    }

    public AssistEllipsis(String string) {
        this(true, string, null);
    }

    public AssistEllipsis(EllipsisDialog ellipsisDialog) {
        this(true, "", ellipsisDialog);
    }

    public AssistEllipsis(String string, EllipsisDialog ellipsisDialog) {
        this(true, new AssistField(), ellipsisDialog, true);
        this.editTitleStem = string;
    }

    public AssistEllipsis(AssistField assistField, EllipsisDialog ellipsisDialog, boolean bl) {
        this(true, assistField, ellipsisDialog, bl);
    }

    public AssistEllipsis(boolean bl) {
        this(bl, "", null);
    }

    public AssistEllipsis(boolean bl, String string) {
        this(bl, string, null);
    }

    public AssistEllipsis(boolean bl, EllipsisDialog ellipsisDialog) {
        this(bl, "", ellipsisDialog);
    }

    public AssistEllipsis(boolean bl, String string, EllipsisDialog ellipsisDialog) {
        this(bl, new AssistField(bl), ellipsisDialog, true);
        this.editTitleStem = string;
        if (this.icon != null) {
            this.icon.setDescription(string);
        }
    }

    public AssistEllipsis(boolean bl, AssistField assistField, EllipsisDialog ellipsisDialog, boolean bl2) {
        this.editTitle = new StringBuffer();
        this.ellipsisDialog = ellipsisDialog;
        this.setLayout(new GridBagLayout());
        this.textField = assistField;
        AccessibleAssistEllipsis accessibleAssistEllipsis = (AccessibleAssistEllipsis)this.getAccessibleContext();
        accessibleAssistEllipsis.setTextFieldContext(this.textField.getAccessibleContext());
        this.textField.setAccessibleContext(accessibleAssistEllipsis);
        this.textField.setPaintClipped(true);
        this.textField.setNestedBorders(true);
        this.setBackground(assistField.getBackground());
        this.textField.setRequired(bl);
        if (bl2) {
            this.icon = new EllipsisIcon();
            this.ellipsisButton = new AssistButton((Icon)this.icon);
            this.ellipsisButton.setBorder(MinimalButtonBorder.getInstance());
            this.ellipsisButton.setOpaque(true);
            this.ellipsisButton.addActionListener(this);
        }
        this.layoutKids();
        this.nested = false;
        this.setBorder();
        this.assistListeners = new EventListenerList();
        if (this.textField.isEditable()) {
            this.textField.getDocument().addUndoableEditListener(this);
        }
        this.addComponentListener(this);
        this.addPropertyChangeListener("labeledBy", this);
        this.addPropertyChangeListener("UAKey", this);
        this.textField.addAssistListener(this);
        this.textField.addFocusListener(this);
    }

    protected void layoutKids() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.textField, gridBagConstraints);
        if (this.ellipsisButton != null) {
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 1, 0, 0);
            this.add((Component)this.ellipsisButton, gridBagConstraints);
            if (this.group == null) {
                this.group = new ComponentGroup();
            } else {
                Enumeration enumeration = this.group.getElements();
                while (enumeration.hasMoreElements()) {
                    this.group.remove((JComponent)enumeration.nextElement());
                }
            }
            this.group.add(this.textField);
            this.group.add(this.ellipsisButton);
        }
    }

    public void setBeepPolicy(boolean bl) {
        this.textField.setBeepPolicy(bl);
    }

    public Boolean getBeepPolicy() {
        return this.textField.getBeepPolicy();
    }

    public void resetBeepPolicy() {
        this.textField.resetBeepPolicy();
    }

    public void setTitle(String string) {
        this.editTitle.setLength(0);
        if (this.editTitleStem != null) {
            this.editTitle.append(this.editTitleStem);
        }
        if (string != null) {
            if (this.editTitle.length() > 0) {
                this.editTitle.append(" - ");
            }
            this.editTitle.append(string);
        }
        if (this.icon != null) {
            this.icon.setDescription(this.editTitle.toString());
        }
    }

    public void setOKText(String string) {
        this.okText = string;
    }

    public void setCancelText(String string) {
        this.cancelText = string;
    }

    public int getColumns() {
        return this.textField.getColumns();
    }

    public void setColumns(int n2) {
        this.textField.setColumns(n2);
    }

    public String getText() {
        return this.textField.getText();
    }

    public Object getValue() {
        return this.cellValue;
    }

    public void setValue(Object object) {
        this.cellValue = object;
        if (this.textField.isEditable()) {
            this.textField.getDocument().removeUndoableEditListener(this);
        }
        if (this.ellipsisDialog == null || this.ellipsisDialog instanceof AreaDialog) {
            this.textField.setText(AssistManager.blankWhitespaces(object == null ? "" : object.toString()));
        } else {
            this.textField.setText(this.ellipsisDialog.format(object));
        }
        if (this.textField.isEditable()) {
            this.textField.getDocument().addUndoableEditListener(this);
        }
    }

    public void updateRequired() {
        if (this.getRequired()) {
            boolean bl = this.isValueValid();
            EventListenerList eventListenerList = this.assistListeners;
            this.assistListeners = null;
            this.textField.setText(this.selectItem);
            this.textField.updateRequired();
            this.assistListeners = eventListenerList;
            if (bl) {
                this.fireValidityChanged();
            }
        }
    }

    public void setRequired(boolean bl) {
        this.textField.setRequired(bl);
    }

    public boolean getRequired() {
        return this.textField.getRequired();
    }

    public void setClearDisabled(boolean bl) {
        this.textField.setClearDisabled(bl);
    }

    public boolean getClearDisabled() {
        return this.textField.getClearDisabled();
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[3] = 111;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        if (this.nested) {
            cArray[2] = 116;
            if (this.textField.isEditable() && !this.textField.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                string = String.copyValueOf(cArray);
                if (this.textField.getBorder() != null) {
                    this.textField.setBorder(null);
                }
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
                }
            } else {
                if (this.getBorder() != null) {
                    this.setBorder(null);
                }
                boolean bl = !this.textField.isEnabled() || !this.textField.isEditable() ? false : this.hasFocus();
                cArray[5] = bl ? 102 : 118;
                string = String.copyValueOf(cArray);
                if (!string.equals(this.prevBorderType)) {
                    this.textField.setBorder(AssistManager.getBorder("Assist.nested.border", true, bl, string));
                }
            }
        } else {
            cArray[2] = 115;
            if (this.textField.isEditable() && !this.textField.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                if (AssistManager.getInsideBordersPolicy()) {
                    cArray[3] = 105;
                    if (!AssistManager.getBorder("TextField.border").equals(this.getBorder())) {
                        this.setBorder(AssistManager.getBorder("TextField.border"));
                    }
                    if (AssistManager.getThinBordersPolicy()) {
                        cArray[6] = 116;
                        string = String.copyValueOf(cArray);
                        if (!string.equals(this.prevBorderType)) {
                            this.textField.setBorder(AssistManager.padBorder(2, this.textField, AssistManager.getBorder("Assist.nested.error.border"), string));
                        }
                    } else {
                        cArray[6] = 107;
                        string = String.copyValueOf(cArray);
                        if (!string.equals(this.prevBorderType)) {
                            this.textField.setBorder(AssistManager.padBorder(2, this.textField, AssistManager.getBorder("Assist.error.border"), string));
                        }
                    }
                } else {
                    cArray[3] = 111;
                    cArray[6] = 107;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("TextField.border", false, string));
                        Insets insets = this.getBorder().getBorderInsets(this);
                        this.textField.setBorder(AssistManager.padBorder(2 - insets.left, this, null, string));
                    }
                }
            } else {
                cArray[5] = 118;
                string = String.copyValueOf(cArray);
                if (!string.equals(this.prevBorderType)) {
                    this.setBorder(AssistManager.getBorder("TextField.border"));
                    this.textField.setBorder(AssistManager.padBorder(2, this, null, string));
                }
            }
        }
        this.prevBorderType = string;
        this.repaint();
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        if (this.ellipsisButton != null) {
            this.ellipsisButton.setEnabled(bl);
        }
        this.setBorder();
    }

    public void setEditable(boolean bl) {
        if (this.textField.isEditable()) {
            this.textField.getDocument().removeUndoableEditListener(this);
        }
        this.textField.setEditable(bl);
        if (bl) {
            this.textField.getDocument().addUndoableEditListener(this);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textField != null) {
            this.textField.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
    }

    public void setTextField(AssistField assistField) {
        this.textField.removeAssistListener(this);
        if (this.textField.isEditable()) {
            this.textField.getDocument().removeUndoableEditListener(this);
        }
        this.textField = assistField;
        AccessibleAssistEllipsis accessibleAssistEllipsis = (AccessibleAssistEllipsis)this.getAccessibleContext();
        accessibleAssistEllipsis.setTextFieldContext(this.textField.getAccessibleContext());
        this.textField.setAccessibleContext(accessibleAssistEllipsis);
        this.textField.addAssistListener(this);
        if (this.textField.isEditable()) {
            this.textField.getDocument().addUndoableEditListener(this);
        }
        this.textField.setPaintClipped(true);
        this.textField.setNestedBorders(true);
        this.layoutKids();
    }

    public AssistField getTextField() {
        return this.textField;
    }

    public JButton getButton() {
        return this.ellipsisButton;
    }

    public EllipsisDialog getDefaultDialog() {
        Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = AssistEllipsis.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
        Dimension dimension = new Dimension(250, 150);
        return new AreaDialog((JFrame)container, this.editTitle.toString(), dimension);
    }

    public void setExpandField(boolean bl) {
        if (bl && !this.expandField) {
            CellExpanderManager.sharedInstance().registerComponent(this);
        } else if (!bl && this.expandField) {
            CellExpanderManager.sharedInstance().unregisterComponent(this);
        }
        this.expandField = bl;
    }

    public boolean getExpandField() {
        return this.expandField;
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        if (!this.expandField || this.textField.hasFocus() && this.textField.isEditable()) {
            return null;
        }
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
            this.cep = new Point(0, 0);
        }
        int n2 = this.cellExpander.getLineWidth(this.textField.getText(), this.textField.getFont());
        Insets insets = this.getInsets();
        if (n2 + (this.textField.isEditable() ? 2 : 0) <= this.getWidthForText() - insets.left - insets.right + 1) {
            return null;
        }
        return this.cep;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
        }
        this.cellExpander.setForeground(this.getForeground());
        this.cellExpander.setBackground(this.getBackground());
        CompoundBorder compoundBorder = null;
        compoundBorder = this.textField.isEditable() && !this.textField.isValueValid() ? BorderFactory.createCompoundBorder(this.getBorder(), this.textField.getBorder()) : BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getColor("Table.gridColor")), this.getBorder());
        this.cellExpander.setBorder(compoundBorder);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Insets insets2 = this.cellExpander.getInsets();
        LineMetrics lineMetrics = AssistManager.getLineMetrics(this.textField.getText(), this.cellExpander, this.cellExpander.getFont());
        int n2 = Math.round(lineMetrics.getHeight());
        Point point = new Point(0, 0);
        point.x -= insets2.left;
        point.y = Math.round(dimension.height / 2) - Math.round(n2 / 2) - insets2.top;
        point.x = this.textField.isEditable() ? (point.x += 2) : --point.x;
        this.cellExpander.putClientProperty("translate.point", point);
        this.cellExpander.setFont(this.getFont());
        this.cellExpander.setTipText(CellExpanderManager.untag(this.textField.getText()));
        int n3 = this.getWidthForText() - insets.left - insets.right - 4;
        this.cellExpander.setWidth(n3);
        Dimension dimension2 = this.cellExpander.getPreferredSize();
        dimension2.width = n3;
        if (point.y > 0) {
            dimension2.height += point.y;
        }
        this.cellExpander.setPreferredSize(dimension2);
        this.cellExpander.setSize(dimension2);
        return this.cellExpander;
    }

    protected int getWidthForText() {
        return this.getSize().width - this.ellipsisButton.getSize().width;
    }

    public EllipsisDialog getDialog() {
        if (this.ellipsisDialog == null) {
            this.ellipsisDialog = this.getDefaultDialog();
        }
        return this.ellipsisDialog;
    }

    public AssistEllipsis clone(String string) {
        return this.getRenderer(true, string);
    }

    public AssistEllipsis getRenderer(boolean bl, String string) {
        AssistEllipsis assistEllipsis = null;
        assistEllipsis = bl ? new AssistEllipsis(this.getTextField().clone(string), this.getDialog(), bl) : new AssistEllipsis(this.getTextField().getRenderer(true, string), this.getDialog(), bl);
        assistEllipsis.setBorder(this.getBorder());
        assistEllipsis.setNestedBorders(true);
        return assistEllipsis;
    }

    public void putClientProperties(Object object, Object object2) {
        super.putClientProperty(object, object2);
        this.textField.putClientProperty(object, object2);
        this.ellipsisButton.putClientProperty(object, object2);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.ellipsisButton != null) {
            this.ellipsisButton.addActionListener(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.ellipsisButton != null) {
            this.ellipsisButton.removeActionListener(actionListener);
        }
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (this.textField != null) {
            this.textField.addFocusListener(focusListener);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (this.textField != null) {
            this.textField.removeFocusListener(focusListener);
        }
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (this.textField != null) {
            this.textField.addKeyListener(keyListener);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (this.textField != null) {
            this.textField.removeKeyListener(keyListener);
        }
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.textField != null) {
            this.textField.addMouseListener(mouseListener);
        }
        if (this.ellipsisButton != null) {
            this.ellipsisButton.addMouseListener(mouseListener);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (this.textField != null) {
            this.textField.removeMouseListener(mouseListener);
        }
        if (this.ellipsisButton != null) {
            this.ellipsisButton.removeMouseListener(mouseListener);
        }
    }

    public void requestFocus() {
        if (this.textField.isEditable()) {
            this.textField.requestFocus();
        } else {
            this.ellipsisButton.requestFocus();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = this.getValue();
        if (object != null && object.equals(this.selectItem)) {
            this.textField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void validityChanged(AssistEvent assistEvent) {
        if (!AssistManager.getInsideBordersPolicy()) {
            this.setBorder();
        }
        this.fireValidityChanged();
    }

    public void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistEllipsis.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this) {
            Rectangle rectangle = this.textField.getBounds();
            rectangle.height = this.getBounds().height;
            rectangle.width = this.getBounds().width;
            if (this.ellipsisButton != null) {
                rectangle.width -= this.ellipsisButton.getBounds().width;
            }
            this.textField.setBounds(rectangle);
            this.doLayout();
            ((JPanel)object).repaint();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ellipsisButton) {
            if (this.ellipsisDialog == null) {
                this.ellipsisDialog = this.getDefaultDialog();
            }
            this.ellipsisDialog.setTitle(this.editTitle.toString());
            if (this.cellValue != null && !this.cellValue.equals(this.selectItem)) {
                this.ellipsisDialog.setValue(this.cellValue);
            }
            Dimension dimension = this.ellipsisButton.getSize();
            Point point = this.ellipsisButton.getLocation();
            SwingUtilities.convertPointToScreen(point, this);
            Point point2 = new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
            this.ellipsisDialog.setVisible(point2, this.textField);
            Object object2 = this.ellipsisDialog.getValue();
            if (object2 != null) {
                this.setValue(object2);
            }
            this.textField.requestFocus();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this) {
            if (propertyChangeEvent.getPropertyName().equals("labeledBy")) {
                Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.getAccessibleContext().setAccessibleName(jLabel.getText());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("UAKey")) {
                Object object = propertyChangeEvent.getNewValue();
                this.textField.putClientProperty("UAKey", object);
                this.ellipsisButton.putClientProperty("UAKey", object + "_button");
            }
        }
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        String string = this.textField.getText();
        if (string.length() > 0) {
            Object object;
            if (this.ellipsisDialog == null) {
                this.ellipsisDialog = this.getDefaultDialog();
            }
            if ((object = this.ellipsisDialog.parse(string)) != null) {
                this.cellValue = object;
            }
        } else {
            this.cellValue = null;
        }
    }

    public void setContext(Object object) {
        this.textField.setContext(object);
    }

    public Object getContext() {
        return this.textField.getContext();
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistEllipsis.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        Boolean bl = this.textField.getBeepPolicy();
        this.textField.setBeepPolicy(false);
        this.textField.verifyImmediately(false);
        if (bl == null) {
            this.textField.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.textField.setBeepPolicy(bl);
        }
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistEllipsis.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean isValueValid() {
        return this.textField.isValueValid();
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.textField.verify(bl);
        this.setBorder();
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAssistEllipsis();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AssistButton
    extends JButton {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public AssistButton(Icon icon) {
            super(icon);
            AccessibleAssistEllipsis accessibleAssistEllipsis = (AccessibleAssistEllipsis)AssistEllipsis.this.getAccessibleContext();
            accessibleAssistEllipsis.setAssistButtonContext(this.getAccessibleContext());
            this.setAccessibleContext(accessibleAssistEllipsis);
        }

        public void setAccessibleContext(AccessibleContext accessibleContext) {
            this.accessibleContext = accessibleContext;
        }
    }

    protected class AccessibleAssistEllipsis
    extends JComponent.AccessibleJComponent {
        private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected AccessibleContext textFieldContext;
        protected AccessibleContext assistButtonContext;

        public AccessibleAssistEllipsis() {
            super(AssistEllipsis.this);
        }

        public void setTextFieldContext(AccessibleContext accessibleContext) {
            if (accessibleContext != this) {
                this.textFieldContext = accessibleContext;
            }
        }

        public void setAssistButtonContext(AccessibleContext accessibleContext) {
            if (accessibleContext != this) {
                this.assistButtonContext = accessibleContext;
            }
        }

        public String getAccessibleName() {
            if (this.textFieldContext != null && AssistEllipsis.this.textField.hasFocus()) {
                return this.textFieldContext.getAccessibleName();
            }
            if (this.assistButtonContext != null && AssistEllipsis.this.ellipsisButton.hasFocus()) {
                return this.assistButtonContext.getAccessibleName();
            }
            return super.getAccessibleName();
        }

        public void setAccessibleName(String string) {
            super.setAccessibleName(string);
            if (this.textFieldContext != null) {
                this.textFieldContext.setAccessibleName(string);
            }
            if (this.assistButtonContext != null) {
                this.assistButtonContext.setAccessibleName(string + "...");
            }
        }

        public String getAccessibleDescription() {
            if (this.textFieldContext != null && AssistEllipsis.this.textField.hasFocus()) {
                return this.textFieldContext.getAccessibleDescription();
            }
            if (this.assistButtonContext != null && AssistEllipsis.this.ellipsisButton.hasFocus()) {
                return this.assistButtonContext.getAccessibleDescription();
            }
            return super.getAccessibleDescription();
        }

        public AccessibleRole getAccessibleRole() {
            return AssistRole.ELLIPSIS_EDITOR;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            return this.assistButtonContext.getAccessibleIcon();
        }

        public void setAccessibleParent(Accessible accessible) {
            if (accessible != AssistEllipsis.this) {
                super.setAccessibleParent(accessible);
            }
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public AccessibleAction getAccessibleAction() {
            return this.assistButtonContext.getAccessibleAction();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            AccessibleStateSet accessibleStateSet2 = this.textFieldContext.getAccessibleStateSet();
            AccessibleState[] accessibleStateArray = accessibleStateSet2.toArray();
            int n2 = 0;
            while (n2 < accessibleStateArray.length) {
                accessibleStateSet.add(accessibleStateArray[n2]);
                ++n2;
            }
            accessibleStateSet2 = this.assistButtonContext.getAccessibleStateSet();
            accessibleStateArray = accessibleStateSet2.toArray();
            int n3 = 0;
            while (n3 < accessibleStateArray.length) {
                accessibleStateSet.add(accessibleStateArray[n3]);
                ++n3;
            }
            return accessibleStateSet;
        }

        public AccessibleText getAccessibleText() {
            return this.textFieldContext.getAccessibleText();
        }
    }

    public class AreaDialog
    extends JDialog
    implements EllipsisDialog,
    ActionListener,
    WindowListener {
        private final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        protected AssistArea textArea;
        protected JButton bOK;
        protected JButton bCancel;
        protected String value;

        public AreaDialog(JFrame jFrame, String string, Dimension dimension) {
            super(jFrame, string, true);
            Serializable serializable;
            Font font = super.getFont();
            if (font != null) {
                serializable = super.getFontMetrics(font);
                int n2 = serializable.stringWidth(string);
                if (n2 + 70 > dimension.width) {
                    super.setSize(n2 + 70, dimension.height);
                } else {
                    super.setSize(dimension);
                }
            } else {
                super.setSize(dimension);
            }
            this.getContentPane().setLayout(new GridBagLayout());
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).insets = new Insets(5, 5, 5, 5);
            ((GridBagConstraints)serializable).anchor = 18;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 1.0;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).gridheight = 1;
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).gridy = 0;
            ((GridBagConstraints)serializable).fill = 1;
            this.textArea = new AssistArea();
            this.textArea.setLineWrap(true);
            this.getContentPane().add((Component)this.textArea.getScrollPane(), serializable);
            if (AssistEllipsis.this.okText == null) {
                AssistEllipsis.this.okText = CmStringPool.get(27);
            }
            this.bOK = new JButton(AssistEllipsis.this.okText);
            super.getRootPane().setDefaultButton(this.bOK);
            if (AssistEllipsis.this.cancelText == null) {
                AssistEllipsis.this.cancelText = CmStringPool.get(24);
            }
            this.bCancel = new JButton(AssistEllipsis.this.cancelText);
            this.bCancel.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            Dimension dimension2 = this.bOK.getPreferredSize();
            Dimension dimension3 = this.bCancel.getPreferredSize();
            if (dimension2.width < dimension3.width) {
                this.bOK.setPreferredSize(dimension3);
            } else {
                this.bCancel.setPreferredSize(dimension2);
            }
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(this.bOK);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.bCancel);
            ((GridBagConstraints)serializable).insets = new Insets(0, 5, 5, 5);
            ((GridBagConstraints)serializable).weightx = 0.0;
            ((GridBagConstraints)serializable).weighty = 0.0;
            ((GridBagConstraints)serializable).gridy = 1;
            ((GridBagConstraints)serializable).fill = 2;
            this.getContentPane().add((Component)box, serializable);
            ComponentGroup componentGroup = new ComponentGroup();
            componentGroup.add(this.bOK, true);
            componentGroup.add(this.bCancel);
            this.bOK.addActionListener(this);
            this.bCancel.addActionListener(this);
            this.addWindowListener(this);
        }

        public void setVisible(Point point, AssistField assistField) {
            this.value = null;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = super.getSize();
            if (point.x + dimension2.width > dimension.width) {
                point.x = dimension.width - dimension2.width;
            }
            if (point.y + dimension2.height > dimension.height) {
                point.y = dimension.height - dimension2.height;
            }
            super.setLocation(point);
            this.textArea.setRequired(assistField.getRequired());
            super.setVisible(true);
        }

        public AssistArea getArea() {
            return this.textArea;
        }

        public Object parse(String string) {
            return string;
        }

        public String format(Object object) {
            return AssistManager.blankWhitespaces(object == null ? "" : object.toString());
        }

        public void setValue(Object object) {
            this.textArea.setText(object == null ? "" : object.toString());
        }

        public Object getValue() {
            return this.value;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.bOK) {
                this.value = this.textArea.getText();
            } else if (object == this.bCancel) {
                this.value = null;
            }
            super.setVisible(false);
        }

        public void windowOpened(WindowEvent windowEvent) {
            this.textArea.requestFocus();
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            super.setVisible(false);
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

