/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.AssistTable;
import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.AssistBlankRenderer;
import com.ibm.db2.tools.common.support.AssistComboBoxEditor;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistManager;
import com.ibm.db2.tools.common.support.CellExpander;
import com.ibm.db2.tools.common.support.CellExpanderComponent;
import com.ibm.db2.tools.common.support.CellExpanderManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.text.JTextComponent;

public class AssistCombo
extends JComboBox
implements Serializable,
AssistComponent,
DocumentListener,
ActionListener,
ItemListener,
FocusListener,
KeyListener,
CellExpanderComponent {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean required;
    protected boolean clearDisabled;
    protected boolean isEnabling;
    protected boolean nested;
    protected Boolean localBeepPolicy;
    protected boolean allowWhitespace;
    protected int minHeight;
    protected int minWidth = 0;
    protected boolean itemSelected = false;
    protected boolean firstRemoveUpdate = true;
    protected boolean suppressItemEvent = false;
    protected Object selectItem = CmStringPool.get(94);
    protected ListCellRenderer origRenderer;
    protected ListCellRenderer blankRenderer;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected EventListenerList itemListeners;
    protected AssistEvent assistEvent;
    protected boolean valueValid;
    protected boolean valuePreviouslyValid;
    protected Timer verifyTimer;
    protected String prevBorderType;
    protected boolean expandField = false;
    private CellExpander cellExpander;
    private Point cep;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$AssistTable;

    public AssistCombo() {
        this.init(true);
    }

    public AssistCombo(Vector vector) {
        super(vector);
        this.init(true);
    }

    public AssistCombo(Object[] objectArray) {
        super(objectArray);
        this.init(true);
    }

    public AssistCombo(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init(true);
    }

    public AssistCombo(boolean bl) {
        this.init(bl);
    }

    public AssistCombo(boolean bl, Vector vector) {
        super(vector);
        this.init(bl);
    }

    public AssistCombo(boolean bl, Object[] objectArray) {
        super(objectArray);
        this.init(bl);
    }

    public AssistCombo(boolean bl, ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init(bl);
    }

    protected void init(boolean bl) {
        this.valueValid = true;
        this.valuePreviouslyValid = true;
        this.setRequired(bl);
        this.clearDisabled = AssistManager.getClearDisabledPolicy();
        this.allowWhitespace = false;
        if (!(this.editor instanceof MetalComboBoxEditor)) {
            this.setEditor(new AssistComboBoxEditor(this));
        }
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        this.nested = false;
        this.itemListeners = new EventListenerList();
        this.verifyImmediately(false);
        super.addItemListener(this);
        this.addKeyListener(this);
    }

    public String getUIClassID() {
        return "AssistComboUI";
    }

    public void addItem(Object object) {
        this.suppressItemEvent = true;
        super.addItem(object);
        this.suppressItemEvent = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (!(n2 != 27 && n2 != 10 || this.isPopupVisible() || this.getParent() == null)) {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                AssistManager.redirectKeyEvent(keyEvent, jRootPane);
            }
        } else if (this.getRequired() && !this.itemSelected) {
            if (n2 == 40 && this.getModel().getSize() > 0) {
                this.itemSelected = true;
                if (this.getSelectedIndex() == 0) {
                    this.selectedItemChanged();
                }
                keyEvent.consume();
                this.verify(false, false);
            } else if (this.firstRemoveUpdate && this.isEditable() && (keyEvent.getKeyCode() == 12 || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8)) {
                this.firstRemoveUpdate = false;
                this.getEditor().setItem("");
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.getRequired() && !this.itemSelected && keyEvent.getKeyCode() == 40 && this.getModel().getSize() > 0) {
            this.itemSelected = true;
            this.verify(false, false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.firstRemoveUpdate = true;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.firstRemoveUpdate = true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.getRequired()) {
            if (this.suppressItemEvent) {
                return;
            }
            if (!this.itemSelected && itemEvent.getStateChange() == 1) {
                this.itemSelected = true;
                this.verify(false, false);
            }
        }
        this.notifyItemListeners(itemEvent);
    }

    public void setSelectedItem(Object object) {
        boolean bl = false;
        if (object != null && object.equals(this.getModel().getSelectedItem())) {
            bl = true;
        }
        super.setSelectedItem(object);
        if (bl) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
    }

    public Object getSelectedItem() {
        if (this.getRequired() && !this.itemSelected) {
            Object object = this.getEditor().getItem();
            if (this.isEditable() && null != object && 0 != object.toString().trim().length()) {
                return object;
            }
            return this.selectItem;
        }
        if (this.isEditable() && this.dataModel.getSelectedItem() == null) {
            return this.getEditor().getItem();
        }
        return super.getSelectedItem();
    }

    public int getSelectedIndex() {
        if (this.getRequired() && !this.itemSelected) {
            return -1;
        }
        return super.getSelectedIndex();
    }

    public void setSelectedIndex(int n2) {
        if (n2 == -1) {
            this.itemSelected = false;
        }
        boolean bl = false;
        if (this.getRequired() && !this.itemSelected && this.getModel().getSize() == 1) {
            bl = true;
        }
        super.setSelectedIndex(n2);
        if (bl) {
            this.selectedItemChanged();
        }
    }

    public void setSelectItem(Object object) {
        if (object == null) {
            this.itemSelected = true;
        }
        this.selectItem = object;
        this.repaint();
    }

    public Object getSelectItem() {
        return this.selectItem;
    }

    public boolean getItemSelected() {
        return this.itemSelected;
    }

    public void setItemSelected(boolean bl) {
        if (bl != this.itemSelected) {
            this.itemSelected = bl;
            if (!this.itemSelected && this.isEditable()) {
                this.firstRemoveUpdate = true;
                this.getEditor().setItem(this.selectItem);
            }
            this.verify(false, false);
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = new Dimension();
        if (dimension != null) {
            dimension2.width = dimension.width;
            dimension2.height = dimension.height;
        }
        if (dimension2.height < this.minHeight) {
            dimension2.height = this.minHeight;
        }
        if (dimension2.width < this.minWidth) {
            dimension2.width = this.minWidth;
        }
        return dimension2;
    }

    public void setAllowWhitespace(boolean bl) {
        this.allowWhitespace = bl;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[1] = 67;
        cArray[3] = 111;
        cArray[6] = 32;
        String string = null;
        String string2 = UIManager.getLookAndFeel().getName();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistCombo.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            cArray[2] = 116;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                if (this.isEditable()) {
                    Component component;
                    cArray[4] = 101;
                    if (this.getBorder() != null) {
                        this.setBorder(null);
                    }
                    if (!(string = String.copyValueOf(cArray)).equals(this.prevBorderType) && (component = this.editor.getEditorComponent()) instanceof JComponent) {
                        ((JComponent)component).setBorder(AssistManager.getBorder("Assist.nested.error.border"));
                    }
                } else {
                    cArray[4] = 99;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("Assist.nested.error.border"));
                    }
                }
            } else {
                Component component;
                cArray[5] = 118;
                if (this.getBorder() != null) {
                    this.setBorder(null);
                }
                if ((component = this.editor.getEditorComponent()) instanceof JComponent) {
                    if (((JComponent)component).getBorder() != null) {
                        ((JComponent)component).setBorder(null);
                    }
                } else {
                    boolean bl;
                    boolean bl2 = bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
                    if (bl) {
                        cArray[5] = 102;
                    }
                    if (!(string = String.copyValueOf(cArray)).equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("Assist.nested.border", true, bl, string));
                    }
                }
            }
        } else if (this.nested) {
            cArray[2] = 110;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                if (this.isEditable()) {
                    Component component;
                    cArray[4] = 101;
                    if (this.getBorder() != null) {
                        this.setBorder(null);
                    }
                    if (!(string = String.copyValueOf(cArray)).equals(this.prevBorderType) && (component = this.editor.getEditorComponent()) instanceof JComponent) {
                        ((JComponent)component).setBorder(AssistManager.getBorder("Assist.error.border"));
                    }
                } else {
                    cArray[4] = 99;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        this.setBorder(AssistManager.getBorder("Assist.error.border"));
                    }
                }
            } else {
                Component component;
                cArray[5] = 118;
                if (this.getBorder() != null) {
                    this.setBorder(null);
                }
                if (!(string = String.copyValueOf(cArray)).equals(this.prevBorderType) && (component = this.editor.getEditorComponent()) instanceof JComponent && ((JComponent)component).getBorder() != null) {
                    ((JComponent)component).setBorder(null);
                }
            }
        } else {
            cArray[2] = 115;
            if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                cArray[5] = 101;
                cArray[6] = 116;
                if (this.isEditable()) {
                    cArray[4] = 101;
                    string = String.copyValueOf(cArray);
                    Component component = this.editor.getEditorComponent();
                    if (component instanceof JComponent) {
                        Border border = null;
                        if (AssistManager.getInsideBordersPolicy()) {
                            border = AssistManager.getThinBordersPolicy() ? (string2.equals("Metal") ? AssistManager.getBorder("ComboBox.border", false, string) : AssistManager.getBorder("Assist.nested.error.border")) : (string2.equals("Metal") ? AssistManager.getBorder("ComboBox.border", false, string) : AssistManager.getBorder("Assist.error.border"));
                            if (string2.equals("Metal")) {
                                this.setBorder(null);
                            } else {
                                this.setBorder(AssistManager.getBorder("ComboBox.border"));
                            }
                        } else {
                            border = null;
                            if (string2.equals("Metal")) {
                                this.setBorder(null);
                            } else {
                                this.setBorder(AssistManager.getBorder("ComboBox.border", false, string));
                            }
                        }
                        ((JComponent)component).setBorder(AssistManager.padBorder(2, this, border, string));
                    }
                } else {
                    cArray[4] = 99;
                    string = String.copyValueOf(cArray);
                    Border border = AssistManager.getBorder("ComboBox.border", false, string);
                    this.setBorder(border);
                }
            } else {
                cArray[5] = 118;
                if (this.isEditable()) {
                    Component component;
                    cArray[4] = 101;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType) && (component = this.editor.getEditorComponent()) instanceof JComponent) {
                        if (string2.equals("Metal")) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string).append("0202");
                            Border border = AssistManager.getBorder(stringBuffer.toString());
                            if (border == null) {
                                border = BorderFactory.createCompoundBorder(AssistManager.getBorder("ComboBox.border"), BorderFactory.createEmptyBorder(0, 2, 0, 2));
                            }
                            ((JComponent)component).setBorder(border);
                        } else {
                            ((JComponent)component).setBorder(AssistManager.padBorder(2, this, null, string));
                        }
                        if (string2.equals("Metal")) {
                            if (this.getBorder() != null) {
                                this.setBorder(null);
                            }
                        } else {
                            this.setBorder(AssistManager.getBorder("ComboBox.border"));
                        }
                    }
                } else {
                    cArray[4] = 99;
                    string = String.copyValueOf(cArray);
                    if (!string.equals(this.prevBorderType)) {
                        if (string2.equals("Metal")) {
                            if (this.getBorder() != null) {
                                this.setBorder(null);
                            }
                        } else {
                            this.setBorder(AssistManager.getBorder("ComboBox.border"));
                        }
                    }
                }
            }
        }
        this.repaint();
    }

    public void setMinimumWidth(int n2) {
        this.minWidth = n2;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.localBeepPolicy;
        if (bl) {
            this.localBeepPolicy = Boolean.FALSE;
        }
        this.verifyImmediately(false);
        if (bl) {
            this.localBeepPolicy = bl2;
        }
        this.minHeight = super.getPreferredSize().height;
        JComboBox jComboBox = new JComboBox();
        if (this.getMinimumSize().height == jComboBox.getMinimumSize().height) {
            int n2 = this.getInsets().top - jComboBox.getInsets().top;
            int n3 = this.getInsets().bottom - jComboBox.getInsets().bottom;
            this.minHeight = this.minHeight + n2 + n3;
        }
        if (this.minWidth == 0) {
            this.minWidth = this.getItemCount() == 0 ? this.minHeight * 5 : super.getPreferredSize().width;
        }
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        Boolean bl2 = this.localBeepPolicy;
        if (bl) {
            this.localBeepPolicy = Boolean.FALSE;
        }
        this.setEnabled(this.isEnabled());
        if (bl) {
            this.localBeepPolicy = bl2;
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        String string = UIManager.getLookAndFeel().getName();
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setEnabled(bl);
        if (bl2 != bl || this.isEnabling) {
            int n2 = jTextComponent.getCaretPosition();
            if (n2 >= 0 && n2 <= jTextComponent.getText().length()) {
                jTextComponent.setCaretPosition(n2);
            }
            if (bl) {
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
                jTextComponent.setBackground(UIManager.getColor("TextField.background"));
                jTextComponent.setForeground(UIManager.getColor("ComboBox.foreground"));
                jTextComponent.setDisabledTextColor(Color.green);
                jTextComponent.setSelectionColor(UIManager.getColor("ComboBox.selectionBackground"));
                jTextComponent.setSelectedTextColor(UIManager.getColor("ComboBox.selectionForeground"));
                if (this.origRenderer != null) {
                    this.setRenderer(this.origRenderer);
                }
            } else if (this.clearDisabled) {
                Color color = null;
                if (AssistManager.getDefaultColorsPolicy()) {
                    Color color2 = color = UIManager.getColor("ComboBox.disabledBackground");
                    jTextComponent.setForeground(color2);
                    jTextComponent.setDisabledTextColor(jTextComponent.getBackground());
                    jTextComponent.setSelectionColor(color2);
                    jTextComponent.setSelectedTextColor(color2);
                } else {
                    color = UIManager.getColor("control");
                    jTextComponent.setForeground(color);
                    jTextComponent.setDisabledTextColor(jTextComponent.getBackground());
                    jTextComponent.setSelectionColor(color);
                    jTextComponent.setSelectedTextColor(color);
                }
                this.setForeground(color);
                this.setBackground(color);
                if (!(this.getRenderer() instanceof AssistBlankRenderer)) {
                    this.origRenderer = this.getRenderer();
                }
                if (this.blankRenderer == null) {
                    this.blankRenderer = new AssistBlankRenderer();
                }
                this.setRenderer(this.blankRenderer);
            } else {
                if (AssistManager.getDefaultColorsPolicy()) {
                    this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    jTextComponent.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
                    if (this.isEditable()) {
                        jTextComponent.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    } else {
                        UIManager.put("ComboBox.disabledBackground", UIManager.getColor("ComboBox.background"));
                        UIManager.put("ComboBox.disabledForeground", UIManager.getColor("TextField.inactiveForeground"));
                    }
                } else {
                    if (this.isEditable()) {
                        this.setForeground(UIManager.getColor("ComboBox.foreground"));
                        this.setBackground(UIManager.getColor("control"));
                    } else {
                        UIManager.put("ComboBox.disabledForeground", UIManager.getColor("ComboBox.foreground"));
                        UIManager.put("ComboBox.disabledBackground", UIManager.getColor("control"));
                    }
                    jTextComponent.setForeground(UIManager.getColor("ComboBox.foreground"));
                    jTextComponent.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
                }
                jTextComponent.setSelectionColor(UIManager.getColor("ComboBox.selectionBackground"));
                jTextComponent.setSelectedTextColor(UIManager.getColor("ComboBox.selectionForeground"));
                if (this.origRenderer != null) {
                    this.setRenderer(this.origRenderer);
                }
            }
            this.verifyImmediately(false);
            this.setBorder();
        }
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (bl) {
            ((JTextComponent)this.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            this.getEditor().getEditorComponent().addFocusListener(this);
            ((JTextComponent)this.getEditor().getEditorComponent()).addKeyListener(this);
        } else {
            ((JTextComponent)this.getEditor().getEditorComponent()).getDocument().removeDocumentListener(this);
            this.getEditor().getEditorComponent().removeFocusListener(this);
            ((JTextComponent)this.getEditor().getEditorComponent()).removeKeyListener(this);
        }
    }

    public void insertItemAt(Object object, int n2) {
        super.insertItemAt(object, n2);
        this.verify(false, false);
    }

    public void removeItemAt(int n2) {
        super.removeItemAt(n2);
        if (this.getRequired() && this.getItemCount() == 0) {
            this.itemSelected = false;
            this.verify(false, false);
            this.repaint();
        }
    }

    public void removeItem(Object object) {
        super.removeItem(object);
        if (this.getRequired() && this.getItemCount() == 0) {
            this.itemSelected = false;
            this.verify(false, false);
            this.repaint();
        }
    }

    public void removeAllItems() {
        super.removeAllItems();
        if (this.getRequired()) {
            this.itemSelected = false;
            this.verify(false, false);
            this.repaint();
        }
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistCombo.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        Boolean bl = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        this.verify(false, false);
        this.localBeepPolicy = bl;
        this.valuePreviouslyValid = this.valueValid;
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistCombo.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean containsObject(Object object) {
        int n2 = 0;
        while (n2 < this.getItemCount()) {
            if (this.getItemAt(n2).equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValueValid() {
        if (this.verifyTimer != null && this.verifyTimer.isRunning()) {
            this.verifyTimer.stop();
            this.verifyImmediately(false);
        }
        return this.valueValid;
    }

    public void verify() {
        this.verify(false, false);
    }

    public void verify(boolean bl) {
        this.verify(bl, false);
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public void verify(boolean bl, boolean bl2) {
        if (this.isEnabled() && this.required && (this.isEditable() && (!this.allowWhitespace && this.getEditor().getItem().toString().trim().length() == 0 || this.allowWhitespace && this.getEditor().getItem().toString().length() == 0 || this.getEditor().getItem().equals(this.selectItem)) || !this.isEditable() && (this.getModel().getSize() == 0 || this.getSelectedItem() != null && (this.getSelectedItem().toString().trim().length() == 0 || this.getSelectedItem().toString().trim().startsWith("<"))))) {
            if (this.isValueValid() && AssistManager.getErrorBordersPolicy() && (this.localBeepPolicy != null ? this.localBeepPolicy : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.valueValid = false;
        } else {
            this.valueValid = true;
        }
        this.setBorder();
        this.fireValidityChanged();
    }

    public void setExpandField(boolean bl) {
        if (bl && !this.expandField) {
            CellExpanderManager.sharedInstance().registerComponent(this);
        } else if (!bl && this.expandField) {
            CellExpanderManager.sharedInstance().unregisterComponent(this);
        }
        this.expandField = bl;
    }

    public boolean getExpandField() {
        return this.expandField;
    }

    public Point getCellExpanderLocation(MouseEvent mouseEvent) {
        Object object;
        if (!this.expandField || this.isPopupVisible() || this.isEditable() && this.editor.getEditorComponent().hasFocus()) {
            return null;
        }
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
            this.cep = new Point(0, 0);
        }
        if ((object = this.getSelectedItem()) == null) {
            return null;
        }
        int n2 = this.cellExpander.getLineWidth(object.toString(), this.getFont());
        Insets insets = this.getInsets();
        if (n2 + (this.isEditable() ? 2 : 0) <= this.getWidthForSelectedItem() - insets.left - insets.right + 1) {
            return null;
        }
        return this.cep;
    }

    public CellExpander createCellExpander(MouseEvent mouseEvent) {
        if (this.cellExpander == null) {
            this.cellExpander = new CellExpander(this);
        }
        CompoundBorder compoundBorder = null;
        if (this.isEditable() && this.editor.getEditorComponent() instanceof JComponent) {
            compoundBorder = BorderFactory.createCompoundBorder(this.getBorder(), ((JComponent)this.editor.getEditorComponent()).getBorder());
            this.cellExpander.setForeground(this.getForeground());
            this.cellExpander.setBackground(this.getBackground());
        } else {
            compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getColor("Table.gridColor")), this.getBorder());
            if (this.hasFocus()) {
                this.cellExpander.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                this.cellExpander.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
            } else {
                this.cellExpander.setForeground(this.getForeground());
                this.cellExpander.setBackground(this.getBackground());
            }
        }
        this.cellExpander.setBorder(compoundBorder);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Insets insets2 = this.cellExpander.getInsets();
        LineMetrics lineMetrics = AssistManager.getLineMetrics(this.getSelectedItem().toString(), this.cellExpander, this.cellExpander.getFont());
        int n2 = Math.round(lineMetrics.getHeight());
        Point point = new Point(0, 0);
        point.x -= insets2.left;
        point.y = Math.round(dimension.height / 2) - Math.round(n2 / 2) - insets2.top;
        point.x = this.isEditable() ? (point.x += 2) : --point.x;
        this.cellExpander.putClientProperty("translate.point", point);
        this.cellExpander.setFont(this.getFont());
        this.cellExpander.setTipText(CellExpanderManager.untag(this.getSelectedItem().toString()));
        int n3 = this.getWidthForSelectedItem() - insets.left - insets.right - 4;
        this.cellExpander.setWidth(n3);
        Dimension dimension2 = this.cellExpander.getPreferredSize();
        dimension2.width = n3;
        if (point.y > 0) {
            dimension2.height += point.y;
        }
        this.cellExpander.setPreferredSize(dimension2);
        this.cellExpander.setSize(dimension2);
        return this.cellExpander;
    }

    protected int getWidthForSelectedItem() {
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.getComponent(n3);
            if (component instanceof AbstractButton) {
                return this.getSize().width - component.getSize().width;
            }
            ++n3;
        }
        return this.getSize().width;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        AssistTable assistTable = (AssistTable)SwingUtilities.getAncestorOfClass(class$com$ibm$db2$tools$common$AssistTable == null ? (class$com$ibm$db2$tools$common$AssistTable = AssistCombo.class$("com.ibm.db2.tools.common.AssistTable")) : class$com$ibm$db2$tools$common$AssistTable, this);
        if (assistTable != null) {
            if (n2 == 401 && (n3 == 9 || keyEvent.getKeyChar() == '\t' || n3 == 27)) {
                AssistManager.redirectKeyEvent(keyEvent, assistTable);
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if (n3 == 27 && !this.isPopupVisible() && n2 == 401 && this.getParent() != null) {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                AssistManager.redirectKeyEvent(keyEvent, jRootPane);
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.verifyTimer) {
            this.verifyImmediately(true);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.firstRemoveUpdate = false;
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.verify(true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n2 = AssistManager.getVerifyDelayPolicy();
        if (n2 > 0 && this.verifyTimer == null) {
            this.verifyTimer = new Timer(n2, this);
            this.verifyTimer.setInitialDelay(n2);
            this.verifyTimer.setRepeats(false);
            this.verifyTimer.setCoalesce(true);
        }
        if (n2 > 0) {
            this.verifyTimer.restart();
        } else {
            this.verify(true, false);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        super.intervalAdded(listDataEvent);
        this.verify(false, false);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        super.intervalRemoved(listDataEvent);
        this.verify(false, false);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        super.contentsChanged(listDataEvent);
        Boolean bl = this.localBeepPolicy;
        this.localBeepPolicy = Boolean.FALSE;
        this.verify(false, false);
        this.localBeepPolicy = bl;
    }

    protected void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (this.valuePreviouslyValid != this.valueValid && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistCombo.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.valueValid;
    }

    public AssistCombo clone(Vector vector) {
        AssistCombo assistCombo = new AssistCombo(this.getRequired(), vector);
        assistCombo.setClearDisabled(this.getClearDisabled());
        assistCombo.setBorder(this.getBorder());
        assistCombo.setEditable(this.isEditable());
        assistCombo.setNestedBorders(this.nested);
        assistCombo.setBeepPolicy(false);
        assistCombo.verifyImmediately(false);
        if (this.localBeepPolicy == null) {
            assistCombo.resetBeepPolicy();
        } else {
            assistCombo.setBeepPolicy(this.localBeepPolicy);
        }
        return assistCombo;
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.itemListeners == null) {
            super.addItemListener(itemListener);
        } else {
            this.itemListeners.add(AssistManager.getClass("ItemListener"), itemListener);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this.itemListeners == null) {
            super.removeItemListener(itemListener);
        } else {
            this.itemListeners.remove(AssistManager.getClass("ItemListener"), itemListener);
        }
    }

    protected void notifyItemListeners(ItemEvent itemEvent) {
        if (this.itemListeners == null) {
            return;
        }
        Object[] objectArray = this.itemListeners.getListenerList();
        if (objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == AssistManager.getClass("ItemListener")) {
                    ((ItemListener)objectArray[n2 + 1]).itemStateChanged(itemEvent);
                }
                n2 -= 2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

