/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.event.AssistEvent;
import com.ibm.db2.tools.common.event.AssistListener;
import com.ibm.db2.tools.common.support.AssistComponent;
import com.ibm.db2.tools.common.support.AssistEditorKit;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

public class AssistArea
extends JTextArea
implements AssistComponent,
DocumentListener,
ActionListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean required;
    protected boolean clearDisabled = AssistManager.getClearDisabledPolicy();
    protected boolean isEnabling;
    protected boolean nested;
    protected Boolean localBeepPolicy;
    protected boolean allowWhitespace = false;
    protected boolean unlinkEditableEnabled;
    protected Object assistContext;
    protected EventListenerList assistListeners;
    protected AssistEvent assistEvent;
    protected boolean valueValid = true;
    protected boolean valuePreviouslyValid = true;
    protected Timer verifyTimer;
    protected String prevBorderType;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$com$ibm$db2$tools$common$event$AssistListener;

    public AssistArea() {
        this(true, null, "", 0, 0);
    }

    public AssistArea(String string) {
        this(true, null, string, 0, 0);
    }

    public AssistArea(int n2, int n3) {
        this(true, null, "", n2, n3);
    }

    public AssistArea(String string, int n2, int n3) {
        this(true, null, string, n2, n3);
    }

    public AssistArea(Document document) {
        this(true, document, null, 0, 0);
    }

    public AssistArea(Document document, String string, int n2, int n3) {
        this(true, document, string, n2, n3);
    }

    public AssistArea(boolean bl) {
        this(bl, null, "", 0, 0);
    }

    public AssistArea(boolean bl, String string) {
        this(bl, null, string, 0, 0);
    }

    public AssistArea(boolean bl, int n2, int n3) {
        this(bl, null, "", n2, n3);
    }

    public AssistArea(boolean bl, String string, int n2, int n3) {
        this(bl, null, string, n2, n3);
    }

    public AssistArea(boolean bl, Document document) {
        this(bl, document, null, 0, 0);
    }

    public AssistArea(boolean bl, Document document, String string, int n2, int n3) {
        super(n2, n3);
        AssistEditorKit.enhanceKeymap(this.getKeymap());
        this.assistContext = null;
        this.assistListeners = new EventListenerList();
        this.setText(string);
        this.nested = false;
        this.setBorder();
        this.setRequired(bl);
        this.unlinkEditableEnabled = false;
        if (document != null) {
            this.setDocument(document);
        }
        if (this.getDocument() != null) {
            this.getDocument().addDocumentListener(this);
        }
    }

    public void setAllowWhitespace(boolean bl) {
        this.allowWhitespace = bl;
    }

    public boolean getAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setBeepPolicy(boolean bl) {
        this.localBeepPolicy = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBeepPolicy() {
        return this.localBeepPolicy;
    }

    public void resetBeepPolicy() {
        this.localBeepPolicy = null;
    }

    public void setDocument(Document document) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this);
        }
        super.setDocument(document);
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    public void updateRequired() {
        this.valueValid = false;
        this.setBorder();
        this.selectAll();
        this.fireValidityChanged();
    }

    public void setBorder() {
        char[] cArray = new char[7];
        cArray[0] = 97;
        cArray[1] = 65;
        cArray[4] = 101;
        cArray[6] = 32;
        String string = null;
        Border border = null;
        JScrollPane jScrollPane = this.hasScrollPane();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistArea.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            cArray[2] = 116;
            if (jScrollPane == null) {
                cArray[3] = 111;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    border = AssistManager.getBorder("Assist.nested.error.border");
                } else {
                    cArray[5] = 118;
                    string = String.copyValueOf(cArray);
                    boolean bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
                    border = AssistManager.getBorder("Assist.nested.border", true, bl, string);
                }
            } else {
                cArray[3] = 112;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    border = AssistManager.getBorder("Assist.nested.error.border");
                    if (jScrollPane.getBorder() != null) {
                        jScrollPane.setBorder(null);
                    }
                } else {
                    boolean bl = !this.isEnabled() || !this.isEditable() ? false : this.hasFocus();
                    cArray[5] = bl ? 102 : 118;
                    string = String.copyValueOf(cArray);
                    border = null;
                    if (!string.equals(this.prevBorderType)) {
                        jScrollPane.setBorder(AssistManager.getBorder("Assist.nested.border", true, bl, string));
                    }
                }
            }
            if (string == null) {
                string = String.copyValueOf(cArray);
            }
            if (border == null && this.getBorder() != null || !string.equals(this.prevBorderType)) {
                this.setBorder(border);
            }
        } else if (this.nested) {
            cArray[2] = 110;
            if (jScrollPane == null) {
                cArray[3] = 111;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 116;
                    border = AssistManager.getBorder("Assist.nested.error.border");
                } else {
                    cArray[5] = 118;
                    border = AssistManager.getBorder("Assist.nested.border");
                }
            } else {
                cArray[3] = 112;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 116;
                    border = AssistManager.getBorder("Assist.nested.error.border");
                    jScrollPane.setBorder(null);
                } else {
                    cArray[5] = 118;
                    border = null;
                    jScrollPane.setBorder(AssistManager.getBorder("Assist.nested.border"));
                }
            }
            string = String.copyValueOf(cArray);
            if (border == null && this.getBorder() != null || !string.equals(this.prevBorderType)) {
                this.setBorder(border);
            }
        } else {
            cArray[2] = 115;
            if (jScrollPane == null) {
                cArray[3] = 111;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    string = String.copyValueOf(cArray);
                    border = AssistManager.getBorder("List.border", false, string);
                } else {
                    cArray[5] = 118;
                    border = AssistManager.getBorder("List.border");
                    if (border == null) {
                        border = AssistManager.getBorder("TextField.border");
                    }
                }
            } else {
                cArray[3] = 112;
                if (this.isEnabled() && !this.isValueValid() && AssistManager.getErrorBordersPolicy()) {
                    cArray[5] = 101;
                    cArray[6] = 107;
                    string = String.copyValueOf(cArray);
                    border = AssistManager.getBorder("TextArea.border", false, string);
                } else {
                    cArray[5] = 118;
                    border = AssistManager.getBorder("TextArea.border");
                }
            }
            if (string == null) {
                string = String.copyValueOf(cArray);
            }
            if (!string.equals(this.prevBorderType)) {
                this.setBorder(AssistManager.padBorder(2, this, border, string));
            }
        }
        this.prevBorderType = string;
        this.repaint();
    }

    public JScrollPane hasScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.getParent().getParent();
        }
        return null;
    }

    public JScrollPane getScrollPane() {
        if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)this.getParent().getParent();
        }
        return new JScrollPane(this);
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        Boolean bl2 = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.verifyImmediately(false);
        if (bl2 == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl2);
        }
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setClearDisabled(boolean bl) {
        if (this.clearDisabled == bl) {
            return;
        }
        this.isEnabling = true;
        this.clearDisabled = bl;
        Boolean bl2 = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.setEnabled(this.isEnabled());
        if (bl2 == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl2);
        }
        this.isEnabling = false;
    }

    public boolean getClearDisabled() {
        return this.clearDisabled;
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.unlinkEditableEnabled = true;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (!this.unlinkEditableEnabled) {
            super.setEditable(bl);
        }
        if (bl2 != bl || this.isEnabling) {
            int n2 = this.getCaretPosition();
            if (n2 >= 0 && n2 <= this.getText().length()) {
                this.setCaretPosition(n2);
            }
            if (bl) {
                this.setForeground(UIManager.getColor("TextArea.foreground"));
                this.setBackground(UIManager.getColor("TextArea.background"));
                this.setSelectionColor(UIManager.getColor("TextArea.selectionBackground"));
                this.setSelectedTextColor(UIManager.getColor("TextArea.selectionForeground"));
                this.setDisabledTextColor(UIManager.getColor("TextArea.inactiveForeground"));
            } else if (this.clearDisabled) {
                Color color = null;
                color = AssistManager.getDefaultColorsPolicy() ? UIManager.getColor("TextArea.background") : UIManager.getColor("control");
                this.setBackground(color);
                this.setForeground(color);
                this.setSelectionColor(color);
                this.setSelectedTextColor(color);
                this.setDisabledTextColor(color);
            } else {
                if (AssistManager.getDefaultColorsPolicy()) {
                    this.setForeground(UIManager.getColor("TextArea.inactiveForeground"));
                    this.setBackground(UIManager.getColor("TextArea.background"));
                    this.setDisabledTextColor(UIManager.getColor("TextArea.inactiveForeground"));
                } else {
                    this.setForeground(UIManager.getColor("TextArea.foreground"));
                    this.setBackground(UIManager.getColor("control"));
                    this.setDisabledTextColor(UIManager.getColor("TextArea.foreground"));
                }
                this.setSelectionColor(UIManager.getColor("TextArea.selectionBackground"));
                this.setSelectedTextColor(UIManager.getColor("TextArea.selectionForeground"));
            }
            this.verify(false);
            this.setBorder();
        }
    }

    public void setContext(Object object) {
        this.assistContext = object;
    }

    public Object getContext() {
        return this.assistContext;
    }

    public void setNestedBorders(boolean bl) {
        this.nested = bl;
        this.setBorder();
    }

    public void setText(String string) {
        Boolean bl = this.getBeepPolicy();
        this.setBeepPolicy(false);
        super.setText(string);
        if (bl == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl);
        }
    }

    public void addAssistListener(AssistListener assistListener) {
        this.assistListeners.add(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistArea.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
        if (this.assistEvent == null) {
            this.assistEvent = new AssistEvent(this);
        }
        Boolean bl = this.getBeepPolicy();
        this.setBeepPolicy(false);
        this.verifyImmediately(false);
        if (bl == null) {
            this.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            this.setBeepPolicy(bl);
        }
        this.valuePreviouslyValid = this.valueValid;
        assistListener.validityChanged(this.assistEvent);
    }

    public void removeAssistListener(AssistListener assistListener) {
        this.assistListeners.remove(class$com$ibm$db2$tools$common$event$AssistListener == null ? (class$com$ibm$db2$tools$common$event$AssistListener = AssistArea.class$("com.ibm.db2.tools.common.event.AssistListener")) : class$com$ibm$db2$tools$common$event$AssistListener, assistListener);
    }

    public boolean isValueValid() {
        if (this.verifyTimer != null && this.verifyTimer.isRunning()) {
            this.verifyTimer.stop();
            this.verifyImmediately(false);
        }
        return this.valueValid;
    }

    public void verify() {
        this.verify(false);
    }

    public void verify(boolean bl) {
        this.verify(bl, false);
    }

    public void verifyImmediately(boolean bl) {
        this.verify(bl);
    }

    public void verify(boolean bl, boolean bl2) {
        String string = this.getText();
        if (!this.allowWhitespace) {
            string = string.trim();
        }
        if (this.isEnabled() && this.getRequired() && string.length() == 0) {
            if (!bl2 && this.valueValid && AssistManager.getErrorBordersPolicy() && (this.getBeepPolicy() != null ? this.getBeepPolicy() : AssistManager.getBeepPolicy())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.valueValid = false;
        } else {
            this.valueValid = true;
        }
        if (!bl2) {
            this.setBorder();
            this.fireValidityChanged();
        }
    }

    public void paste() {
        String string;
        Clipboard clipboard;
        if (this.isEditable() && this.isEnabled() && (clipboard = this.getToolkit().getSystemClipboard()) != null && AssistEditorKit.canPaste(this) && (string = AssistEditorKit.getPastable(this)) != null) {
            this.replaceSelection(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.verifyTimer) {
            this.verifyImmediately(true);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.verifyTimer != null) {
            this.verifyTimer.stop();
        }
        this.verify(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n2 = AssistManager.getVerifyDelayPolicy();
        if (n2 > 0 && this.verifyTimer == null) {
            this.verifyTimer = new Timer(n2, this);
            this.verifyTimer.setInitialDelay(n2);
            this.verifyTimer.setRepeats(false);
        }
        if (n2 > 0) {
            this.verifyTimer.setDelay(n2);
            this.verifyTimer.restart();
        } else {
            this.verify(true);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    protected void fireValidityChanged() {
        if (this.assistListeners == null) {
            return;
        }
        Object[] objectArray = this.assistListeners.getListenerList();
        if (this.valuePreviouslyValid != this.valueValid && objectArray.length > 0) {
            int n2 = objectArray.length - 2;
            while (n2 >= 0) {
                if (objectArray[n2] == (class$com$ibm$db2$tools$common$event$AssistListener == null ? AssistArea.class$("com.ibm.db2.tools.common.event.AssistListener") : class$com$ibm$db2$tools$common$event$AssistListener)) {
                    ((AssistListener)objectArray[n2 + 1]).validityChanged(this.assistEvent);
                }
                n2 -= 2;
            }
        }
        this.valuePreviouslyValid = this.valueValid;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(class$javax$swing$JTable == null ? (class$javax$swing$JTable = AssistArea.class$("javax.swing.JTable")) : class$javax$swing$JTable, this);
        if (jTable != null) {
            if (n2 == 401 && (keyEvent.getModifiers() & 2) > 0 && (n3 == 9 || keyEvent.getKeyChar() == '\t' || n3 == 27)) {
                AssistManager.redirectKeyEvent(keyEvent, jTable);
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if (n2 == 402) {
            if (n3 == 10 && (keyEvent.getModifiers() & 2) > 0) {
                JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)keyEvent.getSource());
                JButton jButton = jRootPane.getDefaultButton();
                if (jButton != null) {
                    jButton.getModel().setPressed(false);
                    keyEvent.consume();
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else if (n2 == 401) {
            if (n3 == 10 && (keyEvent.getModifiers() & 2) > 0) {
                JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)keyEvent.getSource());
                JButton jButton = jRootPane.getDefaultButton();
                if (jButton != null) {
                    ButtonModel buttonModel = jButton.getModel();
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                    keyEvent.consume();
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public AssistArea clone(String string) {
        AssistArea assistArea = new AssistArea(this.getRequired(), string, this.getRows(), this.getColumns());
        assistArea.setClearDisabled(this.getClearDisabled());
        assistArea.setBorder(this.getBorder());
        assistArea.setNestedBorders(this.nested);
        assistArea.setBeepPolicy(false);
        assistArea.verifyImmediately(false);
        Boolean bl = this.getBeepPolicy();
        if (bl == null) {
            assistArea.setBeepPolicy(AssistManager.getBeepPolicy());
        } else {
            assistArea.setBeepPolicy(bl);
        }
        return assistArea;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

