/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CmStringPool;
import com.ibm.db2.tools.common.FontProperty;
import com.ibm.db2.tools.common.FontPropertyDisplay;
import com.ibm.db2.tools.common.StatusLine;
import com.ibm.db2.tools.common.support.AssistManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class AppearanceManager
implements Serializable {
    public static final String DIALOG = "Dialog";
    public static final String SANSSERIF = "SansSerif";
    public static final String SERIF = "Serif";
    public static final String MONOSPACED = "Monospaced";
    public static final String DIALOGINPUT = "DialogInput";
    public static int TEXT_AREA_SIZE;
    public static final int DEFAULT_STYLE = 0;
    private static Font userSelectedMenuFont;
    private static String userSelectedMenuFontName;
    private static int userSelectedMenuSize;
    private static String userSelectedMenuColor;
    private static Font userSelectedTextFont;
    private static String userSelectedTextFontName;
    private static int userSelectedTextSize;
    private static String userSelectedTextColor;
    public static final String BLACK = "black";
    public static final String GRAY = "gray";
    public static final String LIGHTGRAY = "lightGray";
    public static final String BLUE = "blue";
    public static final String RED = "red";
    public static final String MAGENTA = "magenta";
    public static final String PINK = "pink";
    public static final String ORANGE = "orange";
    public static final String YELLOW = "yellow";
    public static final String GREEN = "green";
    public static final String DARKGRAY = "darkGray";
    public static final String CYAN = "cyan";
    public static final String WHITE = "white";
    public static final Font defaultMenuFont;
    public static final String defaultMenuFontName;
    public static final int defaultMenuSize;
    public static final int defaultMenuColor;
    public static final Font defaultTextFont;
    public static final String defaultTextFontName;
    public static final int defaultTextSize;
    public static final int defaultTextColor;
    public static final Color menuHighlightColor;
    public static final Color SelectedBackgroundColor;
    public static final Color SelectedOutlineColor;
    public static final Color onColor;
    public static final Color offColor;
    public static final Color TextColor;
    private static Hashtable fontProperties;

    public static Font getFont(String string) {
        return AppearanceManager.findFont(string, -1, -1);
    }

    public static Font getFont(String string, int n2) {
        return AppearanceManager.findFont(string, n2, -1);
    }

    public static Font getFont(String string, int n2, int n3) {
        return AppearanceManager.findFont(string, n2, n3);
    }

    public static Font getFont(Component component) {
        return AppearanceManager.findFont(component, -1, -1);
    }

    public static Font getFont(Component component, int n2) {
        return AppearanceManager.findFont(component, n2, -1);
    }

    public static Font getFont(Component component, int n2, int n3) {
        return AppearanceManager.findFont(component, n2, n3);
    }

    public static Font setFont(Component component) {
        return AppearanceManager.setFont(component, -1, -1);
    }

    public static Font setFont(Component component, int n2) {
        return AppearanceManager.setFont(component, n2, -1);
    }

    public static Font setFont(Component component, int n2, int n3) {
        Font font = AppearanceManager.findFont(component, n2, n3);
        if (font != null) {
            component.setFont(font);
        }
        return font;
    }

    public static void updateFont(Component component) {
        AppearanceManager.setFont(component);
        component.invalidate();
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                AppearanceManager.updateFont(componentArray[n2]);
                ++n2;
            }
        }
    }

    public static void commandLineUpdateFont(Component component) {
        AppearanceManager.setFont(component);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                AppearanceManager.commandLineUpdateFont(componentArray[n2]);
                ++n2;
            }
        }
    }

    public static Color setBackgroundColor(Component component) {
        Color color = null;
        color = AppearanceManager.findBackgroundColor(AppearanceManager.getKeyName(component));
        if (color != null) {
            component.setBackground(color);
        }
        return color;
    }

    private static String getKeyName(Component component) {
        String string = null;
        string = component.getClass().getName();
        if (string.lastIndexOf(46) != -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        return string.trim();
    }

    public static void updateFontSettings(String string, String string2, String string3, String string4, String string5, String string6) {
        Color color;
        Color color2 = new JMenu().getBackground();
        if (color2 != null && AppearanceManager.getColor(string3).getRGB() == color2.getRGB()) {
            string3 = Integer.toString(AppearanceManager.getColor(AppearanceManager.changeColor(AppearanceManager.getClosestNamedColor(AppearanceManager.getColor(string3).getRGB()))).getRGB());
        }
        if ((color = new JLabel().getBackground()) != null && AppearanceManager.getColor(string6).getRGB() == color.getRGB()) {
            string6 = Integer.toString(AppearanceManager.getColor(AppearanceManager.changeColor(AppearanceManager.getClosestNamedColor(AppearanceManager.getColor(string6).getRGB()))).getRGB());
        }
        userSelectedMenuFontName = string;
        try {
            userSelectedMenuSize = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            userSelectedMenuSize = -1;
        }
        userSelectedMenuColor = string3;
        userSelectedMenuFont = AppearanceManager.findFont(new JMenu(), -1, userSelectedMenuSize);
        userSelectedTextFontName = string4;
        try {
            userSelectedTextSize = Integer.parseInt(string5);
            StatusLine.setHeight(userSelectedTextSize);
        }
        catch (Exception exception) {
            userSelectedTextSize = -1;
        }
        userSelectedTextColor = string6;
        userSelectedTextFont = AppearanceManager.findFont(new JLabel(), -1, userSelectedTextSize);
        AppearanceManager.updateUIManagerFonts();
    }

    public static Font getCurrentMenuFont() {
        if (null != userSelectedMenuFont) {
            return userSelectedMenuFont;
        }
        return defaultMenuFont;
    }

    public static Color getCurrentMenuColor() {
        if (null != userSelectedMenuColor) {
            return AppearanceManager.getColor(userSelectedMenuColor);
        }
        return new Color(defaultMenuColor);
    }

    public static Font getCurrentTextFont() {
        if (null != userSelectedTextFont) {
            return userSelectedTextFont;
        }
        return defaultTextFont;
    }

    public static Color getCurrentTextColor() {
        if (null != userSelectedTextColor) {
            return AppearanceManager.getColor(userSelectedTextColor);
        }
        return new Color(defaultTextColor);
    }

    static void updateUIManagerFonts() {
        String string = AppearanceManager.getCurrentMenuFont().getName();
        int n2 = AppearanceManager.getCurrentMenuFont().getSize();
        Color color = AppearanceManager.getCurrentMenuColor();
        String string2 = AppearanceManager.getCurrentTextFont().getName();
        int n3 = AppearanceManager.getCurrentTextFont().getSize();
        Color color2 = AppearanceManager.getCurrentTextColor();
        UIManager.put("CheckBoxMenuItem.foreground", new ColorUIResource(color));
        UIManager.put("CheckBoxMenuItem.acceleratorForeground", new ColorUIResource(color));
        UIManager.put("CheckBoxMenuItem.font", new FontUIResource(string, 0, n2));
        UIManager.put("CommonMenu.foreground", new ColorUIResource(color));
        UIManager.put("CommonMenu.acceleratorForeground", new ColorUIResource(color));
        UIManager.put("CommonMenu.font", new FontUIResource(string, 0, n2));
        UIManager.put("Menu.foreground", new ColorUIResource(color));
        UIManager.put("Menu.acceleratorForeground", new ColorUIResource(color));
        UIManager.put("Menu.font", new FontUIResource(string, 0, n2));
        UIManager.put("MenuBar.foreground", new ColorUIResource(color));
        UIManager.put("MenuBar.font", new FontUIResource(string, 0, n2));
        UIManager.put("MenuItem.foreground", new ColorUIResource(color));
        UIManager.put("MenuItem.acceleratorForeground", new ColorUIResource(color));
        UIManager.put("MenuItem.font", new FontUIResource(string, 0, n2));
        UIManager.put("PopupMenu.foreground", new ColorUIResource(color));
        UIManager.put("PopupMenu.font", new FontUIResource(string, 0, n2));
        UIManager.put("RadioButtonMenuItem.foreground", new ColorUIResource(color));
        UIManager.put("RadioButtonMenuItem.acceleratorForeground", new ColorUIResource(color));
        UIManager.put("RadioButtonMenuItem.font", new FontUIResource(string, 0, n2));
        UIManager.put("Button.foreground", new ColorUIResource(color2));
        UIManager.put("Button.font", new FontUIResource(string2, 0, n3));
        UIManager.put("CheckBox.foreground", new ColorUIResource(color2));
        UIManager.put("CheckBox.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ColorChooser.foreground", new ColorUIResource(color2));
        UIManager.put("ColorChooser.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ComboBox.foreground", new ColorUIResource(color2));
        UIManager.put("ComboBox.font", new FontUIResource(string2, 0, n3));
        UIManager.put("EditorPane.foreground", new ColorUIResource(color2));
        UIManager.put("EditorPane.font", new FontUIResource(string2, 0, n3));
        UIManager.put("InternalFrame.titleFont", new FontUIResource(string2, 0, n3));
        UIManager.put("Label.foreground", new ColorUIResource(color2));
        UIManager.put("Label.font", new FontUIResource(string2, 0, n3));
        UIManager.put("List.foreground", new ColorUIResource(color2));
        UIManager.put("List.font", new FontUIResource(string2, 0, n3));
        UIManager.put("OptionPane.foreground", new ColorUIResource(color2));
        UIManager.put("OptionPane.messageForeground", new ColorUIResource(color2));
        UIManager.put("OptionPane.font", new FontUIResource(string2, 0, n3));
        UIManager.put("Panel.foreground", new ColorUIResource(color2));
        UIManager.put("Panel.font", new FontUIResource(string2, 0, n3));
        UIManager.put("PasswordField.foreground", new ColorUIResource(color2));
        UIManager.put("PasswordField.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ProgressBar.selectionBackground", new ColorUIResource(color2));
        UIManager.put("ProgressBar.font", new FontUIResource(string2, 0, n3));
        UIManager.put("RadioButton.foreground", new ColorUIResource(color2));
        UIManager.put("RadioButton.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ScrollPane.foreground", new ColorUIResource(color2));
        UIManager.put("ScrollPane.font", new FontUIResource(string2, 0, n3));
        UIManager.put("TabbedPane.foreground", new ColorUIResource(color2));
        UIManager.put("TabbedPane.font", new FontUIResource(string2, 0, n3));
        UIManager.put("Table.foreground", new ColorUIResource(color2));
        UIManager.put("Table.focusCellForeground", new ColorUIResource(color2));
        UIManager.put("Table.font", new FontUIResource(string2, 0, n3));
        UIManager.put("TableHeader.foreground", new ColorUIResource(color2));
        UIManager.put("TableHeader.font", new FontUIResource(string2, 0, n3));
        UIManager.put("TextArea.foreground", new ColorUIResource(color2));
        UIManager.put("TextArea.font", new FontUIResource(string2, 0, n3));
        UIManager.put("TextField.foreground", new ColorUIResource(color2));
        UIManager.put("TextField.font", new FontUIResource(string2, 0, n3));
        UIManager.put("TextPane.foreground", new ColorUIResource(color2));
        UIManager.put("TextPane.font", new FontUIResource(string2, 0, n3));
        UIManager.put("TitledBorder.titleColor", new ColorUIResource(color2));
        UIManager.put("TitledBorder.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ToggleButton.foreground", new ColorUIResource(color2));
        UIManager.put("ToggleButton.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ToolBar.foreground", new ColorUIResource(color2));
        UIManager.put("ToolBar.font", new FontUIResource(string2, 0, n3));
        UIManager.put("ToolTip.foreground", new ColorUIResource(color2));
        UIManager.put("ToolTip.font", new FontUIResource(string2, 0, n3));
        UIManager.put("Tree.foreground", new ColorUIResource(color2));
        UIManager.put("Tree.textForeground", new ColorUIResource(color2));
        UIManager.put("Tree.font", new FontUIResource(string2, 0, n3));
        UIManager.put("Viewport.foreground", new ColorUIResource(color2));
        UIManager.put("Viewport.font", new FontUIResource(string2, 0, n3));
    }

    public static int getTextFontHeight() {
        return userSelectedTextSize;
    }

    private static Font findFont(Component component, int n2, int n3) {
        Font font = AppearanceManager.getCurrentMenuFont();
        Font font2 = AppearanceManager.getCurrentTextFont();
        Font font3 = defaultTextFont;
        if (component instanceof JMenuItem || component instanceof JPopupMenu || component instanceof JSeparator) {
            if (userSelectedMenuSize == -1) {
                userSelectedMenuSize = n3 != -1 ? n3 : defaultTextSize;
            }
            if (userSelectedMenuFontName != null && n2 != -1) {
                font = AppearanceManager.getLanguageDependentFont(userSelectedMenuFontName, n2, userSelectedMenuSize);
            } else if (userSelectedMenuFontName != null && n2 == -1) {
                font = AppearanceManager.getLanguageDependentFont(userSelectedMenuFontName, defaultMenuFont.getStyle(), userSelectedMenuSize);
            } else if (userSelectedMenuFontName == null && n2 == -1) {
                font = AppearanceManager.getLanguageDependentFont(defaultMenuFontName, defaultMenuFont.getStyle(), userSelectedMenuSize);
            } else if (userSelectedMenuFont == null && n2 != -1) {
                font = AppearanceManager.getLanguageDependentFont(defaultMenuFontName, n2, userSelectedMenuSize);
            }
            font3 = font;
            component.setForeground(AppearanceManager.getCurrentMenuColor());
        } else {
            if (userSelectedTextSize == -1) {
                userSelectedTextSize = n3 != -1 ? n3 : defaultTextSize;
            }
            if (userSelectedTextFontName != null && n2 != -1) {
                font2 = AppearanceManager.getLanguageDependentFont(userSelectedTextFontName, n2, userSelectedTextSize);
            } else if (userSelectedTextFontName != null && n2 == -1) {
                font2 = AppearanceManager.getLanguageDependentFont(userSelectedTextFontName, defaultTextFont.getStyle(), userSelectedTextSize);
            } else if (userSelectedTextFont == null && n2 == -1) {
                font2 = AppearanceManager.getLanguageDependentFont(defaultTextFontName, defaultTextFont.getStyle(), userSelectedTextSize);
            } else if (userSelectedTextFont == null && n2 != -1) {
                font2 = AppearanceManager.getLanguageDependentFont(defaultTextFontName, n2, userSelectedTextSize);
            }
            font3 = font2;
            if (userSelectedTextColor != null) {
                Color color = component.getBackground();
                if (color != null && AppearanceManager.getColor(userSelectedTextColor).getRGB() == color.getRGB()) {
                    component.setForeground(AppearanceManager.getColor(AppearanceManager.changeColor(AppearanceManager.getClosestNamedColor(AppearanceManager.getColor(userSelectedMenuColor).getRGB()))));
                } else {
                    component.setForeground(AppearanceManager.getColor(userSelectedTextColor));
                }
            } else {
                component.setForeground(new Color(defaultTextColor));
            }
        }
        return font3;
    }

    private static Font findFont(String string, int n2, int n3) {
        Font font = defaultTextFont;
        String string2 = "";
        if (fontProperties.containsKey(string)) {
            FontProperty fontProperty = (FontProperty)fontProperties.get(string);
            font = fontProperty.font == null || n2 != -1 || n3 != -1 ? AppearanceManager.getLanguageDependentFont(fontProperty.fontName, n2 == -1 ? fontProperty.style : n2, n3 == -1 ? fontProperty.size : n2) : fontProperty.font;
        }
        return font;
    }

    private static Color findBackgroundColor(String string) {
        Color color = null;
        if (fontProperties.containsKey(string)) {
            FontProperty fontProperty = (FontProperty)fontProperties.get(string);
            color = fontProperty.color;
        }
        return color;
    }

    public static String getColorString(Color color) {
        String string = "";
        if (color.getRGB() == Color.black.getRGB()) {
            string = BLACK;
        } else if (color.getRGB() == Color.gray.getRGB()) {
            string = GRAY;
        } else if (color.getRGB() == Color.lightGray.getRGB()) {
            string = LIGHTGRAY;
        } else if (color.getRGB() == Color.blue.getRGB()) {
            string = BLUE;
        } else if (color.getRGB() == Color.red.getRGB()) {
            string = RED;
        } else if (color.getRGB() == Color.magenta.getRGB()) {
            string = MAGENTA;
        } else if (color.getRGB() == Color.pink.getRGB()) {
            string = PINK;
        } else if (color.getRGB() == Color.orange.getRGB()) {
            string = ORANGE;
        } else if (color.getRGB() == Color.yellow.getRGB()) {
            string = YELLOW;
        } else if (color.getRGB() == Color.green.getRGB()) {
            string = GREEN;
        } else if (color.getRGB() == Color.darkGray.getRGB()) {
            string = DARKGRAY;
        } else if (color.getRGB() == Color.cyan.getRGB()) {
            string = CYAN;
        } else if (color.getRGB() == Color.white.getRGB()) {
            string = WHITE;
        }
        return string;
    }

    public static String getTranslatedColorString(Color color) {
        String string = null;
        string = color.getRGB() == Color.black.getRGB() ? CmStringPool.get(441) : (color.getRGB() == Color.gray.getRGB() ? CmStringPool.get(439) : (color.getRGB() == Color.lightGray.getRGB() ? CmStringPool.get(438) : (color.getRGB() == Color.blue.getRGB() ? CmStringPool.get(449) : (color.getRGB() == Color.red.getRGB() ? CmStringPool.get(442) : (color.getRGB() == Color.magenta.getRGB() ? CmStringPool.get(447) : (color.getRGB() == Color.pink.getRGB() ? CmStringPool.get(443) : (color.getRGB() == Color.orange.getRGB() ? CmStringPool.get(444) : (color.getRGB() == Color.yellow.getRGB() ? CmStringPool.get(445) : (color.getRGB() == Color.green.getRGB() ? CmStringPool.get(446) : (color.getRGB() == Color.darkGray.getRGB() ? CmStringPool.get(440) : (color.getRGB() == Color.cyan.getRGB() ? CmStringPool.get(448) : (color.getRGB() == Color.white.getRGB() ? CmStringPool.get(437) : CmStringPool.get(442) + " = " + color.getRed() + " " + CmStringPool.get(446) + " = " + color.getGreen() + " " + CmStringPool.get(449) + " = " + color.getBlue()))))))))))));
        return string;
    }

    public static Color getColor(String string) {
        Color color = null;
        try {
            color = new Color(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (null == color) {
            color = Color.black;
            if (string.equalsIgnoreCase(BLACK)) {
                color = Color.black;
            } else if (string.equalsIgnoreCase(GRAY)) {
                color = Color.gray;
            } else if (string.equalsIgnoreCase(LIGHTGRAY)) {
                color = Color.lightGray;
            } else if (string.equalsIgnoreCase(BLUE)) {
                color = Color.blue;
            } else if (string.equalsIgnoreCase(RED)) {
                color = Color.red;
            } else if (string.equalsIgnoreCase(MAGENTA)) {
                color = Color.magenta;
            } else if (string.equalsIgnoreCase(PINK)) {
                color = Color.pink;
            } else if (string.equalsIgnoreCase(ORANGE)) {
                color = Color.orange;
            } else if (string.equalsIgnoreCase(YELLOW)) {
                color = Color.yellow;
            } else if (string.equalsIgnoreCase(GREEN)) {
                color = Color.green;
            } else if (string.equalsIgnoreCase(DARKGRAY)) {
                color = Color.darkGray;
            } else if (string.equalsIgnoreCase(CYAN)) {
                color = Color.cyan;
            } else if (string.equalsIgnoreCase(WHITE)) {
                color = Color.white;
            }
        }
        return color;
    }

    public static String getClosestNamedColor(int n2) {
        Color color = new Color(n2);
        int n3 = color.getRed() <= 127 ? 0 : 255;
        int n4 = color.getGreen() <= 127 ? 0 : 255;
        int n5 = color.getBlue() <= 127 ? 0 : 255;
        return AppearanceManager.getColorString(new Color(n3, n4, n5));
    }

    private static String changeColor(String string) {
        String string2 = string;
        if (string.equals(BLACK) || string.equals(DARKGRAY)) {
            string2 = WHITE;
        } else if (string.equals(GRAY) || string.equals(LIGHTGRAY) || string.equals(BLUE) || string.equals(RED) || string.equals(MAGENTA) || string.equals(PINK) || string.equals(ORANGE) || string.equals(YELLOW) || string.equals(GREEN) || string.equals(CYAN) || string.equals(WHITE)) {
            string2 = BLACK;
        }
        return string2;
    }

    public static Font getLanguageDependentDefaultFont(Font font) {
        String string = font.getName();
        int n2 = font.getStyle();
        int n3 = font.getSize();
        if ((Locale.SIMPLIFIED_CHINESE.equals(AssistManager.getPreferredLanguage()) || Locale.TRADITIONAL_CHINESE.equals(AssistManager.getPreferredLanguage())) && 11 == n3) {
            n3 = 12;
        }
        if (Locale.KOREA.equals(AssistManager.getPreferredLanguage()) || Locale.JAPAN.equals(AssistManager.getPreferredLanguage())) {
            n2 &= 0x7FFFFFFE;
        }
        if ((Locale.KOREA.equals(AssistManager.getPreferredLanguage()) || Locale.JAPAN.equals(AssistManager.getPreferredLanguage()) || Locale.TAIWAN.equals(AssistManager.getPreferredLanguage())) && 14 == n3) {
            n3 = 12;
        }
        if (!string.equals(font.getName()) || n2 != font.getStyle() || n3 != font.getSize()) {
            font = new Font(string, n2, n3);
        }
        return font;
    }

    public static Font getLanguageDependentFont(String string, int n2, int n3) {
        if (Locale.KOREA.equals(AssistManager.getPreferredLanguage()) || Locale.JAPAN.equals(AssistManager.getPreferredLanguage())) {
            n2 &= 0x7FFFFFFE;
        }
        return new Font(string, n2, n3);
    }

    public static synchronized boolean add(String string, String string2, int n2, int n3) {
        if (fontProperties.containsKey(string)) {
            return false;
        }
        FontProperty.add(fontProperties, string, string2, null, n2, n3);
        return true;
    }

    public static void display() {
        new FontPropertyDisplay(fontProperties);
    }

    public static Color getMenuHighlightColor() {
        return menuHighlightColor;
    }

    static {
        userSelectedMenuFont = null;
        userSelectedMenuFontName = null;
        userSelectedMenuSize = -1;
        userSelectedMenuColor = null;
        userSelectedTextFont = null;
        userSelectedTextFontName = null;
        userSelectedTextSize = -1;
        userSelectedTextColor = null;
        defaultMenuFont = AppearanceManager.getLanguageDependentDefaultFont(new JMenu().getFont());
        defaultMenuFontName = defaultMenuFont.getName();
        defaultMenuSize = defaultMenuFont.getSize();
        defaultMenuColor = new JMenu().getForeground().getRGB();
        defaultTextFont = AppearanceManager.getLanguageDependentDefaultFont(new JLabel().getFont());
        defaultTextFontName = defaultTextFont.getName();
        defaultTextSize = defaultTextFont.getSize();
        defaultTextColor = new JLabel().getForeground().getRGB();
        menuHighlightColor = new Color(0, 0, 128);
        SelectedBackgroundColor = SystemColor.info;
        SelectedOutlineColor = Color.black;
        onColor = Color.darkGray;
        offColor = Color.white;
        TextColor = new Color(defaultTextColor);
        fontProperties = new Hashtable();
        JTextArea jTextArea = new JTextArea();
        TEXT_AREA_SIZE = jTextArea.getFont().getSize();
        FontProperty.add(fontProperties, "JTextArea", MONOSPACED, null, 0, TEXT_AREA_SIZE);
        FontProperty.add(fontProperties, "CCTextArea", MONOSPACED, null, 0, TEXT_AREA_SIZE);
    }
}

