/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.tools.common;

import com.ibm.db2.tools.common.CommonImageRepository;
import com.ibm.db2.tools.common.CommonTrace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnimatedGearsButton
extends JPanel
implements ActionListener,
Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\n(c) Copyright IBM Corp. 1995, 2004. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int FRAMES_PER_SECOND = 5;
    private ImageIcon[] gears = new ImageIcon[4];
    private int imageIndex = 0;
    private int timeBetweenFrames = 200;
    private volatile transient Timer timer;
    private JLabel gearLabel = new JLabel();
    private JLabel statusLabel = new JLabel();
    private String statusText;
    private String previousStatusText;

    public AnimatedGearsButton() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "AnimatedGearsButton", this, "AnimatedGearsButton()");
        }
        this.gears[0] = CommonImageRepository.getCommonIcon(CommonImageRepository.EXECUTE_IMAGE1);
        this.gears[1] = CommonImageRepository.getCommonIcon(CommonImageRepository.EXECUTE_IMAGE2);
        this.gears[2] = CommonImageRepository.getCommonIcon(CommonImageRepository.EXECUTE_IMAGE3);
        this.gears[3] = CommonImageRepository.getCommonIcon(CommonImageRepository.EXECUTE_IMAGE4);
        this.setLayout(new BorderLayout());
        this.gearLabel.setHorizontalAlignment(0);
        this.gearLabel.setIcon(this.gears[0]);
        this.statusLabel.setHorizontalAlignment(0);
        this.add("Center", this.gearLabel);
        this.add("South", this.statusLabel);
        this.timer = new Timer(this.timeBetweenFrames, this);
        this.timer.setInitialDelay(0);
        this.timer.setCoalesce(true);
        CommonTrace.exit(commonTrace);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.advance();
    }

    public void startTurning() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "AnimatedGearsButton", this, "startTurning()");
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
        CommonTrace.exit(commonTrace);
    }

    public void stopTurning() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "AnimatedGearsButton", this, "stopTurning()");
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.statusText = "";
        if (EventQueue.isDispatchThread()) {
            this.statusLabel.setText(this.statusText);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AnimatedGearsButton.this.statusLabel.setText(AnimatedGearsButton.this.statusText);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CommonTrace.exit(commonTrace);
    }

    public boolean isTurning() {
        CommonTrace commonTrace = null;
        if (CommonTrace.isTrace()) {
            commonTrace = CommonTrace.create("com.ibm.db2.tools.common", "AnimatedGearsButton", this, "isTurning()");
        }
        boolean bl = this.timer.isRunning();
        return CommonTrace.exit(commonTrace, bl);
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public void setGearsBackground(Color color) {
        if (color != null) {
            this.setBackground(color);
            this.gearLabel.setBackground(color);
            this.statusLabel.setBackground(color);
        }
    }

    private void advance() {
        ++this.imageIndex;
        if (this.imageIndex > 3) {
            this.imageIndex = 0;
        }
        this.gearLabel.setIcon(this.gears[this.imageIndex]);
        if (this.statusText != null && this.statusText != this.previousStatusText) {
            this.statusLabel.setText(this.statusText);
            this.previousStatusText = this.statusText;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.gearLabel != null) {
            this.gearLabel.setEnabled(bl);
        }
        if (this.statusLabel != null) {
            this.statusLabel.setEnabled(bl);
        }
    }
}

