/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.policy.repository;

import com.ibm.db2.common.xmlutils.xmlserializer.DOMWriter;
import com.ibm.db2.pd.PdTrace;
import com.ibm.db2.policy.api.PolicyDocument;
import com.ibm.db2.policy.api.PolicyTraceHeader;
import com.ibm.db2.policy.api.PolicyTraceRCs;
import com.ibm.db2.policy.parser.PolicyDB2ATMParser;
import com.ibm.db2.policy.parser.PolicyDB2BackupParser;
import com.ibm.db2.policy.parser.PolicyDB2CommonMEDParser;
import com.ibm.db2.policy.repository.PolicyDBStorageAdapter;
import com.ibm.db2.policy.repository.PolicyRepositoryConstants;
import com.ibm.db2.policy.repository.PolicyRepositoryInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PolicyDBRepository
implements PolicyRepositoryInterface,
PolicyRepositoryConstants,
PolicyTraceHeader,
PolicyTraceRCs {
    private Connection con = null;
    private InputStream policy = null;
    private Document doc = null;
    PolicyDBStorageAdapter stAdapter;

    public PolicyDBRepository(Connection connection) {
        this.con = connection;
    }

    public PolicyDocument retrievePolicies(String string, String string2, String string3) throws SQLException, IOException, SAXException, ParserConfigurationException {
        Object[] objectArray = new Object[]{string, string2, string3};
        PdTrace.pdTraceEntry(481296509, objectArray);
        PolicyDocument policyDocument = null;
        this.setStorageAdapter(this.con);
        this.policy = this.stAdapter.getStoredPolicy(string, string2, string3);
        if (this.policy != null) {
            policyDocument = this.parsePolicy(this.policy, string, string2, string3);
        }
        PdTrace.pdTraceExit(481296509, 0, null);
        return policyDocument;
    }

    public PolicyDocument parsePolicy(InputStream inputStream, String string, String string2, String string3) throws SAXException, IOException, ParserConfigurationException {
        PdTrace.pdTraceEntry(481296510, null);
        PolicyDocument policyDocument = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(inputStream);
            if (string.equals("DB2DatabaseRecoveryMED")) {
                PolicyDB2BackupParser policyDB2BackupParser = new PolicyDB2BackupParser();
                policyDocument = policyDB2BackupParser.getPolicyDocument(this.doc);
            } else if (string.equals("DB2CommonMED")) {
                PolicyDB2CommonMEDParser policyDB2CommonMEDParser = new PolicyDB2CommonMEDParser();
                policyDocument = policyDB2CommonMEDParser.getPolicyDocument(this.doc);
            } else if (string.equals("DB2TableMaintenanceMED")) {
                PolicyDB2ATMParser policyDB2ATMParser = new PolicyDB2ATMParser();
                policyDocument = policyDB2ATMParser.getPolicyDocument(this.doc);
            }
        }
        catch (SAXException sAXException) {
            PdTrace.pdTraceError(481296510, -4, 10, sAXException.getMessage());
            throw sAXException;
        }
        catch (IOException iOException) {
            PdTrace.pdTraceError(481296510, -4, 20, iOException.getMessage());
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PdTrace.pdTraceError(481296510, -4, 30, illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            PdTrace.pdTraceError(481296510, -4, 40, parserConfigurationException.getMessage());
            throw parserConfigurationException;
        }
        PdTrace.pdTraceExit(481296510, 0, policyDocument == null ? "NULL" : "POLDOC");
        return policyDocument;
    }

    public void storePolicy(String string, String string2, String string3) throws SQLException, IOException {
        Object[] objectArray = new Object[]{string, string2, string3};
        PdTrace.pdTraceEntry(481296511, objectArray);
        byte[] byArray = null;
        try {
            byArray = this.getDOMByteArray();
        }
        catch (IOException iOException) {
            PdTrace.pdTraceError(481296511, -5, 10, iOException.getMessage());
            throw iOException;
        }
        try {
            this.stAdapter.storePolicy(string, string2, string3, byArray);
        }
        catch (SQLException sQLException) {
            PdTrace.pdTraceError(481296511, -5, 20, sQLException.getMessage());
            throw sQLException;
        }
        PdTrace.pdTraceExit(481296511, 0, null);
    }

    public byte[] getDOMByteArray() throws IOException {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DOMWriter dOMWriter = new DOMWriter(false, (OutputStream)byteArrayOutputStream);
        dOMWriter.print((Node)this.doc);
        byteArrayOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public void setStorageAdapter(Connection connection) {
        this.stAdapter = new PolicyDBStorageAdapter(connection);
    }

    public Document getDocument() {
        return this.doc;
    }

    public static void writeXMLFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            System.out.println(transformerException);
        }
    }
}

