/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.policy.app;

import com.ibm.db2.pd.PdTrace;
import com.ibm.db2.policy.api.PolicyACPolicy;
import com.ibm.db2.policy.api.PolicyConditionSection;
import com.ibm.db2.policy.api.PolicyDocument;
import com.ibm.db2.policy.api.PolicyMaintWindowCond;
import com.ibm.db2.policy.api.PolicyNotLE;
import com.ibm.db2.policy.api.PolicyPrecondition;
import com.ibm.db2.policy.api.PolicyTraceHeader;
import com.ibm.db2.policy.api.PolicyTraceRCs;
import com.ibm.db2.policy.app.DB2CommonMaintWindow;
import com.ibm.db2.policy.app.DB2PolicyStringRepository;
import com.ibm.db2.policy.repository.PolicyDBRepository;
import com.ibm.db2.policy.repository.PolicyRepositoryConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DB2CommonPolicy
implements PolicyRepositoryConstants,
PolicyTraceHeader,
PolicyTraceRCs {
    public static final int MAINTWIND_REPLACE = 0;
    public static final int MAINTWIND_APPEND = 1;
    private Connection con;
    private PolicyDocument polDoc;
    private Vector condSections = null;
    private PolicyACPolicy polACPol;
    Hashtable maintWindows = new Hashtable();
    private PolicyDBRepository dbRep;
    private DB2CommonMaintWindow maintWindowOffline = null;
    private DB2CommonMaintWindow maintWindowOnline = null;
    private boolean isDuringWindow;

    public DB2CommonPolicy(Connection connection) {
        PdTrace.pdTraceEntry(481296483, null);
        this.con = connection;
        PdTrace.pdTraceExit(481296483, 0, null);
    }

    public void retrievePolicy() throws SQLException, IOException, SAXException, IllegalArgumentException, ParserConfigurationException {
        PdTrace.pdTraceEntry(481296484, null);
        if (this.con != null) {
            this.dbRep = new PolicyDBRepository(this.con);
            this.polDoc = this.dbRep.retrievePolicies("DB2CommonMED", "NOP", "CommonPolicy");
        } else {
            String string = DB2PolicyStringRepository.getPolicyString(DB2PolicyStringRepository.COMMON_POLICY_ID);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            this.dbRep = new PolicyDBRepository(null);
            this.polDoc = this.dbRep.parsePolicy(byteArrayInputStream, "DB2CommonMED", "NOP", "CommonPolicy");
        }
        this.condSections = this.polDoc.getConditionSections();
        this.createMaintenanceWindows();
        PdTrace.pdTraceExit(481296484, 0, null);
    }

    private void createMaintenanceWindows() {
        PdTrace.pdTraceEntry(481296486, null);
        PolicyConditionSection policyConditionSection = (PolicyConditionSection)this.condSections.elementAt(0);
        Vector vector = policyConditionSection.getConditions();
        PdTrace.pdTraceData(481296486, 10, new Integer(vector.size()));
        int n2 = 0;
        while (n2 < vector.size()) {
            PolicyMaintWindowCond policyMaintWindowCond;
            PolicyPrecondition policyPrecondition = (PolicyPrecondition)vector.elementAt(n2);
            if (policyPrecondition.getLE() instanceof PolicyNotLE) {
                this.isDuringWindow = false;
                policyMaintWindowCond = (PolicyMaintWindowCond)policyPrecondition.getLE().getPolTimePeriodCond();
            } else {
                this.isDuringWindow = true;
                policyMaintWindowCond = (PolicyMaintWindowCond)policyPrecondition.getPolTimePeriodCond();
            }
            PdTrace.pdTraceData(481296486, 10, new Integer(policyMaintWindowCond.getWindowType()));
            if (policyMaintWindowCond.getWindowType() == 0) {
                this.maintWindows.put("OFFLINE", policyMaintWindowCond);
                this.maintWindowOffline = new DB2CommonMaintWindow(0, (PolicyMaintWindowCond)this.maintWindows.get("OFFLINE"));
                this.maintWindowOffline.setDuringWindow(this.isDuringWindow);
                this.maintWindowOffline.setPrecondition(policyPrecondition);
            } else {
                this.maintWindows.put("ONLINE", policyMaintWindowCond);
                this.maintWindowOnline = new DB2CommonMaintWindow(1, (PolicyMaintWindowCond)this.maintWindows.get("ONLINE"));
                this.maintWindowOnline.setDuringWindow(this.isDuringWindow);
                this.maintWindowOnline.setPrecondition(policyPrecondition);
            }
            ++n2;
        }
        PdTrace.pdTraceExit(481296486, 0, null);
    }

    public DB2CommonMaintWindow getMaintenanceWindowByType(int n2) {
        PdTrace.pdTraceEntry(481296485, null);
        DB2CommonMaintWindow dB2CommonMaintWindow = null;
        dB2CommonMaintWindow = n2 == 1 ? this.maintWindowOnline : this.maintWindowOffline;
        PdTrace.pdTraceExit(481296485, 0, dB2CommonMaintWindow);
        return dB2CommonMaintWindow;
    }

    public void setMaintenanceWindow(DB2CommonMaintWindow dB2CommonMaintWindow, int n2) {
        PdTrace.pdTraceEntry(481296487, dB2CommonMaintWindow);
        PolicyConditionSection policyConditionSection = (PolicyConditionSection)this.condSections.elementAt(0);
        PolicyPrecondition policyPrecondition = new PolicyPrecondition();
        policyPrecondition.setIsReplace(n2 == 0);
        if (dB2CommonMaintWindow.isDuringWindow()) {
            policyPrecondition.setPolTimePeriodCond(dB2CommonMaintWindow.getPolMaintWindow());
            policyConditionSection.addCondition(policyPrecondition);
        } else {
            PolicyNotLE policyNotLE = new PolicyNotLE();
            policyNotLE.setPolTimePeriodCond(dB2CommonMaintWindow.getPolMaintWindow());
            policyPrecondition.setLE(policyNotLE);
            policyConditionSection.addCondition(policyPrecondition);
        }
        PdTrace.pdTraceData(481296487, 10, new Integer(dB2CommonMaintWindow.getWindowType()));
        if (dB2CommonMaintWindow.getWindowType() == 1) {
            this.maintWindows.put("ONLINE", dB2CommonMaintWindow.getPolMaintWindow());
            this.maintWindowOnline = dB2CommonMaintWindow;
        } else {
            this.maintWindows.put("OFFLINE", dB2CommonMaintWindow.getPolMaintWindow());
            this.maintWindowOffline = dB2CommonMaintWindow;
        }
        PdTrace.pdTraceExit(481296487, 0, null);
    }

    public Document getDocument() {
        return this.dbRep.getDocument();
    }

    public byte[] getPolicyByteArray() throws IOException {
        return this.dbRep.getDOMByteArray();
    }

    public void storePolicy() throws SQLException, IOException {
        PdTrace.pdTraceEntry(481296488, null);
        this.dbRep.storePolicy("DB2CommonMED", "NOP", "CommonPolicy");
        PdTrace.pdTraceExit(481296488, 0, null);
    }

    public void storePolicy(Connection connection) throws SQLException, IOException {
        PdTrace.pdTraceEntry(481296489, null);
        this.dbRep.setStorageAdapter(connection);
        this.dbRep.storePolicy("DB2CommonMED", "NOP", "CommonPolicy");
        PdTrace.pdTraceExit(481296489, 0, null);
    }
}

