/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.policy.app;

import com.ibm.db2.pd.PdTrace;
import com.ibm.db2.policy.api.PolicyACPolicy;
import com.ibm.db2.policy.api.PolicyDBBackupAction;
import com.ibm.db2.policy.api.PolicyDBBackupTarget;
import com.ibm.db2.policy.api.PolicyDBBackupTargetDisk;
import com.ibm.db2.policy.api.PolicyDBBackupTargetTape;
import com.ibm.db2.policy.api.PolicyDBBackupTargetTsm;
import com.ibm.db2.policy.api.PolicyDBBackupTargetVendLib;
import com.ibm.db2.policy.api.PolicyDBBackupTargetXbsa;
import com.ibm.db2.policy.api.PolicyDBBkupTrgtLibOptions;
import com.ibm.db2.policy.api.PolicyDBBkupTrgtNumSessions;
import com.ibm.db2.policy.api.PolicyDBBkupTrgtPathName;
import com.ibm.db2.policy.api.PolicyDocument;
import com.ibm.db2.policy.api.PolicyPolSection;
import com.ibm.db2.policy.api.PolicyScope;
import com.ibm.db2.policy.api.PolicySensor;
import com.ibm.db2.policy.api.PolicyTraceHeader;
import com.ibm.db2.policy.api.PolicyTraceRCs;
import com.ibm.db2.policy.repository.PolicyDBRepository;
import com.ibm.db2.policy.repository.PolicyRepositoryConstants;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DB2BackupPolicy
implements PolicyRepositoryConstants,
PolicyTraceHeader,
PolicyTraceRCs {
    private Connection con;
    private PolicyDocument polDoc;
    private PolicyACPolicy polACPol;
    private PolicyDBBackupAction dbBackupAction;
    private PolicyDBBackupTarget bkupTarget;
    private int mediaType;
    Hashtable sensors;
    private PolicyDBRepository dbRep;

    public DB2BackupPolicy(Connection connection) {
        PdTrace.pdTraceEntry(481296457, null);
        this.con = connection;
        this.dbRep = new PolicyDBRepository(connection);
        PdTrace.pdTraceExit(481296457, 0, null);
    }

    public void retrievePolicy() throws SQLException, IOException, SAXException, IllegalArgumentException, ParserConfigurationException {
        PdTrace.pdTraceEntry(481296458, null);
        this.polDoc = this.dbRep.retrievePolicies("DB2DatabaseRecoveryMED", "DBBackupDecision", "DBBackupPolicy");
        PolicyPolSection policyPolSection = (PolicyPolSection)this.polDoc.getPolicySections().elementAt(0);
        this.polACPol = policyPolSection.getACPolicy(0);
        this.dbBackupAction = (PolicyDBBackupAction)this.polACPol.getDecision().getSimplePolAction();
        this.bkupTarget = this.dbBackupAction.getDBBackupTarget();
        if (this.polACPol.getPrecondition() != null) {
            this.sensors = this.polACPol.getPrecondition().getSensors();
        }
        PdTrace.pdTraceExit(481296458, 0, null);
    }

    public void setMode(int n2) {
        this.dbBackupAction.setMode(n2);
    }

    public int getMode() {
        return this.dbBackupAction.getMode();
    }

    public String getScope() {
        String string = null;
        Vector vector = this.polACPol.getScopes();
        if (vector != null) {
            string = ((PolicyScope)vector.elementAt(0)).getScope();
        }
        return string;
    }

    public void setScope(String string) {
        Vector vector = this.polACPol.getScopes();
        if (vector != null) {
            ((PolicyScope)vector.elementAt(0)).setScope(string);
        }
    }

    public int getNumOfFullBackups() {
        PdTrace.pdTraceEntry(481296459, null);
        int n2 = 0;
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Number_Full_DB_Backups");
        }
        if (policySensor != null) {
            n2 = Integer.parseInt(policySensor.getPolConstant().getValue());
        }
        PdTrace.pdTraceExit(481296459, 0, new Integer(n2));
        return n2;
    }

    public void setNumOfFullBackups(int n2) {
        PdTrace.pdTraceEntry(481296460, new Integer(n2));
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Number_Full_DB_Backups");
        }
        if (policySensor != null) {
            policySensor.getPolConstant().setValue(String.valueOf(n2));
        }
        PdTrace.pdTraceExit(481296460, 0, null);
    }

    public int getHrsBetweenBackups() {
        PdTrace.pdTraceEntry(481296461, null);
        int n2 = 0;
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Elapsed_Time_Since_Last_DB_Backup");
        }
        if (policySensor != null) {
            n2 = Integer.parseInt(policySensor.getPolConstant().getValue());
        }
        PdTrace.pdTraceExit(481296461, 0, new Integer(n2));
        return n2;
    }

    public void setHrsBetweenBackups(int n2) {
        PdTrace.pdTraceEntry(481296462, new Integer(n2));
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Elapsed_Time_Since_Last_DB_Backup");
        }
        if (policySensor != null) {
            policySensor.getPolConstant().setValue(String.valueOf(n2));
        }
        PdTrace.pdTraceExit(481296462, 0, null);
    }

    public int getNumPagesOfLogConsumed() {
        PdTrace.pdTraceEntry(481296463, null);
        int n2 = 0;
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Log_Consumed_Since_Last_DB_Backup");
        }
        if (policySensor != null) {
            n2 = Integer.parseInt(policySensor.getPolConstant().getValue());
        }
        PdTrace.pdTraceExit(481296463, 0, new Integer(n2));
        return n2;
    }

    public void setNumPagesOfLogConsumed(int n2) {
        PdTrace.pdTraceEntry(481296464, new Integer(n2));
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Log_Consumed_Since_Last_DB_Backup");
        }
        if (policySensor != null) {
            policySensor.getPolConstant().setValue(String.valueOf(n2));
        }
        PdTrace.pdTraceExit(481296464, 0, null);
    }

    public int getMediaType() {
        this.mediaType = this.bkupTarget.getTargetType();
        return this.mediaType;
    }

    public void updateTarget(int n2, String string, int n3, String string2) {
        Object[] objectArray = new Object[]{new Integer(n2), string, new Integer(n3), string2};
        PdTrace.pdTraceEntry(481296465, objectArray);
        this.setMediaType(n2);
        if (this.mediaType == 0) {
            this.bkupTarget = new PolicyDBBackupTargetDisk();
            ((PolicyDBBackupTargetDisk)this.bkupTarget).setPathName(new PolicyDBBkupTrgtPathName());
            this.setDiskTargetPathName(string);
        } else if (this.mediaType == 1) {
            this.bkupTarget = new PolicyDBBackupTargetTape();
            ((PolicyDBBackupTargetTape)this.bkupTarget).setPathName(new PolicyDBBkupTrgtPathName());
            this.setTapeTargetPathName(string);
        } else if (this.mediaType == 2) {
            this.bkupTarget = new PolicyDBBackupTargetTsm();
            ((PolicyDBBackupTargetTsm)this.bkupTarget).setNumSessions(new PolicyDBBkupTrgtNumSessions());
            this.setTsmNumberOfSessions(n3);
        } else if (this.mediaType == 3) {
            this.bkupTarget = new PolicyDBBackupTargetXbsa();
            ((PolicyDBBackupTargetXbsa)this.bkupTarget).setNumSessions(new PolicyDBBkupTrgtNumSessions());
            this.setXbsaNumberOfSessions(n3);
        } else if (this.mediaType == 4) {
            this.bkupTarget = new PolicyDBBackupTargetVendLib();
            ((PolicyDBBackupTargetVendLib)this.bkupTarget).setPathName(new PolicyDBBkupTrgtPathName());
            ((PolicyDBBackupTargetVendLib)this.bkupTarget).setLibOptions(new PolicyDBBkupTrgtLibOptions());
            this.setVendLibFileName(string);
            this.setVendLibOptions(string2);
        }
        ((PolicyDBBackupAction)this.polACPol.getDecision().getSimplePolAction()).setDBBackupTarget(this.bkupTarget);
        PdTrace.pdTraceExit(481296465, 0, null);
    }

    private void setMediaType(int n2) {
        this.mediaType = n2;
    }

    public String getDiskTargetPathName() {
        PdTrace.pdTraceEntry(481296466, null);
        String string = "";
        if (this.mediaType == 0 && ((PolicyDBBackupTargetDisk)this.bkupTarget).getPathName() != null && ((PolicyDBBackupTargetDisk)this.bkupTarget).getPathName().getPathName() != null) {
            string = ((PolicyDBBackupTargetDisk)this.bkupTarget).getPathName().getPathName();
        }
        if (string.equals("")) {
            string = this.getDefBackupPath();
        }
        PdTrace.pdTraceExit(481296466, 0, string);
        return string;
    }

    public void setDiskTargetPathName(String string) {
        if (this.mediaType == 0) {
            ((PolicyDBBackupTargetDisk)this.bkupTarget).getPathName().setPathName(string);
        }
    }

    public String getTapeTargetPathName() {
        PdTrace.pdTraceEntry(481296467, null);
        String string = null;
        if (this.mediaType == 1) {
            string = ((PolicyDBBackupTargetTape)this.bkupTarget).getPathName().getPathName();
        }
        PdTrace.pdTraceExit(481296467, 0, string);
        return string;
    }

    public void setTapeTargetPathName(String string) {
        if (this.mediaType == 1) {
            ((PolicyDBBackupTargetTape)this.bkupTarget).getPathName().setPathName(string);
        }
    }

    public int getTsmNumberOfSessions() {
        PdTrace.pdTraceEntry(481296468, null);
        int n2 = 0;
        if (this.mediaType == 2) {
            n2 = ((PolicyDBBackupTargetTsm)this.bkupTarget).getNumSessions().getNumSessions();
        }
        PdTrace.pdTraceExit(481296468, 0, new Integer(n2));
        return n2;
    }

    public void setTsmNumberOfSessions(int n2) {
        if (this.mediaType == 2) {
            ((PolicyDBBackupTargetTsm)this.bkupTarget).getNumSessions().setNumSessions(n2);
        }
    }

    public int getXbsaNumberOfSessions() {
        PdTrace.pdTraceEntry(481296469, null);
        int n2 = 0;
        if (this.mediaType == 3) {
            n2 = ((PolicyDBBackupTargetXbsa)this.bkupTarget).getNumSessions().getNumSessions();
        }
        PdTrace.pdTraceExit(481296469, 0, new Integer(n2));
        return n2;
    }

    public void setXbsaNumberOfSessions(int n2) {
        if (this.mediaType == 3) {
            ((PolicyDBBackupTargetXbsa)this.bkupTarget).getNumSessions().setNumSessions(n2);
        }
    }

    public String getVendLibFileName() {
        PdTrace.pdTraceEntry(481296470, null);
        String string = null;
        if (this.mediaType == 4) {
            string = ((PolicyDBBackupTargetVendLib)this.bkupTarget).getPathName().getPathName();
        }
        PdTrace.pdTraceExit(481296470, 0, string);
        return string;
    }

    public void setVendLibFileName(String string) {
        if (this.mediaType == 4) {
            ((PolicyDBBackupTargetVendLib)this.bkupTarget).getPathName().setPathName(string);
        }
    }

    public String getVendLibOptions() {
        PdTrace.pdTraceEntry(481296471, null);
        String string = null;
        if (this.mediaType == 4) {
            string = ((PolicyDBBackupTargetVendLib)this.bkupTarget).getLibOptions().getLibOptions();
        }
        PdTrace.pdTraceExit(481296471, 0, string);
        return string;
    }

    public void setVendLibOptions(String string) {
        if (this.mediaType == 4) {
            ((PolicyDBBackupTargetVendLib)this.bkupTarget).getLibOptions().setLibOptions(string);
        }
    }

    public Document getDocument() {
        return this.dbRep.getDocument();
    }

    public void storePolicy() throws SQLException, IOException {
        PdTrace.pdTraceEntry(481296472, null);
        this.dbRep.storePolicy("DB2DatabaseRecoveryMED", "DBBackupDecision", "DBBackupPolicy");
        PdTrace.pdTraceExit(481296472, 0, null);
    }

    private native String getDefBackupPath();

    static {
        System.loadLibrary("db2jcmn");
    }
}

