/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.policy.app;

import com.ibm.db2.pd.PdTrace;
import com.ibm.db2.policy.api.PolicyACPolicy;
import com.ibm.db2.policy.api.PolicyDocument;
import com.ibm.db2.policy.api.PolicyPolSection;
import com.ibm.db2.policy.api.PolicyScope;
import com.ibm.db2.policy.api.PolicySensor;
import com.ibm.db2.policy.api.PolicyTraceHeader;
import com.ibm.db2.policy.api.PolicyTraceRCs;
import com.ibm.db2.policy.repository.PolicyDBRepository;
import com.ibm.db2.policy.repository.PolicyRepositoryConstants;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DB2ATMReorgPolicy
implements PolicyRepositoryConstants,
PolicyTraceHeader,
PolicyTraceRCs {
    private Connection con;
    private PolicyDocument polDoc;
    PolicyACPolicy polACPol;
    Hashtable sensors;
    private PolicyDBRepository dbRep;

    public DB2ATMReorgPolicy(Connection connection) {
        PdTrace.pdTraceEntry(481296473, null);
        this.con = connection;
        this.dbRep = new PolicyDBRepository(connection);
        PdTrace.pdTraceExit(481296473, 0, null);
    }

    public void retrievePolicy() throws SQLException, IOException, SAXException, IllegalArgumentException, ParserConfigurationException {
        PdTrace.pdTraceEntry(481296474, null);
        this.polDoc = this.dbRep.retrievePolicies("DB2TableMaintenanceMED", "TableReorgDecision", "TableReorgPolicy");
        PolicyPolSection policyPolSection = (PolicyPolSection)this.polDoc.getPolicySections().elementAt(0);
        this.polACPol = policyPolSection.getACPolicy(0);
        if (this.polACPol.getPrecondition() != null) {
            this.sensors = this.polACPol.getPrecondition().getSensors();
        }
        PdTrace.pdTraceExit(481296474, 0, null);
    }

    public String getScope() {
        String string = null;
        Vector vector = this.polACPol.getScopes();
        if (vector != null) {
            string = ((PolicyScope)vector.elementAt(0)).getScope();
        }
        return string;
    }

    public void setScope(String string) {
        Vector vector = this.polACPol.getScopes();
        if (vector != null) {
            ((PolicyScope)vector.elementAt(0)).setScope(string);
        }
    }

    public String getWhereClause() {
        PdTrace.pdTraceEntry(481296475, null);
        String string = "";
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Tables");
        }
        if (policySensor != null) {
            string = policySensor.getPolConstant().getValue();
        }
        PdTrace.pdTraceExit(481296475, 0, string);
        return string;
    }

    public void setWhereClause(String string) {
        PdTrace.pdTraceEntry(481296476, string);
        PolicySensor policySensor = null;
        if (this.sensors != null) {
            policySensor = (PolicySensor)this.sensors.get("Tables");
        }
        if (policySensor != null) {
            policySensor.getPolConstant().setValue(string);
        }
        PdTrace.pdTraceExit(481296476, 0, null);
    }

    public Document getDocument() {
        return this.dbRep.getDocument();
    }

    public void storePolicy() throws SQLException, IOException {
        PdTrace.pdTraceEntry(481296477, null);
        this.dbRep.storePolicy("DB2TableMaintenanceMED", "TableReorgDecision", "TableReorgPolicy");
        PdTrace.pdTraceExit(481296477, 0, null);
    }
}

