/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils.db;

import com.huawei.utils.db.PooledDBConnection;
import com.huawei.utils.db.PooledResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class PooledStatement
implements Statement {
    protected PooledDBConnection connection;
    protected Statement statement;

    public PooledStatement(PooledDBConnection conn, Statement stmt) {
        this.connection = conn;
        this.statement = stmt;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return new PooledResultSet(this, this.statement.executeQuery(this.connection.pool.toDB(sql)));
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.statement.executeUpdate(this.connection.pool.toDB(sql));
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(this.connection.pool.toDB(name));
    }

    public boolean execute(String sql) throws SQLException {
        return this.statement.execute(this.connection.pool.toDB(sql));
    }

    public ResultSet getResultSet() throws SQLException {
        return new PooledResultSet(this, this.statement.getResultSet());
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(this.connection.pool.toDB(sql));
    }

    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.executeUpdate(this.connection.pool.toDB(sql), autoGeneratedKeys);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.executeUpdate(this.connection.pool.toDB(sql), columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            columnNames[i2] = this.connection.pool.toDB(columnNames[i2]);
        }
        sql = this.connection.pool.toDB(sql);
        return this.statement.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.execute(this.connection.pool.toDB(sql), autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.execute(this.connection.pool.toDB(sql), columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            columnNames[i2] = this.connection.pool.toDB(columnNames[i2]);
        }
        sql = this.connection.pool.toDB(sql);
        return this.statement.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }
}

