/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils.db;

import com.huawei.utils.db.DBPool;
import com.huawei.utils.db.PooledCallableStatement;
import com.huawei.utils.db.PooledPreparedStatement;
import com.huawei.utils.db.PooledStatement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledDBConnection
implements Connection,
PooledConnection {
    protected DBPool pool;
    private Connection conn;
    long lastUpdateTime = System.currentTimeMillis();
    private LinkedList listeners = new LinkedList();
    private LinkedList stmts = new LinkedList();
    private SQLException createFromWhere;
    private static final String FOGET_CLOSE = "zh".equals(Locale.getDefault().getLanguage()) ? "\u8b66\u544a\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u6c60\u68c0\u6d4b\u5230\u4e00\u4e2a\u8fde\u63a5\u5fd8\u8bb0\u88ab\u5173\u95ed" : "Warning, DBPool detect that a DB connection forgot to close";

    public PooledDBConnection(Connection theConn, DBPool thePool) {
        this.pool = thePool;
        this.createFromWhere = new SQLException(FOGET_CLOSE);
        if (theConn == null) {
            throw new NullPointerException("Connection is null");
        }
        this.conn = theConn;
        this.addConnectionEventListener(thePool);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        while (this.stmts.size() > 0) {
            ((Statement)this.stmts.remove(0)).close();
        }
        this.fireConnectionClosed();
        this.conn = null;
    }

    public Statement createStatement() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            Statement st = this.conn.createStatement();
            this.stmts.add(st);
            return new PooledStatement(this, st);
        }
        catch (SQLException ex) {
            this.fireConnectionErrorOccurred(ex);
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            Statement st = this.conn.createStatement(resultSetType, resultSetConcurrency);
            this.stmts.add(st);
            return st;
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            CallableStatement st = this.conn.prepareCall(this.pool.toDB(sql));
            this.stmts.add(st);
            return new PooledCallableStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            CallableStatement st = this.conn.prepareCall(this.pool.toDB(sql), resultSetType, resultSetConcurrency);
            this.stmts.add(st);
            return new PooledCallableStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            PreparedStatement st = this.conn.prepareStatement(this.pool.toDB(sql));
            this.stmts.add(st);
            return new PooledPreparedStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            PreparedStatement st = this.conn.prepareStatement(this.pool.toDB(sql), resultSetType, resultSetConcurrency);
            this.stmts.add(st);
            return new PooledPreparedStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.setTypeMap(map);
    }

    public Map getTypeMap() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.getTypeMap();
    }

    public void clearWarnings() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.clearWarnings();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.getWarnings();
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.getTransactionIsolation();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.setTransactionIsolation(level);
    }

    public String getCatalog() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.setCatalog(catalog);
    }

    public boolean isReadOnly() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        if (this.conn == null) {
            this.conn.setReadOnly(readOnly);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.getMetaData();
    }

    public boolean isClosed() throws SQLException {
        if (this.conn == null) {
            return true;
        }
        if (this.conn.isClosed()) {
            this.conn = null;
            return true;
        }
        return false;
    }

    public void rollback() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.rollback();
    }

    public void commit() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.commit();
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.conn.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.setAutoCommit(autoCommit);
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        return this.pool.fromDB(this.conn.nativeSQL(this.pool.toDB(sql)));
    }

    public String toString() {
        return "[PooledConnection@" + System.identityHashCode(this) + " statement number:" + this.stmts.size() + (this.conn == null ? "; closed" : "; alive") + "; connection: " + this.conn + ']';
    }

    protected void finalize() throws Throwable {
        if (this.conn != null) {
            StringWriter sw = new StringWriter();
            this.createFromWhere.printStackTrace(new PrintWriter(sw));
            StringTokenizer st = new StringTokenizer(sw.toString(), "\n");
            st.nextToken();
            st.nextToken();
            st.nextToken();
            this.pool.log(FOGET_CLOSE + st.nextToken("\u0000"));
            this.close();
        }
        super.finalize();
    }

    public void addConnectionEventListener(ConnectionEventListener l2) {
        this.listeners.add(l2);
    }

    public void removeConnectionEventListener(ConnectionEventListener l2) {
        this.listeners.remove(l2);
    }

    private void fireConnectionClosed() {
        ConnectionEvent e2 = new ConnectionEvent(this);
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            ConnectionEventListener listener = (ConnectionEventListener)i2.next();
            listener.connectionClosed(e2);
        }
    }

    private void fireConnectionErrorOccurred(SQLException ex) {
        ConnectionEvent e2 = new ConnectionEvent(this, ex);
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            ConnectionEventListener listener = (ConnectionEventListener)i2.next();
            listener.connectionErrorOccurred(e2);
        }
    }

    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        this.conn.rollback(savepoint);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            PreparedStatement st = this.conn.prepareStatement(this.pool.toDB(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
            this.stmts.add(st);
            return new PooledPreparedStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            PreparedStatement st = this.conn.prepareStatement(this.pool.toDB(sql), autoGeneratedKeys);
            this.stmts.add(st);
            return new PooledPreparedStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            PreparedStatement st = this.conn.prepareStatement(this.pool.toDB(sql), columnNames);
            this.stmts.add(st);
            return new PooledPreparedStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            PreparedStatement st = this.conn.prepareStatement(this.pool.toDB(sql), columnIndexes);
            this.stmts.add(st);
            return new PooledPreparedStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            Statement st = this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            this.stmts.add(st);
            return new PooledStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("DBPool: Connection closed.");
        }
        try {
            CallableStatement st = this.conn.prepareCall(this.pool.toDB(sql), resultSetType, resultSetConcurrency, resultSetHoldability);
            this.stmts.add(st);
            return new PooledCallableStatement(this, st);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }
}

