/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils.db;

import com.huawei.api.smsend.system.SMLog;
import com.huawei.utils.Args;
import com.huawei.utils.db.PooledDBConnection;
import com.huawei.utils.db.PreStatement;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import sun.jdbc.rowset.CachedRowSet;

public class DBPool
implements DataSource,
ConnectionEventListener {
    private final Object lock = new Object();
    private String name = "dbpool";
    private String driver;
    private String url;
    private String user;
    private String password;
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static DateFormat dfTemp = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private LinkedList freeConns = new LinkedList();
    private LinkedList allocatedConns = new LinkedList();
    private int maxConnNum = 10;
    private int maxFreeConnNum = (int)((double)this.maxConnNum * 0.8);
    private int connTimeout = 0;
    private int maxUsedTimeAConnection = 20000;
    private PrintWriter logWriter = new PrintWriter(System.out, true);
    private long watchInterval = -5000L;
    private boolean correctCharset;
    private String testSQL = "";
    private int tidyPosition = 0;
    private TidyThread watchThread;
    private int POOL_STATE = 0;
    private byte[] getConLock = new byte[0];
    private boolean isLockGetDBConnThread = false;

    public DBPool(Args args) throws SQLException {
        this.setArgs(args);
    }

    public void setArgs(Args args) throws SQLException {
        try {
            this.logWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream("./log/dbpool_log_" + dfTemp.format(new Date(System.currentTimeMillis())) + ".log")));
        }
        catch (Exception ex) {
            this.logWriter = new PrintWriter(System.out, true);
        }
        this.driver = args.get("driver", this.driver);
        if (this.driver != null) {
            this.driver = this.driver.trim();
        }
        if (this.driver == null || this.driver.length() == 0) {
            throw new IllegalArgumentException(this.log("driver parameter absent"));
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(this.log("can't find JDBC driver: " + this.driver));
        }
        catch (Exception ex) {
            throw new SQLException(this.log("load JDBC driver fail: " + ex));
        }
        String oldURL = this.url;
        this.url = args.get("url", this.url);
        if (this.url != null) {
            this.url = this.url.trim();
        }
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException(this.log("url parameter absent"));
        }
        this.name = args.get("name", this.name);
        this.correctCharset = args.get("correct-charset", this.correctCharset);
        this.testSQL = args.get("test-sql", this.testSQL);
        if (this.testSQL != null && this.testSQL.trim().length() == 0) {
            this.testSQL = null;
        }
        this.connTimeout = args.get("connection-timeout", 60);
        if (this.connTimeout < -1) {
            throw new IllegalArgumentException(this.log("connection-timeout parameter error."));
        }
        this.connTimeout *= 1000;
        DriverManager.setLoginTimeout(args.get("login-timeout", 60));
        String oldUser = this.user;
        this.user = args.get("user", this.user);
        String oldPassword = this.password;
        this.password = args.get("password", this.password);
        this.maxConnNum = args.get("max-connection", this.maxConnNum);
        this.maxFreeConnNum = args.get("max-free-connection", this.maxFreeConnNum);
        this.watchInterval = args.get("watch-interval", this.watchInterval / 1000L) * 1000L;
        if (this.watchThread != null) {
            this.watchThread.kill();
            this.watchThread = null;
        }
        if (this.watchInterval > 0L) {
            this.watchThread = new TidyThread(this.url + "-watcher");
            this.watchThread.start();
        }
        if (oldURL == null || !oldURL.equals(this.url) || oldUser == null && this.user != null || oldUser != null && !oldUser.equals(this.user) || oldPassword == null && this.password != null || oldPassword != null && !oldPassword.equals(this.password)) {
            this.reset();
        }
        this.isLockGetDBConnThread = args.get("lock-getConnThread", "false").equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet query(String sql) throws SQLException {
        int maxRow = 100000;
        Connection conn = null;
        Statement stmt = null;
        boolean n2 = false;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            CachedRowSet crs = new CachedRowSet();
            crs.setType(1004);
            crs.setMaxRows(maxRow);
            crs.populate(rs);
            conn.close();
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet[] queryMultiRS(String[] sql) throws SQLException {
        ResultSet[] rs = new ResultSet[sql.length];
        int maxRow = 1000;
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            Statement stat = conn.createStatement();
            for (int index = 0; index < sql.length; ++index) {
                ResultSet rsxx = stat.executeQuery(sql[index]);
                CachedRowSet crs = new CachedRowSet();
                crs.setType(1004);
                crs.setMaxRows(maxRow);
                crs.populate(rsxx);
                rs[index] = crs;
            }
            conn.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ResultSet[] resultSetArray = null;
            return resultSetArray;
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeSqlBatch(String[] sql) throws SQLException {
        int maxRow = 1000;
        int[] result = null;
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            Statement stat = conn.createStatement();
            for (int index = 0; index < sql.length; ++index) {
                stat.addBatch(sql[index]);
            }
            result = new int[sql.length];
            result = stat.executeBatch();
            conn.commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            int[] nArray = null;
            return nArray;
        }
        finally {
            try {
                conn.setAutoCommit(true);
                conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) throws SQLException {
        Connection conn = null;
        int n2 = 0;
        try {
            conn = this.getConnection();
            Statement stmt = conn.createStatement();
            n2 = stmt.executeUpdate(sql);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return n2;
    }

    public void executePreparedBatch(String sql, PreStatement[] stat) throws SQLException {
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            PreparedStatement pstat = null;
            pstat = con.prepareStatement(sql);
            for (int index = 0; index < stat.length; ++index) {
                block15: for (int mm = 0; mm < stat[index].getParametersCount(); ++mm) {
                    switch (stat[index].getParams().getParameters()[mm].type) {
                        case 4: {
                            pstat.setInt(mm + 1, (Integer)stat[index].getParams().getParameters()[mm].data);
                            continue block15;
                        }
                        case 12: {
                            pstat.setString(mm + 1, stat[index].getParams().getParameters()[mm].data.toString());
                            continue block15;
                        }
                        case 93: {
                            pstat.setTimestamp(mm + 1, (Timestamp)stat[index].getParams().getParameters()[mm].data);
                            continue block15;
                        }
                        case 6: {
                            pstat.setFloat(mm + 1, ((Float)stat[index].getParams().getParameters()[mm].data).floatValue());
                            continue block15;
                        }
                        case 8: {
                            pstat.setDouble(mm + 1, (Double)stat[index].getParams().getParameters()[mm].data);
                            continue block15;
                        }
                        case 2000: {
                            pstat.setObject(mm + 1, stat[index].getParams().getParameters()[mm].data);
                            continue block15;
                        }
                        case 2: {
                            pstat.setInt(mm + 1, (Integer)stat[index].getParams().getParameters()[mm].data);
                            continue block15;
                        }
                        default: {
                            pstat.setString(mm + 1, stat[index].getParams().getParameters()[mm].data.toString());
                        }
                    }
                }
                pstat.addBatch();
            }
            pstat.executeBatch();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
                con.close();
            }
        }
    }

    public void executePrepared(PreStatement stat) throws SQLException {
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            PreparedStatement pstat = null;
            pstat = con.prepareStatement(stat.sql);
            block14: for (int mm = 0; mm < stat.getParametersCount(); ++mm) {
                switch (stat.getParams().getParameters()[mm].type) {
                    case 4: {
                        pstat.setInt(mm + 1, (Integer)stat.getParams().getParameters()[mm].data);
                        continue block14;
                    }
                    case 12: {
                        pstat.setString(mm + 1, stat.getParams().getParameters()[mm].data.toString());
                        continue block14;
                    }
                    case 93: {
                        pstat.setTimestamp(mm + 1, (Timestamp)stat.getParams().getParameters()[mm].data);
                        continue block14;
                    }
                    case 6: {
                        pstat.setFloat(mm + 1, ((Float)stat.getParams().getParameters()[mm].data).floatValue());
                        continue block14;
                    }
                    case 8: {
                        pstat.setDouble(mm + 1, (Double)stat.getParams().getParameters()[mm].data);
                        continue block14;
                    }
                    case 2000: {
                        pstat.setObject(mm + 1, stat.getParams().getParameters()[mm].data);
                        continue block14;
                    }
                    case 2: {
                        pstat.setInt(mm + 1, (Integer)stat.getParams().getParameters()[mm].data);
                        continue block14;
                    }
                    default: {
                        pstat.setString(mm + 1, stat.getParams().getParameters()[mm].toString());
                    }
                }
            }
            pstat.execute();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
                con.close();
            }
        }
    }

    public void executeCallable(PreStatement stat) throws SQLException {
        Connection con = null;
        Statement callstat = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            callstat = con.prepareCall(stat.sql);
            stat.execSQLCallableStat((CallableStatement)callstat);
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            if (con != null) {
                con.commit();
                con.setAutoCommit(true);
                con.close();
            }
            if (callstat != null) {
                callstat.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkConState();
        return this.getInnerConnection();
    }

    private Connection getInnerConnection() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.freeConns == null) {
                throw new IllegalStateException(this.log("this pool is closed"));
            }
            int freeConnNum = this.freeConns.size();
            int allocatedConnNum = this.allocatedConns.size();
            SMLog.info("**********freeConns.size():" + this.freeConns.size() + "   allocatedConns.size():" + this.allocatedConns.size() + " Thread:" + Thread.currentThread().getName());
            if (freeConnNum > 0) {
                Connection c2 = (Connection)this.freeConns.removeLast();
                PooledDBConnection pdb = new PooledDBConnection(c2, this);
                this.allocatedConns.add(pdb);
                return pdb;
            }
            if (freeConnNum + allocatedConnNum < this.maxConnNum) {
                Connection c3 = DriverManager.getConnection(this.url, this.user, this.password);
                PooledDBConnection pdb = new PooledDBConnection(c3, this);
                this.allocatedConns.add(pdb);
                return pdb;
            }
            try {
                long costTime = 0L;
                long beforeWait = System.currentTimeMillis();
                do {
                    if (this.connTimeout <= 0) {
                        this.lock.wait();
                    } else if (this.connTimeout > 0) {
                        this.lock.wait((long)this.connTimeout - costTime);
                    }
                    if (this.freeConns == null) {
                        throw new IllegalStateException(this.log("this pool is closed"));
                    }
                    freeConnNum = this.freeConns.size();
                    if (freeConnNum <= 0) continue;
                    Connection c4 = (Connection)this.freeConns.removeLast();
                    PooledDBConnection pdb = new PooledDBConnection(c4, this);
                    this.allocatedConns.add(pdb);
                    return pdb;
                } while ((costTime = System.currentTimeMillis() - beforeWait) < (long)this.connTimeout);
                throw new SQLException(this.log("connection number reachs the upper limit(" + this.maxConnNum + "). Timeout while waiting a connection."));
            }
            catch (InterruptedException ex) {
                throw new SQLException(this.log("interrupted while waiting connection."));
            }
        }
    }

    public Connection getConnection(String dbUser, String dbPswd) throws SQLException {
        if (dbUser == null) {
            throw new NullPointerException(this.log("parameter user is null"));
        }
        if (dbPswd == null) {
            throw new NullPointerException(this.log("parameter password is null"));
        }
        if (dbUser.equals(this.user) && dbPswd.equals(this.password)) {
            return this.getConnection();
        }
        Connection c2 = DriverManager.getConnection(this.url, this.user, this.password);
        PooledDBConnection pdb = new PooledDBConnection(c2, this);
        this.allocatedConns.add(pdb);
        return pdb;
    }

    public void setLoginTimeout(int time) {
        DriverManager.setLoginTimeout(time);
    }

    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter pw) {
        this.logWriter = pw;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getIdle() {
        if (this.freeConns == null) {
            throw new IllegalStateException("DBPool closed");
        }
        return this.freeConns.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.freeConns.size() > 0) {
                for (int i2 = this.maxFreeConnNum; i2 < this.freeConns.size(); ++i2) {
                    this.freeConns.removeFirst();
                }
            }
        }
        this.innerTidy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTidy() {
        block22: {
            if (this.testSQL != null && this.testSQL.trim().length() >= 0) {
                PooledConnection pc2 = null;
                boolean badConnectionFlag = false;
                try {
                    pc2 = (PooledConnection)((Object)this.getInnerConnection());
                    this.test(pc2.getConnection());
                    SMLog.info("-----------------------DBPool test OK.");
                    if (this.getConLockState() != 0) {
                        this.setConLockState(0);
                        this.notifyGetConRequest();
                    }
                    return;
                }
                catch (Exception ex) {
                    if (ex.getMessage().indexOf("reachs the upper limit(") != -1) break block22;
                    this.setConLockState(-1);
                    badConnectionFlag = true;
                    this.log("Tidy connection for " + ex);
                    SMLog.info("------------------Find dbpool disconnect ,begin clear connection.");
                    Object object = this.lock;
                    synchronized (object) {
                        this.allocatedConns.clear();
                        while (!this.freeConns.isEmpty()) {
                            try {
                                ((Connection)this.freeConns.removeFirst()).close();
                            }
                            catch (Exception e2) {}
                        }
                    }
                }
                finally {
                    if (pc2 != null) {
                        try {
                            if (!badConnectionFlag) {
                                pc2.close();
                            } else {
                                pc2.getConnection().close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void oldTidy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.freeConns == null || this.freeConns.size() == 0) {
                return;
            }
            if (this.testSQL != null && this.testSQL.trim().length() >= 0) {
                Object c2 = null;
                try {
                    this.test((Connection)this.freeConns.get(this.tidyPosition++ % this.freeConns.size()));
                    return;
                }
                catch (SQLException ex) {
                    this.log("tidy connection for " + ex);
                    while (!this.freeConns.isEmpty()) {
                        try {
                            ((Connection)this.freeConns.removeFirst()).close();
                        }
                        catch (Exception e2) {}
                    }
                    this.allocatedConns.clear();
                    for (int i2 = this.maxFreeConnNum; i2 < this.freeConns.size(); ++i2) {
                        this.freeConns.removeFirst();
                    }
                }
            }
        }
    }

    private void tidyTimeoutConnection() {
        long nowTime = System.currentTimeMillis();
        Iterator iter = this.allocatedConns.iterator();
        PooledDBConnection pdb = null;
        String info = "Time:" + df.format(new Date(nowTime)) + "\n\r" + "DBPool:" + this.url + "\n\r" + "Connection state:" + "free:" + this.freeConns.size() + "  used:" + this.allocatedConns.size() + "\n\r";
        this.log(info);
        while (iter.hasNext()) {
            pdb = (PooledDBConnection)iter.next();
            if (nowTime - pdb.lastUpdateTime < (long)this.maxUsedTimeAConnection) continue;
            try {
                this.log("Find a connection executing timeOut,system will force to close it.");
                pdb.close();
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.watchThread.kill();
            while (!this.freeConns.isEmpty()) {
                try {
                    ((Connection)this.freeConns.removeFirst()).close();
                }
                catch (Exception exception) {}
            }
            this.freeConns = null;
            this.allocatedConns.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            int free = this.freeConns.size();
            int total = this.freeConns.size() + this.allocatedConns.size();
            return "DBPool: name=" + this.name + ", driver=" + this.driver + ", url=" + this.url + ", user=" + this.user + ", password=" + "********" + ", max-connection=" + this.maxConnNum + ", max-free-connection" + this.maxFreeConnNum + ",correct-charset=" + this.correctCharset + ", current free/total connection is " + free + '/' + total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConState() throws SQLException {
        byte[] byArray = this.getConLock;
        synchronized (this.getConLock) {
            if (this.isLockGetDBConnThread) {
                while (this.POOL_STATE != 0) {
                    try {
                        this.getConLock.wait();
                    }
                    catch (Exception exception) {}
                }
            } else if (this.POOL_STATE != 0) {
                throw new SQLException("DB Connection is not connected");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGetConRequest() {
        byte[] byArray = this.getConLock;
        synchronized (this.getConLock) {
            this.getConLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConLockState() {
        byte[] byArray = this.getConLock;
        synchronized (this.getConLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.POOL_STATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConLockState(int state) {
        byte[] byArray = this.getConLock;
        synchronized (this.getConLock) {
            this.POOL_STATE = state;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void connectionErrorOccurred(ConnectionEvent e2) {
        this.log(e2.getSQLException());
        try {
            Connection conn = ((PooledConnection)e2.getSource()).getConnection();
            this.kill(conn);
        }
        catch (SQLException ex) {
            this.log(ex);
        }
    }

    public void connectionClosed(ConnectionEvent e2) {
        PooledDBConnection conn = (PooledDBConnection)e2.getSource();
        this.freeConnection(conn);
    }

    protected String log(Object message) {
        try {
            if (this.logWriter != null) {
                this.logWriter.println(df.format(new Date()) + DBPool.locate() + this.name + ':' + message);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return message.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(Connection c2) throws SQLException {
        Statement stmt = null;
        try {
            stmt = c2.createStatement();
            if (this.testSQL != null) {
                ResultSet rs = stmt.executeQuery(this.testSQL);
                rs.close();
            }
            stmt.close();
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.allocatedConns.clear();
            while (!this.freeConns.isEmpty()) {
                Connection c2 = (Connection)this.freeConns.getFirst();
                try {
                    c2.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected String fromDB(String str) {
        if (this.correctCharset) {
            if (str == null) {
                return null;
            }
            try {
                return new String(str.getBytes("iso-8859-1"));
            }
            catch (UnsupportedEncodingException ex) {
                return str;
            }
        }
        return str;
    }

    protected String toDB(String str) {
        if (this.correctCharset) {
            if (str == null) {
                return null;
            }
            try {
                return new String(str.getBytes(), "iso-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                return str;
            }
        }
        return str;
    }

    private static String locate() {
        final StringWriter sw = new StringWriter(32);
        new Exception().printStackTrace(new PrintWriter((Writer)sw){
            private int i;
            {
                super(x0);
                this.i = 1;
            }

            public void println(Object o2) {
            }

            public void println(char[] c2) {
                this.println(new String(c2));
            }

            public void println(String str) {
                if (str.indexOf("com.huawei.utils.db") < 0) {
                    sw.getBuffer().setLength(0);
                    str = str.substring(str.indexOf(40));
                    if (!str.equals("(Unknown Source)")) {
                        super.println(str);
                    }
                }
            }
        });
        return sw.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeConnection(PooledDBConnection connxx) {
        Connection conn = connxx.getConnection();
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.freeConns == null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!this.allocatedConns.remove(connxx)) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (conn.isClosed()) {
                    this.log("connection closed when it released");
                    return;
                }
                if (this.freeConns.size() >= this.maxFreeConnNum) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        this.log("error occurs while release connection:" + conn + ' ' + ex);
                    }
                    return;
                }
                if (!conn.getAutoCommit()) {
                    conn.setAutoCommit(true);
                }
                conn.clearWarnings();
                try {
                    if (conn.isReadOnly()) {
                        conn.setReadOnly(false);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.freeConns.add(conn);
                this.lock.notify();
            }
            catch (Exception ex) {
                this.log("error occurs while take back connection:" + conn + ' ' + ex);
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void kill(Connection conn) {
        Object object = this.lock;
        synchronized (object) {
            this.allocatedConns.remove(conn);
            try {
                conn.close();
            }
            catch (Exception ex) {
                this.log(ex);
            }
        }
    }

    class TidyThread
    extends Thread {
        private boolean alive;

        public TidyThread(String name) {
            super(name);
            this.alive = true;
        }

        public void kill() {
            this.alive = false;
        }

        public final void run() {
            while (this.alive) {
                try {
                    Thread.sleep(DBPool.this.watchInterval);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    DBPool.this.tidy();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        }
    }
}

