/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.utils.db;

import com.huawei.utils.db.PooledStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import sun.jdbc.rowset.CachedRowSet;

public class CombCachedRowSet
implements ResultSet {
    protected PooledStatement statement;
    protected ResultSet resultSet;
    protected List rs = new ArrayList();

    public CombCachedRowSet(PooledStatement stmt, ResultSet rs) {
        this.statement = stmt;
        this.resultSet = rs;
    }

    public boolean addRowSet(CachedRowSet otherRS) {
        if (this.rs.size() == 0) {
            this.rs.add(otherRS);
            return true;
        }
        try {
            ResultSetMetaData md1 = otherRS.getMetaData();
            ResultSetMetaData md2 = ((CachedRowSet)this.rs.get(0)).getMetaData();
            int len = md1.getColumnCount();
            if (len != md2.getColumnCount()) {
                return false;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if (md1.getColumnType(i2) == md2.getColumnType(i2)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public String getString(int i2) throws SQLException {
        return this.statement.connection.pool.fromDB(this.resultSet.getString(i2));
    }

    public boolean getBoolean(int i2) throws SQLException {
        return this.resultSet.getBoolean(i2);
    }

    public byte getByte(int i2) throws SQLException {
        return this.resultSet.getByte(i2);
    }

    public short getShort(int i2) throws SQLException {
        return this.resultSet.getShort(i2);
    }

    public int getInt(int i2) throws SQLException {
        return this.resultSet.getInt(i2);
    }

    public long getLong(int i2) throws SQLException {
        return this.resultSet.getLong(i2);
    }

    public float getFloat(int i2) throws SQLException {
        return this.resultSet.getFloat(i2);
    }

    public double getDouble(int i2) throws SQLException {
        return this.resultSet.getDouble(i2);
    }

    public byte[] getBytes(int i2) throws SQLException {
        return this.resultSet.getBytes(i2);
    }

    public Date getDate(int i2) throws SQLException {
        return this.resultSet.getDate(i2);
    }

    public Time getTime(int i2) throws SQLException {
        return this.resultSet.getTime(i2);
    }

    public Timestamp getTimestamp(int i2) throws SQLException {
        return this.resultSet.getTimestamp(i2);
    }

    public InputStream getAsciiStream(int i2) throws SQLException {
        return this.resultSet.getAsciiStream(i2);
    }

    public InputStream getBinaryStream(int i2) throws SQLException {
        return this.resultSet.getBinaryStream(i2);
    }

    public String getString(String columnName) throws SQLException {
        return this.statement.connection.pool.fromDB(this.resultSet.getString(this.statement.connection.pool.toDB(columnName)));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.resultSet.getBoolean(this.statement.connection.pool.toDB(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.resultSet.getByte(this.statement.connection.pool.toDB(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.resultSet.getShort(this.statement.connection.pool.toDB(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.resultSet.getInt(this.statement.connection.pool.toDB(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.resultSet.getLong(this.statement.connection.pool.toDB(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.resultSet.getFloat(this.statement.connection.pool.toDB(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.resultSet.getInt(this.statement.connection.pool.toDB(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(this.statement.connection.pool.toDB(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.resultSet.getBytes(this.statement.connection.pool.toDB(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.resultSet.getDate(this.statement.connection.pool.toDB(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.resultSet.getTime(this.statement.connection.pool.toDB(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.resultSet.getTimestamp(this.statement.connection.pool.toDB(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.resultSet.getUnicodeStream(this.statement.connection.pool.toDB(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.resultSet.getBinaryStream(this.statement.connection.pool.toDB(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public Object getObject(int i2) throws SQLException {
        Object o2 = this.resultSet.getObject(i2);
        if (o2 instanceof String) {
            o2 = this.statement.connection.pool.fromDB((String)o2);
        }
        return o2;
    }

    public Object getObject(String columnName) throws SQLException {
        Object o2 = this.resultSet.getObject(this.statement.connection.pool.toDB(columnName));
        if (o2 instanceof String) {
            o2 = this.statement.connection.pool.fromDB((String)o2);
        }
        return o2;
    }

    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(this.statement.connection.pool.toDB(columnName));
    }

    public Reader getCharacterStream(int i2) throws SQLException {
        return this.resultSet.getCharacterStream(i2);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.resultSet.getCharacterStream(this.statement.connection.pool.toDB(columnName));
    }

    public BigDecimal getBigDecimal(int i2) throws SQLException {
        return this.resultSet.getBigDecimal(i2);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.resultSet.getBigDecimal(this.statement.connection.pool.toDB(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.resultSet.afterLast();
    }

    public boolean first() throws SQLException {
        return this.resultSet.first();
    }

    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        return this.resultSet.absolute(row);
    }

    public boolean relative(int rows) throws SQLException {
        return this.resultSet.relative(rows);
    }

    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.resultSet.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.resultSet.setFetchDirection(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.resultSet.getType();
    }

    public int getConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    public void updateNull(int i2) throws SQLException {
        this.resultSet.updateNull(i2);
    }

    public void updateBoolean(int i2, boolean x2) throws SQLException {
        this.resultSet.updateBoolean(i2, x2);
    }

    public void updateByte(int i2, byte x2) throws SQLException {
        this.resultSet.updateByte(i2, x2);
    }

    public void updateShort(int i2, short x2) throws SQLException {
        this.resultSet.updateShort(i2, x2);
    }

    public void updateInt(int i2, int x2) throws SQLException {
        this.resultSet.updateInt(i2, x2);
    }

    public void updateLong(int i2, long x2) throws SQLException {
        this.resultSet.updateLong(i2, x2);
    }

    public void updateFloat(int i2, float x2) throws SQLException {
        this.resultSet.updateFloat(i2, x2);
    }

    public void updateDouble(int i2, double x2) throws SQLException {
        this.resultSet.updateDouble(i2, x2);
    }

    public void updateBigDecimal(int i2, BigDecimal x2) throws SQLException {
        this.resultSet.updateBigDecimal(i2, x2);
    }

    public void updateString(int i2, String x2) throws SQLException {
        this.resultSet.updateString(i2, x2);
    }

    public void updateBytes(int i2, byte[] x2) throws SQLException {
        this.resultSet.updateBytes(i2, x2);
    }

    public void updateDate(int i2, Date x2) throws SQLException {
        this.resultSet.updateDate(i2, x2);
    }

    public void updateTime(int i2, Time x2) throws SQLException {
        this.resultSet.updateTime(i2, x2);
    }

    public void updateTimestamp(int i2, Timestamp x2) throws SQLException {
        this.resultSet.updateTimestamp(i2, x2);
    }

    public void updateAsciiStream(int i2, InputStream x2, int length) throws SQLException {
        this.resultSet.updateAsciiStream(i2, x2, length);
    }

    public void updateBinaryStream(int i2, InputStream x2, int length) throws SQLException {
        this.resultSet.updateBinaryStream(i2, x2, length);
    }

    public void updateCharacterStream(int i2, Reader x2, int length) throws SQLException {
        this.resultSet.updateCharacterStream(i2, x2, length);
    }

    public void updateObject(int i2, Object x2, int scale) throws SQLException {
        this.resultSet.updateObject(i2, x2, scale);
    }

    public void updateObject(int i2, Object x2) throws SQLException {
        this.resultSet.updateObject(i2, x2);
    }

    public void updateNull(String columnName) throws SQLException {
        this.resultSet.updateNull(this.statement.connection.pool.toDB(columnName));
    }

    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.resultSet.updateBoolean(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateByte(String columnName, byte x2) throws SQLException {
        this.resultSet.updateByte(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateShort(String columnName, short x2) throws SQLException {
        this.resultSet.updateShort(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateInt(String columnName, int x2) throws SQLException {
        this.resultSet.updateInt(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateLong(String columnName, long x2) throws SQLException {
        this.resultSet.updateLong(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateFloat(String columnName, float x2) throws SQLException {
        this.resultSet.updateFloat(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateDouble(String columnName, double x2) throws SQLException {
        this.resultSet.updateDouble(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.resultSet.updateBigDecimal(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateString(String columnName, String x2) throws SQLException {
        this.resultSet.updateString(this.statement.connection.pool.toDB(columnName), this.statement.connection.pool.toDB(x2));
    }

    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.resultSet.updateBytes(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateDate(String columnName, Date x2) throws SQLException {
        this.resultSet.updateDate(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateTime(String columnName, Time x2) throws SQLException {
        this.resultSet.updateTime(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.resultSet.updateTimestamp(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.resultSet.updateAsciiStream(this.statement.connection.pool.toDB(columnName), x2, length);
    }

    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.resultSet.updateBinaryStream(this.statement.connection.pool.toDB(columnName), x2, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.resultSet.updateCharacterStream(this.statement.connection.pool.toDB(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.resultSet.updateObject(this.statement.connection.pool.toDB(columnName), x2, scale);
    }

    public void updateObject(String columnName, Object x2) throws SQLException {
        this.resultSet.updateObject(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    public Object getObject(int i2, Map map) throws SQLException {
        Object o2 = this.resultSet.getObject(i2, map);
        if (o2 instanceof String) {
            o2 = this.statement.connection.pool.fromDB((String)o2);
        }
        return o2;
    }

    public Ref getRef(int i2) throws SQLException {
        return this.resultSet.getRef(i2);
    }

    public Blob getBlob(int i2) throws SQLException {
        return this.resultSet.getBlob(i2);
    }

    public Clob getClob(int i2) throws SQLException {
        return this.resultSet.getClob(i2);
    }

    public Array getArray(int i2) throws SQLException {
        return this.resultSet.getArray(i2);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        Object o2 = this.resultSet.getObject(this.statement.connection.pool.toDB(columnName), map);
        if (o2 instanceof String) {
            o2 = this.statement.connection.pool.fromDB((String)o2);
        }
        return o2;
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.resultSet.getRef(this.statement.connection.pool.toDB(columnName));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.resultSet.getBlob(this.statement.connection.pool.toDB(columnName));
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.resultSet.getClob(this.statement.connection.pool.toDB(columnName));
    }

    public Array getArray(String columnName) throws SQLException {
        return this.resultSet.getArray(this.statement.connection.pool.toDB(columnName));
    }

    public Date getDate(int i2, Calendar cal) throws SQLException {
        return this.resultSet.getDate(i2, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.resultSet.getDate(this.statement.connection.pool.toDB(columnName), cal);
    }

    public Time getTime(int i2, Calendar cal) throws SQLException {
        return this.resultSet.getTime(i2, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.resultSet.getTime(this.statement.connection.pool.toDB(columnName), cal);
    }

    public Timestamp getTimestamp(int i2, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(i2, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar c2) throws SQLException {
        return this.resultSet.getTimestamp(this.statement.connection.pool.toDB(columnName), c2);
    }

    public InputStream getUnicodeStream(int i2) throws SQLException {
        return this.resultSet.getUnicodeStream(i2);
    }

    public BigDecimal getBigDecimal(int i2, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(i2, scale);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.resultSet.getAsciiStream(this.statement.connection.pool.toDB(columnName));
    }

    public URL getURL(int columnIndex) throws SQLException {
        return this.resultSet.getURL(columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        return this.resultSet.getURL(this.statement.connection.pool.toDB(columnName));
    }

    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.resultSet.updateRef(columnIndex, x2);
    }

    public void updateRef(String columnName, Ref x2) throws SQLException {
        this.resultSet.updateRef(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.resultSet.updateBlob(columnIndex, x2);
    }

    public void updateBlob(String columnName, Blob x2) throws SQLException {
        this.resultSet.updateBlob(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.resultSet.updateClob(columnIndex, x2);
    }

    public void updateClob(String columnName, Clob x2) throws SQLException {
        this.resultSet.updateClob(this.statement.connection.pool.toDB(columnName), x2);
    }

    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.resultSet.updateArray(columnIndex, x2);
    }

    public void updateArray(String columnName, Array x2) throws SQLException {
        this.resultSet.updateArray(this.statement.connection.pool.toDB(columnName), x2);
    }
}

